/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.convert;

import ilog.views.util.IlvColorUtil;
import ilog.views.util.convert.IlvConvertException;
import ilog.views.util.convert.IlvConverter;
import ilog.views.util.convert.IlvLocalizedConverter;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class IlvConvert
implements Serializable {
    private static HashMap a = new HashMap();
    private static final Class[] b;

    private IlvConvert() {
    }

    public static final void addConverter(IlvConverter ilvConverter) {
        Class[] classArray = ilvConverter.fromTypes();
        Class[] classArray2 = ilvConverter.toTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class clazz = classArray[i2];
            HashMap<Class, IlvConverter> hashMap = (HashMap<Class, IlvConverter>)a.get(clazz);
            if (hashMap == null) {
                hashMap = new HashMap<Class, IlvConverter>();
                a.put(clazz, hashMap);
            }
            for (int i3 = 0; i3 < classArray2.length; ++i3) {
                hashMap.put(classArray2[i3], ilvConverter);
            }
        }
    }

    public static final void addConverter(PropertyEditor propertyEditor, Class clazz) {
        IlvConvert.addConverter(new PropertyEditorWrapper(propertyEditor, clazz));
    }

    public static IlvConverter getConverter(Class clazz, Class clazz2) {
        HashMap hashMap = (HashMap)a.get(clazz);
        IlvConverter ilvConverter = hashMap == null ? null : (IlvConverter)hashMap.get(clazz2);
        if (ilvConverter == null) {
            if (clazz != Object.class) {
                return IlvConvert.getConverter(clazz.getSuperclass(), clazz2);
            }
        }
        return ilvConverter;
    }

    public static boolean isConverterLocalized(Class clazz, Class clazz2) {
        IlvConverter ilvConverter = IlvConvert.getConverter(clazz, clazz2);
        return ilvConverter != null && ilvConverter instanceof IlvLocalizedConverter;
    }

    public static void removeConverter(Class clazz, Class clazz2) {
        HashMap hashMap = (HashMap)a.get(clazz);
        if (hashMap != null) {
            hashMap.remove(clazz2);
        }
    }

    public static final Object convert(Object object, Class clazz) throws IlvConvertException {
        if (object == null) {
            throw new IlvConvertException("cannot convert null value");
        }
        if ((clazz = IlvConvert.a(clazz)).isAssignableFrom(object.getClass())) {
            return object;
        }
        IlvConverter ilvConverter = IlvConvert.getConverter(object.getClass(), clazz);
        if (ilvConverter != null) {
            return ilvConverter.convert(object, clazz);
        }
        throw new IlvConvertException("No converter registered for " + object.getClass().getName() + " to " + clazz.getName());
    }

    public static boolean isConvertible(Class clazz, Class clazz2) {
        if (clazz == null) {
            return false;
        }
        if ((clazz2 = IlvConvert.a(clazz2)).isAssignableFrom(clazz)) {
            return true;
        }
        IlvConverter ilvConverter = IlvConvert.getConverter(clazz, clazz2);
        return ilvConverter != null;
    }

    public static final Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
        if (object == null) {
            throw new IlvConvertException("cannot convert null value");
        }
        if ((clazz = IlvConvert.a(clazz)).isAssignableFrom(object.getClass())) {
            return object;
        }
        IlvConverter ilvConverter = IlvConvert.getConverter(object.getClass(), clazz);
        if (ilvConverter != null) {
            if (ilvConverter instanceof IlvLocalizedConverter) {
                IlvLocalizedConverter ilvLocalizedConverter = (IlvLocalizedConverter)ilvConverter;
                return ilvLocalizedConverter.convert(object, clazz, locale);
            }
            if (locale == null || locale == Locale.getDefault()) {
                return ilvConverter.convert(object, clazz);
            }
            throw new IlvConvertException("No localized version of the converter registered for " + object.getClass().getName() + " to " + clazz.getName());
        }
        throw new IlvConvertException("No localized converter registered for " + object.getClass().getName() + " to " + clazz.getName());
    }

    private static Class a(Class clazz) {
        if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        } else if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        }
        return clazz;
    }

    public static final String convertToString(Object object) throws IlvConvertException {
        return (String)IlvConvert.convert(object, String.class);
    }

    public static final int convertToInt(Object object) throws IlvConvertException {
        return (Integer)IlvConvert.convert(object, Integer.class);
    }

    public static final long convertToLong(Object object) throws IlvConvertException {
        return (Long)IlvConvert.convert(object, Long.class);
    }

    public static final boolean convertToBoolean(Object object) throws IlvConvertException {
        return (Boolean)IlvConvert.convert(object, Boolean.class);
    }

    public static final float convertToFloat(Object object) throws IlvConvertException {
        return ((Float)IlvConvert.convert(object, Float.class)).floatValue();
    }

    public static final double convertToDouble(Object object) throws IlvConvertException {
        return (Double)IlvConvert.convert(object, Double.class);
    }

    public static final short convertToShort(Object object) throws IlvConvertException {
        return (Short)IlvConvert.convert(object, Short.class);
    }

    public static final byte convertToByte(Object object) throws IlvConvertException {
        return (Byte)IlvConvert.convert(object, Byte.class);
    }

    static {
        Class[] classArray = new Class[9];
        classArray[0] = Byte.class;
        classArray[1] = Short.class;
        classArray[2] = Integer.class;
        classArray[3] = Long.class;
        classArray[4] = Float.class;
        classArray[5] = Double.class;
        classArray[6] = BigDecimal.class;
        classArray[7] = BigInteger.class;
        classArray[8] = Boolean.class;
        b = classArray;
        IlvConvert.addConverter(new NumberToNumberFilter());
        IlvConvert.addConverter(new StringToColorFilter());
        IlvConvert.addConverter(new ColorToStringFilter());
        IlvConvert.addConverter(new NumberToColorFilter());
        IlvConvert.addConverter(new ColorToNumberFilter());
        IlvConvert.addConverter(new StringToFontFilter());
        IlvConvert.addConverter(new FontToStringFilter());
        IlvConvert.addConverter(new StringToNumberFilter());
        IlvConvert.addConverter(new NumberToStringFilter());
        IlvConvert.addConverter(new StringToCurrencyPercentConverter());
        IlvConvert.addConverter(new StringToDateConverter());
        IlvConvert.addConverter(new PercentToStringConverter());
        IlvConvert.addConverter(new CurrencyToStringConverter());
    }

    private static class PropertyEditorWrapper
    implements IlvConverter {
        private PropertyEditor a;
        private Class b;

        public PropertyEditorWrapper(PropertyEditor propertyEditor, Class clazz) {
            this.a = propertyEditor;
            this.b = clazz;
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            try {
                if (clazz == this.b && object instanceof String) {
                    this.a.setAsText(object.toString());
                    return this.a.getValue();
                }
                if (clazz == String.class && object.getClass() == this.b) {
                    this.a.setValue(object);
                    return this.a.getAsText();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IlvConvertException(illegalArgumentException, "cannot convert " + object + " to " + clazz);
            }
            throw new IlvConvertException("cannot convert " + object + " to " + clazz);
        }

        public Class[] fromTypes() {
            Class[] classArray = new Class[2];
            classArray[0] = String.class;
            classArray[1] = this.b;
            return classArray;
        }

        public Class[] toTypes() {
            return this.fromTypes();
        }
    }

    static class StringToFontFilter
    implements IlvConverter {
        StringToFontFilter() {
        }

        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Class[] toTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Font.class;
            return classArray;
        }

        public Object convert(Object object, Class clazz) {
            return Font.decode((String)object);
        }
    }

    static class FontToStringFilter
    implements IlvConverter {
        FontToStringFilter() {
        }

        public Class[] fromTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Font.class;
            return classArray;
        }

        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Object convert(Object object, Class clazz) {
            Font font = (Font)object;
            String string = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
            String string2 = font.getName();
            if (string2 == null) {
                string2 = "Dialog";
            }
            return string2 + "-" + string + "-" + font.getSize();
        }
    }

    static class StringToDateConverter
    implements IlvLocalizedConverter {
        StringToDateConverter() {
        }

        public Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
            String string = (String)object;
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            try {
                Date date = dateFormat.parse(string);
                return date;
            }
            catch (ParseException parseException) {
                int n2 = string.indexOf(44);
                if (n2 == -1) {
                    throw new IlvConvertException("cannot convert " + object + " to java.util.Date. Use syntax like \"mm/dd/yy,02/21/03\"", object);
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string.substring(0, n2), locale);
                ParsePosition parsePosition = new ParsePosition(n2 + 1);
                Date date = simpleDateFormat.parse(string, parsePosition);
                if (parsePosition.getErrorIndex() != -1) {
                    throw new IlvConvertException("cannot convert " + object + " to java.util.Date. Use syntax like \"mm/dd/yy,06/18/64\". Problem located at pos " + parsePosition.getErrorIndex() + ".", object);
                }
                return date;
            }
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            try {
                return this.convert(object, clazz, Locale.getDefault());
            }
            catch (IlvConvertException ilvConvertException) {
                try {
                    return new SimpleDateFormat().parse((String)object);
                }
                catch (Exception exception) {
                    throw ilvConvertException;
                }
            }
        }

        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Class[] toTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Date.class;
            return classArray;
        }
    }

    static class NumberToColorFilter
    implements IlvConverter {
        private static NumberToNumberFilter a = new NumberToNumberFilter();
        private static Class b;

        NumberToColorFilter() {
        }

        public Class[] fromTypes() {
            Class[] classArray = new Class[6];
            classArray[0] = Byte.class;
            classArray[1] = Short.class;
            classArray[2] = Integer.class;
            classArray[3] = Long.class;
            classArray[4] = Float.class;
            classArray[5] = Double.class;
            Class[] classArray2 = classArray;
            return classArray2;
        }

        public Class[] toTypes() {
            Class[] classArray;
            if (b != null) {
                classArray = new Class[2];
                classArray[0] = Color.class;
                classArray[1] = b;
            } else {
                classArray = new Class[1];
                classArray[0] = Color.class;
            }
            return classArray;
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            Integer n2 = (Integer)a.convert(object, Integer.class);
            return new Color(n2);
        }

        static {
            try {
                b = Class.forName("java.awt.Paint");
            }
            catch (Throwable throwable) {
                b = null;
            }
        }
    }

    static class ColorToNumberFilter
    implements IlvConverter {
        private static NumberToNumberFilter a = new NumberToNumberFilter();

        ColorToNumberFilter() {
        }

        public Class[] fromTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Color.class;
            return classArray;
        }

        public Class[] toTypes() {
            Class[] classArray = new Class[6];
            classArray[0] = Byte.class;
            classArray[1] = Short.class;
            classArray[2] = Integer.class;
            classArray[3] = Long.class;
            classArray[4] = Float.class;
            classArray[5] = Double.class;
            Class[] classArray2 = classArray;
            return classArray2;
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            Color color = (Color)object;
            int n2 = color.getRGB();
            return a.convert(new Integer(n2), clazz);
        }
    }

    static class StringToColorFilter
    implements IlvConverter {
        StringToColorFilter() {
        }

        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Class[] toTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Color.class;
            return classArray;
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            try {
                return IlvColorUtil.toColor(object.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IlvConvertException("cannot convert " + object + " to java.awt.Color");
            }
        }
    }

    static class ColorToStringFilter
    implements IlvConverter {
        ColorToStringFilter() {
        }

        public Class[] fromTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Color.class;
            return classArray;
        }

        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            try {
                return IlvColorUtil.toHumanReadableString((Color)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IlvConvertException("cannot convert color " + object + " to String");
            }
        }
    }

    static class CurrencyToStringConverter
    implements IlvLocalizedConverter {
        CurrencyToStringConverter() {
        }

        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Class[] fromTypes() {
            return new Class[]{IlvLocalizedConverter.CURRENCY_AS_NUMBER_CLASS};
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            return this.convert(object, clazz, Locale.getDefault());
        }

        public Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
            NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
            return numberFormat.format(object);
        }
    }

    static class PercentToStringConverter
    implements IlvLocalizedConverter {
        PercentToStringConverter() {
        }

        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Class[] fromTypes() {
            return new Class[]{IlvLocalizedConverter.PERCENT_AS_NUMBER_CLASS};
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            return this.convert(object, clazz, Locale.getDefault());
        }

        public Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
            NumberFormat numberFormat = NumberFormat.getPercentInstance(locale);
            return numberFormat.format(object);
        }
    }

    static class StringToCurrencyPercentConverter
    implements IlvLocalizedConverter {
        StringToCurrencyPercentConverter() {
        }

        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Class[] toTypes() {
            return new Class[]{IlvLocalizedConverter.CURRENCY_AS_NUMBER_CLASS, IlvLocalizedConverter.PERCENT_AS_NUMBER_CLASS};
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            return this.convert(object, clazz, Locale.getDefault());
        }

        public Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
            boolean bl = clazz == IlvLocalizedConverter.PERCENT_AS_NUMBER_CLASS;
            try {
                NumberFormat numberFormat = bl ? NumberFormat.getCurrencyInstance(locale) : NumberFormat.getPercentInstance(locale);
                Number number = numberFormat.parse((String)object);
                return number;
            }
            catch (ParseException parseException) {
                throw new IlvConvertException("cannot convert " + (bl ? "percent " : "currency ") + object + " to String, with Locale: " + locale);
            }
        }
    }

    static class StringToNumberFilter
    implements IlvLocalizedConverter {
        static HashMap[] a = new HashMap[10];
        static final int b = 500;

        StringToNumberFilter() {
        }

        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Class[] toTypes() {
            return b;
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            Comparable<Boolean> comparable;
            HashMap<Object, Boolean> hashMap;
            block32: {
                int n2 = 9;
                if (clazz == Byte.class) {
                    n2 = 0;
                } else if (clazz == Short.class) {
                    n2 = 1;
                } else if (clazz == Integer.class) {
                    n2 = 2;
                } else if (clazz == Long.class) {
                    n2 = 3;
                } else if (clazz == Float.class) {
                    n2 = 4;
                } else if (clazz == Double.class) {
                    n2 = 5;
                } else if (clazz == String.class) {
                    n2 = 6;
                } else if (clazz == BigInteger.class) {
                    n2 = 7;
                } else if (clazz == BigDecimal.class) {
                    n2 = 8;
                }
                hashMap = a[n2];
                comparable = null;
                if (hashMap == null) {
                    StringToNumberFilter.a[n2] = hashMap = new HashMap<Object, Boolean>();
                } else {
                    comparable = (Comparable<Boolean>)hashMap.get(object);
                }
                if (comparable != null) {
                    return comparable;
                }
                String string = (String)object;
                try {
                    if (clazz == Boolean.class) {
                        comparable = string.equalsIgnoreCase("true") ? Boolean.TRUE : (string.equalsIgnoreCase("false") ? Boolean.FALSE : (Double.valueOf(string) != 0.0 ? Boolean.TRUE : Boolean.FALSE));
                        break block32;
                    }
                    if (clazz == Byte.class) {
                        comparable = Byte.valueOf(string);
                        break block32;
                    }
                    if (clazz == Short.class) {
                        comparable = Short.valueOf(string);
                        break block32;
                    }
                    if (clazz == Integer.class) {
                        comparable = Integer.valueOf(string);
                        break block32;
                    }
                    if (clazz == Long.class) {
                        comparable = Long.valueOf(string);
                        break block32;
                    }
                    if (clazz == Float.class) {
                        comparable = Float.valueOf(string);
                        break block32;
                    }
                    if (clazz == Double.class) {
                        comparable = Double.valueOf(string);
                        break block32;
                    }
                    if (clazz == BigDecimal.class) {
                        comparable = new BigDecimal(string);
                        break block32;
                    }
                    if (clazz == BigInteger.class) {
                        comparable = new BigInteger(string);
                        break block32;
                    }
                    throw new IlvConvertException("cannot convert " + object + " to " + clazz);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IlvConvertException("cannot convert " + object + " to " + clazz);
                }
            }
            if (hashMap.size() < 500) {
                hashMap.put(object, (Boolean)comparable);
            }
            return comparable;
        }

        public Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
            try {
                if (clazz == Boolean.class) {
                    return this.convert(object, clazz);
                }
                Number number = NumberFormat.getInstance(locale).parse((String)object);
                return IlvConvert.convert(number, clazz);
            }
            catch (ParseException parseException) {
                throw new IlvConvertException("cannot convert number " + object + " to String, with Locale: " + locale);
            }
        }
    }

    static class NumberToStringFilter
    implements IlvLocalizedConverter {
        NumberToStringFilter() {
        }

        public Class[] fromTypes() {
            return b;
        }

        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            return object.toString();
        }

        public Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
            return IlvConvert.convert(NumberFormat.getInstance(locale).format(object), clazz);
        }
    }

    static class NumberToNumberFilter
    implements IlvConverter {
        NumberToNumberFilter() {
        }

        public Class[] fromTypes() {
            Class[] classArray = new Class[b.length + 1];
            for (int i2 = 0; i2 < b.length; ++i2) {
                classArray[i2] = b[i2];
            }
            classArray[i2] = Number.class;
            return classArray;
        }

        public Class[] toTypes() {
            return b;
        }

        public Object convert(Object object, Class clazz) throws IlvConvertException {
            Class<?> clazz2 = object.getClass();
            if (clazz2 == Boolean.class) {
                if (clazz == Byte.class) {
                    return new Byte((byte)((Boolean)object != false ? 1 : 0));
                }
                if (clazz == Short.class) {
                    return new Short((short)((Boolean)object != false ? 1 : 0));
                }
                if (clazz == Integer.class) {
                    return new Integer((Boolean)object != false ? 1 : 0);
                }
                if (clazz == Long.class) {
                    return new Long((Boolean)object != false ? 1L : 0L);
                }
                if (clazz == Float.class) {
                    return new Float((Boolean)object != false ? 1.0f : 0.0f);
                }
                if (clazz == Double.class) {
                    return new Double((Boolean)object != false ? 1.0 : 0.0);
                }
                if (clazz == BigDecimal.class) {
                    return BigDecimal.valueOf((Boolean)object != false ? 1L : 0L);
                }
                if (clazz == BigInteger.class) {
                    return BigInteger.valueOf((Boolean)object != false ? 1L : 0L);
                }
                return object;
            }
            Number number = (Number)object;
            if (clazz == Byte.class) {
                return new Byte(number.byteValue());
            }
            if (clazz == Short.class) {
                return new Short(number.shortValue());
            }
            if (clazz == Integer.class) {
                return new Integer(number.intValue());
            }
            if (clazz == Long.class) {
                return new Long(number.longValue());
            }
            if (clazz == Float.class) {
                return new Float(number.floatValue());
            }
            if (clazz == Double.class) {
                return new Double(number.doubleValue());
            }
            if (clazz == BigDecimal.class) {
                return BigDecimal.valueOf(number.longValue());
            }
            if (clazz == BigInteger.class) {
                return BigInteger.valueOf(number.longValue());
            }
            return number.longValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
    }
}

