/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.swing;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerChangedEvent;
import ilog.views.event.ManagerChangedListener;
import ilog.views.event.ManagerContentAboutToChangeEvent;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentMonitor;
import ilog.views.event.ManagerLayerEvent;
import ilog.views.event.ManagerLayerInsertedEvent;
import ilog.views.event.ManagerLayerListener;
import ilog.views.event.ManagerLayerMovedEvent;
import ilog.views.event.ManagerLayerRemovedEvent;
import ilog.views.event.ManagerLayerVisibilityEvent;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.event.ObjectVisibilityChangedEvent;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.internal.IlvBoundingBoxCache;
import ilog.views.internal.IlvUtility;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelListener;
import java.beans.Beans;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;

public class IlvJScrollManagerView
extends JComponent {
    private static UI a;
    private IlvManagerView b;
    private JScrollBar c;
    private JScrollBar d;
    private int e;
    private int f;
    private boolean g = true;
    private boolean h = true;
    private int i;
    private int j;
    private boolean k;
    private scrollListener l = new scrollListener();
    private Object m;
    private transient int n = 0;
    private transient boolean o = false;
    private boolean p = false;
    private IlvBoundingBoxCache q = new IlvBoundingBoxCache(1);
    public static final int VERTICAL_SCROLLBAR_AS_NEEDED = 20;
    public static final int VERTICAL_SCROLLBAR_NEVER = 21;
    public static final int VERTICAL_SCROLLBAR_ALWAYS = 22;
    public static final int HORIZONTAL_SCROLLBAR_AS_NEEDED = 30;
    public static final int HORIZONTAL_SCROLLBAR_NEVER = 31;
    public static final int HORIZONTAL_SCROLLBAR_ALWAYS = 32;

    private boolean a(IlvGraphic ilvGraphic) {
        IlvTransformer ilvTransformer = this.b.getTransformer();
        IlvRect ilvRect = this.q.get(ilvTransformer);
        if (ilvRect == null) {
            return false;
        }
        IlvRect ilvRect2 = ilvGraphic.boundingBox(ilvTransformer);
        return ilvRect2.x > ilvRect.x && ilvRect2.x + ilvRect2.width < ilvRect.x + ilvRect.width && ilvRect2.y > ilvRect.y && ilvRect2.y + ilvRect2.height < ilvRect.y + ilvRect.height;
    }

    public IlvJScrollManagerView() {
        this(new IlvManager(), new IlvTransformer());
    }

    public IlvJScrollManagerView(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        this.b = this.createManagerView(ilvManager, ilvTransformer);
        this.a();
    }

    public IlvJScrollManagerView(IlvManagerView ilvManagerView) {
        this.b = ilvManagerView;
        this.a();
    }

    public void updateUI() {
        if (a == null) {
            a = new UI();
        }
        this.setUI(a);
    }

    public void setAdjusting(boolean bl) {
        if (bl) {
            ++this.n;
            if (this.n == 1) {
                this.o = false;
            }
        } else if (this.n > 0) {
            --this.n;
            if (this.n == 0 && this.o) {
                this.o = false;
                this.p = false;
                this.adjustScrollBars();
            }
        }
    }

    public final boolean isAdjusting() {
        return this.n > 0;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public final JScrollBar getVerticalScrollBar() {
        return this.c;
    }

    public final JScrollBar getHorizontalScrollBar() {
        return this.d;
    }

    protected IlvManagerView createManagerView(IlvManager ilvManager, IlvTransformer ilvTransformer) {
        return new IlvManagerView(ilvManager, ilvTransformer);
    }

    private final void a() {
        this.setBorder(new BevelBorder(1));
        this.setLayout(null);
        this.add(this.b);
        this.c = new JScrollBar(1);
        this.c.setUnitIncrement(10);
        this.add(this.c);
        this.d = new JScrollBar(0);
        this.d.setUnitIncrement(10);
        this.add(this.d);
        this.setOpaque(true);
        this.updateUI();
        this.i = 22;
        this.j = 32;
        this.n = 0;
    }

    public void removeNotify() {
        this.k = false;
        this.d.removeAdjustmentListener(this.l);
        this.c.removeAdjustmentListener(this.l);
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        this.d.addAdjustmentListener(this.l);
        this.c.addAdjustmentListener(this.l);
        this.k = true;
        this.adjustScrollBars();
    }

    public void doLayout() {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        Insets insets = this.getBorder().getBorderInsets(this);
        int n4 = this.g ? this.c.getPreferredSize().width : 0;
        int n5 = this.h ? this.d.getPreferredSize().height : 0;
        this.b.setBounds(insets.left, insets.top, Math.max(0, n2 - n4 - (insets.left + insets.right)), Math.max(0, n3 - n5 - (insets.top + insets.bottom)));
        if (this.g) {
            this.c.setBounds(n2 - n4 - insets.right, insets.top, n4, n3 - n5 - (insets.top + insets.bottom));
        }
        if (this.h) {
            this.d.setBounds(insets.left, n3 - n5 - insets.bottom, n2 - n4 - (insets.left + insets.right), n5);
        }
    }

    public final IlvManagerView getView() {
        return this.b;
    }

    public final void setView(IlvManagerView ilvManagerView) {
        if (ilvManagerView == null) {
            if (Beans.isDesignTime()) {
                return;
            }
            throw new IllegalArgumentException("view cannot be null");
        }
        this.addImpl(ilvManagerView, null, 0);
    }

    public void adjustScrollBars() {
        if (IlvSwingUtil.isDispatchThread()) {
            this.c();
        } else {
            this.b();
        }
    }

    private void b() {
        if (this.p) {
            return;
        }
        this.p = true;
        SwingUtilities.invokeLater(this.l);
    }

    private void c() {
        if (!this.k) {
            return;
        }
        if (this.isAdjusting()) {
            this.o = true;
            return;
        }
        this.p = false;
        IlvRect ilvRect = this.b.computeBBox();
        this.q.put(this.b.getTransformer(), new IlvRect(ilvRect));
        int n2 = this.b.getHeight();
        int n3 = this.b.getWidth();
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, n3, n2);
        ilvRect.width = (float)Math.floor((double)ilvRect.width + 1.0);
        ilvRect.height = (float)Math.floor((double)ilvRect.height + 1.0);
        ilvRect.x = (float)Math.floor(ilvRect.x);
        ilvRect.y = (float)Math.floor(ilvRect.y);
        ilvRect.add(ilvRect2);
        this.e = -((int)ilvRect.x);
        this.f = -((int)ilvRect.y);
        if (this.getHorizontalScrollBarPolicy() == 30) {
            if (ilvRect2.x <= ilvRect.x && ilvRect.x + ilvRect.width <= ilvRect2.x + ilvRect2.width) {
                this.setHorizontalScrollBarVisible(false);
            } else {
                this.setHorizontalScrollBarVisible(true);
            }
        }
        if (this.getVerticalScrollBarPolicy() == 20) {
            if (ilvRect2.y <= ilvRect.y && ilvRect.y + ilvRect.height <= ilvRect2.y + ilvRect2.height) {
                this.setVerticalScrollBarVisible(false);
            } else {
                this.setVerticalScrollBarVisible(true);
            }
        }
        if (this.c != null && this.g && (this.c.getValue() != this.f || this.c.getVisibleAmount() != n2 || (float)this.c.getMaximum() != ilvRect.height)) {
            this.c.removeAdjustmentListener(this.l);
            this.c.setValues(this.f, n2 > 0 ? n2 : 1, 0, (int)ilvRect.height);
            this.c.setBlockIncrement(Math.max(this.c.getVisibleAmount(), 1));
            this.c.addAdjustmentListener(this.l);
        }
        if (this.d != null && this.h && (this.d.getValue() != this.e || this.d.getVisibleAmount() != n3 || (float)this.d.getMaximum() != ilvRect.width)) {
            this.d.removeAdjustmentListener(this.l);
            this.d.setValues(this.e, n3 > 0 ? n3 : 1, 0, (int)ilvRect.width);
            this.d.setBlockIncrement(Math.max(this.d.getVisibleAmount(), 1));
            this.d.addAdjustmentListener(this.l);
        }
        if (this.d != null) {
            this.e = this.d.getValue();
        }
        if (this.c != null) {
            this.f = this.c.getValue();
        }
    }

    public void adjustView() {
        if (this.d.getValue() != this.e || this.c.getValue() != this.f) {
            this.b.removeTransformerListener(this.l);
            this.b.removeComponentListener(this.l);
            this.b.translate(this.d != null && this.h ? (float)(-(this.d.getValue() - this.e)) : 0.0f, this.c != null && this.g ? (float)(-(this.c.getValue() - this.f)) : 0.0f, true);
            this.b.addTransformerListener(this.l);
            this.b.addComponentListener(this.l);
            if (this.getHorizontalScrollBarPolicy() == 30 || this.getVerticalScrollBarPolicy() == 20) {
                this.adjustScrollBars();
            }
            float f2 = ((Component)this.c).getHeight();
            float f3 = ((Component)this.c).getWidth();
            IlvRect ilvRect = new IlvRect(0.0f, 0.0f, f3, f2);
            IlvRect ilvRect2 = this.b.computeBBox();
            ilvRect2.add(ilvRect);
            ilvRect2.width = (float)Math.floor((double)ilvRect2.width + 1.0);
            ilvRect2.height = (float)Math.floor((double)ilvRect2.height + 1.0);
            ilvRect2.x = (float)Math.floor(ilvRect2.x);
            ilvRect2.y = (float)Math.floor(ilvRect2.y);
            this.e = this.d.getValue();
            this.f = this.c.getValue();
        }
    }

    public int getVerticalScrollBarPolicy() {
        return this.i;
    }

    public void setVerticalScrollBarPolicy(int n2) {
        if (n2 == this.i) {
            return;
        }
        switch (n2) {
            case 20: {
                this.i = n2;
                this.adjustScrollBars();
                break;
            }
            case 21: {
                this.i = n2;
                this.setVerticalScrollBarVisible(false);
                break;
            }
            case 22: {
                this.i = n2;
                this.setVerticalScrollBarVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid verticalScrollBarPolicy");
            }
        }
    }

    public int getHorizontalScrollBarPolicy() {
        return this.j;
    }

    public void setHorizontalScrollBarPolicy(int n2) {
        if (n2 == this.j) {
            return;
        }
        switch (n2) {
            case 30: {
                this.j = n2;
                this.adjustScrollBars();
                break;
            }
            case 31: {
                this.j = n2;
                this.setHorizontalScrollBarVisible(false);
                break;
            }
            case 32: {
                this.j = n2;
                this.setHorizontalScrollBarVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid horizontalScrollBarPolicy");
            }
        }
    }

    public boolean isVerticalScrollBarVisible() {
        return this.g;
    }

    public void setVerticalScrollBarVisible(boolean bl) {
        if (bl == this.g) {
            return;
        }
        this.g = bl;
        if (bl) {
            this.adjustScrollBars();
            this.invalidate();
            this.add(this.c);
            this.validate();
        } else {
            this.remove(this.c);
            this.invalidate();
            this.validate();
        }
    }

    public boolean isHorizontalScrollBarVisible() {
        return this.h;
    }

    public void setHorizontalScrollBarVisible(boolean bl) {
        if (bl == this.h) {
            return;
        }
        this.h = bl;
        if (bl) {
            this.adjustScrollBars();
            this.invalidate();
            this.add(this.d);
            this.validate();
        } else {
            this.remove(this.d);
            this.invalidate();
            this.validate();
        }
    }

    public boolean isWheelScrollingEnabled() {
        return this.m != null;
    }

    public void setWheelScrollingEnabled(boolean bl) {
        if (bl) {
            if (this.m == null) {
                this.m = new IlvUtility.MouseWheelAdapter(this);
                this.addMouseWheelListener((MouseWheelListener)this.m);
            }
        } else if (this.m != null) {
            this.removeMouseWheelListener((MouseWheelListener)this.m);
            this.m = null;
        }
    }

    public void processManagerViewKeyEvent(KeyEvent keyEvent) {
        this.processKeyEvent(keyEvent);
    }

    public void paintComponent(Graphics graphics) {
        if (this.h && this.g) {
            graphics.setColor(this.getBackground());
            Border border = this.getBorder();
            int n2 = 0;
            int n3 = 0;
            if (border != null) {
                Insets insets = border.getBorderInsets(this);
                n2 = insets.right;
                n3 = insets.bottom;
            }
            int n4 = this.c.getPreferredSize().width;
            int n5 = this.d.getPreferredSize().height;
            graphics.fillRect(this.getWidth() - n4 - n2, this.getHeight() - n5 - n3, n4, n5);
            try {
                if (UIManager.getLookAndFeel().getName().contains("GTK")) {
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.paintComponent(graphics);
    }

    protected void addImpl(Component component, Object object, int n2) {
        if (component instanceof IlvManagerView) {
            if (this.b != null && this.b.getParent() == this) {
                this.b.removeTransformerListener(this.l);
                this.b.removeComponentListener(this.l);
                this.b.removeManagerChangedListener(this.l);
                this.b.getManager().removeManagerContentChangedListener(this.l);
                this.b.getManager().removeManagerLayerListener(this.l);
                this.remove(this.b);
            }
            this.b = (IlvManagerView)component;
            this.b.addTransformerListener(this.l);
            this.b.addComponentListener(this.l);
            this.b.addManagerChangedListener(this.l);
            this.b.getManager().addManagerContentChangedListener(this.l);
            this.b.getManager().addManagerLayerListener(this.l);
            this.b.setTransparent(false);
        }
        super.addImpl(component, object, n2);
    }

    private static class UI
    extends ComponentUI {
        private UI() {
        }

        public void update(Graphics graphics, JComponent jComponent) {
            IlvJScrollManagerView ilvJScrollManagerView = (IlvJScrollManagerView)jComponent;
            IlvManagerView ilvManagerView = ilvJScrollManagerView.getView();
            if (jComponent.isOpaque() && (ilvManagerView == null || ilvManagerView.isTransparent())) {
                graphics.setColor(jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
            this.paint(graphics, jComponent);
        }
    }

    private class scrollListener
    extends ComponentAdapter
    implements TransformerListener,
    ManagerContentMonitor,
    ManagerLayerListener,
    AdjustmentListener,
    Serializable,
    Runnable,
    ManagerChangedListener {
        private scrollListener() {
        }

        public void managerChanged(ManagerChangedEvent managerChangedEvent) {
            if (managerChangedEvent.getOldValue() != null) {
                managerChangedEvent.getOldValue().removeManagerContentChangedListener(this);
                managerChangedEvent.getOldValue().removeManagerLayerListener(this);
            }
            if (managerChangedEvent.getNewValue() != null) {
                managerChangedEvent.getNewValue().addManagerContentChangedListener(this);
                managerChangedEvent.getNewValue().addManagerLayerListener(this);
            }
            IlvJScrollManagerView.this.adjustScrollBars();
        }

        public void componentResized(ComponentEvent componentEvent) {
            IlvJScrollManagerView.this.c();
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            IlvJScrollManagerView.this.adjustScrollBars();
        }

        public void contentAboutToChange(ManagerContentAboutToChangeEvent managerContentAboutToChangeEvent) {
            IlvGraphic ilvGraphic = managerContentAboutToChangeEvent.getGraphicObject();
            if (IlvJScrollManagerView.this.a(ilvGraphic)) {
                return;
            }
            if (!managerContentAboutToChangeEvent.isAdjusting()) {
                IlvJScrollManagerView.this.b();
            }
        }

        public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
            if (!managerContentChangedEvent.isAdjusting()) {
                IlvGraphic ilvGraphic;
                IlvGraphic ilvGraphic2;
                IlvGraphic ilvGraphic3;
                if (managerContentChangedEvent instanceof ObjectInsertedEvent ? IlvJScrollManagerView.this.a(ilvGraphic3 = ((ObjectInsertedEvent)managerContentChangedEvent).getGraphicObject()) : (managerContentChangedEvent instanceof ObjectVisibilityChangedEvent ? IlvJScrollManagerView.this.a(ilvGraphic2 = ((ObjectVisibilityChangedEvent)managerContentChangedEvent).getGraphicObject()) : (managerContentChangedEvent instanceof ObjectBBoxChangedEvent ? IlvJScrollManagerView.this.a(ilvGraphic = ((ObjectBBoxChangedEvent)managerContentChangedEvent).getGraphicObject()) : managerContentChangedEvent instanceof ObjectRemovedEvent))) {
                    return;
                }
                IlvJScrollManagerView.this.b();
            }
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            IlvJScrollManagerView.this.adjustView();
        }

        public void layerInserted(ManagerLayerInsertedEvent managerLayerInsertedEvent) {
        }

        public void layerRemoved(ManagerLayerRemovedEvent managerLayerRemovedEvent) {
        }

        public void layerMoved(ManagerLayerMovedEvent managerLayerMovedEvent) {
        }

        public void layerChanged(ManagerLayerEvent managerLayerEvent) {
            IlvManagerView ilvManagerView;
            if (managerLayerEvent instanceof ManagerLayerVisibilityEvent && ((ilvManagerView = ((ManagerLayerVisibilityEvent)managerLayerEvent).getManagerView()) == null || ilvManagerView == IlvJScrollManagerView.this.b)) {
                IlvJScrollManagerView.this.adjustScrollBars();
            }
        }

        public void run() {
            IlvJScrollManagerView.this.c();
        }
    }
}

