/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.svg.servlet;

import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvRect;
import ilog.views.svg.SVGDocumentBuilder;
import ilog.views.svg.SVGDocumentBuilderConfigurator;
import ilog.views.util.xml.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public abstract class IlvSVGManagerServletSupport {
    private boolean a = false;
    private boolean b = false;
    ServletContext c = null;
    private SVGDocumentBuilderConfigurator d = null;

    public IlvSVGManagerServletSupport(SVGDocumentBuilderConfigurator sVGDocumentBuilderConfigurator, ServletContext servletContext) {
        this.c = servletContext;
        this.d = sVGDocumentBuilderConfigurator;
        this.d.setCompactMode(this.d.getCompactMode() & 0x1A);
        this.d.setMetadataOn("http://xmlns.ilog.com/JViews/GraphicsFramework", "ilvgf", true);
    }

    protected final ServletContext getContext() {
        return this.c;
    }

    public final void setVerbose(boolean bl) {
        this.a = bl;
    }

    public final boolean isVerbose() {
        return this.a;
    }

    public final void setContentLengthEnable(boolean bl) {
        this.b = bl;
    }

    public final boolean getContentLengthEnable() {
        return this.b;
    }

    public abstract IlvManager getManager(HttpServletRequest var1) throws ServletException;

    protected IlvManagerLayer[] getLayers(HttpServletRequest httpServletRequest, IlvManager ilvManager) throws ServletException {
        return this.a(httpServletRequest, ilvManager);
    }

    final IlvManagerLayer[] a(HttpServletRequest httpServletRequest, IlvManager ilvManager) throws ServletException {
        IlvManagerLayer[] ilvManagerLayerArray = new IlvManagerLayer[ilvManager.getLayersCount()];
        for (int i2 = 0; i2 < ilvManagerLayerArray.length; ++i2) {
            ilvManagerLayerArray[i2] = ilvManager.getManagerLayer(i2);
        }
        return ilvManagerLayerArray;
    }

    protected Object getLock(HttpServletRequest httpServletRequest) {
        return this.a(httpServletRequest);
    }

    final Object a(HttpServletRequest httpServletRequest) {
        return new Boolean(true);
    }

    protected Document generateSVGDocument(HttpServletRequest httpServletRequest, int n2, int n3, String[] stringArray) throws ServletException {
        return this.a(httpServletRequest, n2, n3, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    Document a(HttpServletRequest var1_1, int var2_2, int var3_3, String[] var4_4) throws ServletException {
        if (this.isVerbose()) {
            this.c.log("Starts generating SVG image");
            this.c.log("  width=" + var2_2);
            this.c.log("  height=" + var3_3);
            var5_5 = new StringBuffer("  layers=");
            for (var6_6 = 0; var6_6 < var4_4.length; ++var6_6) {
                var5_5.append(var4_4[var6_6] + " ");
            }
            this.c.log(var5_5.toString());
            this.c.log("");
        }
        var5_5 = null;
        var6_7 = this.getLock(var1_1);
        synchronized (var6_7) {
            var7_8 = this.getManager(var1_1);
            this.prepareManager(var1_1, var7_8);
            var8_9 = this.getLayers(var1_1, var7_8);
            var9_10 = new HashMap<Serializable, Boolean>();
            if (var4_4.length != 0) {
                for (var10_11 = 0; var10_11 < var4_4.length; ++var10_11) {
                    var11_13 = var4_4[var10_11];
                    var12_14 /* !! */  = null;
                    if (!var11_13.startsWith("Layer_")) {
                        for (var13_15 = 0; var13_15 < var8_9.length; ++var13_15) {
                            if (var8_9[var13_15].getName() == null || !var8_9[var13_15].getName().equals(var11_13)) continue;
                            var12_14 /* !! */  = var8_9[var13_15];
                            break;
                        }
                    } else {
                        try {
                            var13_15 = Integer.parseInt(var11_13.substring(6, var11_13.length()));
                            if (var13_15 < 0 || var13_15 >= var8_9.length) ** GOTO lbl37
                            var12_14 /* !! */  = var8_9[var13_15];
                        }
                        catch (Exception var13_16) {
                            throw new ServletException("bad layer : " + (String)var11_13);
                        }
                    }
                    if (var12_14 /* !! */  == null) {
                        throw new ServletException("bad layer : " + (String)var11_13);
                    }
                    var9_10.put(var12_14 /* !! */ , Boolean.TRUE);
                }
            } else {
                for (var10_11 = 0; var10_11 < var8_9.length; ++var10_11) {
                    var9_10.put(var8_9[var10_11], Boolean.TRUE);
                }
            }
            var10_12 = IlvSVGManagerServletSupport.c(var1_1);
            if (this.d.isViewBoxOn() || var10_12 != null) {
                var11_13 = this.d;
                synchronized (var11_13) {
                    var12_14 /* !! */  = this.d.getViewBox();
                    if (var10_12 != null) {
                        this.d.setViewBox(var10_12);
                    }
                    this.d.setAttribute("width", Integer.toString(var2_2));
                    this.d.setAttribute("height", Integer.toString(var3_3));
                    var5_5 = this.a(var7_8, var9_10, var4_4.length != 0);
                    if (var12_14 /* !! */  != null) {
                        this.d.setViewBox(var12_14 /* !! */ );
                    }
                }
            } else {
                var5_5 = this.a(var7_8, var9_10, var4_4.length != 0);
            }
        }
        if (this.isVerbose()) {
            this.c.log("Ends generating Image");
        }
        return var5_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document a(IlvManager ilvManager, final Map map, final boolean bl) {
        SVGDocumentBuilder sVGDocumentBuilder = new SVGDocumentBuilder(this.d){

            protected Element translate(IlvManagerLayer ilvManagerLayer) {
                if (map.containsKey(ilvManagerLayer)) {
                    Element element = super.translate(ilvManagerLayer);
                    if (bl) {
                        element.setAttribute("id", "lod__" + element.getAttribute("id"));
                    }
                    return element;
                }
                return null;
            }
        };
        if (bl) {
            SVGDocumentBuilderConfigurator sVGDocumentBuilderConfigurator = this.d;
            synchronized (sVGDocumentBuilderConfigurator) {
                int n2 = this.d.getCompactMode();
                SVGDocument sVGDocument = null;
                try {
                    this.d.setCompactMode(n2 & 8);
                    sVGDocument = sVGDocumentBuilder.buildDocument(ilvManager);
                }
                finally {
                    this.d.setCompactMode(n2);
                }
                return sVGDocument;
            }
        }
        return sVGDocumentBuilder.buildDocument(ilvManager);
    }

    private static IlvManagerLayer[] a(IlvManager ilvManager) {
        IlvManagerLayer[] ilvManagerLayerArray = new IlvManagerLayer[ilvManager.getLayersCount()];
        for (int i2 = 0; i2 < ilvManagerLayerArray.length; ++i2) {
            ilvManagerLayerArray[i2] = ilvManager.getManagerLayer(i2);
        }
        return ilvManagerLayerArray;
    }

    private void b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        int n2 = IlvSVGManagerServletSupport.a(httpServletRequest, "width");
        int n3 = IlvSVGManagerServletSupport.a(httpServletRequest, "height");
        String[] stringArray = IlvSVGManagerServletSupport.b(httpServletRequest);
        Document document = this.generateSVGDocument(httpServletRequest, n2, n3, stringArray);
        httpServletResponse.setContentType("image/svg+xml");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (this.b) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLUtil.WriteDocument(document, byteArrayOutputStream);
            httpServletResponse.setContentLength(byteArrayOutputStream.size());
            byteArrayOutputStream.writeTo((OutputStream)servletOutputStream);
        } else {
            XMLUtil.WriteDocument(document, (OutputStream)servletOutputStream);
        }
    }

    protected void prepareManager(HttpServletRequest httpServletRequest, IlvManager ilvManager) throws ServletException {
    }

    public boolean handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.a(httpServletRequest, httpServletResponse);
    }

    final boolean a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getParameter("request");
        if (this.isVerbose()) {
            this.c.log("request is " + httpServletRequest.getQueryString());
        }
        if (string == null) {
            return false;
        }
        if (string.equals("image")) {
            this.b(httpServletRequest, httpServletResponse);
            return true;
        }
        if (this.isVerbose()) {
            this.c.log("wrong type '" + string + "'");
        }
        return false;
    }

    private static int a(HttpServletRequest httpServletRequest, String string) throws ServletException {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null || string2.length() == 0) {
            throw new ServletException("parameter " + string + " is required");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException("bad parameter " + string);
        }
    }

    private static String[] b(HttpServletRequest httpServletRequest) throws ServletException {
        String string = httpServletRequest.getParameter("layer");
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static IlvRect c(HttpServletRequest httpServletRequest) throws ServletException {
        String string = httpServletRequest.getParameter("viewBox");
        if (string == null) {
            return null;
        }
        IlvRect ilvRect = new IlvRect();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        try {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ServletException("bad viewBox " + string);
            }
            String string2 = stringTokenizer.nextToken();
            ilvRect.x = Float.parseFloat(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ServletException("bad viewBox y");
            }
            string2 = stringTokenizer.nextToken();
            ilvRect.y = Float.parseFloat(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ServletException("bad viewBox width");
            }
            string2 = stringTokenizer.nextToken();
            ilvRect.width = Float.parseFloat(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ServletException("bad viewBox height");
            }
            string2 = stringTokenizer.nextToken();
            ilvRect.height = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ServletException("bad viewBox " + string);
        }
        return ilvRect;
    }
}

