/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.svg.css;

import ilog.views.svg.css.CSS2ValueFactory;
import ilog.views.svg.css.PrimitiveValue;
import ilog.views.svg.css.ValueList;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.w3c.dom.css.CSSValue;

class SVGValueFactory
extends CSS2ValueFactory {
    private static HashMap a = new HashMap(100);
    private static HashMap b = new HashMap(30);

    SVGValueFactory() {
    }

    protected CSSValue createCSSValueImp(String string, String string2) {
        if (string == "fill") {
            return this.createPaint(string2);
        }
        if (string == "fill-opacity") {
            return this.createNumber(string2);
        }
        if (string == "fill-rule" || string == "clip-rule") {
            return this.createIdentifier(string2);
        }
        if (string == "stop-color") {
            return this.createColor(string2.toLowerCase().intern());
        }
        if (string == "stop-opacity") {
            return this.createNumber(string2);
        }
        if (string == "stroke") {
            return this.createPaint(string2);
        }
        if (string == "stroke-dasharray") {
            return this.createListOfNumbers(string2);
        }
        if (string == "stroke-dashoffset") {
            return this.createNumber(string2);
        }
        if (string == "stroke-linecap") {
            return this.createIdentifier(string2);
        }
        if (string == "stroke-linejoin") {
            return this.createIdentifier(string2);
        }
        if (string == "stroke-miterlimit") {
            return this.createNumber(string2);
        }
        if (string == "stroke-opacity") {
            return this.createNumber(string2);
        }
        if (string == "opacity") {
            return this.createNumber(string2);
        }
        if (string == "stroke-width") {
            return this.createLength(string2);
        }
        if (string == "text-anchor") {
            return this.createIdentifier(string2);
        }
        if (string == "visibility") {
            return this.createIdentifier(string2);
        }
        if (string == "clip-path") {
            return this.createURL(string2);
        }
        if (string == "marker-start" || string == "marker-mid" || string == "marker-end") {
            if (string2.equalsIgnoreCase("none")) {
                return this.createIdentifier("none");
            }
            return this.createURL(string2);
        }
        if (string == "filter" || string == "clip" || string == "mask") {
            return this.createString(string2);
        }
        if (string == "shape-rendering" || string == "image-rendering" || string == "text-rendering" || string == "color-interpolation") {
            return this.createIdentifier(string2);
        }
        return super.createCSSValueImp(string, string2);
    }

    protected CSSValue createColor(String string) {
        if (string == "currentcolor") {
            return this.createIdentifier("currentColor");
        }
        if (string == "none") {
            return this.createIdentifier("none");
        }
        CSSValue cSSValue = super.createColor(string);
        if (cSSValue == null) {
            Color color = (Color)a.get(string);
            if (color != null) {
                PrimitiveValue primitiveValue = new PrimitiveValue();
                primitiveValue.d = color;
                primitiveValue.c = (short)25;
                primitiveValue.e = string;
                return primitiveValue;
            }
            color = (Color)b.get(string);
            if (color != null) {
                PrimitiveValue primitiveValue = new PrimitiveValue();
                primitiveValue.d = color;
                primitiveValue.c = (short)25;
                primitiveValue.e = string;
                return primitiveValue;
            }
        }
        return cSSValue;
    }

    protected CSSValue createPaint(String string) {
        CSSValue cSSValue = this.createURL(string);
        if (cSSValue == null) {
            cSSValue = this.createColor(string.toLowerCase().intern());
        }
        return cSSValue;
    }

    protected CSSValue createURL(String string) {
        if (string.startsWith("url") || string.startsWith("URL")) {
            PrimitiveValue primitiveValue = new PrimitiveValue();
            primitiveValue.c = (short)20;
            primitiveValue.a = string;
            primitiveValue.e = string;
            return primitiveValue;
        }
        return null;
    }

    protected CSSValue createListOfNumbers(String string) {
        if (string.equalsIgnoreCase("none")) {
            return this.createIdentifier("none");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        ValueList valueList = new ValueList();
        valueList.a = string;
        while (stringTokenizer.hasMoreTokens()) {
            valueList.addItem(this.createNumber(stringTokenizer.nextToken()));
        }
        return valueList;
    }

    static {
        CSS2ValueFactory._colors.put("azure", new Color(240, 255, 255));
        CSS2ValueFactory._colors.put("beige", new Color(245, 245, 220));
        CSS2ValueFactory._colors.put("aliceblue", new Color(250, 248, 255));
        CSS2ValueFactory._colors.put("antiquewhite", new Color(250, 235, 215));
        CSS2ValueFactory._colors.put("aquamarine", new Color(127, 255, 212));
        CSS2ValueFactory._colors.put("darkblue", new Color(0, 0, 139));
        CSS2ValueFactory._colors.put("darkcyan", new Color(0, 139, 139));
        CSS2ValueFactory._colors.put("darkgray", new Color(169, 169, 169));
        CSS2ValueFactory._colors.put("darkgreen", new Color(0, 100, 0));
        CSS2ValueFactory._colors.put("darkgrey", new Color(169, 169, 169));
        CSS2ValueFactory._colors.put("darkred", new Color(139, 0, 0));
        CSS2ValueFactory._colors.put("cyan", Color.cyan);
        CSS2ValueFactory._colors.put("coral", new Color(255, 127, 80));
        CSS2ValueFactory._colors.put("gold", new Color(255, 215, 0));
        CSS2ValueFactory._colors.put("grey", Color.gray);
        CSS2ValueFactory._colors.put("lightyellow", new Color(255, 255, 224));
        CSS2ValueFactory._colors.put("lightcoral", new Color(240, 128, 128));
        CSS2ValueFactory._colors.put("lightblue", new Color(173, 216, 230));
        CSS2ValueFactory._colors.put("lightcyan", new Color(224, 255, 255));
        CSS2ValueFactory._colors.put("lightgray", new Color(211, 211, 211));
        CSS2ValueFactory._colors.put("lightgreen", new Color(144, 238, 144));
        CSS2ValueFactory._colors.put("lightgrey", new Color(211, 211, 211));
        CSS2ValueFactory._colors.put("magenta", Color.magenta);
        CSS2ValueFactory._colors.put("pink", new Color(255, 192, 203));
        CSS2ValueFactory._colors.put("salmon", new Color(250, 128, 114));
        CSS2ValueFactory._colors.put("brown", new Color(165, 42, 42));
        CSS2ValueFactory._colors.put("orange", new Color(255, 165, 0));
        CSS2ValueFactory._colors.put("turquoise", new Color(64, 224, 208));
        CSS2ValueFactory._colors.put("violet", new Color(238, 130, 238));
        CSS2ValueFactory._colors.put("wheat", new Color(245, 222, 179));
        CSS2ValueFactory._colors.put("bisque", new Color(255, 228, 196));
        CSS2ValueFactory._colors.put("indigo", new Color(75, 0, 130));
        CSS2ValueFactory._colors.put("ivory", new Color(255, 255, 240));
        CSS2ValueFactory._colors.put("khaki", new Color(240, 230, 140));
        a.put("blanchedalmond", new Color(255, 235, 205));
        a.put("blueviolet", new Color(138, 42, 226));
        a.put("burlywood", new Color(222, 184, 135));
        a.put("cadetblue", new Color(95, 158, 160));
        a.put("chartreuse", new Color(127, 255, 0));
        a.put("chocolate", new Color(210, 105, 30));
        a.put("cornflowerblue", new Color(100, 149, 237));
        a.put("cornsilk", new Color(255, 248, 220));
        a.put("crimson", new Color(220, 20, 60));
        a.put("darkgoldenrod", new Color(184, 134, 11));
        a.put("darkkhaki", new Color(189, 183, 107));
        a.put("darkmagenta", new Color(139, 0, 139));
        a.put("darkolivegreen", new Color(85, 107, 47));
        a.put("darkorange", new Color(255, 140, 0));
        a.put("darkorchid", new Color(153, 50, 204));
        a.put("darksalmon", new Color(233, 150, 122));
        a.put("darkseagreen", new Color(143, 188, 143));
        a.put("darkslateblue", new Color(72, 61, 139));
        a.put("darkslategray", new Color(47, 79, 79));
        a.put("darkslategrey", new Color(47, 79, 79));
        a.put("darkturquoise", new Color(0, 206, 209));
        a.put("darkviolet", new Color(148, 0, 211));
        a.put("deeppink", new Color(255, 20, 147));
        a.put("deepskyblue", new Color(0, 191, 255));
        a.put("dimgray", new Color(105, 105, 105));
        a.put("dimgrey", new Color(105, 105, 105));
        a.put("dodgerblue", new Color(30, 144, 255));
        a.put("firebrick", new Color(178, 34, 34));
        a.put("floralwhite", new Color(255, 250, 240));
        a.put("forestgreen", new Color(34, 192, 34));
        a.put("fuchsia", new Color(255, 0, 255));
        a.put("gainsboro", new Color(220, 220, 220));
        a.put("ghostwhite", new Color(248, 248, 255));
        a.put("goldenrod", new Color(218, 165, 32));
        a.put("greenyellow", new Color(173, 255, 47));
        a.put("honeydew", new Color(240, 255, 240));
        a.put("hotpink", new Color(255, 105, 180));
        a.put("indianred", new Color(205, 92, 92));
        a.put("lavender", new Color(230, 230, 250));
        a.put("lavenderblush", new Color(255, 240, 245));
        a.put("lawngreen", new Color(124, 252, 0));
        a.put("lemonchiffon", new Color(255, 250, 205));
        a.put("lightgoldenrodyellow", new Color(250, 250, 210));
        a.put("lightpink", new Color(255, 182, 193));
        a.put("lightsalmon", new Color(255, 160, 122));
        a.put("lightseagreen", new Color(32, 178, 170));
        a.put("lightskyblue", new Color(135, 206, 250));
        a.put("lightslategray", new Color(119, 136, 153));
        a.put("lightslategrey", new Color(119, 136, 153));
        a.put("lightsteelblue", new Color(176, 196, 222));
        a.put("limegreen", new Color(50, 205, 50));
        a.put("linen", new Color(250, 240, 230));
        a.put("mediumaquamarine", new Color(102, 205, 170));
        a.put("mediumblue", new Color(0, 0, 205));
        a.put("mediumorchid", new Color(186, 85, 211));
        a.put("mediumpurple", new Color(147, 112, 219));
        a.put("mediumseagreen", new Color(60, 179, 113));
        a.put("mediumslateblue", new Color(123, 104, 238));
        a.put("mediumspringgreen", new Color(0, 250, 154));
        a.put("mediumturquoise", new Color(72, 209, 204));
        a.put("mediumvioletred", new Color(199, 21, 133));
        a.put("midnightblue", new Color(25, 25, 112));
        a.put("mintcream", new Color(245, 255, 250));
        a.put("mistyrose", new Color(255, 228, 225));
        a.put("moccasin", new Color(255, 228, 181));
        a.put("navajowhite", new Color(255, 222, 173));
        a.put("oldlace", new Color(253, 245, 230));
        a.put("olivedrab", new Color(107, 142, 35));
        a.put("orangered", new Color(255, 69, 0));
        a.put("orchid", new Color(218, 112, 214));
        a.put("palegoldenrod", new Color(238, 232, 170));
        a.put("palegreen", new Color(152, 251, 152));
        a.put("paleturquoise", new Color(175, 238, 238));
        a.put("palevioletred", new Color(219, 112, 147));
        a.put("papayawhip", new Color(255, 239, 213));
        a.put("peachpuff", new Color(255, 218, 185));
        a.put("peru", new Color(205, 133, 63));
        a.put("plum", new Color(221, 160, 221));
        a.put("powderblue", new Color(176, 224, 230));
        a.put("rosybrown", new Color(188, 143, 143));
        a.put("royalblue", new Color(65, 105, 225));
        a.put("saddlebrown", new Color(139, 69, 19));
        a.put("sandybrown", new Color(244, 164, 96));
        a.put("seagreen", new Color(46, 139, 87));
        a.put("seashell", new Color(255, 245, 238));
        a.put("sienna", new Color(160, 82, 45));
        a.put("skyblue", new Color(135, 206, 235));
        a.put("slateblue", new Color(106, 90, 205));
        a.put("slategray", new Color(112, 128, 144));
        a.put("slategrey", new Color(112, 128, 144));
        a.put("snow", new Color(255, 250, 250));
        a.put("springgreen", new Color(0, 255, 127));
        a.put("steelblue", new Color(70, 130, 180));
        a.put("tan", new Color(210, 180, 140));
        a.put("thistle", new Color(216, 191, 216));
        a.put("tomato", new Color(255, 99, 71));
        a.put("whitesmoke", new Color(245, 245, 245));
        a.put("yellowgreen", new Color(154, 205, 50));
        b.put("activeborder", SystemColor.activeCaptionBorder);
        b.put("activecaption", SystemColor.activeCaption);
        b.put("appworkspace", SystemColor.desktop);
        b.put("background", SystemColor.desktop);
        b.put("buttonface", SystemColor.control);
        b.put("buttonhighlight", SystemColor.controlLtHighlight);
        b.put("buttonshadow", SystemColor.controlShadow);
        b.put("buttontext", SystemColor.controlText);
        b.put("captiontext", SystemColor.activeCaptionText);
        b.put("graytext", SystemColor.textInactiveText);
        b.put("highlight", SystemColor.controlHighlight);
        b.put("highlighttext", SystemColor.textHighlightText);
        b.put("inactiveborder", SystemColor.inactiveCaptionBorder);
        b.put("inactivecaption", SystemColor.inactiveCaption);
        b.put("inactivecaptiontext", SystemColor.inactiveCaptionText);
        b.put("infobackground", SystemColor.info);
        b.put("infotext", SystemColor.infoText);
        b.put("menu", SystemColor.menu);
        b.put("menutext", SystemColor.menuText);
        b.put("scrollbar", SystemColor.scrollbar);
        b.put("threeddarkshadow", SystemColor.controlDkShadow);
        b.put("threedface", SystemColor.control);
        b.put("threedhighlight", SystemColor.controlHighlight);
        b.put("threedlightshadow", SystemColor.controlLtHighlight);
        b.put("threedshadow", SystemColor.controlShadow);
        b.put("window", SystemColor.window);
        b.put("windowframe", SystemColor.windowBorder);
        b.put("windowtext", SystemColor.windowText);
    }
}

