/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.linkconnector;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.linkconnector.IlvShapePath;
import ilog.views.util.java2d.internal.IlvMath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.Vector;

public class IlvClippingUtil {
    private IlvClippingUtil() {
    }

    public static void ConnectLinksToPoint(IlvGrapher ilvGrapher, IlvGraphic ilvGraphic, IlvPoint ilvPoint, final IlvTransformer ilvTransformer, boolean bl) {
        IlvApplyObject ilvApplyObject = new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvPoint ilvPoint = (IlvPoint)object;
                ((IlvLinkImage)ilvGraphic).movePoint(0, ilvPoint.x, ilvPoint.y, ilvTransformer);
            }
        };
        ilvGrapher.applyToObjects(ilvGrapher.getLinksFrom(ilvGraphic), ilvApplyObject, (Object)ilvPoint, bl);
        IlvApplyObject ilvApplyObject2 = new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                IlvPoint ilvPoint = (IlvPoint)object;
                IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
                ilvLinkImage.movePoint(ilvLinkImage.getPointsCardinal() - 1, ilvPoint.x, ilvPoint.y, ilvTransformer);
            }
        };
        ilvGrapher.applyToObjects(ilvGrapher.getLinksTo(ilvGraphic), ilvApplyObject2, (Object)ilvPoint, bl);
    }

    public static IlvPoint BestClipPointOnRay(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n2) {
        if (n2 == 0) {
            return new IlvPoint(ilvPoint);
        }
        boolean bl = false;
        IlvPoint ilvPoint3 = null;
        IlvPoint ilvPoint4 = null;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.0;
        double d4 = ilvPoint2.x - ilvPoint.x;
        double d5 = ilvPoint2.y - ilvPoint.y;
        double d6 = d4 * d4 + d5 * d5;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (ilvPointArray[i2] == null) continue;
            d4 = ilvPointArray[i2].x - ilvPoint.x;
            d5 = ilvPointArray[i2].y - ilvPoint.y;
            double d7 = d4 * d4 + d5 * d5;
            if (IlvClippingUtil.a(ilvPoint, ilvPoint2, ilvPointArray[i2])) {
                if (!(d6 >= d7)) continue;
                bl = true;
                if (!(d7 > d3)) continue;
                d3 = d7;
                ilvPoint4 = ilvPointArray[i2];
                continue;
            }
            if (bl || !(d7 <= d2)) continue;
            d2 = d7;
            ilvPoint3 = ilvPointArray[i2];
        }
        return bl ? ilvPoint4 : (ilvPoint3 != null ? ilvPoint3 : new IlvPoint(ilvPoint));
    }

    private static boolean a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
        float f2;
        float f3 = ilvPoint2.x > ilvPoint.x ? ilvPoint2.x - ilvPoint.x : ilvPoint.x - ilvPoint2.x;
        float f4 = f2 = ilvPoint2.y > ilvPoint.y ? ilvPoint2.y - ilvPoint.y : ilvPoint.y - ilvPoint2.y;
        if (f3 > f2) {
            if (ilvPoint.x < ilvPoint2.x && ilvPoint.x <= ilvPoint3.x) {
                return true;
            }
            if (ilvPoint.x > ilvPoint2.x && ilvPoint.x >= ilvPoint3.x) {
                return true;
            }
        } else {
            if (ilvPoint.y < ilvPoint2.y && ilvPoint.y <= ilvPoint3.y) {
                return true;
            }
            if (ilvPoint.y > ilvPoint2.y && ilvPoint.y >= ilvPoint3.y) {
                return true;
            }
        }
        return false;
    }

    public static boolean LineIntersectsSegment(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5) {
        if (ilvPoint3.equals(ilvPoint4)) {
            if ((ilvPoint3.x - ilvPoint.x) * (ilvPoint2.y - ilvPoint.y) == (ilvPoint2.x - ilvPoint.x) * (ilvPoint3.y - ilvPoint.y)) {
                ilvPoint5.x = ilvPoint3.x;
                ilvPoint5.y = ilvPoint3.y;
                return true;
            }
        } else if (IlvUtil.GetLineIntersection(ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, ilvPoint5) != null) {
            float f2;
            float f3 = ilvPoint4.x > ilvPoint3.x ? ilvPoint4.x - ilvPoint3.x : ilvPoint3.x - ilvPoint4.x;
            float f4 = f2 = ilvPoint4.y > ilvPoint3.y ? ilvPoint4.y - ilvPoint3.y : ilvPoint3.y - ilvPoint4.y;
            if (f3 > f2 ? ilvPoint3.x <= ilvPoint5.x && ilvPoint5.x <= ilvPoint4.x || ilvPoint4.x <= ilvPoint5.x && ilvPoint5.x <= ilvPoint3.x : ilvPoint3.y <= ilvPoint5.y && ilvPoint5.y <= ilvPoint4.y || ilvPoint4.y <= ilvPoint5.y && ilvPoint5.y <= ilvPoint3.y) {
                return true;
            }
        }
        return false;
    }

    public static int LineIntersectsPolyPoints(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, boolean bl, IlvPoint[] ilvPointArray2) {
        IlvPoint ilvPoint3;
        int n2 = 0;
        IlvPoint ilvPoint4 = null;
        IlvPoint ilvPoint5 = null;
        IlvPoint ilvPoint6 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Point2D point2D = null;
        IlvPoint ilvPoint7 = new IlvPoint();
        IlvPoint ilvPoint8 = new IlvPoint();
        IlvPoint ilvPoint9 = new IlvPoint();
        for (int i2 = 0; i2 < ilvPointArray.length; ++i2) {
            ilvPoint6 = ilvPointArray[i2];
            if (ilvPoint5 != null && IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint5, ilvPoint6, ilvPoint7) && (point2D == null || !point2D.equals(ilvPoint7))) {
                int n3 = n2++;
                point2D = ilvPoint7;
                ilvPointArray2[n3] = point2D;
                ilvPoint7 = new IlvPoint();
                bl4 = true;
                if (i2 == 1) {
                    bl2 = true;
                }
            }
            if (ilvPoint4 != null && !bl3 && !bl4) {
                ilvPoint8.x = 0.5f * (ilvPoint4.x + ilvPoint5.x);
                ilvPoint8.y = 0.5f * (ilvPoint4.y + ilvPoint5.y);
                ilvPoint9.x = 0.5f * (ilvPoint5.x + ilvPoint6.x);
                ilvPoint9.y = 0.5f * (ilvPoint5.y + ilvPoint6.y);
                if (IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint8, ilvPoint9, ilvPoint7) && (point2D == null || !point2D.equals(ilvPoint5))) {
                    int n4 = n2++;
                    point2D = ilvPoint5;
                    ilvPointArray2[n4] = point2D;
                }
            }
            ilvPoint4 = ilvPoint5;
            ilvPoint5 = ilvPoint6;
            bl3 = bl4;
        }
        IlvPoint ilvPoint10 = ilvPoint3 = n2 > 0 ? ilvPointArray2[0] : null;
        if (ilvPointArray.length > 2 && bl) {
            ilvPoint6 = ilvPointArray[0];
            if (!(!IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint5, ilvPoint6, ilvPoint7) || point2D != null && point2D.equals(ilvPoint7) || ilvPoint3 != null && ilvPoint3.equals(ilvPoint7))) {
                ilvPointArray2[n2++] = ilvPoint7;
                ilvPoint7 = new IlvPoint();
                bl4 = true;
            }
            if (!bl3 && !bl4) {
                ilvPoint8.x = 0.5f * (ilvPoint4.x + ilvPoint5.x);
                ilvPoint8.y = 0.5f * (ilvPoint4.y + ilvPoint5.y);
                ilvPoint9.x = 0.5f * (ilvPoint5.x + ilvPoint6.x);
                ilvPoint9.y = 0.5f * (ilvPoint5.y + ilvPoint6.y);
                if (!(!IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint8, ilvPoint9, ilvPoint7) || point2D != null && point2D.equals(ilvPoint5) || ilvPoint3 != null && ilvPoint3.equals(ilvPoint5))) {
                    int n5 = n2++;
                    point2D = ilvPoint5;
                    ilvPointArray2[n5] = point2D;
                }
            }
            ilvPoint4 = ilvPointArray[0];
            if (!bl2 && !bl4) {
                ilvPoint8.x = 0.5f * (ilvPoint4.x + ilvPoint6.x);
                ilvPoint8.y = 0.5f * (ilvPoint4.y + ilvPoint6.y);
                ilvPoint9.x = 0.5f * (ilvPoint5.x + ilvPoint6.x);
                ilvPoint9.y = 0.5f * (ilvPoint5.y + ilvPoint6.y);
                if (!(!IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint8, ilvPoint9, ilvPoint7) || point2D != null && point2D.equals(ilvPoint6) || ilvPoint3 != null && ilvPoint3.equals(ilvPoint6))) {
                    ilvPointArray2[n2++] = ilvPoint6;
                }
            }
        }
        return n2;
    }

    public static int LineIntersectsEllipse(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect, IlvPoint[] ilvPointArray) {
        double d2 = ilvPoint2.x - ilvPoint.x;
        double d3 = ilvPoint2.y - ilvPoint.y;
        double d4 = 0.5 * (double)ilvRect.width;
        double d5 = 0.5 * (double)ilvRect.height;
        double d6 = (double)ilvRect.x + d4;
        double d7 = (double)ilvRect.y + d5;
        if (d2 == 0.0 && d3 == 0.0) {
            return 0;
        }
        double d8 = d2 > 0.0 ? d2 : -d2;
        double d9 = d3 > 0.0 ? d3 : -d3;
        if (d8 > d9) {
            double d10 = d3 / d2;
            double d11 = (double)ilvPoint.y - d7 - d10 * ((double)ilvPoint.x - d6);
            double d12 = d5 * d5 + d4 * d4 * d10 * d10 - d11 * d11;
            if (d12 < 0.0) {
                return 0;
            }
            if (d12 == 0.0) {
                double d13 = -d10 * d11 * d4 * d4 / (d5 * d5 + d4 * d4 * d10 * d10);
                double d14 = d10 * d13 + d11;
                ilvPointArray[0] = new IlvPoint((float)(d13 + d6), (float)(d14 + d7));
                return 1;
            }
            double d15 = Math.sqrt(d12);
            double d16 = (d4 * d5 * d15 - d10 * d11 * d4 * d4) / (d5 * d5 + d4 * d4 * d10 * d10);
            double d17 = d10 * d16 + d11;
            ilvPointArray[0] = new IlvPoint((float)(d16 + d6), (float)(d17 + d7));
            d16 = (-d4 * d5 * d15 - d10 * d11 * d4 * d4) / (d5 * d5 + d4 * d4 * d10 * d10);
            d17 = d10 * d16 + d11;
            ilvPointArray[1] = new IlvPoint((float)(d16 + d6), (float)(d17 + d7));
            return 2;
        }
        double d18 = d2 / d3;
        double d19 = (double)ilvPoint.x - d6 - d18 * ((double)ilvPoint.y - d7);
        double d20 = d4 * d4 + d5 * d5 * d18 * d18 - d19 * d19;
        if (d20 < 0.0) {
            return 0;
        }
        if (d20 == 0.0) {
            double d21 = -d18 * d19 * d5 * d5 / (d4 * d4 + d5 * d5 * d18 * d18);
            double d22 = d18 * d21 + d19;
            ilvPointArray[0] = new IlvPoint((float)(d22 + d6), (float)(d21 + d7));
            return 1;
        }
        double d23 = Math.sqrt(d20);
        double d24 = (d4 * d5 * d23 - d18 * d19 * d5 * d5) / (d4 * d4 + d5 * d5 * d18 * d18);
        double d25 = d18 * d24 + d19;
        ilvPointArray[0] = new IlvPoint((float)(d25 + d6), (float)(d24 + d7));
        d24 = (-d4 * d5 * d23 - d18 * d19 * d5 * d5) / (d4 * d4 + d5 * d5 * d18 * d18);
        d25 = d18 * d24 + d19;
        ilvPointArray[1] = new IlvPoint((float)(d25 + d6), (float)(d24 + d7));
        return 2;
    }

    public static int LineIntersectsArc(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvRect ilvRect, double d2, double d3, IlvPoint[] ilvPointArray) {
        int n2;
        int n3 = IlvClippingUtil.LineIntersectsEllipse(ilvPoint, ilvPoint2, ilvRect, ilvPointArray);
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(IlvClippingUtil.a(ilvRect, ilvPointArray[n2], d2) <= d3)) continue;
            ilvPointArray[n4++] = ilvPointArray[n2];
        }
        for (n2 = n4; n2 < n3; ++n2) {
            ilvPointArray[n2] = null;
        }
        return n4;
    }

    public static int LineIntersectsQuadSpline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n2, IlvPoint[] ilvPointArray2) {
        int n3;
        double d2;
        double d3;
        double d4 = ilvPointArray[n2].x;
        double d5 = 2.0 * ((double)ilvPointArray[n2 + 1].x - d4);
        double d6 = (double)ilvPointArray[n2 + 2].x - d5 - d4;
        double d7 = ilvPointArray[n2].y;
        double d8 = 2.0 * ((double)ilvPointArray[n2 + 1].y - d7);
        double d9 = (double)ilvPointArray[n2 + 2].y - d8 - d7;
        double d10 = ilvPoint2.x - ilvPoint.x;
        double d11 = ilvPoint2.y - ilvPoint.y;
        if (d10 == 0.0 && d11 == 0.0) {
            return 0;
        }
        double[] dArray = new double[2];
        double d12 = d10 > 0.0 ? d10 : -d10;
        double d13 = d11 > 0.0 ? d11 : -d11;
        if (d12 > d13) {
            d3 = d11 / d10;
            d2 = (double)ilvPoint.y - d3 * (double)ilvPoint.x;
            n3 = IlvMath.calcQuadSolution(d3 * d6 - d9, d3 * d5 - d8, d3 * d4 - d7 + d2, dArray);
        } else {
            d3 = d10 / d11;
            d2 = (double)ilvPoint.x - d3 * (double)ilvPoint.y;
            n3 = IlvMath.calcQuadSolution(d3 * d9 - d6, d3 * d8 - d5, d3 * d7 - d4 + d2, dArray);
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(0.0 <= dArray[i2]) || !(dArray[i2] <= 1.0)) continue;
            ilvPointArray2[n4++] = new IlvPoint((float)(d6 * dArray[i2] * dArray[i2] + d5 * dArray[i2] + d4), (float)(d9 * dArray[i2] * dArray[i2] + d8 * dArray[i2] + d7));
        }
        return n4;
    }

    public static int LineIntersectsCubicSpline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint[] ilvPointArray, int n2, IlvPoint[] ilvPointArray2) {
        int n3;
        double d2;
        double d3;
        double d4 = ilvPointArray[n2].x;
        double d5 = 3.0 * ((double)ilvPointArray[n2 + 1].x - d4);
        double d6 = (double)(3.0f * (ilvPointArray[n2 + 2].x - ilvPointArray[n2 + 1].x)) - d5;
        double d7 = (double)ilvPointArray[n2 + 3].x - d6 - d5 - d4;
        double d8 = ilvPointArray[n2].y;
        double d9 = 3.0 * ((double)ilvPointArray[n2 + 1].y - d8);
        double d10 = (double)(3.0f * (ilvPointArray[n2 + 2].y - ilvPointArray[n2 + 1].y)) - d9;
        double d11 = (double)ilvPointArray[n2 + 3].y - d10 - d9 - d8;
        double d12 = ilvPoint2.x - ilvPoint.x;
        double d13 = ilvPoint2.y - ilvPoint.y;
        if (d12 == 0.0 && d13 == 0.0) {
            return 0;
        }
        double[] dArray = new double[3];
        double d14 = d12 > 0.0 ? d12 : -d12;
        double d15 = d13 > 0.0 ? d13 : -d13;
        if (d14 > d15) {
            d3 = d13 / d12;
            d2 = (double)ilvPoint.y - d3 * (double)ilvPoint.x;
            n3 = IlvMath.calcCubicSolution(d3 * d7 - d11, d3 * d6 - d10, d3 * d5 - d9, d3 * d4 - d8 + d2, dArray);
        } else {
            d3 = d12 / d13;
            d2 = (double)ilvPoint.x - d3 * (double)ilvPoint.y;
            n3 = IlvMath.calcCubicSolution(d3 * d11 - d7, d3 * d10 - d6, d3 * d9 - d5, d3 * d8 - d4 + d2, dArray);
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!(0.0 <= dArray[i2]) || !(dArray[i2] <= 1.0)) continue;
            ilvPointArray2[n4++] = new IlvPoint((float)(d7 * dArray[i2] * dArray[i2] * dArray[i2] + d6 * dArray[i2] * dArray[i2] + d5 * dArray[i2] + d4), (float)(d11 * dArray[i2] * dArray[i2] * dArray[i2] + d10 * dArray[i2] * dArray[i2] + d9 * dArray[i2] + d8));
        }
        return n4;
    }

    private static double a(IlvRect ilvRect, IlvPoint ilvPoint, double d2) {
        float f2 = ilvPoint.x - ilvRect.x - ilvRect.width / 2.0f;
        float f3 = ilvRect.y + ilvRect.height / 2.0f - ilvPoint.y;
        double d3 = (double)f2 / (double)ilvRect.width;
        double d4 = (double)f3 / (double)ilvRect.height;
        double d5 = 57.29577951308232 * Math.atan2(d4, d3);
        d5 -= d2;
        while (d5 < 0.0) {
            d5 += 360.0;
        }
        while (d5 > 360.0) {
            d5 -= 360.0;
        }
        return d5;
    }

    private static void a(IlvRect ilvRect, double d2, IlvPoint ilvPoint) {
        d2 = d2 * Math.PI / 180.0;
        ilvPoint.x = ilvRect.x + 0.5f * ilvRect.width * (1.0f + (float)Math.cos(d2));
        ilvPoint.y = ilvRect.y + 0.5f * ilvRect.height * (1.0f - (float)Math.sin(d2));
    }

    public static IlvPoint ArcStartPoint(IlvRect ilvRect, double d2) {
        double d3 = d2;
        IlvPoint ilvPoint = new IlvPoint();
        IlvClippingUtil.a(ilvRect, d3, ilvPoint);
        double d4 = IlvClippingUtil.a(ilvRect, ilvPoint, d2);
        if (d4 > 180.0) {
            double d5 = 0.0;
            while (d4 > 180.0) {
                d3 = d2 + (d5 += 0.004);
                IlvClippingUtil.a(ilvRect, d3, ilvPoint);
                d4 = IlvClippingUtil.a(ilvRect, ilvPoint, d2);
            }
            double d6 = d5;
            while (d4 < 180.0) {
                d6 = d5;
                d3 = d2 + (d5 /= 8.0);
                IlvClippingUtil.a(ilvRect, d3, ilvPoint);
                d4 = IlvClippingUtil.a(ilvRect, ilvPoint, d2);
            }
            d3 = d2 + d6;
            IlvClippingUtil.a(ilvRect, d3, ilvPoint);
        }
        return ilvPoint;
    }

    public static IlvPoint ArcEndPoint(IlvRect ilvRect, double d2, double d3) {
        if (d3 == 0.0) {
            return IlvClippingUtil.ArcStartPoint(ilvRect, d2);
        }
        double d4 = d2 + d3;
        IlvPoint ilvPoint = new IlvPoint();
        IlvClippingUtil.a(ilvRect, d4, ilvPoint);
        double d5 = IlvClippingUtil.a(ilvRect, ilvPoint, d2);
        if (d5 > d3) {
            double d6 = 0.0;
            while (d5 > d3) {
                d4 = d2 + d3 - (d6 += 0.004);
                IlvClippingUtil.a(ilvRect, d4, ilvPoint);
                d5 = IlvClippingUtil.a(ilvRect, ilvPoint, d2);
            }
            double d7 = d6;
            while (d5 < d3) {
                d7 = d6;
                d4 = d2 + d3 - (d6 /= 8.0);
                IlvClippingUtil.a(ilvRect, d4, ilvPoint);
                d5 = IlvClippingUtil.a(ilvRect, ilvPoint, d2);
            }
            d4 = d2 + d3 - d7;
            IlvClippingUtil.a(ilvRect, d4, ilvPoint);
        }
        return ilvPoint;
    }

    public static IlvPoint getClippedPoint(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        if (ilvGraphic instanceof IlvShapePath) {
            if (ilvPoint == null || ilvPoint2 == null) {
                return null;
            }
            if (ilvPoint.equals(ilvPoint2)) {
                return new IlvPoint(ilvPoint);
            }
            return IlvClippingUtil.getClippedPoint(((IlvShapePath)((Object)ilvGraphic)).getShapePath(ilvTransformer), null, 0.0f, ilvPoint, ilvPoint2);
        }
        return ilvGraphic.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
    }

    public static IlvPoint getClippedPoint(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        IlvPoint[] ilvPointArray;
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        ilvPointArray = new IlvPoint[]{new IlvPoint(ilvRect.x, ilvRect.y), new IlvPoint(ilvRect.x + ilvRect.width, ilvPointArray[0].y), new IlvPoint(ilvPointArray[1].x, ilvRect.y + ilvRect.height), new IlvPoint(ilvRect.x, ilvPointArray[2].y)};
        IlvPoint[] ilvPointArray2 = new IlvPoint[4];
        int n2 = IlvClippingUtil.LineIntersectsPolyPoints(ilvPoint, ilvPoint2, ilvPointArray, true, ilvPointArray2);
        return IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray2, n2);
    }

    public static IlvPoint getClippedPoint(PathIterator pathIterator, IlvTransformer ilvTransformer, float f2, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        double d2;
        double d3;
        double d4;
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        Vector<IlvPoint> vector = new Vector<IlvPoint>(2, 2);
        IlvPoint[] ilvPointArray = new IlvPoint[3];
        float[] fArray = new float[6];
        IlvPoint[] ilvPointArray2 = new IlvPoint[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            ilvPointArray2[i2] = new IlvPoint();
        }
        IlvPoint ilvPoint3 = new IlvPoint();
        IlvPoint ilvPoint4 = new IlvPoint();
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    ilvPointArray2[0].move(fArray[0], fArray[1]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[0]);
                    }
                    ilvPoint3.move(ilvPointArray2[0].x, ilvPointArray2[0].y);
                    break;
                }
                case 1: {
                    ilvPointArray2[1].move(fArray[0], fArray[1]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[1]);
                    }
                    ilvPoint4.setLocation(ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[0], ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[1], ilvPointArray2[0]);
                    IlvPoint ilvPoint5 = new IlvPoint();
                    if (IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPointArray2[0], ilvPointArray2[1], ilvPoint5)) {
                        vector.addElement(ilvPoint5);
                    }
                    ilvPointArray2[0].setLocation(ilvPoint4);
                    break;
                }
                case 2: {
                    int n2;
                    ilvPointArray2[1].move(fArray[0], fArray[1]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[1]);
                    }
                    ilvPointArray2[2].move(fArray[2], fArray[3]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[2]);
                    }
                    ilvPoint4.setLocation(ilvPointArray2[2]);
                    IlvClippingUtil.a(ilvPointArray2[0], ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[2], ilvPointArray2[1]);
                    int n3 = IlvClippingUtil.LineIntersectsQuadSpline(ilvPoint, ilvPoint2, ilvPointArray2, 0, ilvPointArray);
                    for (n2 = 0; n2 < n3; ++n2) {
                        vector.addElement(ilvPointArray[n2]);
                    }
                    ilvPointArray2[0].setLocation(ilvPoint4);
                    break;
                }
                case 3: {
                    int n2;
                    ilvPointArray2[1].move(fArray[0], fArray[1]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[1]);
                    }
                    ilvPointArray2[2].move(fArray[2], fArray[3]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[2]);
                    }
                    ilvPointArray2[3].move(fArray[4], fArray[5]);
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPointArray2[3]);
                    }
                    ilvPoint4.setLocation(ilvPointArray2[3]);
                    IlvClippingUtil.a(ilvPointArray2[0], ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[3], ilvPointArray2[2]);
                    int n3 = IlvClippingUtil.LineIntersectsCubicSpline(ilvPoint, ilvPoint2, ilvPointArray2, 0, ilvPointArray);
                    for (n2 = 0; n2 < n3; ++n2) {
                        vector.addElement(ilvPointArray[n2]);
                    }
                    ilvPointArray2[0].setLocation(ilvPoint4);
                    break;
                }
                case 4: {
                    ilvPointArray2[1].setLocation(ilvPoint3);
                    IlvClippingUtil.a(ilvPointArray2[0], ilvPointArray2[1]);
                    IlvClippingUtil.a(ilvPointArray2[1], ilvPointArray2[0]);
                    IlvPoint ilvPoint5 = new IlvPoint();
                    if (!IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPointArray2[0], ilvPointArray2[1], ilvPoint5)) break;
                    vector.addElement(ilvPoint5);
                }
            }
            pathIterator.next();
        }
        if (vector.size() == 0) {
            return new IlvPoint(ilvPoint);
        }
        Object[] objectArray = new IlvPoint[vector.size()];
        vector.copyInto(objectArray);
        IlvPoint ilvPoint6 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, (IlvPoint[])objectArray, objectArray.length);
        if (f2 > 0.0f && objectArray.length > 0 && (d4 = Math.sqrt((d3 = (double)(ilvPoint2.x - ilvPoint.x)) * d3 + (d2 = (double)(ilvPoint2.y - ilvPoint.y)) * d2)) != 0.0) {
            ilvPoint6.x += (float)(0.5 * (double)f2 * d3 / d4);
            ilvPoint6.y += (float)(0.5 * (double)f2 * d2 / d4);
        }
        return ilvPoint6;
    }

    private static void a(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        float f2 = ilvPoint.x;
        double d2 = ilvPoint2.x - f2;
        float f3 = ilvPoint.y;
        double d3 = ilvPoint2.y - f3;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        if (d4 > (double)1.0E-11f) {
            float f4 = 1.0E-5f;
            for (int i2 = 0; i2 < 6; ++i2) {
                ilvPoint.x -= (float)(d2 / d4 * (double)f4);
                ilvPoint.y -= (float)(d3 / d4 * (double)f4);
                if (ilvPoint.x != f2 || ilvPoint.y != f3) {
                    return;
                }
                f4 *= 10.0f;
            }
        }
    }
}

