/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.io;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvIndexedSet;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.AsciiDataReader;
import ilog.views.io.BinaryDataReader;
import ilog.views.io.DataReader;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvGrapherReader;
import ilog.views.io.IlvGraphicBagReader;
import ilog.views.io.IlvManagerReader;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.io.Tokenizer;
import ilog.views.io.TypedArrayReader;
import ilog.views.util.IlvClassLoaderUtil;
import ilog.views.util.java2d.IlvPattern;
import ilog.views.util.java2d.IlvTexture;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class IlvInputStream {
    private static final String a = "Not an Ilog JViews Data File";
    IlvGraphicBag b;
    IlvGraphicBagReader c;
    TypedArrayReader d;
    private boolean e = false;
    int f;
    int g;
    Object h = null;
    private float i;
    private URL j = null;
    private InputStream k;
    boolean l = false;
    IlvGraphicVector m = null;
    private Tokenizer n;
    private DataReader o;
    private int p;
    private static final String q = "bad path, missing initial moveto";
    private static final String r = "bad path specification";
    private PendingLink s = null;

    public IlvInputStream(InputStream inputStream) {
        this.k = new BufferedInputStream(inputStream);
        this.n = new Tokenizer(this.k);
        this.n.ordinaryChar(123);
        this.n.ordinaryChar(125);
        this.n.ordinaryChar(91);
        this.n.ordinaryChar(93);
        this.n.ordinaryChar(35);
        this.n.ordinaryChar(44);
        this.n.ordinaryChar(58);
        this.o = new AsciiDataReader(this, this.n);
        this.d = new TypedArrayReader(this.o);
    }

    public boolean isASCIIMode() {
        return this.o instanceof AsciiDataReader;
    }

    public void setDocumentBase(URL uRL) {
        this.j = uRL;
    }

    public URL getDocumentBase() {
        return this.j;
    }

    private IlvGraphicBagReader a(DataInputStream dataInputStream) throws IOException, IlvReadFileException {
        if (dataInputStream.readInt() != 21067) {
            throw new IlvReadFileException(a);
        }
        this.i = dataInputStream.readFloat();
        String string = dataInputStream.readUTF();
        return IlvGraphicBagReader.readerFromClassName(string);
    }

    private IlvGraphicBagReader a(Tokenizer tokenizer) throws IlvReadFileException, IOException {
        int n2 = tokenizer.a();
        if (n2 != 35) {
            throw new IlvReadFileException(a);
        }
        n2 = tokenizer.a();
        if (n2 != -3 || !tokenizer.o.equals("ILOG")) {
            throw new IlvReadFileException(a);
        }
        n2 = tokenizer.a();
        if (n2 != -3 || !tokenizer.o.equals("Views")) {
            throw new IlvReadFileException(a);
        }
        n2 = tokenizer.a();
        if (n2 != -3 || !tokenizer.o.equals("Java")) {
            throw new IlvReadFileException(a);
        }
        n2 = tokenizer.a();
        if (n2 != -2) {
            throw new IlvReadFileException(a);
        }
        this.i = (float)tokenizer.p;
        n2 = tokenizer.a();
        if (n2 != 35) {
            throw new IlvReadFileException("#Reader expected in header");
        }
        n2 = tokenizer.a();
        if (n2 != -3 || !tokenizer.o.equals("Reader")) {
            throw new IlvReadFileException("#Reader expected in header");
        }
        n2 = tokenizer.a();
        if (n2 != 58) {
            throw new IlvReadFileException(": expected in header");
        }
        n2 = tokenizer.a();
        if (n2 != -3) {
            throw new IlvReadFileException("Reader name expected in header");
        }
        String string = tokenizer.o;
        return IlvGraphicBagReader.readerFromClassName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(IlvGraphicBag ilvGraphicBag) throws IOException, IlvReadFileException {
        if (!this.e) {
            this.b = ilvGraphicBag;
            DataInputStream dataInputStream = null;
            boolean bl = false;
            IlvGraphicBagReader ilvGraphicBagReader = null;
            this.k.mark(1000);
            try {
                ilvGraphicBagReader = this.a(this.n);
            }
            catch (IOException iOException) {
                bl = true;
                this.k.reset();
            }
            catch (IlvReadFileException ilvReadFileException) {
                bl = true;
                this.k.reset();
            }
            if (bl) {
                try {
                    dataInputStream = new DataInputStream(this.k);
                    ilvGraphicBagReader = this.a(dataInputStream);
                }
                catch (IOException iOException) {
                    throw new IlvReadFileException(a, iOException);
                }
                catch (IlvReadFileException ilvReadFileException) {
                    throw new IlvReadFileException(a, ilvReadFileException);
                }
            }
            this.c = ilvGraphicBagReader;
            this.o = bl ? new BinaryDataReader(this, dataInputStream) : new AsciiDataReader(this, this.n);
            this.d = new TypedArrayReader(this.o);
            this.e = true;
            ++this.p;
            this.o.a();
            --this.p;
            if (this.p == 0) {
                this.f();
            }
            this.readExtensions();
        } else {
            ++this.p;
            IlvGraphicBag ilvGraphicBag2 = this.b;
            IlvGraphicBagReader ilvGraphicBagReader = this.c;
            this.b = ilvGraphicBag;
            this.c = ilvGraphicBag instanceof IlvGrapher ? IlvGrapherReader.c : IlvManagerReader.a;
            try {
                this.o.b();
                if (this.p == 1) {
                    this.f();
                }
            }
            finally {
                this.b = ilvGraphicBag2;
                this.c = ilvGraphicBagReader;
                --this.p;
            }
        }
    }

    public final IlvGraphicBag getGraphicBag() {
        return this.b;
    }

    final void a(String string) throws IOException, IlvReadFileException {
        Serializable serializable;
        Object object;
        if (!(this.b instanceof IlvManager) && !string.equals("ilog.views.IlvManagerLayer")) {
            throw new IlvReadFileException("Cannot read specialized layer " + string + " into a bag (" + this.b.getClass().getName() + ") which is " + "not an IlvManager or a subclass");
        }
        String string2 = null;
        IlvPersistentObject[] ilvPersistentObjectArray = null;
        try {
            string2 = this.readString("name");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        int n2 = this.readInt("index");
        int n3 = this.f;
        int n4 = this.g;
        this.f = n2;
        boolean bl = this.readBoolean("visible");
        try {
            ilvPersistentObjectArray = this.readPersistentObjects("filters");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        boolean bl2 = this.readBoolean("selectable");
        float f2 = 1.0f;
        try {
            f2 = this.readFloat("alphaComposite");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        Object[] objectArray = this.a();
        if (!string.equals("ilog.views.IlvManagerLayer")) {
            object = null;
            if (n2 < ((IlvManager)this.b).getLayersCount()) {
                object = ((IlvManager)this.b).getManagerLayer(n2);
            }
            if (object != null) {
                if (object.getClass() != IlvManagerLayer.class && !object.getClass().getName().equals(string)) {
                    throw new IlvReadFileException("cannot merge layer of class " + string + " at index " + n2 + " with an existing layer of class " + object.getClass().getName());
                }
                if (((IlvIndexedSet)object).getCardinal() != 0) {
                    throw new IlvReadFileException("cannot merge layer of class " + string + " at index " + n2 + " because existing layer is not empty");
                }
            }
            serializable = null;
            try {
                serializable = IlvClassLoaderUtil.forName(null, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IlvReadFileException("Layer class " + string + " cannot be found", classNotFoundException);
            }
            IlvManagerLayer ilvManagerLayer = (IlvManagerLayer)this.o.readObjectFields((Class)serializable);
            ((IlvManager)this.b).addLayer(ilvManagerLayer, n2);
            if (object != null) {
                ((IlvManager)this.b).removeLayer(n2 + 1, false);
            }
        }
        if ((object = this.getGraphicBag()) != null && object instanceof IlvManager && n2 >= 0) {
            serializable = (IlvManager)object;
            ((IlvManager)serializable).setNumberOfLayer(n2 + 1);
            this.g = ((IlvManager)serializable).getManagerLayer(n2).getCardinal();
        }
        try {
            this.a("elements", true);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.c.setVisible((IlvGraphicBag)object, n2, bl);
        this.c.setAlpha((IlvGraphicBag)object, n2, f2);
        this.c.setSelectable((IlvGraphicBag)object, n2, bl2);
        this.c.setNamedProperties((IlvGraphicBag)object, n2, objectArray);
        this.c.setVisibilityFilters((IlvGraphicBag)object, n2, ilvPersistentObjectArray);
        this.c.setName((IlvGraphicBag)object, n2, string2);
        this.f = n3;
        this.g = n4;
    }

    public void setCopyPasteMode() {
        this.l = true;
        this.m = new IlvGraphicVector(100);
    }

    public IlvGraphicEnumeration getObjects() {
        return this.m.elements();
    }

    public void registerGraphic(IlvGraphic ilvGraphic) {
        if (this.h != null) {
            this.o._objects.put(this.h, ilvGraphic);
            this.h = null;
        }
    }

    protected IlvPersistentObject invokeConstructor(Constructor constructor) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray = new Object[]{this};
        return (IlvPersistentObject)constructor.newInstance(objectArray);
    }

    protected IlvGraphic readObject(boolean bl, int n2) throws IOException, IlvReadFileException {
        return (IlvGraphic)this.o.readObject(bl, true, n2);
    }

    IlvPersistentObject[] a(String string, boolean bl) throws IOException, IlvReadFileException {
        this.o.a(string);
        return (IlvGraphic[])this.o.a(bl, true);
    }

    public final boolean readBoolean(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.ae();
    }

    public final boolean[] readBooleanArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.z();
    }

    public final short readShort(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.ac();
    }

    public final short[] readShortArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.w();
    }

    public final int readInt(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.d();
    }

    public final int[] readIntArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.u();
    }

    public final long readLong(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.ab();
    }

    public final long[] readLongArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.x();
    }

    public final float readFloat(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.aa();
    }

    public final float[] readFloatArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.v();
    }

    public final double readDouble(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.ad();
    }

    public final double[] readDoubleArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.y();
    }

    public final String readString(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.e();
    }

    public final String[] readStringArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.q();
    }

    public final IlvPoint readPoint(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.m();
    }

    public final IlvPoint[] readPointArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.f();
    }

    public final IlvRect readRect(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.n();
    }

    public final IlvRect[] readRectArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.p();
    }

    public final IlvTransformer readTransformer(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.o();
    }

    public final IlvTransformer[] readTransformerArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.r();
    }

    public final Color readColor(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.l();
    }

    public final Color[] readColorArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.s();
    }

    public final Font readFont(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.g();
    }

    public final Font[] readFontArray(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.t();
    }

    public final Shape readShape(String string, String string2) throws IlvReadFileException {
        return this.a(string, string2);
    }

    public final GradientPaint readGradient(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.h();
    }

    public final IlvPattern readPattern(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.i();
    }

    public final IlvTexture readTexture(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.j();
    }

    public final Paint readPaint(String string) throws IlvReadFileException {
        return IlvUtility2D.readPaint(this, string, string);
    }

    public final BasicStroke readStroke(String string) throws IlvReadFileException {
        this.o.a(string);
        return this.o.k();
    }

    public final IlvGraphic readObject(String string) throws IlvReadFileException {
        this.e = true;
        this.o.a(string);
        IlvGraphic ilvGraphic = null;
        try {
            ilvGraphic = this.readObject(false, 0);
        }
        catch (IOException iOException) {
            throw new IlvReadFileException(iOException);
        }
        return ilvGraphic;
    }

    public final IlvGraphic[] readObjects(String string) throws IlvReadFileException {
        IlvGraphic[] ilvGraphicArray = null;
        this.o.a(string);
        try {
            ilvGraphicArray = (IlvGraphic[])this.o.a(false, true);
        }
        catch (IOException iOException) {
            throw new IlvReadFileException(iOException);
        }
        return ilvGraphicArray;
    }

    public final IlvPersistentObject readPersistentObject(String string) throws IlvReadFileException {
        this.e = true;
        this.o.a(string);
        IlvPersistentObject ilvPersistentObject = null;
        try {
            ilvPersistentObject = this.o.readObject(false, false, 0);
        }
        catch (IOException iOException) {
            throw new IlvReadFileException(iOException);
        }
        return ilvPersistentObject;
    }

    public final IlvPersistentObject[] readPersistentObjects(String string) throws IlvReadFileException {
        IlvPersistentObject[] ilvPersistentObjectArray = null;
        this.o.a(string);
        try {
            ilvPersistentObjectArray = (IlvPersistentObject[])this.o.a(false, false);
        }
        catch (IOException iOException) {
            throw new IlvReadFileException(iOException);
        }
        return ilvPersistentObjectArray;
    }

    public final Object[] readObjectArray(String string, String string2) throws IlvReadFileException {
        this.o.a(string);
        Object[] objectArray = null;
        try {
            objectArray = this.d.a(string2);
        }
        catch (IOException iOException) {
            throw new IlvReadFileException(iOException);
        }
        return objectArray;
    }

    protected void readExtensions() throws IlvReadFileException {
    }

    IlvPersistentObject[] a() throws IlvReadFileException {
        IlvPersistentObject[] ilvPersistentObjectArray = null;
        try {
            ilvPersistentObjectArray = this.readPersistentObjects("namedProperties");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        return ilvPersistentObjectArray;
    }

    GradientPaint b() throws IlvReadFileException {
        Color color = this.readColor("color1");
        Color color2 = this.readColor("color2");
        IlvPoint ilvPoint = this.readPoint("point1");
        IlvPoint ilvPoint2 = this.readPoint("point2");
        boolean bl = this.readBoolean("cyclic");
        return new GradientPaint(new Point2D.Float(ilvPoint.x, ilvPoint.y), color, new Point2D.Float(ilvPoint2.x, ilvPoint2.y), color2, bl);
    }

    IlvPattern c() throws IlvReadFileException {
        Color color = null;
        Color color2 = this.readColor("fg");
        try {
            color = this.readColor("bg");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        int n2 = this.readInt("type");
        return new IlvPattern(n2, color2, color);
    }

    Shape a(String string, String string2) throws IlvReadFileException {
        String string3 = this.readString(string);
        String string4 = this.readString(string2);
        return IlvInputStream.b(string3, string4);
    }

    IlvTexture d() throws IlvReadFileException {
        IlvTexture ilvTexture;
        String string = this.readString("url");
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this.getDocumentBase() != null) {
            try {
                uRL = new URL(this.getDocumentBase(), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IlvReadFileException("bad url in texture", malformedURLException);
            }
        }
        IlvRect ilvRect = null;
        try {
            ilvRect = this.readRect("anchor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            ilvTexture = ilvRect == null ? new IlvTexture(uRL) : new IlvTexture(uRL, (Rectangle2D)ilvRect);
        }
        catch (Exception exception) {
            throw new IlvReadFileException("cannot create Texture " + string, exception);
        }
        return ilvTexture;
    }

    BasicStroke e() throws IlvReadFileException {
        float f2;
        float f3;
        float[] fArray;
        int n2;
        int n3;
        float f4;
        block19: {
            String string;
            block18: {
                f4 = 1.0f;
                n3 = 2;
                n2 = 0;
                fArray = null;
                f3 = 0.0f;
                f2 = 10.0f;
                try {
                    f4 = this.readFloat("lineWidth");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                    // empty catch block
                }
                try {
                    string = this.readString("endCap");
                    if (string.equals("Butt")) {
                        n3 = 0;
                        break block18;
                    }
                    if (string.equals("Round")) {
                        n3 = 1;
                        break block18;
                    }
                    if (string.equals("Square")) {
                        n3 = 2;
                        break block18;
                    }
                    throw new IlvReadFileException("bad end cap style");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                    // empty catch block
                }
            }
            try {
                string = this.readString("lineJoin");
                if (string.equals("Miter")) {
                    n2 = 0;
                    break block19;
                }
                if (string.equals("Round")) {
                    n2 = 1;
                    break block19;
                }
                if (string.equals("Bevel")) {
                    n2 = 2;
                    break block19;
                }
                throw new IlvReadFileException("bad line join style");
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                // empty catch block
            }
        }
        try {
            fArray = this.readFloatArray("dashArray");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            f3 = this.readFloat("dashPhase");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            f2 = this.readFloat("miterLimit");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        return new BasicStroke(f4, n3, n2, f2, fArray, f3);
    }

    private static Shape b(String string, String string2) throws IlvReadFileException {
        return IlvInputStream.a(string, string2.equals("nonzero") ? 1 : 0);
    }

    private static Shape a(String string, int n2) throws IlvReadFileException {
        GeneralPath generalPath = new GeneralPath(n2);
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " zMLCQ", true);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("z")) {
                if (bl) {
                    throw new IllegalArgumentException(q);
                }
                generalPath.closePath();
                continue;
            }
            if (string2.equals("M")) {
                bl = false;
                generalPath.moveTo(IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer));
                continue;
            }
            if (string2.equals("L")) {
                if (bl) {
                    throw new IllegalArgumentException(q);
                }
                generalPath.lineTo(IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer));
                continue;
            }
            if (string2.equals("C")) {
                if (bl) {
                    throw new IllegalArgumentException(q);
                }
                generalPath.curveTo(IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer));
                continue;
            }
            if (string2.equals("Q")) {
                if (bl) {
                    throw new IllegalArgumentException(q);
                }
                generalPath.quadTo(IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer), IlvInputStream.a(stringTokenizer));
                continue;
            }
            if (string2.equals(" ")) continue;
            throw new IllegalArgumentException(r);
        }
        return generalPath;
    }

    private static float a(StringTokenizer stringTokenizer) throws IlvReadFileException {
        String string = null;
        while (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()).equals(" ")) {
            string = null;
        }
        if (string == null) {
            throw new IlvReadFileException(r);
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IlvReadFileException(r, numberFormatException);
        }
    }

    void a(IlvLinkImage ilvLinkImage, int n2, IlvGrapher ilvGrapher, int n3) {
        if (n3 != -1) {
            n3 += this.g;
        }
        PendingLink pendingLink = new PendingLink(ilvGrapher, n2, ilvLinkImage, n3);
        if (this.s == null) {
            this.s = pendingLink;
        } else {
            PendingLink.f.d = pendingLink;
        }
        PendingLink.f = pendingLink;
    }

    private void f() throws IlvReadFileException {
        PendingLink pendingLink = this.s;
        while (pendingLink != null) {
            IlvManagerLayer ilvManagerLayer;
            IlvLinkImage ilvLinkImage = pendingLink.c;
            int n2 = pendingLink.b;
            IlvGrapher ilvGrapher = pendingLink.a;
            if (ilvLinkImage.getFrom().getGraphicBag() == null) {
                IlvGrapherReader.c.storeObject(this, ilvLinkImage.getFrom(), ilvGrapher, pendingLink.b, -1);
            }
            if (ilvLinkImage.getTo().getGraphicBag() == null) {
                IlvGrapherReader.c.storeObject(this, ilvLinkImage.getTo(), ilvGrapher, pendingLink.b, -1);
            }
            ilvGrapher.addLink(ilvLinkImage, n2, false);
            if (pendingLink.e != -1 && (ilvManagerLayer = ilvGrapher.getManagerLayer(n2)).getCardinal() - 1 != pendingLink.e && pendingLink.e != -1) {
                ilvManagerLayer.setIndex(ilvLinkImage, pendingLink.e);
            }
            IlvGrapherReader.c.afterStoreObject(this, ilvLinkImage, n2);
            pendingLink = pendingLink.d;
        }
        this.s = null;
        PendingLink.f = null;
    }

    private static final class PendingLink {
        IlvGrapher a;
        int b;
        IlvLinkImage c;
        PendingLink d;
        int e;
        static PendingLink f;

        PendingLink(IlvGrapher ilvGrapher, int n2, IlvLinkImage ilvLinkImage, int n3) {
            this.a = ilvGrapher;
            this.b = n2;
            this.c = ilvLinkImage;
            this.e = n3;
        }
    }
}

