/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.interactor.IlvLinkImageFactory;
import ilog.views.interactor.IlvMakePolyPointsInteractor;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import java.awt.Graphics;
import java.io.Serializable;

public class IlvMakeLinkInteractor
extends IlvMakePolyPointsInteractor {
    private IlvGraphic a;
    private IlvGraphic b;
    private static final IlvRect c = new IlvRect(0.0f, 0.0f, 10.0f, 10.0f);
    private IlvGraphic d;
    private IlvRect e;
    private IlvRect f;
    private boolean g = false;
    private boolean h = true;
    private boolean i = false;
    private IlvLinkConnector j;
    private boolean k = false;
    private static final float l = 2.0f;

    public IlvMakeLinkInteractor() {
        this.setAllowingMultiplePoints(false);
    }

    protected void attach(IlvManagerView ilvManagerView) {
        super.attach(ilvManagerView);
        IlvManager ilvManager = ilvManagerView.getManager();
        if (ilvManager != null) {
            ilvManager.deSelectAll(true, true);
        }
    }

    protected void reInitialize() {
        this.b();
        super.reInitialize();
        this.a = null;
        this.b = null;
        this.d = null;
        this.j = null;
    }

    public final IlvGrapher getGrapher() {
        return (IlvGrapher)this.getManager();
    }

    public boolean isOriented() {
        return this.g;
    }

    public final void setOriented(boolean bl) {
        this.g = bl;
    }

    public final void setLinkFactory(IlvLinkImageFactory ilvLinkImageFactory) {
        this.q = ilvLinkImageFactory;
    }

    public final IlvLinkImageFactory getLinkFactory() {
        return (IlvLinkImageFactory)this.q;
    }

    protected IlvGraphic makePolyPoint(IlvPoint[] ilvPointArray) {
        IlvGraphic ilvGraphic = null;
        IlvGraphic ilvGraphic2 = null;
        if (this.isOpaqueMode() && !this.k) {
            ilvGraphic = new DummyNode(this.a);
            ilvGraphic2 = new DummyNode(this.b);
        } else {
            if (!this.b(this.a) || !this.b(this.b)) {
                return null;
            }
            ilvGraphic = this.a;
            ilvGraphic2 = this.b;
        }
        return this.a(ilvGraphic, ilvGraphic2, ilvPointArray);
    }

    public final IlvGraphic getFrom() {
        return this.a;
    }

    public final IlvGraphic getTo() {
        return this.b;
    }

    protected Class getLinkClass() {
        return this.getLinkFactory() != null ? this.getLinkFactory().getLinkImageClass() : IlvLinkImage.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIt() {
        this.k = true;
        try {
            super.doIt();
        }
        finally {
            this.k = false;
        }
    }

    private IlvLinkImage a(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, IlvPoint[] ilvPointArray) {
        IlvLinkImage ilvLinkImage;
        IlvLinkImage ilvLinkImage2 = ilvLinkImage = this.getLinkFactory() != null ? this.getLinkFactory().createObject(ilvGraphic, ilvGraphic2, ilvPointArray, this.isOriented()) : new IlvLinkImage(ilvGraphic, ilvGraphic2, this.isOriented());
        if (ilvLinkImage != null) {
            ilvLinkImage.setBackground(this.getBackground());
            ilvLinkImage.setForeground(this.getForeground());
        }
        if (ilvLinkImage != null) {
            IlvPoint ilvPoint;
            IlvTransformer ilvTransformer = this.getTransformer();
            IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
            if (ilvLinkConnector != null && !(ilvLinkConnector instanceof IlvClippingLinkConnector)) {
                ilvPoint = new IlvPoint(ilvPointArray[0]);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint);
                }
                ilvLinkConnector.connectLink(ilvLinkImage, ilvPoint, true, this.a(ilvGraphic));
            }
            if ((ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic2)) != null && !(ilvLinkConnector instanceof IlvClippingLinkConnector)) {
                ilvPoint = new IlvPoint(ilvPointArray[ilvPointArray.length - 1]);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint);
                }
                ilvLinkConnector.connectLink(ilvLinkImage, ilvPoint, false, this.a(ilvGraphic2));
            }
        }
        return ilvLinkImage;
    }

    private IlvTransformer a(IlvGraphic ilvGraphic) {
        return this.a(ilvGraphic, this.k);
    }

    private IlvTransformer a(IlvGraphic ilvGraphic, boolean bl) {
        if (!bl) {
            return this.getTransformer();
        }
        if (ilvGraphic instanceof DummyNode) {
            ilvGraphic = ((DummyNode)ilvGraphic).a();
        }
        return ilvGraphic != null && ilvGraphic.getGraphicBag() instanceof IlvManager ? ((IlvManager)ilvGraphic.getGraphicBag()).getDrawingTransformer(this.getManagerView()) : this.getTransformer();
    }

    protected void react(IlvPoint ilvPoint) {
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        IlvTransformer ilvTransformer = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint2);
        }
        if (this.a(ilvPoint2)) {
            return;
        }
        IlvGraphic ilvGraphic = this.getGrapher().getObject(ilvPoint2, this.getManagerView(), this.isCreationInSubManagersAllowed());
        if (ilvGraphic == null || ilvGraphic instanceof IlvSelection || ilvGraphic instanceof IlvManager && !this.a(ilvPoint2, (IlvManager)ilvGraphic)) {
            if (this.d != null) {
                this.unHighlight(this.d);
                this.d = null;
            }
            if (this.count() > 0) {
                this.b = null;
            } else {
                this.a = null;
            }
            return;
        }
        if (!this.b(ilvGraphic)) {
            return;
        }
        if (ilvGraphic != this.d) {
            if (this.d != null) {
                this.unHighlight(this.d);
            }
            this.d = ilvGraphic;
            if (this.d != null) {
                this.highlight(this.d);
                this.e = this.d.boundingBox(ilvTransformer);
                if (this.j != null) {
                    IlvRect ilvRect = this.j.getGhostBoundingBox(ilvTransformer);
                    if (ilvRect.width > 0.0f && ilvRect.height > 0.0f) {
                        ilvRect.expand(2.0f);
                        this.f = new IlvRect(ilvRect);
                    } else {
                        this.f = null;
                    }
                }
            }
        }
    }

    private boolean a(IlvPoint ilvPoint) {
        if (this.d == null || this.e == null || this.f == null || this.e.inside(ilvPoint.x, ilvPoint.y)) {
            return false;
        }
        IlvRect ilvRect = new IlvRect(this.e);
        ilvRect.add(this.f);
        return ilvRect.inside(ilvPoint.x, ilvPoint.y);
    }

    protected void highlight(IlvGraphic ilvGraphic) {
        IlvTransformer ilvTransformer;
        if (!this.b(ilvGraphic)) {
            return;
        }
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
        boolean bl = false;
        if (ilvLinkConnector != null && this.a(ilvLinkConnector, ilvTransformer = this.a(ilvGraphic, true))) {
            bl = true;
            this.j = ilvLinkConnector;
            this.b(ilvLinkConnector, ilvTransformer);
        }
        if (!bl) {
            this.j = null;
            this.a(ilvGraphic, true, true);
        }
    }

    protected void unHighlight(IlvGraphic ilvGraphic) {
        if (!this.b(ilvGraphic)) {
            return;
        }
        if (this.j != null) {
            this.b();
        } else {
            this.a(ilvGraphic, false, true);
        }
    }

    private boolean a(IlvLinkConnector ilvLinkConnector, IlvTransformer ilvTransformer) {
        if (ilvLinkConnector == null || !ilvLinkConnector.supportsDrawGhost()) {
            return false;
        }
        IlvRect ilvRect = ilvLinkConnector.getGhostBoundingBox(ilvTransformer);
        return ilvRect.width > 0.0f && ilvRect.height > 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IlvGraphic ilvGraphic, boolean bl, boolean bl2) {
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (!(ilvGraphicBag instanceof IlvManager)) {
            return;
        }
        IlvManager ilvManager = (IlvManager)ilvGraphicBag;
        if (!bl2 && !ilvManager.isSelectable(ilvGraphic)) {
            return;
        }
        IlvManager ilvManager2 = this.getManager();
        if (ilvManager != ilvManager2) {
            ilvManager.setContentsAdjusting(true, true);
            ilvManager2.setSelectionAdjusting(true);
        }
        try {
            ilvManager.setSelected(ilvGraphic, bl, true);
        }
        finally {
            if (ilvManager != ilvManager2) {
                ilvManager2.setSelectionAdjusting(false);
                ilvManager.setContentsAdjusting(false, true);
            }
        }
    }

    protected boolean numberOfPointsReached() {
        return this.a != null && this.b != null;
    }

    protected boolean endOnDoubleClick() {
        return false;
    }

    private boolean b(IlvPoint ilvPoint) {
        IlvGraphic ilvGraphic;
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        IlvManagerView ilvManagerView = this.getManagerView();
        IlvTransformer ilvTransformer = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint2);
        }
        IlvGraphic ilvGraphic2 = ilvGraphic = this.a(ilvPoint2) ? this.d : this.getGrapher().getObject(ilvPoint2, ilvManagerView, this.isCreationInSubManagersAllowed());
        if (ilvGraphic == null && !this.isAllowingMultiplePoints() && this.d == this.a) {
            return false;
        }
        if (!this.isAllowingMultiplePoints() && (ilvGraphic == null || ilvGraphic != null && ilvGraphic instanceof IlvSelection)) {
            ilvGraphic = this.d;
        }
        if (ilvGraphic != null && !(ilvGraphic instanceof IlvSelection) && this.b(ilvGraphic) && this.acceptDestination(ilvPoint, ilvGraphic)) {
            this.b = ilvGraphic;
            if (this.m != null) {
                ((DummyNode)((IlvLinkImage)this.m).getTo()).a(this.b);
            }
            if (this.d != null) {
                this.unHighlight(this.d);
                this.d = null;
            }
            return true;
        }
        return this.isAllowingMultiplePoints();
    }

    private boolean c(IlvPoint ilvPoint) {
        IlvGraphic ilvGraphic;
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        IlvManagerView ilvManagerView = this.getManagerView();
        IlvTransformer ilvTransformer = this.getTransformer();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint2);
        }
        if ((ilvGraphic = this.getGrapher().getObject(ilvPoint2, ilvManagerView, this.isCreationInSubManagersAllowed())) == null || ilvGraphic != null && ilvGraphic instanceof IlvSelection) {
            ilvGraphic = this.d;
        }
        if (ilvGraphic != null && this.b(ilvGraphic) && this.a == null && this.acceptOrigin(ilvPoint, ilvGraphic)) {
            this.a = ilvGraphic;
            if (this.m != null) {
                ((DummyNode)((IlvLinkImage)this.m).getFrom()).a(this.a);
            }
            if (this.d != null) {
                this.unHighlight(this.d);
                this.d = null;
            }
            return true;
        }
        return false;
    }

    private boolean b(IlvGraphic ilvGraphic) {
        if (ilvGraphic == null) {
            return false;
        }
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (!(ilvGraphicBag instanceof IlvGrapher)) {
            return false;
        }
        return ((IlvGrapher)ilvGraphicBag).isNode(ilvGraphic);
    }

    protected boolean acceptOrigin(IlvPoint ilvPoint, IlvGraphic ilvGraphic) {
        if (!this.isCreationInSubManagersAllowed() && ilvGraphic.getGraphicBag() != this.getManager()) {
            return false;
        }
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
        if (ilvLinkConnector != null) {
            IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
            IlvTransformer ilvTransformer = this.getTransformer();
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint2);
            }
            IlvPoint ilvPoint3 = ilvLinkConnector.getClosestConnectionPoint(ilvPoint2, ilvGraphic, null, this.getLinkClass(), true, this.a(ilvGraphic, true));
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint3);
            }
            ilvPoint.move(ilvPoint3.x, ilvPoint3.y);
        }
        return true;
    }

    protected boolean acceptDestination(IlvPoint ilvPoint, IlvGraphic ilvGraphic) {
        Serializable serializable;
        if (!this.isCreationInSubManagersAllowed() && ilvGraphic.getGraphicBag() != this.getManager()) {
            return false;
        }
        if (!this.isSelfLinkAllowed() && this.getFrom() == ilvGraphic) {
            return false;
        }
        IlvPoint ilvPoint2 = null;
        if (ilvGraphic instanceof IlvManager) {
            ilvPoint2 = new IlvPoint(ilvPoint);
            serializable = this.getTransformer();
            if (serializable != null) {
                ((IlvTransformer)serializable).apply(ilvPoint2);
            }
            if (!this.a(ilvPoint2, (IlvManager)ilvGraphic)) {
                return false;
            }
        }
        if (this.getFrom().getGraphicBag() != ilvGraphic.getGraphicBag() && IlvGrapher.getLowestCommonGrapher(this.getFrom(), ilvGraphic) == null) {
            return false;
        }
        serializable = IlvLinkConnector.GetAttached(ilvGraphic);
        if (serializable != null) {
            IlvTransformer ilvTransformer = this.getTransformer();
            if (ilvPoint2 == null) {
                ilvPoint2 = new IlvPoint(ilvPoint);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint2);
                }
            }
            IlvPoint ilvPoint3 = ((IlvLinkConnector)serializable).getClosestConnectionPoint(ilvPoint2, ilvGraphic, null, this.getLinkClass(), false, this.a(ilvGraphic, true));
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint3);
            }
            ilvPoint.move(ilvPoint3.x, ilvPoint3.y);
        }
        return true;
    }

    private boolean a(IlvPoint ilvPoint, IlvManager ilvManager) {
        IlvPoint ilvPoint2;
        IlvTransformer ilvTransformer;
        IlvGraphicBag ilvGraphicBag = ilvManager.getGraphicBag();
        if (ilvGraphicBag == null) {
            ilvTransformer = this.getManagerView().getTransformer();
        } else if (ilvGraphicBag instanceof IlvManager) {
            ilvTransformer = ((IlvManager)ilvGraphicBag).getDrawingTransformer(this.getManagerView());
        } else {
            throw new RuntimeException("manager: " + ilvManager + " is inside a bag which is not IlvManager: " + ilvGraphicBag);
        }
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvPoint2 = new IlvPoint(ilvPoint.x, ilvPoint.y);
            ilvTransformer.inverse(ilvPoint2);
        } else {
            ilvPoint2 = ilvPoint;
        }
        return ilvManager.containsFrame(ilvPoint2, ilvPoint, ilvTransformer);
    }

    protected boolean accept(IlvPoint ilvPoint) {
        return this.count() == 0 ? this.c(ilvPoint) : this.b(ilvPoint);
    }

    public final void setSelfLinkAllowed(boolean bl) {
        this.h = bl;
    }

    public final boolean isSelfLinkAllowed() {
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPolyPoints(IlvGraphic ilvGraphic) {
        Serializable serializable;
        Serializable serializable2;
        IlvManager ilvManager;
        IlvLinkImage ilvLinkImage = (IlvLinkImage)ilvGraphic;
        IlvManager ilvManager2 = ilvManager = ilvLinkImage.getFrom().getGraphicBag() == ilvLinkImage.getTo().getGraphicBag() ? (IlvManager)ilvLinkImage.getFrom().getGraphicBag() : IlvGrapher.getLowestCommonGrapher(ilvLinkImage.getFrom(), ilvLinkImage.getTo());
        if (ilvManager == null) {
            throw new RuntimeException("no common parent found for " + ilvLinkImage.getFrom().getGraphicBag() + " and " + ilvLinkImage.getTo().getGraphicBag());
        }
        int n2 = ilvLinkImage.getPointsCardinal();
        if (n2 >= 3) {
            serializable2 = this.getTransformer();
            serializable = ilvManager.getDrawingTransformer(this.getManagerView());
            for (int i2 = 1; i2 < n2 - 1; ++i2) {
                IlvPoint ilvPoint = ilvLinkImage.getPointAt(i2, (IlvTransformer)serializable2);
                if (serializable != null) {
                    ((IlvTransformer)serializable).inverse(ilvPoint);
                }
                ilvLinkImage.movePoint(i2, ilvPoint.x, ilvPoint.y, (IlvTransformer)serializable);
            }
        }
        serializable2 = this.getManager();
        Serializable serializable3 = serializable = ilvManager != null ? ilvManager : null;
        if (serializable == null) {
            return;
        }
        if (serializable != serializable2) {
            ((IlvManager)serializable).setContentsAdjusting(true, true);
            ((IlvManager)serializable2).setSelectionAdjusting(true);
        } else {
            ((IlvManager)serializable).setSelectionAdjusting(true);
        }
        try {
            if (ilvManager instanceof IlvGrapher) {
                ((IlvGrapher)ilvManager).addLink(ilvLinkImage, ((IlvGrapher)ilvManager).getLinksInsertionLayer(), true);
            } else {
                ilvManager.addObject(ilvLinkImage, ilvManager.getInsertionLayer(), true);
            }
            if (this.isSelectionMode()) {
                this.a((IlvGraphic)ilvLinkImage, true, false);
            }
        }
        finally {
            if (serializable != serializable2) {
                ((IlvManager)serializable2).setSelectionAdjusting(false);
                ((IlvManager)serializable).setContentsAdjusting(false, true);
            } else {
                ((IlvManager)serializable).setSelectionAdjusting(false);
            }
        }
    }

    public void setSelectionMode(boolean bl) {
        this.i = bl;
    }

    public boolean isSelectionMode() {
        return this.i;
    }

    public boolean isGridMode() {
        return super.isGridMode() && this.count() != 0;
    }

    protected void drawGhost(Graphics graphics) {
        this.a(graphics);
        this.b(graphics);
    }

    private void a(Graphics graphics) {
        if (this.count() > 1) {
            super.drawGhost(graphics);
        }
    }

    private void b(Graphics graphics) {
        if (this.j != null) {
            this.j.drawGhost(graphics, this.a(this.j.getNode(), true), this.getFrom(), this.getTo(), this.getLinkClass(), this.getFrom() == null);
        }
    }

    private void b() {
        if (this.j != null) {
            IlvLinkConnector ilvLinkConnector = this.j;
            this.j = null;
            this.a(ilvLinkConnector);
        }
    }

    private void a(IlvLinkConnector ilvLinkConnector) {
        if (ilvLinkConnector != null && this.getManagerView() != null) {
            this.b(ilvLinkConnector, this.a(ilvLinkConnector.getNode(), true));
        }
    }

    private void b(IlvLinkConnector ilvLinkConnector, IlvTransformer ilvTransformer) {
        IlvManagerView ilvManagerView;
        if (ilvLinkConnector != null && (ilvManagerView = this.getManagerView()) != null) {
            IlvRect ilvRect = ilvLinkConnector.getGhostBoundingBox(ilvTransformer);
            ilvManagerView.invalidateRect(ilvRect);
            ilvManagerView.reDrawViews();
        }
    }

    private class MovablePointLinkConnector
    extends IlvLinkConnector {
        private IlvPoint a = null;

        private MovablePointLinkConnector() {
        }

        public void detach(boolean bl) {
            super.detach(bl);
            this.a = null;
        }

        public IlvPoint getConnectionPoint(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer) {
            if (this.a == null) {
                return new IlvPoint(0.0f, 0.0f);
            }
            IlvPoint ilvPoint = new IlvPoint(this.a);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            return ilvPoint;
        }

        public void connectLink(IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, boolean bl, IlvTransformer ilvTransformer) {
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint);
            }
            if (this.a == null) {
                this.a = new IlvPoint(ilvPoint.x, ilvPoint.y);
            } else {
                this.a.move(ilvPoint.x, ilvPoint.y);
            }
        }

        public boolean zoomable() {
            return true;
        }

        public IlvPoint getClosestConnectionPoint(IlvPoint ilvPoint, Object object, Object object2, Object object3, boolean bl, IlvTransformer ilvTransformer) {
            return ilvPoint;
        }

        public void linkRemoved(IlvLinkImage ilvLinkImage) {
            this.a = null;
        }

        protected void allLinksRemoved() {
            this.a = null;
        }

        public IlvRect getGhostBoundingBox(IlvTransformer ilvTransformer) {
            return new IlvRect();
        }
    }

    private class DummyNode
    extends IlvGraphic {
        private IlvGraphic a = null;

        DummyNode(IlvGraphic ilvGraphic) {
            MovablePointLinkConnector movablePointLinkConnector = new MovablePointLinkConnector();
            movablePointLinkConnector.attach(this, false);
            this.a(ilvGraphic);
        }

        void a(IlvGraphic ilvGraphic) {
            this.a = ilvGraphic;
        }

        IlvGraphic a() {
            return this.a;
        }

        public IlvGraphic copy() {
            return null;
        }

        public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        }

        public IlvRect boundingBox(IlvTransformer ilvTransformer) {
            return this.a != null ? this.a.boundingBox(ilvTransformer) : c;
        }

        public void applyTransform(IlvTransformer ilvTransformer) {
        }
    }
}

