/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.linkpolicy;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvAbstractCrossingGraphic;
import ilog.views.graphic.linkpolicy.IlvCrossingAwareLinkImage;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvTunnelCrossings
extends IlvAbstractCrossingGraphic {
    public IlvTunnelCrossings(IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage) {
        super(ilvCrossingAwareLinkImage);
    }

    public IlvTunnelCrossings(IlvTunnelCrossings ilvTunnelCrossings) {
        super(ilvTunnelCrossings);
    }

    public IlvTunnelCrossings(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
    }

    public IlvGraphic copy() {
        return new IlvTunnelCrossings(this);
    }

    public void drawCrossing(Graphics graphics, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f2, float f3, float f4) {
        graphics.setColor(ilvLinkImage.getForeground());
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f4, true, false);
        if (!drawingParameters.g) {
            return;
        }
        IlvGraphicUtil.DrawBezier(graphics, drawingParameters.a, 4, drawingParameters.e, 0, 1, drawingParameters.f, ilvTransformer, true);
        IlvGraphicUtil.DrawBezier(graphics, drawingParameters.b, 4, drawingParameters.e, 0, 1, drawingParameters.f, ilvTransformer, true);
        IlvGraphicUtil.DrawPolyline(graphics, drawingParameters.c, 2, drawingParameters.e, 0, 1, drawingParameters.f, ilvTransformer, true);
    }

    public boolean containsAtCrossing(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvPoint ilvPoint6, float f2, float f3, float f4) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint3, ilvPoint4, ilvPoint5, ilvPoint6, f4, false, false);
        if (!drawingParameters.g) {
            return false;
        }
        if (IlvGraphicUtil.PointInBezier(ilvPoint2, drawingParameters.a, 4, drawingParameters.d, 0, 1, null)) {
            return true;
        }
        if (IlvGraphicUtil.PointInBezier(ilvPoint2, drawingParameters.b, 4, drawingParameters.d, 0, 1, null)) {
            return true;
        }
        return IlvGraphicUtil.PointInPolyline(ilvPoint2, drawingParameters.c, 2, drawingParameters.d, 0, 1, null);
    }

    public IlvRect expandLinkBoundingBox(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        float f2;
        double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = this.getRelatedLinkImage();
        float f3 = ilvCrossingAwareLinkImage.getGap();
        if (ilvCrossingAwareLinkImage.isGapZoomable()) {
            f3 = (float)((double)f3 * d2);
        }
        if ((f2 = ilvCrossingAwareLinkImage.getLineWidth()) != 0.0f) {
            float f4 = ilvCrossingAwareLinkImage.getMaximumLineWidth();
            f2 = IlvStrokeInfo.zoomedLineWidth(f2, f4, ilvTransformer, true);
        }
        f2 = (float)((double)f2 * d2);
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, 2.0f * f3 + f2, f3);
        IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
        IlvPoint ilvPoint2 = new IlvPoint(2.0f * f3 + f2, 0.0f);
        this.addCrossingBound(ilvRect2, ilvTransformer, ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f3);
        IlvRect ilvRect3 = new IlvRect(0.0f, 0.0f, f3, 2.0f * f3 + f2);
        ilvPoint.move(0.0f, 0.0f);
        ilvPoint2.move(0.0f, 2.0f * f3 + f2);
        this.addCrossingBound(ilvRect3, ilvTransformer, ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f3);
        IlvRect ilvRect4 = new IlvRect(ilvRect);
        ilvRect4.x -= 1.5f * ilvRect3.width;
        ilvRect4.y -= 1.5f * ilvRect2.height;
        ilvRect4.width += 3.0f * ilvRect3.width;
        ilvRect4.height += 3.0f * ilvRect2.height;
        return ilvRect4;
    }

    public void addCrossingBound(IlvRect ilvRect, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f2, float f3, float f4) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f4, false, true);
        if (!drawingParameters.g) {
            return;
        }
        IlvRect ilvRect2 = new IlvRect();
        IlvGraphicUtil.BezierBoundingBox(ilvRect2, drawingParameters.a, 4, drawingParameters.d, 0, 1, null);
        ilvRect.add(ilvRect2);
        IlvGraphicUtil.BezierBoundingBox(ilvRect2, drawingParameters.b, 4, drawingParameters.d, 0, 1, null);
        ilvRect.add(ilvRect2);
        ilvRect.add(IlvGraphicUtil.PolylineBBox(drawingParameters.c, 2, drawingParameters.d, 0, 1, null));
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
    }

    class DrawingParameters {
        IlvPoint[] a;
        IlvPoint[] b;
        IlvPoint[] c;
        float d;
        float e;
        float[] f;
        boolean g = true;

        DrawingParameters(IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f2, boolean bl, boolean bl2) {
            float f3;
            float f4;
            float f5;
            double d2;
            this.e = ilvLinkImage.getLineWidth();
            int n2 = ilvLinkImage.getEndCap();
            double d3 = d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (bl) {
                this.f = ilvLinkImage.getLineStyle();
            }
            if (this.e != 0.0f) {
                f5 = ilvLinkImage.getMaximumLineWidth();
                if (bl) {
                    this.f = IlvStrokeInfo.zoomedLineStyle(this.f, this.e, f5, ilvTransformer);
                }
                this.e = IlvStrokeInfo.zoomedLineWidth(this.e, f5, ilvTransformer, bl2);
            }
            this.d = (float)((double)this.e * d2);
            f5 = ilvPoint3.x - ilvPoint2.x;
            float f6 = ilvPoint3.y - ilvPoint2.y;
            double d4 = Math.sqrt(f5 * f5 + f6 * f6);
            if (d4 == 0.0) {
                this.g = false;
                return;
            }
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 0.0f;
            if (n2 == 0) {
                double d5;
                if (ilvPoint != null && Math.abs((f4 = ilvPoint2.x - ilvPoint.x) * f6 - (f3 = ilvPoint2.y - ilvPoint.y) * f5) < 0.01f && (d5 = Math.sqrt(f4 * f4 + f3 * f3)) > (double)(0.5f * this.d)) {
                    f7 = (float)((double)(0.5f * this.d * f5) / d4);
                    f8 = (float)((double)(0.5f * this.d * f6) / d4);
                }
                if (ilvPoint4 != null && Math.abs((f4 = ilvPoint4.x - ilvPoint3.x) * f6 - (f3 = ilvPoint4.y - ilvPoint3.y) * f5) < 0.01f && (d5 = Math.sqrt(f4 * f4 + f3 * f3)) > (double)(0.5f * this.d)) {
                    f9 = (float)((double)(0.5f * this.d * f5) / d4);
                    f10 = (float)((double)(0.5f * this.d * f6) / d4);
                }
                if ((d4 = Math.sqrt((f5 += f7 + f9) * f5 + (f6 += f8 + f10) * f6)) == 0.0) {
                    this.g = false;
                    return;
                }
            }
            f4 = 0.5f * this.d + f2;
            f3 = 0.5f * this.d + f2;
            if (f3 == 0.0f) {
                this.g = false;
                return;
            }
            if ((double)(2.0f * f4) > d4) {
                f4 = (float)(d4 / 2.0);
            }
            int n3 = -1;
            if (f5 < 0.0f || f5 == 0.0f && f6 < 0.0f) {
                n3 = 1;
            }
            this.a = new IlvPoint[4];
            this.b = new IlvPoint[4];
            this.c = new IlvPoint[2];
            float f11 = ilvPoint2.x - f7;
            float f12 = ilvPoint2.y - f8;
            float f13 = ilvPoint3.x + f9;
            float f14 = ilvPoint3.y + f10;
            float f15 = -((float)((double)((float)n3 * f3 * f6) / d4));
            float f16 = (float)((double)((float)n3 * f3 * f5) / d4);
            float f17 = (float)((double)(f4 * f5) / d4);
            float f18 = (float)((double)(f4 * f6) / d4);
            this.a[0] = new IlvPoint(f11, f12);
            this.a[1] = new IlvPoint(f11 + 0.42f * f15, f12 + 0.42f * f16);
            this.a[2] = new IlvPoint(f11 + 0.58f * f17 + f15, f12 + 0.58f * f18 + f16);
            this.a[3] = new IlvPoint(f11 + f17 + f15, f12 + f18 + f16);
            this.b[0] = new IlvPoint(f13, f14);
            this.b[1] = new IlvPoint(f13 + 0.42f * f15, f14 + 0.42f * f16);
            this.b[2] = new IlvPoint(f13 - 0.58f * f17 + f15, f14 - 0.58f * f18 + f16);
            this.b[3] = new IlvPoint(f13 - f17 + f15, f14 - f18 + f16);
            this.c[0] = this.a[3];
            this.c[1] = this.b[3];
        }
    }
}

