/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.decoration;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.graphic.IlvGraphicSet;
import ilog.views.graphic.IlvLine;
import ilog.views.graphic.composite.internal.IlvInvisibleSelection;
import ilog.views.graphic.composite.internal.IlvPolyline2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class IlvAssociation
extends IlvGraphicSet
implements ManagerContentChangedListener,
IlvPersistentObject {
    private IlvGraphic a;
    private IlvGraphic b;
    private IlvLine c;
    IlvApplyObject d = new IlvApplyObject(){

        public void apply(IlvGraphic ilvGraphic, Object object) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    IlvAssociation.this.a();
                }
            });
        }
    };

    public IlvAssociation() {
        this((IlvGraphic)null);
    }

    public IlvAssociation(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        Color color = this.getForeground();
        try {
            this.b = ilvInputStream.readObject("callout");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setAnchor(ilvInputStream.readObject("anchor"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.c = (IlvLine)ilvInputStream.readObject("line");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        this.registerBlinkingResource(color, this.getForeground());
    }

    public IlvAssociation(IlvGraphic ilvGraphic) {
        this.setLine(new IlvLine(0.0f, 0.0f, 10.0f, 10.0f));
        this.setAnchor(ilvGraphic);
    }

    public IlvAssociation(IlvAssociation ilvAssociation) {
        if (ilvAssociation.getAnchor() != null) {
            this.setAnchor(ilvAssociation.getAnchor().copy());
        }
        if (ilvAssociation.getCallout() != null) {
            this.setCallout(ilvAssociation.getCallout().copy());
        }
        if (ilvAssociation.getLine() != null) {
            this.setLine((IlvLine)ilvAssociation.getLine().copy());
        }
    }

    public IlvGraphic copy() {
        return new IlvAssociation(this);
    }

    public IlvLine getLine() {
        return this.c;
    }

    public void setLine(IlvLine ilvLine) {
        Color color = this.getForeground();
        if (this.c != null) {
            this.removeObject(this.c, false);
        }
        this.c = ilvLine;
        if (ilvLine != null) {
            this.addObject(ilvLine, false);
        }
        this.a();
        this.registerBlinkingResource(color, this.getForeground());
    }

    public IlvGraphic getAnchor() {
        return this.a;
    }

    public void setAnchor(IlvGraphic ilvGraphic) {
        this.a = ilvGraphic;
        this.a();
    }

    private IlvPoint a(IlvTransformer ilvTransformer) {
        if (this.a instanceof IlvLinkImage) {
            IlvPoint[] ilvPointArray = ((IlvLinkImage)this.a).getLinkPoints(ilvTransformer);
            IlvPolyline2D ilvPolyline2D = new IlvPolyline2D(ilvPointArray);
            return new IlvPoint(ilvPolyline2D.getMedian().point);
        }
        IlvRect ilvRect = this.a.boundingBox(ilvTransformer);
        IlvPoint ilvPoint = new IlvPoint((float)ilvRect.getCenterX(), (float)ilvRect.getCenterY());
        return ilvPoint;
    }

    public IlvGraphic getCallout() {
        return this.b;
    }

    public void setCallout(IlvGraphic ilvGraphic) {
        this.b = ilvGraphic;
        this.a();
    }

    private void a() {
        if (this.b != null || this.a != null) {
            IlvPoint ilvPoint;
            IlvRect ilvRect = this.b != null ? this.b.boundingBox(null) : this.a.boundingBox(null);
            final IlvPoint ilvPoint2 = new IlvPoint((float)ilvRect.getCenterX(), (float)ilvRect.getCenterY());
            if (this.a != null) {
                ilvRect = this.a.boundingBox(null);
                ilvPoint = new IlvPoint((float)ilvRect.getCenterX(), (float)ilvRect.getCenterY());
            } else {
                ilvPoint = new IlvPoint(ilvPoint2);
            }
            if (this.getGraphicBag() != null) {
                this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        IlvAssociation.this.c.setFrom(ilvPoint2);
                        IlvAssociation.this.c.setTo(ilvPoint);
                    }
                }, null, true);
            } else {
                this.c.setFrom(ilvPoint2);
                this.c.setTo(ilvPoint);
            }
        }
    }

    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        IlvManager ilvManager;
        if (this.getGraphicBag() != null && this.getGraphicBag() instanceof IlvManager) {
            ilvManager = (IlvManager)this.getGraphicBag();
            ilvManager.removeManagerContentChangedListener(this);
        }
        super.setGraphicBag(ilvGraphicBag);
        if (ilvGraphicBag instanceof IlvManager) {
            ilvManager = (IlvManager)ilvGraphicBag;
            ilvManager.addManagerContentChangedListener(this);
            this.a();
        }
    }

    public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
        switch (managerContentChangedEvent.getType()) {
            case 4: {
                ObjectBBoxChangedEvent objectBBoxChangedEvent = (ObjectBBoxChangedEvent)managerContentChangedEvent;
                if (objectBBoxChangedEvent.getGraphicObject() != this.b && objectBBoxChangedEvent.getGraphicObject() != this.a) break;
                managerContentChangedEvent.getManager().applyToObject(this, this.d, null, true);
                break;
            }
            case 1: {
                ObjectInsertedEvent objectInsertedEvent = (ObjectInsertedEvent)managerContentChangedEvent;
                if (objectInsertedEvent.getGraphicObject() == this.b || objectInsertedEvent.getGraphicObject() == this.a) {
                    managerContentChangedEvent.getManager().applyToObject(this, this.d, null, true);
                    break;
                }
                if (objectInsertedEvent.getGraphicObject() != this) break;
                managerContentChangedEvent.getManager().setMovable(this, false);
                break;
            }
        }
    }

    public IlvSelection makeSelection() {
        return new IlvInvisibleSelection(this);
    }

    public boolean zoomable() {
        return false;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        if (this.b != null) {
            ilvOutputStream.write("callout", this.b);
        }
        if (this.a != null) {
            ilvOutputStream.write("anchor", this.a);
        }
        if (this.c != null) {
            ilvOutputStream.write("line", this.c);
        }
    }

    public float[] getLineStyle() {
        if (this.c == null) {
            return null;
        }
        return this.c.getLineStyle();
    }

    public void setLineStyle(float[] fArray) {
        if (this.c == null) {
            return;
        }
        this.c.setLineStyle(fArray);
    }

    public float getLineWidth() {
        if (this.c == null) {
            return 0.0f;
        }
        return this.c.getLineWidth();
    }

    public void setLineWidth(float f2) {
        if (this.c == null) {
            return;
        }
        this.c.setLineWidth(f2);
    }

    public void setForeground(Color color) {
        if (this.c == null) {
            return;
        }
        Color color2 = this.getForeground();
        this.c.setForeground(color);
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        if (this.c == null) {
            return Color.black;
        }
        return this.c.getForeground();
    }

    public float getMaximumLineWidth() {
        if (this.c == null) {
            return 0.0f;
        }
        return this.c.getMaximumLineWidth();
    }

    public void setMaximumLineWidth(float f2) {
        if (this.c == null) {
            return;
        }
        this.c.setMaximumLineWidth(f2);
    }
}

