/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvShadowRectangle
extends IlvRectangle {
    private float a = 4.0f;
    private int b = 10;

    public IlvShadowRectangle() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f), 2.0f, 10);
    }

    public IlvShadowRectangle(IlvRect ilvRect, float f2, int n2) {
        super(ilvRect);
        this.setThickness(f2);
        this.setShadowPosition(n2);
        super.setFillOn(true);
    }

    public IlvShadowRectangle(IlvRect ilvRect) {
        this(ilvRect, 5.0f, 10);
    }

    public IlvShadowRectangle(IlvShadowRectangle ilvShadowRectangle) {
        super(ilvShadowRectangle);
        this.setThickness(ilvShadowRectangle.getThickness());
        this.setShadowPosition(ilvShadowRectangle.getShadowPosition());
    }

    public IlvShadowRectangle(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setThickness(ilvInputStream.readFloat("thickness"));
        this.setShadowPosition(ilvInputStream.readInt("shadowPosition"));
    }

    public IlvGraphic copy() {
        return new IlvShadowRectangle(this);
    }

    public int getShadowPosition() {
        return this.b;
    }

    public void setShadowPosition(int n2) {
        if (n2 != 5 && n2 != 9 && n2 != 6 && n2 != 10) {
            throw new IllegalArgumentException("bad position");
        }
        this.b = n2;
    }

    public float getThickness() {
        return this.a;
    }

    public void setThickness(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.a = f2;
    }

    protected void drawContent(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
    }

    public final void setRadius(int n2) {
        throw new RuntimeException("could not change radius for IlvShadowRectangle");
    }

    public final void setStrokeOn(boolean bl) {
        throw new RuntimeException("could not change stroke on/off for IlvShadowRectangle");
    }

    public final void setFillOn(boolean bl) {
        throw new RuntimeException("could not change fill on/off for IlvShadowRectangle");
    }

    public final void setCorners(int n2) {
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2 = this.getThickness();
        int n2 = this.getShadowPosition();
        IlvRect ilvRect = new IlvRect(this.drawrect);
        if (ilvTransformer != null) {
            ilvTransformer.applyFloor(ilvRect);
        } else {
            ilvRect.floor();
        }
        if (3.0f * f2 > ilvRect.width) {
            f2 = ilvRect.width / 3.0f;
        }
        if (3.0f * f2 > ilvRect.height) {
            f2 = ilvRect.height / 3.0f;
        }
        float f3 = ilvRect.x;
        float f4 = ilvRect.y;
        if ((n2 & 3) != 0) {
            ilvRect.width = Math.max(0.0f, ilvRect.width - f2);
            if ((n2 & 1) != 0) {
                ilvRect.x += f2;
            } else {
                f3 += f2;
            }
        }
        if ((n2 & 0xC) != 0) {
            ilvRect.height = Math.max(0.0f, ilvRect.height - f2);
            if ((n2 & 4) != 0) {
                ilvRect.y += f2;
            } else {
                f4 += f2;
            }
        }
        graphics.setColor(this.getForeground());
        graphics.fillRect((int)f3, (int)f4, (int)ilvRect.width, (int)ilvRect.height);
        graphics.setColor(this.getBackground());
        graphics.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        graphics.setColor(this.getForeground());
        graphics.drawRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        this.drawContent(graphics, ilvRect, ilvTransformer);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("thickness", this.getThickness());
        ilvOutputStream.write("shadowPosition", this.getShadowPosition());
    }
}

