/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTextInterface;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvText;
import ilog.views.graphic.IlvTextSelection;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;

public class IlvLabel
extends IlvGraphic
implements IlvFontInterface,
IlvTextInterface {
    private Color a;
    private String b;
    private Font c = IlvToolkit.defaultFont;
    private final IlvPoint d = new IlvPoint();
    private int e;
    private int f;

    public IlvLabel() {
        this(new IlvPoint(0.0f, 0.0f), "");
    }

    public IlvLabel(IlvPoint ilvPoint, String string) {
        this.setLabel(string);
        this.setCenter(ilvPoint);
        this.a();
    }

    public IlvLabel(IlvLabel ilvLabel) {
        super(ilvLabel);
        this.setCenter(ilvLabel.getCenter());
        this.setLabel(ilvLabel.getLabel());
        this.setFont(ilvLabel.getFont());
        this.setForeground(ilvLabel.a);
        this.setAntialiasing(ilvLabel.isAntialiasing());
        this.a();
    }

    public IlvGraphic copy() {
        return new IlvLabel(this);
    }

    public void setLabel(String string) {
        this.b = string != null ? string : "";
        this.a();
    }

    public String getLabel() {
        return this.b;
    }

    public boolean supportMultiline() {
        return false;
    }

    public void setCenter(IlvPoint ilvPoint) {
        this.d.move(ilvPoint.x, ilvPoint.y);
    }

    public IlvPoint getCenter() {
        return new IlvPoint(this.d.x, this.d.y);
    }

    public final boolean isAntialiasing() {
        return this.getProperty("__ILVAntialiasing") != null;
    }

    public void setAntialiasing(boolean bl) {
        this.setProperty("__ILVAntialiasing", bl ? new Boolean(true) : null);
        this.a();
    }

    void a() {
        if (this.b == null) {
            return;
        }
        IlvRect ilvRect = IlvGraphicUtil.GetStringBounds(this.b, this.c, this.isAntialiasing());
        this.e = (int)ilvRect.width;
        this.f = (int)ilvRect.height;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.b == null) {
            return;
        }
        IlvPoint ilvPoint = this.getCenter();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
        }
        graphics.setFont(this.c);
        graphics.setColor(this.getForeground());
        int n2 = (int)Math.floor(ilvPoint.x) - this.e / 2;
        int n3 = (int)Math.floor(ilvPoint.y) + this.f / 2;
        IlvGraphicUtil.DrawString(graphics, this.b, n2, n3, this.isAntialiasing());
    }

    public boolean zoomable() {
        return false;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = this.getCenter();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
        }
        if (this.b != null) {
            IlvRect ilvRect = new IlvRect(ilvPoint.x - (float)(this.e / 2), ilvPoint.y - (float)(this.f / 2), this.e, this.f);
            if (ilvRect.width < 1.0E-20f) {
                ilvRect.width = 1.0E-20f;
            }
            if (ilvRect.height < 1.0E-20f) {
                ilvRect.height = 1.0E-20f;
            }
            return ilvRect;
        }
        return new IlvRect(ilvPoint.x, ilvPoint.y, 1.0E-20f, 1.0E-20f);
    }

    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        return this.boundingBox(ilvTransformer);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        ilvTransformer.apply(this.d);
    }

    public IlvSelection makeSelection() {
        return new IlvTextSelection(this, false);
    }

    public IlvLabel(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        this.setFont(ilvInputStream.readFont("font"));
        this.setCenter(ilvInputStream.readPoint("center"));
        this.setLabel(ilvInputStream.readString("label"));
        try {
            this.setAntialiasing(ilvInputStream.readBoolean("antialiasing"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void setForeground(Color color) {
        Color color2 = this.a;
        this.a = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        if (this.a != null) {
            return this.a;
        }
        return Color.black;
    }

    public void setFont(Font font) {
        this.c = font;
        this.a();
    }

    public Font getFont() {
        return this.c;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("font", this.getFont());
        ilvOutputStream.write("center", this.d);
        ilvOutputStream.write("label", this.getLabel());
        if (this.isAntialiasing()) {
            ilvOutputStream.write("antialiasing", this.isAntialiasing());
        }
    }

    public String toString() {
        String string = this.getLabel();
        if (string == null) {
            string = "[null string]";
        } else if (string.length() == 0) {
            string = "[empty string]";
        }
        return super.toString() + " Label: " + string;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (super.contains(ilvPoint, ilvPoint2, ilvTransformer)) {
            return true;
        }
        return IlvText.a(this, ilvPoint2, ilvTransformer);
    }

    public Shape getCaretShape(IlvTextSelection.Range range, IlvTransformer ilvTransformer) {
        Shape shape;
        if (range.isEmpty()) {
            return null;
        }
        Font font = this.getFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        String string = this.b() ? " " : this.getLabel();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        if (range.isCollapsed()) {
            Shape[] shapeArray = textLayout.getCaretShapes(range.from);
            shape = shapeArray[0];
        } else {
            shape = textLayout.getLogicalHighlightShape(range.from, range.to);
        }
        return this.a(shape, font, fontRenderContext, ilvTransformer);
    }

    boolean b() {
        return this.b == null || this.b.length() == 0;
    }

    Shape a(Shape shape, Font font, FontRenderContext fontRenderContext, IlvTransformer ilvTransformer) {
        AffineTransform affineTransform = this.a(font, fontRenderContext, ilvTransformer);
        return affineTransform.createTransformedShape(shape);
    }

    AffineTransform a(Font font, FontRenderContext fontRenderContext, IlvTransformer ilvTransformer) {
        LineMetrics lineMetrics = font.getLineMetrics(this.getLabel(), fontRenderContext);
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        double d2 = ilvRect.getX();
        double d3 = ilvRect.getMaxY() - (double)lineMetrics.getDescent();
        return new AffineTransform(1.0, 0.0, 0.0, 1.0, d2, d3);
    }

    public int pickCharacter(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        Font font = this.getFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        String string = this.b() ? " " : this.getLabel();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        AffineTransform affineTransform = this.a(font, fontRenderContext, ilvTransformer);
        Point2D.Float float_ = new Point2D.Float(ilvPoint.x, ilvPoint.y);
        Point2D.Float float_2 = new Point2D.Float();
        try {
            affineTransform.inverseTransform(float_, float_2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
            return -1;
        }
        TextHitInfo textHitInfo = textLayout.hitTestChar(float_2.x, float_2.y);
        if (this.b()) {
            return Math.min(0, textHitInfo.getInsertionIndex());
        }
        return textHitInfo.getInsertionIndex();
    }

    public int lineCount() {
        return 1;
    }

    public int lineOffset(int n2) {
        return 0;
    }
}

