/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.internal.DataStreamHandler;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;

public class IlvIcon
extends IlvGraphic
implements ImageObserver {
    protected final IlvRect drawrect;
    private Image a;
    private String b;
    private URL c;
    private boolean d;
    private boolean e;
    private IlvTransformer f;
    private boolean g;
    private RenderedImage h;
    private boolean i;
    private float j;
    private transient boolean k;
    private static boolean l = false;
    private static ImageHandler m = new ImageHandler();

    public IlvIcon() {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = false;
        this.j = 1.0f;
        this.k = false;
        this.drawrect.x = 0.0f;
        this.drawrect.y = 0.0f;
        this.drawrect.width = 10.0f;
        this.drawrect.height = 10.0f;
        this.i = false;
        this.g = true;
        this.f = new IlvTransformer();
    }

    public IlvIcon(RenderedImage renderedImage, IlvRect ilvRect) {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = false;
        this.j = 1.0f;
        this.k = false;
        this.a(ilvRect);
        this.h = renderedImage;
        this.i = false;
        this.f = new IlvTransformer();
    }

    public IlvIcon(Image image, IlvRect ilvRect) {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = false;
        this.j = 1.0f;
        this.k = false;
        this.a(ilvRect);
        this.a = image;
        this.i = false;
        this.f = new IlvTransformer();
    }

    public IlvIcon(URL uRL, IlvRect ilvRect) {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = false;
        this.j = 1.0f;
        this.k = false;
        this.b = uRL.toString();
        this.a(ilvRect);
        this.a = Toolkit.getDefaultToolkit().getImage(uRL);
        this.i = false;
        this.f = new IlvTransformer();
    }

    public IlvIcon(String string, IlvRect ilvRect) {
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = false;
        this.j = 1.0f;
        this.k = false;
        this.setImageLocation(string);
        this.a(ilvRect);
        this.f = new IlvTransformer();
    }

    public IlvIcon(IlvIcon ilvIcon) {
        super(ilvIcon);
        this.drawrect = new IlvRect();
        this.c = null;
        this.d = false;
        this.e = false;
        this.f = null;
        this.g = false;
        this.i = false;
        this.j = 1.0f;
        this.k = false;
        this.a(ilvIcon.drawrect);
        this.f = new IlvTransformer(ilvIcon.f);
        this.a = ilvIcon.a;
        this.h = ilvIcon.h;
        this.i = false;
        this.b = ilvIcon.b;
        this.e = ilvIcon.e;
        this.setClip(ilvIcon.getClip());
        this.setAlpha(ilvIcon.getAlpha());
        this.setAutoResizing(ilvIcon.isAutoResizing());
    }

    public IlvIcon(IlvInputStream ilvInputStream) throws IlvReadFileException {
        block18: {
            super(ilvInputStream);
            this.drawrect = new IlvRect();
            this.c = null;
            this.d = false;
            this.e = false;
            this.f = null;
            this.g = false;
            this.i = false;
            this.j = 1.0f;
            this.k = false;
            this.i = false;
            try {
                IlvRect ilvRect = ilvInputStream.readRect("rectangle");
                this.a(ilvRect);
                try {
                    this.f = ilvInputStream.readTransformer("transform");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                    this.f = new IlvTransformer();
                }
                String string = ilvInputStream.readString("location");
                this.a = null;
                this.d = false;
                this.b = string;
                if (string == null) break block18;
                try {
                    if (string.startsWith("data:")) {
                        this.a = DataStreamHandler.GetImageFromData(string);
                    } else {
                        URL uRL = new URL(string);
                        this.a = Toolkit.getDefaultToolkit().getImage(uRL);
                    }
                    this.c = null;
                }
                catch (MalformedURLException malformedURLException) {
                    if (ilvInputStream.getDocumentBase() == null) break block18;
                    try {
                        URL uRL = new URL(ilvInputStream.getDocumentBase(), string);
                        this.a = Toolkit.getDefaultToolkit().getImage(uRL);
                        this.c = ilvInputStream.getDocumentBase();
                    }
                    catch (MalformedURLException malformedURLException2) {
                        this.a = Toolkit.getDefaultToolkit().getImage(this.b);
                        this.c = null;
                    }
                }
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
                // empty catch block
            }
        }
        try {
            this.e = ilvInputStream.readBoolean("quality");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setClip(ilvInputStream.readShape("clip", "clipRule"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.g = ilvInputStream.readBoolean("autoResize");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setAlpha(ilvInputStream.readFloat("alpha"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    private void a(IlvRect ilvRect) {
        this.drawrect.x = ilvRect.x;
        this.drawrect.y = ilvRect.y;
        this.drawrect.width = ilvRect.width;
        this.drawrect.height = ilvRect.height;
        if (this.drawrect.width <= 0.0f) {
            this.drawrect.width = 1.0E-20f;
        }
        if (this.drawrect.height <= 0.0f) {
            this.drawrect.height = 1.0E-20f;
        }
    }

    public IlvGraphic copy() {
        return new IlvIcon(this);
    }

    public Image getImage() {
        return this.a;
    }

    public RenderedImage getRenderedImage() {
        return this.h;
    }

    public void setRenderedImage(RenderedImage renderedImage) {
        if (this.getGraphicBag() != null) {
            m.b(this.a, this);
        }
        this.h = renderedImage;
        this.a = null;
        this.i = false;
    }

    public void setImage(Image image) {
        if (image != this.a) {
            if (this.getGraphicBag() != null) {
                m.b(this.a, this);
                this.a = image;
                m.a(this.a, this);
            } else {
                this.a = image;
            }
        }
        this.h = null;
        this.i = false;
        if (this.g) {
            this.c();
        }
    }

    public String getImageLocation() {
        return this.b;
    }

    public void setImageLocation(String string) {
        block8: {
            if (this.getGraphicBag() != null) {
                m.b(this.a, this);
            }
            if (string != null) {
                try {
                    if (string.startsWith("data:")) {
                        this.a = DataStreamHandler.GetImageFromData(string);
                        break block8;
                    }
                    URL uRL = null;
                    uRL = this.c != null ? new URL(this.c, string) : new URL(string);
                    this.a = Toolkit.getDefaultToolkit().getImage(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    this.a = Toolkit.getDefaultToolkit().getImage(string);
                }
            } else {
                this.a = null;
            }
        }
        if (this.getGraphicBag() != null) {
            m.a(this.a, this);
        }
        this.h = null;
        this.i = false;
        if (this.g) {
            this.c();
        }
        this.b = string;
    }

    public IlvTransformer getTransformer() {
        return new IlvTransformer(this.f);
    }

    public void setClip(Shape shape) {
        this.setProperty("__ClipProperty", shape);
    }

    public Shape getClip() {
        return (Shape)this.getProperty("__ClipProperty");
    }

    public void setAlpha(float f2) {
        if (f2 > 1.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0, 1.0]");
        }
        this.j = f2;
    }

    public float getAlpha() {
        return this.j;
    }

    public void setHighQualityRendering(boolean bl) {
        this.e = bl;
    }

    public boolean isHighQualityRendering() {
        return this.e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        if (image == this.a) {
            boolean bl = false;
            if ((n2 & 0x40) != 0) {
                this.a = null;
                bl = true;
            }
            if ((n2 & 0x20) != 0) {
                bl = true;
            }
            if ((n2 & 0x10) != 0) {
                this.d = true;
                bl = true;
            }
            if (bl) {
                IlvIcon ilvIcon = this;
                synchronized (ilvIcon) {
                    if (!this.k) {
                        this.k = true;
                        SwingUtilities.invokeLater(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    IlvIcon.this.reDraw();
                                }
                                catch (Throwable throwable) {
                                    if (!l) {
                                        throwable.printStackTrace();
                                    }
                                }
                                finally {
                                    IlvIcon ilvIcon = IlvIcon.this;
                                    synchronized (ilvIcon) {
                                        IlvIcon.this.k = false;
                                    }
                                }
                            }
                        });
                    }
                }
            }
            if (this.d && this.getGraphicBag() == null) {
                return false;
            }
            return (n2 & 0x60) == 0;
        }
        return false;
    }

    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        if (this.getGraphicBag() != null) {
            m.b(this.a, this);
        }
        super.setGraphicBag(ilvGraphicBag);
        if (this.getGraphicBag() != null) {
            m.a(this.a, this);
        }
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        this.d();
        Shape shape = null;
        Shape shape2 = this.getClip();
        if (shape2 != null) {
            shape = IlvGraphicUtil.AddClip(graphics, IlvGraphicUtil.CreateTransformedShape(shape2, ilvTransformer));
        }
        IlvRect ilvRect = new IlvRect(this.drawrect);
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer2.compose(ilvTransformer);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = IlvUtility2D.SetComposedAlpha(graphics2D, this.getAlpha());
        if (this.h != null) {
            IlvGraphicUtil.DrawRenderedImage(graphics, ilvRect, this.h, ilvTransformer2, this.e);
        } else if (this.a != null) {
            IlvGraphicUtil.DrawImage(graphics, ilvRect, this.a, ilvTransformer2, m.c(this.a), this.e);
        }
        if (shape2 != null) {
            graphics.setClip(shape);
        }
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
    }

    public IlvRect getDefinitionRect() {
        return new IlvRect(this.drawrect);
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(this.drawrect);
        IlvTransformer ilvTransformer2 = this.getTransformer();
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer2.compose(ilvTransformer);
        }
        return IlvGraphicUtil.RectBBox(ilvRect, ilvTransformer2);
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.getClip() != null && !IlvGraphicUtil.PointInShape(ilvPoint, this.getClip())) {
            return false;
        }
        return super.contains(ilvPoint, ilvPoint2, ilvTransformer);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.getClip() != null) {
            this.setClip(IlvGraphicUtil.CreateTransformedShape(this.getClip(), ilvTransformer));
        }
        this.f.compose(ilvTransformer);
    }

    public final void setAutoResizing(boolean bl) {
        this.g = bl;
    }

    private void c() {
        if (this.a == null) {
            return;
        }
        Dimension dimension = m.b(this.a);
        this.drawrect.width = dimension.width;
        this.drawrect.height = dimension.height;
    }

    private void d() {
        if (this.i) {
            return;
        }
        Image image = this.a;
        if (image == null && this.h instanceof Image) {
            image = (Image)((Object)this.h);
        }
        if (image == null) {
            this.i = true;
            return;
        }
        m.a(image);
        this.i = true;
    }

    public final boolean isAutoResizing() {
        return this.g;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float f2;
        super.write(ilvOutputStream);
        ilvOutputStream.write("rectangle", this.drawrect);
        ilvOutputStream.write("transform", this.f);
        String string = this.getImageLocation();
        if (string != null) {
            ilvOutputStream.write("location", this.getImageLocation());
        }
        if (this.e) {
            ilvOutputStream.write("quality", true);
        }
        if (this.getClip() != null) {
            ilvOutputStream.write("clip", "clipRule", this.getClip());
        }
        if (this.g) {
            ilvOutputStream.write("autoResize", this.g);
        }
        if ((f2 = this.getAlpha()) != 1.0f) {
            ilvOutputStream.write("alpha", f2);
        }
    }

    static class ImageHandler {
        WeakHashMap a = new WeakHashMap();

        ImageHandler() {
        }

        synchronized void a(Image image, IlvIcon ilvIcon) {
            if (image == null) {
                return;
            }
            ImageInfo imageInfo = (ImageInfo)this.a.get(image);
            if (imageInfo == null) {
                imageInfo = new ImageInfo();
                this.a.put(image, imageInfo);
                Toolkit.getDefaultToolkit().prepareImage(image, -1, -1, imageInfo);
            }
            imageInfo.a(ilvIcon);
        }

        synchronized void b(Image image, IlvIcon ilvIcon) {
            if (image == null) {
                return;
            }
            ImageInfo imageInfo = (ImageInfo)this.a.get(image);
            if (imageInfo == null) {
                return;
            }
            imageInfo.b(ilvIcon);
            if (imageInfo.a()) {
                this.a.remove(image);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void a(Image image) {
            if (image == null) {
                return;
            }
            ImageInfo imageInfo = null;
            ImageHandler imageHandler = this;
            synchronized (imageHandler) {
                imageInfo = (ImageInfo)this.a.get(image);
            }
            if (imageInfo == null) {
                return;
            }
            imageInfo.a(image);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Dimension b(Image image) {
            if (image == null) {
                return new Dimension(-1, -1);
            }
            ImageInfo imageInfo = null;
            ImageHandler imageHandler = this;
            synchronized (imageHandler) {
                imageInfo = (ImageInfo)this.a.get(image);
            }
            if (imageInfo == null) {
                imageInfo = new ImageInfo();
            }
            return imageInfo.b(image);
        }

        synchronized ImageObserver c(Image image) {
            if (image == null) {
                return null;
            }
            return (ImageInfo)this.a.get(image);
        }
    }

    static class ImageInfo
    implements ImageObserver {
        boolean a = false;
        int b = -1;
        int c = -1;
        WeakHashMap<IlvIcon, Boolean> d = new WeakHashMap();

        ImageInfo() {
        }

        synchronized void a(IlvIcon ilvIcon) {
            this.d.put(ilvIcon, Boolean.TRUE);
        }

        synchronized void b(IlvIcon ilvIcon) {
            this.d.remove(ilvIcon);
        }

        synchronized boolean a() {
            return this.d.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
            boolean bl = false;
            Object object = this;
            synchronized (object) {
                for (IlvIcon ilvIcon : this.d.keySet()) {
                    if (ilvIcon == null) continue;
                    bl |= ilvIcon.imageUpdate(image, n2, n3, n4, n5, n6);
                }
            }
            object = m;
            synchronized (object) {
                if (this.a()) {
                    m.a.remove(image);
                }
            }
            return bl;
        }

        void a(Image image) {
            if (this.a) {
                return;
            }
            if (image == null) {
                this.a = true;
                return;
            }
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!mediaTracker.isErrorID(0)) {
                this.b = image.getWidth(null);
                this.c = image.getHeight(null);
            }
            mediaTracker.removeImage(image);
            this.a = true;
        }

        Dimension b(Image image) {
            if (this.b == -1 || this.c == -1) {
                this.a = false;
                this.a(image);
            }
            return new Dimension(this.b, this.c);
        }
    }
}

