/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.awt;

import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.interactor.IlvPanInteractor;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.interactor.IlvZoomViewInteractor;
import ilog.views.ui.IlvImageButton;
import ilog.views.util.IlvImageUtil;
import ilog.views.util.IlvResourceUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IlvManagerViewControlBar
extends Panel {
    private IlvManagerView a = null;
    private InteractorCommander b = null;
    private InteractorCommander c = null;
    private InteractorCommander d = null;
    private ActionCommander e = null;
    private float f = 2.0f;
    private ActionCommander g = null;
    private float h = 2.0f;
    private ActionCommander i = null;

    public IlvManagerViewControlBar() {
        this.setLayout(new FlowLayout(3, 0, 0));
        this.a();
    }

    private void a() {
        this.b = new InteractorCommander(this.a("IlvManagerViewControlBar.pan.image"), new IlvPanInteractor(), false);
        this.add(this.b);
        this.c = new InteractorCommander(this.a("IlvManagerViewControlBar.select.image"), new IlvSelectInteractor(), false);
        this.add(this.c);
        this.d = new InteractorCommander(this.a("IlvManagerViewControlBar.zoombox.image"), new IlvZoomViewInteractor(), false);
        this.add(this.d);
        this.e = new ActionCommander(this.a("IlvManagerViewControlBar.zoom.image"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (IlvManagerViewControlBar.this.getView() == null) {
                    return;
                }
                Dimension dimension = IlvManagerViewControlBar.this.a.getSize();
                IlvPoint ilvPoint = new IlvPoint(dimension.width / 2, dimension.height / 2);
                IlvManagerViewControlBar.this.a.zoom(ilvPoint, IlvManagerViewControlBar.this.f, IlvManagerViewControlBar.this.f, true);
            }
        });
        this.add(this.e);
        this.g = new ActionCommander(this.a("IlvManagerViewControlBar.unzoom.image"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (IlvManagerViewControlBar.this.getView() == null) {
                    return;
                }
                Dimension dimension = IlvManagerViewControlBar.this.a.getSize();
                IlvPoint ilvPoint = new IlvPoint(dimension.width / 2, dimension.height / 2);
                IlvManagerViewControlBar.this.a.zoom(ilvPoint, 1.0 / (double)IlvManagerViewControlBar.this.h, 1.0 / (double)IlvManagerViewControlBar.this.h, true);
            }
        });
        this.add(this.g);
        this.i = new ActionCommander(this.a("IlvManagerViewControlBar.showall.image"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (IlvManagerViewControlBar.this.getView() == null) {
                    return;
                }
                IlvManagerViewControlBar.this.getView().fitTransformerToContent();
                IlvManagerViewControlBar.this.getView().repaint();
            }
        });
        this.add(this.i);
    }

    private String a(String string) {
        return IlvResourceUtil.getString(string, IlvManagerViewControlBar.class);
    }

    public void setPanButtonAvailable(boolean bl) {
        this.b.setVisible(bl);
    }

    public boolean isPanButtonAvailable() {
        return this.b.isVisible();
    }

    public void setPanIconURL(URL uRL) {
        this.b.setImageURL(uRL);
    }

    public URL getPanIconURL() {
        return this.b.getImageURL();
    }

    public void setPanIconImage(Image image) {
        this.b.setImage(image);
    }

    public Image getPanIconImage() {
        return this.b.getImage();
    }

    public void setPanInteractor(IlvManagerViewInteractor ilvManagerViewInteractor) {
        this.b.setInteractor(ilvManagerViewInteractor);
    }

    public IlvManagerViewInteractor getPanInteractor() {
        return this.b.getInteractor();
    }

    public void setSelectButtonAvailable(boolean bl) {
        this.c.setVisible(bl);
    }

    public boolean isSelectButtonAvailable() {
        return this.c.isVisible();
    }

    public void setSelectIconURL(URL uRL) {
        this.c.setImageURL(uRL);
    }

    public URL getSelectIconURL() {
        return this.c.getImageURL();
    }

    public void setSelectIconImage(Image image) {
        this.c.setImage(image);
    }

    public Image getSelectIconImage() {
        return this.c.getImage();
    }

    public void setSelectInteractor(IlvManagerViewInteractor ilvManagerViewInteractor) {
        this.c.setInteractor(ilvManagerViewInteractor);
    }

    public IlvManagerViewInteractor getSelectInteractor() {
        return this.c.getInteractor();
    }

    public void setZoomViewButtonAvailable(boolean bl) {
        this.d.setVisible(bl);
    }

    public boolean isZoomViewButtonAvailable() {
        return this.d.isVisible();
    }

    public void setZoomViewIconURL(URL uRL) {
        this.d.setImageURL(uRL);
    }

    public URL getZoomViewIconURL() {
        return this.d.getImageURL();
    }

    public void setZoomViewIconImage(Image image) {
        this.d.setImage(image);
    }

    public Image getZoomViewIconImage() {
        return this.d.getImage();
    }

    public void setZoomViewInteractor(IlvManagerViewInteractor ilvManagerViewInteractor) {
        this.d.setInteractor(ilvManagerViewInteractor);
    }

    public IlvManagerViewInteractor getZoomViewInteractor() {
        return this.d.getInteractor();
    }

    public void setZoomInButtonAvailable(boolean bl) {
        this.e.setVisible(bl);
    }

    public boolean isZoomInButtonAvailable() {
        return this.e.isVisible();
    }

    public void setZoomInIconURL(URL uRL) {
        this.e.setImageURL(uRL);
    }

    public URL getZoomInIconURL() {
        return this.e.getImageURL();
    }

    public void setZoomInIconImage(Image image) {
        this.e.setImage(image);
    }

    public Image getZoomInIconImage() {
        return this.e.getImage();
    }

    public void setZoomInFactor(float f2) {
        if ((double)f2 <= 1.0) {
            throw new IllegalArgumentException("ZoomIn factor must be strictly greather than 1");
        }
        this.f = f2;
    }

    public float getZoomInFactor() {
        return this.f;
    }

    public void setZoomOutButtonAvailable(boolean bl) {
        this.g.setVisible(bl);
    }

    public boolean isZoomOutButtonAvailable() {
        return this.g.isVisible();
    }

    public void setZoomOutIconURL(URL uRL) {
        this.g.setImageURL(uRL);
    }

    public URL getZoomOutIconURL() {
        return this.g.getImageURL();
    }

    public void setZoomOutIconImage(Image image) {
        this.g.setImage(image);
    }

    public Image getZoomOutIconImage() {
        return this.g.getImage();
    }

    public void setZoomOutFactor(float f2) {
        if ((double)f2 <= 1.0) {
            throw new IllegalArgumentException("ZoomOut factor must be strictly greather than 1");
        }
        this.h = f2;
    }

    public float getZoomOutFactor() {
        return this.h;
    }

    public void setFitToContentsButtonAvailable(boolean bl) {
        this.i.setVisible(bl);
    }

    public boolean isFitToContentsButtonAvailable() {
        return this.i.isVisible();
    }

    public void setFitToContentsIconURL(URL uRL) {
        this.i.setImageURL(uRL);
    }

    public URL getFitToContentsIconURL() {
        return this.i.getImageURL();
    }

    public void setFitToContentsIconImage(Image image) {
        this.i.setImage(image);
    }

    public Image getFitToContentsIconImage() {
        return this.i.getImage();
    }

    public void setView(IlvManagerView ilvManagerView) {
        Component[] componentArray = this.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Component component = componentArray[i2];
            if (component instanceof InteractorCommander) {
                ((InteractorCommander)component).setView(ilvManagerView);
                continue;
            }
            Class[] classArray = new Class[1];
            classArray[0] = IlvManagerView.class;
            Class[] classArray2 = classArray;
            Object[] objectArray = new Object[]{ilvManagerView};
            Method method = null;
            Class<?> clazz = component.getClass();
            try {
                method = clazz.getMethod("setView", classArray2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            try {
                method.invoke((Object)component, objectArray);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.a = ilvManagerView;
    }

    public IlvManagerView getView() {
        return this.a;
    }

    private class ImageCommandButton
    extends IlvImageButton {
        private int a;
        private int b;
        protected URL _imageURL;

        public ImageCommandButton() {
            super(null);
            this.a = 3;
            this.b = 3;
            this.setToggle(true);
            this.setState(false);
        }

        public void setImage(Image image) {
            super.setImage(image);
            this._imageURL = null;
        }

        public Image getImage() {
            return super.getImage();
        }

        public void setImageURL(URL uRL) {
            this._imageURL = uRL;
            if (uRL == null) {
                return;
            }
            Image image = IlvImageUtil.loadImage(uRL);
            if (image != null) {
                super.setImage(image);
            } else {
                Logger.getLogger("ilog.views.awt").log(Level.INFO, "Warning: error during read for image " + uRL);
            }
        }

        public URL getImageURL() {
            return this._imageURL;
        }

        public Dimension getMinimumSize() {
            Image image = this.getImage();
            if (image == null || !this.prepareImage(image, this)) {
                return this.getSize();
            }
            return new Dimension(image.getWidth(this) + 2 * this.a, image.getHeight(this) + 2 * this.b);
        }

        public Dimension getPreferredSize() {
            Image image = this.getImage();
            if (image == null || !this.prepareImage(image, this)) {
                return new Dimension(16, 16);
            }
            return new Dimension(image.getWidth(this) + 2 * this.a, image.getHeight(this) + 2 * this.b);
        }

        public void setMarginWidth(int n2) {
            this.a = n2;
        }

        public int getMarginWidth() {
            return this.a;
        }

        public void setMarginHeight(int n2) {
            this.b = n2;
        }

        public int getMarginHeight() {
            return this.b;
        }

        protected Image loadImage(String string) {
            try {
                Image image = IlvImageUtil.getImageFromFile(IlvManagerViewControlBar.class, string);
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForID(0);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                mediaTracker.removeImage(image, 0);
                return image;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private class ActionCommander
    extends ImageCommandButton {
        public ActionCommander(String string, ActionListener actionListener) {
            this.setImage(this.loadImage(string));
            this._imageURL = IlvManagerViewControlBar.class.getResource(string);
            this.setToggle(false);
            this.setState(false);
            this.addActionListener(actionListener);
        }
    }

    private class InteractorCommander
    extends ImageCommandButton {
        private IlvManagerViewInteractor a = null;
        private IlvManagerView b = null;
        private InteractorListener c = null;
        private boolean d;

        public InteractorCommander(String string, IlvManagerViewInteractor ilvManagerViewInteractor, boolean bl) {
            this.setImage(this.loadImage(string));
            this._imageURL = IlvManagerViewControlBar.class.getResource(string);
            this.setToggle(true);
            this.setState(false);
            this.a = ilvManagerViewInteractor;
            this.d = bl;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (InteractorCommander.this.getView() == null || InteractorCommander.this.getInteractor() == null) {
                        return;
                    }
                    if (InteractorCommander.this.getState()) {
                        InteractorCommander.this.getView().setInteractor(InteractorCommander.this.getInteractor());
                    } else if (InteractorCommander.this.b.getInteractor() == InteractorCommander.this.getInteractor()) {
                        InteractorCommander.this.b.popInteractor();
                    }
                }
            });
        }

        public IlvManagerViewInteractor getInteractor() {
            return this.a;
        }

        public void setInteractor(IlvManagerViewInteractor ilvManagerViewInteractor) {
            this.a = ilvManagerViewInteractor;
        }

        public IlvManagerView getView() {
            return this.b;
        }

        public void setView(IlvManagerView ilvManagerView) {
            if (this.b != null && this.c != null) {
                this.b.removeInteractorListener(this.c);
            }
            this.b = ilvManagerView;
            if (this.c == null) {
                this.c = new InteractorListener(){

                    public void interactorChanged(InteractorChangedEvent interactorChangedEvent) {
                        boolean bl;
                        boolean bl2 = bl = interactorChangedEvent.getNewValue() == InteractorCommander.this.getInteractor();
                        if (InteractorCommander.this.getState() != bl) {
                            InteractorCommander.this.setState(bl);
                        }
                    }
                };
            }
            if (this.b != null) {
                this.b.addInteractorListener(this.c);
            }
        }
    }
}

