/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.applications.util.wizard;

import ilog.views.applications.util.IlvApplicationsUtil;
import ilog.views.applications.util.wizard.IlvWizardPanel;
import ilog.views.util.IlvClassLoaderUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class IlvWizardUtil {
    public static final Border TABLE_BORDER = new CompoundBorder(new LineBorder(IlvApplicationsUtil.ILOG_DARK_BLUE, 1), new EmptyBorder(3, 3, 3, 3));
    public static final Color ERROR_COLOR = Color.red;
    public static final Color MSG_COLOR = Color.black;
    private static Font a;

    public static void reportException(IlvWizardPanel ilvWizardPanel, Exception exception) {
        JOptionPane.showMessageDialog(ilvWizardPanel, exception.getMessage(), IlvWizardPanel.getMessage("IlvWizardUtil_Exception_Occured"), 0);
    }

    public static JScrollPane createScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setBackground(IlvApplicationsUtil.METAL_GRAY);
        jScrollPane.setBorder(TABLE_BORDER);
        return jScrollPane;
    }

    public static JPanel createJPanel(LayoutManager layoutManager) {
        JPanel jPanel = new JPanel(layoutManager);
        jPanel.setBackground(IlvApplicationsUtil.WIZARD_DEFAULT_BACKGROUND);
        return jPanel;
    }

    public static JTextComponent createMessagePanel() {
        JTextArea jTextArea = new JTextArea(){

            public void setForeground(Color color) {
                super.setForeground(color);
                this.setDisabledTextColor(color);
            }
        };
        jTextArea.setEditable(false);
        if (a == null) {
            a = Font.decode(IlvWizardPanel.getMessage("IlvWizardUtil.msg.font"));
        }
        jTextArea.setFont(a);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(TABLE_BORDER);
        jTextArea.setEnabled(false);
        return jTextArea;
    }

    public static JLabel createJLabel(String string) {
        JLabel jLabel = new JLabel(IlvWizardPanel.getMessage(string));
        jLabel.setBackground(IlvApplicationsUtil.WIZARD_DEFAULT_BACKGROUND);
        jLabel.setOpaque(true);
        jLabel.setHorizontalAlignment(10);
        return jLabel;
    }

    public static JTable createJTable(TableModel tableModel) {
        JTable jTable = new JTable(tableModel);
        IlvWizardUtil.initTable(jTable);
        return jTable;
    }

    public static void initTable(JTable jTable) {
        JLabel jLabel = (JLabel)((Object)jTable.getTableHeader().getDefaultRenderer());
        jLabel.setHorizontalAlignment(0);
        jTable.setBackground(IlvApplicationsUtil.METAL_GRAY);
    }

    public static JRadioButton createJRadioButton(String string) {
        JRadioButton jRadioButton = new JRadioButton(IlvWizardPanel.getMessage(string));
        jRadioButton.setBackground(IlvApplicationsUtil.WIZARD_DEFAULT_BACKGROUND);
        jRadioButton.setOpaque(false);
        return jRadioButton;
    }

    public static URL getResourceFromPackage(Class clazz, String string) {
        String string2 = clazz.getPackage().getName().replace('.', '/');
        String string3 = string2 + "/" + string;
        return IlvClassLoaderUtil.getResource(clazz, string3);
    }

    public static class EmptyTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            return 20;
        }

        public int getColumnCount() {
            return 4;
        }

        public Object getValueAt(int n2, int n3) {
            return "";
        }
    }
}

