/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.io.Serializable;

public final class IlvQuadtree
implements Serializable {
    private static String a = "Copyright (C) 1996-2001 by ILOG.All Rights Reserved.DECOMPILATION OR ALTERATION OF THE PRESENT CODE IS ILLEGAL. ILOG is the author of and owns this byte-code. Its source code is a trade secret of ILOG. Contact info@ilog.com for more details.";
    private IlvQuadtree b;
    private IlvQuadtree c;
    private IlvQuadtree d;
    private IlvQuadtree e;
    private IlvGraphic[] f;
    private int g;
    private boolean h;
    private int i = 30;
    private double j;
    private double k;
    private double l;
    private double m;
    private IlvRect n;
    private boolean o;
    private IlvQuadtree p;
    private static final int q = 1;
    private static final int r = 2;
    private static final int s = 4;
    private static final int t = 8;
    private static final int u = 5;
    private static final int v = 6;
    private static final int w = 9;
    private static final int x = 10;
    private static final int y = 65535;
    static final double z = 1.0E-5;
    private static boolean aa = true;
    private static final double ab = 10000.0;

    IlvQuadtree(int n2) {
        this.i = n2;
        this.j = -10000.0;
        this.k = -10000.0;
        this.l = 20000.0;
        this.m = 20000.0;
    }

    private IlvQuadtree(IlvQuadtree ilvQuadtree, int n2) {
        this(n2);
        this.p = ilvQuadtree;
    }

    private IlvQuadtree(IlvQuadtree ilvQuadtree, int n2, double d2, double d3, double d4, double d5) {
        this.i = n2;
        this.j = d2;
        this.k = d3;
        this.l = d4;
        this.m = d5;
        this.p = ilvQuadtree;
    }

    private IlvQuadtree(IlvQuadtree ilvQuadtree) {
        this.b = ilvQuadtree.b;
        this.c = ilvQuadtree.c;
        this.d = ilvQuadtree.d;
        this.e = ilvQuadtree.e;
        if (this.b != null) {
            this.b.p = this;
        }
        if (this.c != null) {
            this.c.p = this;
        }
        if (this.d != null) {
            this.d.p = this;
        }
        if (this.e != null) {
            this.e.p = this;
        }
        this.f = ilvQuadtree.f;
        this.g = ilvQuadtree.g;
        this.h = ilvQuadtree.h;
        this.i = ilvQuadtree.i;
        this.j = ilvQuadtree.j;
        this.k = ilvQuadtree.k;
        this.l = ilvQuadtree.l;
        this.m = ilvQuadtree.m;
        this.o = false;
        this.n = null;
        this.p = ilvQuadtree;
    }

    private IlvQuadtree d() {
        return this.p;
    }

    public static boolean isOptimizeMode() {
        return aa;
    }

    public static void setOptimizeMode(boolean bl) {
        aa = bl;
    }

    void a(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        if (ilvRect == null) {
            ilvRect = ilvGraphic.boundingBox(null);
        }
        if (!aa) {
            if (Float.isNaN(ilvRect.x) || Float.isInfinite(ilvRect.x) || Float.isNaN(ilvRect.y) || Float.isInfinite(ilvRect.y) || Float.isNaN(ilvRect.width) || Float.isInfinite(ilvRect.width) || Float.isNaN(ilvRect.height) || Float.isInfinite(ilvRect.height)) {
                throw new RuntimeException("IlvQuadtree.add: " + ilvGraphic + " Invalid coordinates, obj.bbox=" + ilvRect);
            }
            if (this.p != null) {
                throw new RuntimeException("IlvQuadtree.add: " + ilvGraphic + " Call not allowed for non-root cells");
            }
            if (this.b(ilvGraphic, ilvRect) != null) {
                throw new RuntimeException("IlvQuadtree.add: " + ilvGraphic + " Already in quadtree");
            }
        }
        if (!this.c(ilvRect)) {
            if (this.h) {
                this.b(ilvRect);
            } else {
                this.f(ilvRect);
            }
        }
        this.c(ilvGraphic, ilvRect);
        if (!aa) {
            IlvQuadtree ilvQuadtree = ilvGraphic.h();
            if (ilvQuadtree == null) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer cannot be null after update");
            }
            if (!ilvQuadtree.c(ilvGraphic)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer cell does not contain the object");
            }
        }
    }

    private void c(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        if (!aa && !this.c(ilvRect)) {
            String string = null;
            if (this == this.p.c) {
                string = "top right";
            } else if (this == this.p.b) {
                string = "top left";
            } else if (this == this.p.e) {
                string = "bottom right";
            } else if (this == this.p.d) {
                string = "bottom left";
            }
            throw new RuntimeException("IlvQuadtree.nodeAdd: " + ilvGraphic + " Not contained in cell bounds " + new IlvRect((float)this.j, (float)this.k, (float)this.l, (float)this.m) + " parent:" + this.p + " position:" + string);
        }
        if (this.h) {
            this.d(ilvGraphic, ilvRect);
        } else if (this.l > 1.0E-5 && this.m > 1.0E-5 && this.g >= this.i - 1) {
            if (this.g == this.i - 1) {
                IlvGraphic[] ilvGraphicArray = this.f;
                int n2 = this.g;
                this.e();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.d(ilvGraphicArray[i2], ilvGraphicArray[i2].boundingBox(null));
                }
            }
            this.d(ilvGraphic, ilvRect);
        } else {
            this.b(ilvGraphic);
        }
    }

    private void e() {
        this.g = 0;
        this.f = null;
    }

    private void d(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        switch (this.a(ilvRect)) {
            case 6: {
                if (this.b == null) {
                    this.b = new IlvQuadtree(this, this.i, this.j, this.k, this.l / 2.0, this.m / 2.0);
                    this.h = true;
                }
                this.b.c(ilvGraphic, ilvRect);
                break;
            }
            case 5: {
                if (this.c == null) {
                    this.c = new IlvQuadtree(this, this.i, this.j + this.l / 2.0, this.k, this.l / 2.0, this.m / 2.0);
                    this.h = true;
                }
                this.c.c(ilvGraphic, ilvRect);
                break;
            }
            case 10: {
                if (this.d == null) {
                    this.d = new IlvQuadtree(this, this.i, this.j, this.k + this.m / 2.0, this.l / 2.0, this.m / 2.0);
                    this.h = true;
                }
                this.d.c(ilvGraphic, ilvRect);
                break;
            }
            case 9: {
                if (this.e == null) {
                    this.e = new IlvQuadtree(this, this.i, this.j + this.l / 2.0, this.k + this.m / 2.0, this.l / 2.0, this.m / 2.0);
                    this.h = true;
                }
                this.e.c(ilvGraphic, ilvRect);
                break;
            }
            case 65535: {
                this.b(ilvGraphic);
            }
        }
    }

    void a(IlvGraphic ilvGraphic, IlvQuadtree ilvQuadtree, IlvRect ilvRect) {
        this.o = false;
        if (ilvRect == null) {
            ilvRect = ilvGraphic.boundingBox(null);
        }
        if (!aa) {
            if (Float.isNaN(ilvRect.x) || Float.isInfinite(ilvRect.x) || Float.isNaN(ilvRect.y) || Float.isInfinite(ilvRect.y) || Float.isNaN(ilvRect.width) || Float.isInfinite(ilvRect.width) || Float.isNaN(ilvRect.height) || Float.isInfinite(ilvRect.height)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Invalid coordinates, obj.bbox=" + ilvRect);
            }
            if (ilvQuadtree == null) {
                throw new IllegalArgumentException("IlvQuadtree.update: " + ilvGraphic + " [" + ilvRect + "] " + " Root quadtree cell cannot be null");
            }
            if (ilvGraphic.h() != this) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer points to a different cell");
            }
            if (this.p == null && this != ilvQuadtree) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Cell with null parent must be the root");
            }
            if (!this.c(ilvGraphic)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Not stored in this quadtree cell");
            }
        }
        if (this.c(ilvRect)) {
            this.e(ilvGraphic, ilvRect);
        } else if (this.p == null) {
            if (this.h) {
                if (!this.a(ilvGraphic, false)) {
                    throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Cannot remove from divided root cell of quadtree");
                }
                this.b(ilvRect);
                this.c(ilvGraphic, ilvRect);
            } else if (this.g >= this.i) {
                if (!this.a(ilvGraphic, false)) {
                    throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Cannot remove from non divided root cell of quadtree");
                }
                this.a(ilvGraphic, ilvRect);
            } else {
                this.f(ilvRect);
            }
        } else {
            if (!this.a(ilvGraphic, false)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Cannot remove from quadtree");
            }
            if (this.p.c(ilvRect)) {
                this.b(false);
                this.p.c(ilvGraphic, ilvRect);
            } else {
                this.b(true);
                ilvQuadtree.a(ilvGraphic, ilvRect);
            }
        }
        if (!aa) {
            IlvQuadtree ilvQuadtree2 = ilvGraphic.h();
            if (ilvQuadtree2 == null) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer cannot be null after update");
            }
            if (!ilvQuadtree2.c(ilvGraphic)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Backpointer cell does not contain the object");
            }
            if (!ilvQuadtree2.c(ilvRect)) {
                throw new RuntimeException("IlvQuadtree.update: " + ilvGraphic + " Bounds of backpointer cell does not contain the object");
            }
        }
    }

    boolean a(IlvGraphic ilvGraphic) {
        if (!aa && !this.c(ilvGraphic)) {
            throw new RuntimeException("IlvQuadtree.remove: " + ilvGraphic + " Not stored in this quadtree cell");
        }
        return this.a(ilvGraphic, true);
    }

    private boolean a(IlvGraphic ilvGraphic, boolean bl) {
        ilvGraphic.a((IlvQuadtree)null);
        if (this.f == null) {
            return false;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.g; ++i2) {
            if (ilvGraphic != this.f[i2]) continue;
            n2 = this.g - i2 - 1;
            if (n2 > 0) {
                System.arraycopy(this.f, i2 + 1, this.f, i2, n2);
            }
            --this.g;
            this.f[this.g] = null;
            this.o = false;
            if (bl) {
                this.b(true);
            }
            return true;
        }
        return false;
    }

    private void b(boolean bl) {
        if (this.g == 0 && !this.h && this.p != null) {
            if (this == this.p.b) {
                this.p.b = null;
            } else if (this == this.p.d) {
                this.p.d = null;
            } else if (this == this.p.c) {
                this.p.c = null;
            } else {
                this.p.e = null;
            }
            if (this.p.b == null && this.p.c == null && this.p.d == null && this.p.e == null) {
                this.p.h = false;
                if (bl) {
                    this.p.b(true);
                }
            }
        }
    }

    void a() {
        this.f = null;
        this.g = 0;
        this.o = false;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.p = null;
        this.h = false;
    }

    private void e(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        if (!this.h && (this.g < this.i || Math.min(this.l, this.m) <= 1.0E-5)) {
            this.o = false;
        } else {
            switch (this.a(ilvRect)) {
                case 6: {
                    this.a(ilvGraphic, false);
                    if (this.b == null) {
                        this.b = new IlvQuadtree(this, this.i);
                        this.b.j = this.j;
                        this.b.k = this.k;
                        this.b.l = this.l / 2.0;
                        this.b.m = this.m / 2.0;
                        this.h = true;
                    }
                    this.b.c(ilvGraphic, ilvRect);
                    break;
                }
                case 5: {
                    this.a(ilvGraphic, false);
                    if (this.c == null) {
                        this.c = new IlvQuadtree(this, this.i);
                        this.c.j = this.j + this.l / 2.0;
                        this.c.k = this.k;
                        this.c.l = this.j + this.l - this.c.j;
                        this.c.m = this.m / 2.0;
                        this.h = true;
                    }
                    this.c.c(ilvGraphic, ilvRect);
                    break;
                }
                case 10: {
                    this.a(ilvGraphic, false);
                    if (this.d == null) {
                        this.d = new IlvQuadtree(this, this.i);
                        this.d.j = this.j;
                        this.d.k = this.k + this.m / 2.0;
                        this.d.l = this.l / 2.0;
                        this.d.m = this.k + this.m - this.d.k;
                        this.h = true;
                    }
                    this.d.c(ilvGraphic, ilvRect);
                    break;
                }
                case 9: {
                    this.a(ilvGraphic, false);
                    if (this.e == null) {
                        this.e = new IlvQuadtree(this, this.i);
                        this.e.j = this.j + this.l / 2.0;
                        this.e.k = this.k + this.m / 2.0;
                        this.e.l = this.j + this.l - this.e.j;
                        this.e.m = this.k + this.m - this.e.k;
                        this.h = true;
                    }
                    this.e.c(ilvGraphic, ilvRect);
                    break;
                }
                case 65535: {
                    this.o = false;
                }
            }
        }
    }

    private int a(IlvRect ilvRect) {
        double d2;
        double d3;
        if (this.l <= 1.0E-5 || this.m <= 1.0E-5) {
            return 65535;
        }
        double d4 = ilvRect.x;
        double d5 = this.j + this.l / 2.0;
        int n2 = 1;
        if (d4 < d5) {
            if (d4 + (double)ilvRect.width <= d5) {
                n2 = 2;
            } else {
                return 65535;
            }
        }
        return (d3 = (double)ilvRect.y) >= (d2 = this.k + this.m / 2.0) ? n2 | 8 : (d3 + (double)ilvRect.height <= d2 ? n2 | 4 : 65535);
    }

    private int a(IlvPoint ilvPoint) {
        if (this.l <= 1.0E-5 || this.m <= 1.0E-5) {
            return 65535;
        }
        if ((double)ilvPoint.x >= this.j + this.l / 2.0) {
            if ((double)ilvPoint.y >= this.k + this.m / 2.0) {
                return 9;
            }
            return 5;
        }
        if ((double)ilvPoint.y >= this.k + this.m / 2.0) {
            return 10;
        }
        return 6;
    }

    private void a(float f2, float f3) {
        if (this.b(f2, f3)) {
            return;
        }
        IlvGraphic[] ilvGraphicArray = this.f;
        int n2 = this.g;
        this.f = null;
        this.o = false;
        this.g = 0;
        boolean bl = true;
        switch ((this.j >= (double)f2 ? 2 : 1) | (this.k >= (double)f3 ? 4 : 8)) {
            case 10: {
                do {
                    IlvQuadtree ilvQuadtree = new IlvQuadtree(this);
                    if (bl) {
                        bl = false;
                        ilvQuadtree.f = ilvGraphicArray;
                        ilvQuadtree.g = n2;
                        this.a(ilvGraphicArray, n2, ilvQuadtree);
                    } else {
                        ilvQuadtree.f = null;
                        ilvQuadtree.g = 0;
                    }
                    ilvQuadtree.j = this.j;
                    ilvQuadtree.k = this.k;
                    ilvQuadtree.l = this.l;
                    ilvQuadtree.m = this.m;
                    this.j -= this.l;
                    this.l = 2.0 * this.l;
                    this.m = 2.0 * this.m;
                    this.c = ilvQuadtree;
                    this.b = null;
                    this.d = null;
                    this.e = null;
                } while (!this.b(f2, f3));
                break;
            }
            case 9: {
                do {
                    IlvQuadtree ilvQuadtree = new IlvQuadtree(this);
                    if (bl) {
                        bl = false;
                        ilvQuadtree.f = ilvGraphicArray;
                        ilvQuadtree.g = n2;
                        this.a(ilvGraphicArray, n2, ilvQuadtree);
                    } else {
                        ilvQuadtree.f = null;
                        ilvQuadtree.g = 0;
                    }
                    ilvQuadtree.j = this.j;
                    ilvQuadtree.k = this.k;
                    ilvQuadtree.l = this.l;
                    ilvQuadtree.m = this.m;
                    this.l = 2.0 * this.l;
                    this.m = 2.0 * this.m;
                    this.b = ilvQuadtree;
                    this.c = null;
                    this.d = null;
                    this.e = null;
                } while (!this.b(f2, f3));
                break;
            }
            case 6: {
                do {
                    IlvQuadtree ilvQuadtree = new IlvQuadtree(this);
                    if (bl) {
                        bl = false;
                        ilvQuadtree.f = ilvGraphicArray;
                        ilvQuadtree.g = n2;
                        this.a(ilvGraphicArray, n2, ilvQuadtree);
                    } else {
                        ilvQuadtree.f = null;
                        ilvQuadtree.g = 0;
                    }
                    ilvQuadtree.j = this.j;
                    ilvQuadtree.k = this.k;
                    ilvQuadtree.l = this.l;
                    ilvQuadtree.m = this.m;
                    this.j += -this.l;
                    this.k += -this.m;
                    this.l = 2.0 * this.l;
                    this.m = 2.0 * this.m;
                    this.e = ilvQuadtree;
                    this.b = null;
                    this.c = null;
                    this.d = null;
                } while (!this.b(f2, f3));
                break;
            }
            case 5: {
                do {
                    IlvQuadtree ilvQuadtree = new IlvQuadtree(this);
                    if (bl) {
                        bl = false;
                        ilvQuadtree.f = ilvGraphicArray;
                        ilvQuadtree.g = n2;
                        this.a(ilvGraphicArray, n2, ilvQuadtree);
                    } else {
                        ilvQuadtree.f = null;
                        ilvQuadtree.g = 0;
                    }
                    ilvQuadtree.j = this.j;
                    ilvQuadtree.k = this.k;
                    ilvQuadtree.l = this.l;
                    ilvQuadtree.m = this.m;
                    this.k -= this.m;
                    this.l = 2.0 * this.l;
                    this.m = 2.0 * this.m;
                    this.d = ilvQuadtree;
                    this.b = null;
                    this.c = null;
                    this.e = null;
                } while (!this.b(f2, f3));
            }
        }
        this.h = true;
        this.f = null;
        this.o = false;
        this.g = 0;
    }

    private void a(IlvGraphic[] ilvGraphicArray, int n2, IlvQuadtree ilvQuadtree) {
        if (ilvGraphicArray != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ilvGraphicArray[i2].a(ilvQuadtree);
            }
        }
    }

    private void b(IlvRect ilvRect) {
        this.a(ilvRect.x, ilvRect.y);
        this.a(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height);
    }

    IlvQuadtree b(IlvGraphic ilvGraphic, IlvRect ilvRect) {
        if (!this.e(ilvRect)) {
            return null;
        }
        if (!this.h) {
            return this.c(ilvGraphic) ? this : null;
        }
        switch (this.a(ilvRect)) {
            case 6: {
                return this.b != null ? this.b.b(ilvGraphic, ilvRect) : null;
            }
            case 5: {
                return this.c != null ? this.c.b(ilvGraphic, ilvRect) : null;
            }
            case 10: {
                return this.d != null ? this.d.b(ilvGraphic, ilvRect) : null;
            }
            case 9: {
                return this.e != null ? this.e.b(ilvGraphic, ilvRect) : null;
            }
            case 65535: {
                return this.c(ilvGraphic) ? this : null;
            }
        }
        return null;
    }

    private void a(int n2) {
        if (this.f == null) {
            this.f = new IlvGraphic[Math.max(this.i, n2)];
        } else {
            int n3 = this.f.length;
            if (n2 > n3) {
                IlvGraphic[] ilvGraphicArray = this.f;
                int n4 = n3 * 2;
                if (n4 < n2) {
                    n4 = n2;
                }
                this.f = new IlvGraphic[n4];
                System.arraycopy(ilvGraphicArray, 0, this.f, 0, this.g);
            }
        }
    }

    private void b(IlvGraphic ilvGraphic) {
        this.a(this.g + 1);
        this.f[this.g++] = ilvGraphic;
        ilvGraphic.a(this);
        this.o = false;
    }

    private boolean c(IlvGraphic ilvGraphic) {
        if (this.f == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.g; ++i2) {
            if (ilvGraphic != this.f[i2]) continue;
            return true;
        }
        return false;
    }

    private boolean c(IlvRect ilvRect) {
        return (double)ilvRect.x >= this.j && (double)ilvRect.y >= this.k && (double)(ilvRect.x + ilvRect.width) <= this.j + this.l && (double)(ilvRect.y + ilvRect.height) <= this.k + this.m;
    }

    private boolean d(IlvRect ilvRect) {
        return this.j >= (double)ilvRect.x && this.j + this.l <= (double)(ilvRect.x + ilvRect.width) && this.k >= (double)ilvRect.y && this.k + this.m <= (double)(ilvRect.y + ilvRect.height);
    }

    private boolean b(float f2, float f3) {
        return (double)f2 >= this.j && (double)f2 <= this.j + this.l && (double)f3 >= this.k && (double)f3 <= this.k + this.m;
    }

    private boolean e(IlvRect ilvRect) {
        return this.j <= (double)(ilvRect.x + ilvRect.width) && this.j + this.l >= (double)ilvRect.x && this.k <= (double)(ilvRect.y + ilvRect.height) && this.k + this.m >= (double)ilvRect.y;
    }

    private void f(IlvRect ilvRect) {
        if (ilvRect.width == 0.0f || ilvRect.height == 0.0f) {
            return;
        }
        double d2 = Math.min(this.j, (double)ilvRect.x);
        double d3 = Math.max(this.j + this.l, (double)(ilvRect.x + ilvRect.width));
        double d4 = Math.min(this.k, (double)ilvRect.y);
        double d5 = Math.max(this.k + this.m, (double)(ilvRect.y + ilvRect.height));
        this.j = d2;
        this.k = d4;
        this.l = d3 - d2;
        this.m = d5 - d4;
    }

    void b() {
        this.o = false;
    }

    IlvRect c() {
        return this.g(null);
    }

    private IlvRect g(IlvRect ilvRect) {
        if (ilvRect != null && this.j > (double)ilvRect.x && this.k > (double)ilvRect.y && this.j + this.l < (double)(ilvRect.x + ilvRect.width) && this.k + this.m < (double)(ilvRect.y + ilvRect.height)) {
            return ilvRect;
        }
        if (!this.o) {
            this.n = null;
            for (int i2 = 0; i2 < this.g; ++i2) {
                IlvGraphic ilvGraphic = this.f[i2];
                if (!ilvGraphic.zoomable() || !ilvGraphic.isVisible()) continue;
                IlvRect ilvRect2 = ilvGraphic.boundingBox(null);
                if (this.n == null) {
                    this.n = ilvRect2;
                    continue;
                }
                this.n.add(ilvRect2);
            }
            this.o = true;
        }
        if (this.n != null) {
            if (ilvRect == null) {
                ilvRect = new IlvRect(this.n);
            } else {
                ilvRect.add(this.n);
            }
        }
        if (this.b != null) {
            ilvRect = this.b.g(ilvRect);
        }
        if (this.c != null) {
            ilvRect = this.c.g(ilvRect);
        }
        if (this.d != null) {
            ilvRect = this.d.g(ilvRect);
        }
        if (this.e != null) {
            ilvRect = this.e.g(ilvRect);
        }
        return ilvRect;
    }

    void a(IlvApplyObject ilvApplyObject, Object object) {
        for (int i2 = 0; i2 < this.g; ++i2) {
            ilvApplyObject.apply(this.f[i2], object);
        }
        if (this.b != null) {
            this.b.a(ilvApplyObject, object);
        }
        if (this.c != null) {
            this.c.a(ilvApplyObject, object);
        }
        if (this.d != null) {
            this.d.a(ilvApplyObject, object);
        }
        if (this.e != null) {
            this.e.a(ilvApplyObject, object);
        }
    }

    void b(IlvApplyObject ilvApplyObject, Object object) {
        for (int i2 = 0; i2 < this.g; ++i2) {
            IlvGraphic ilvGraphic = this.f[i2];
            if (!ilvGraphic.zoomable()) continue;
            ilvApplyObject.apply(ilvGraphic, object);
        }
        if (this.b != null) {
            this.b.b(ilvApplyObject, object);
        }
        if (this.c != null) {
            this.c.b(ilvApplyObject, object);
        }
        if (this.d != null) {
            this.d.b(ilvApplyObject, object);
        }
        if (this.e != null) {
            this.e.b(ilvApplyObject, object);
        }
    }

    void a(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, IlvTransformer ilvTransformer) {
        if (this.d(ilvRect)) {
            this.a(ilvApplyObject, object);
        } else if (this.e(ilvRect)) {
            for (int i2 = 0; i2 < this.g; ++i2) {
                IlvGraphic ilvGraphic = this.f[i2];
                if (!ilvGraphic.inside(ilvRect, ilvRect2, ilvTransformer)) continue;
                ilvApplyObject.apply(ilvGraphic, object);
            }
            if (this.b != null) {
                this.b.a(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.c != null) {
                this.c.a(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.d != null) {
                this.d.a(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.e != null) {
                this.e.a(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
        }
    }

    void b(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, IlvTransformer ilvTransformer) {
        if (this.d(ilvRect)) {
            this.b(ilvApplyObject, object);
        } else if (this.e(ilvRect)) {
            for (int i2 = 0; i2 < this.g; ++i2) {
                IlvGraphic ilvGraphic = this.f[i2];
                if (!ilvGraphic.zoomable() || !ilvGraphic.inside(ilvRect, ilvRect2, ilvTransformer)) continue;
                ilvApplyObject.apply(ilvGraphic, object);
            }
            if (this.b != null) {
                this.b.b(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.c != null) {
                this.c.b(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.d != null) {
                this.d.b(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.e != null) {
                this.e.b(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
        }
    }

    void c(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, IlvTransformer ilvTransformer) {
        if (this.d(ilvRect)) {
            this.a(ilvApplyObject, object);
        } else if (this.e(ilvRect)) {
            for (int i2 = 0; i2 < this.g; ++i2) {
                IlvGraphic ilvGraphic = this.f[i2];
                if (!ilvGraphic.intersects(ilvRect, ilvRect2, ilvTransformer)) continue;
                ilvApplyObject.apply(ilvGraphic, object);
            }
            if (this.b != null) {
                this.b.c(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.c != null) {
                this.c.c(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.d != null) {
                this.d.c(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.e != null) {
                this.e.c(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
        }
    }

    void d(IlvRect ilvRect, IlvRect ilvRect2, IlvApplyObject ilvApplyObject, Object object, IlvTransformer ilvTransformer) {
        if (this.d(ilvRect)) {
            this.b(ilvApplyObject, object);
        } else if (this.e(ilvRect)) {
            for (int i2 = 0; i2 < this.g; ++i2) {
                IlvGraphic ilvGraphic = this.f[i2];
                if (!ilvGraphic.zoomable() || !ilvGraphic.intersects(ilvRect, ilvRect2, ilvTransformer)) continue;
                ilvApplyObject.apply(ilvGraphic, object);
            }
            if (this.b != null) {
                this.b.d(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.c != null) {
                this.c.d(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.d != null) {
                this.d.d(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
            if (this.e != null) {
                this.e.d(ilvRect, ilvRect2, ilvApplyObject, object, ilvTransformer);
            }
        }
    }

    private IlvQuadtree b(int n2) {
        switch (n2) {
            case 5: {
                return this.c;
            }
            case 6: {
                return this.b;
            }
            case 9: {
                return this.e;
            }
            case 10: {
                return this.d;
            }
        }
        return null;
    }

    IlvGraphic a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic;
        IlvQuadtree ilvQuadtree;
        if (!this.b(ilvPoint.x, ilvPoint.y)) {
            return null;
        }
        if (this.h && (ilvQuadtree = this.b(this.a(ilvPoint))) != null && (ilvGraphic = ilvQuadtree.a(ilvPoint, ilvPoint2, ilvTransformer)) != null) {
            return ilvGraphic;
        }
        if (this.f != null && this.g != 0) {
            for (int i2 = this.g - 1; i2 >= 0; --i2) {
                ilvGraphic = this.f[i2];
                if (!ilvGraphic.isVisible() || !ilvGraphic.zoomable() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
                return ilvGraphic;
            }
        }
        return null;
    }

    IlvGraphic b(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic;
        IlvQuadtree ilvQuadtree;
        if (!this.b(ilvPoint.x, ilvPoint.y)) {
            return null;
        }
        if (this.h && (ilvQuadtree = this.b(this.a(ilvPoint))) != null && (ilvGraphic = ilvQuadtree.b(ilvPoint, ilvPoint2, ilvTransformer)) != null) {
            return ilvGraphic;
        }
        if (this.f != null && this.g != 0) {
            for (int i2 = this.g - 1; i2 >= 0; --i2) {
                ilvGraphic = this.f[i2];
                if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
                return ilvGraphic;
            }
        }
        return null;
    }

    void a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvGraphicVector ilvGraphicVector) {
        IlvQuadtree ilvQuadtree;
        if (!this.b(ilvPoint.x, ilvPoint.y)) {
            return;
        }
        if (this.h && (ilvQuadtree = this.b(this.a(ilvPoint))) != null) {
            ilvQuadtree.a(ilvPoint, ilvPoint2, ilvTransformer, ilvGraphicVector);
        }
        if (this.f != null && this.g != 0) {
            for (int i2 = this.g - 1; i2 >= 0; --i2) {
                IlvGraphic ilvGraphic = this.f[i2];
                if (!ilvGraphic.isVisible() || !ilvGraphic.zoomable() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
                ilvGraphicVector.addElement(ilvGraphic);
            }
        }
    }

    void b(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvGraphicVector ilvGraphicVector) {
        IlvQuadtree ilvQuadtree;
        if (!this.b(ilvPoint.x, ilvPoint.y)) {
            return;
        }
        if (this.h && (ilvQuadtree = this.b(this.a(ilvPoint))) != null) {
            ilvQuadtree.b(ilvPoint, ilvPoint2, ilvTransformer, ilvGraphicVector);
        }
        if (this.f != null && this.g != 0) {
            for (int i2 = this.g - 1; i2 >= 0; --i2) {
                IlvGraphic ilvGraphic = this.f[i2];
                if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
                ilvGraphicVector.addElement(ilvGraphic);
            }
        }
    }

    final int a(boolean bl) {
        int n2 = this.g;
        IlvRect ilvRect = new IlvRect((float)this.j, (float)this.k, (float)this.l, (float)this.m);
        if (bl) {
            System.out.print("** Cell " + this + " bounds: " + ilvRect);
            System.out.println(" " + this.g + " elements" + (!this.h ? " (leave)" : ""));
        }
        if (this.f == null && this.g != 0) {
            throw new RuntimeException("_elements is null and _count != 0");
        }
        if (this.f != null && this.f.length < this.g) {
            throw new RuntimeException("_elements.length (" + this.f.length + ") < _count (" + this.g + ")");
        }
        if (this.f != null) {
            IlvGraphic ilvGraphic = null;
            IlvQuadtree ilvQuadtree = null;
            boolean bl2 = Math.min(this.l, this.m) > 1.0E-5 && (this.g >= this.i || this.h);
            for (int i2 = 0; i2 < this.g; ++i2) {
                IlvRect ilvRect2;
                ilvGraphic = this.f[i2];
                ilvQuadtree = ilvGraphic.h();
                if (ilvQuadtree == null) {
                    throw new RuntimeException("null backpointer");
                }
                if (ilvQuadtree != this) {
                    System.out.println("obj " + ilvGraphic);
                    if (ilvGraphic.getName() != null) {
                        System.out.println("name = " + ilvGraphic.getName());
                    }
                    System.out.println("has backpointer to cell " + ilvQuadtree);
                    ilvRect2 = new IlvRect((float)ilvQuadtree.j, (float)ilvQuadtree.k, (float)ilvQuadtree.l, (float)ilvQuadtree.m);
                    System.out.println("    (bounds = " + ilvRect2 + ")");
                    System.out.println("and is in cell " + this);
                    System.out.println("    (bounds = " + ilvRect + ")");
                    throw new RuntimeException("backpointer to a different cell");
                }
                ilvRect2 = ilvGraphic.boundingBox(null);
                if (!ilvRect.contains(ilvRect2)) {
                    int n3 = 50;
                    boolean bl3 = false;
                    float f2 = 0.0f;
                    float f3 = ilvRect.x - ilvRect2.x;
                    f2 = Math.max(f2, f3 / ilvRect2.width);
                    if (f3 > 0.0f) {
                        float f4 = n3 != 0 ? ilvRect2.width / (float)n3 : 0.0f;
                        if (f3 > f4) {
                            bl3 = true;
                        }
                    }
                    f3 = ilvRect.y - ilvRect2.y;
                    f2 = Math.max(f2, f3 / ilvRect2.height);
                    if (f3 > 0.0f) {
                        float f5 = n3 != 0 ? ilvRect2.height / (float)n3 : 0.0f;
                        if (f3 > f5) {
                            bl3 = true;
                        }
                    }
                    f3 = ilvRect2.x + ilvRect2.width - ilvRect.x - ilvRect.width;
                    f2 = Math.max(f2, f3 / ilvRect2.width);
                    if (f3 > 0.0f) {
                        float f6 = n3 != 0 ? ilvRect2.width / (float)n3 : 0.0f;
                        if (f3 > f6) {
                            bl3 = true;
                        }
                    }
                    f3 = ilvRect2.y + ilvRect2.height - ilvRect.y - ilvRect.height;
                    f2 = Math.max(f2, f3 / ilvRect2.height);
                    if (f3 > 0.0f) {
                        float f7 = n3 != 0 ? ilvRect2.height / (float)n3 : 0.0f;
                        if (f3 > f7) {
                            bl3 = true;
                        }
                    }
                    if (bl3) {
                        throw new RuntimeException("Object " + ilvGraphic + " not contained in the bounds of its " + "quadtree cell = " + ilvRect + " maxError = " + f2 * 100.0f + " %");
                    }
                }
                if (!bl2 || this.a(ilvRect2) == 65535) continue;
                System.out.println("******** _count: " + this.g);
                System.out.println(" i = " + i2);
                System.out.println("obj = " + this.f[i2]);
                System.out.println(" Subcells: " + (this.b == null ? "null" : "TOP_L") + " " + (this.c == null ? "null" : "TOP_R") + " " + (this.d == null ? "null" : "BOTTOM_L") + " " + (this.e == null ? "null" : "BOTTOM_R"));
                System.out.println("_divided: " + this.h);
                System.out.println("bounds: " + new IlvRect((float)this.j, (float)this.k, (float)this.l, (float)this.m));
                if (this.p == null) {
                    System.out.println("(top root cell)");
                }
                String string = ilvGraphic instanceof IlvLinkImage ? "link" : "node";
                String string2 = null;
                switch (this.a(ilvRect2)) {
                    case 6: {
                        string2 = "QTopL";
                        break;
                    }
                    case 5: {
                        string2 = "QTopR";
                        break;
                    }
                    case 10: {
                        string2 = "QBottomL";
                        break;
                    }
                    case 9: {
                        string2 = "QBottomR";
                        break;
                    }
                    case 65535: {
                        string2 = "QInside";
                    }
                }
                System.out.println("********* Objects in the cell that should be in subcells:");
                boolean bl4 = true;
                IlvRect ilvRect3 = null;
                for (int i3 = 0; i3 < this.g; ++i3) {
                    string = this.f[i3] instanceof IlvLinkImage ? "link" : "node";
                    ilvRect3 = this.f[i3].boundingBox(null);
                    string2 = null;
                    switch (this.a(ilvRect3)) {
                        case 6: {
                            string2 = "QTopL";
                            break;
                        }
                        case 5: {
                            string2 = "QTopR";
                            break;
                        }
                        case 10: {
                            string2 = "QBottomL";
                            break;
                        }
                        case 9: {
                            string2 = "QBottomR";
                            break;
                        }
                        case 65535: {
                            string2 = "QInside";
                        }
                    }
                    if (i2 == i3) {
                        System.out.println("j = " + i3 + " posDescr = " + string2);
                    }
                    if (!bl2 || string2.equals("QInside")) continue;
                    if (bl4) {
                        System.out.println("******** _count: " + this.g);
                        bl4 = false;
                    }
                    System.out.println("  bbox[" + i3 + "] " + string + ": " + ilvRect3 + " (" + string2 + ")");
                }
                throw new RuntimeException("Object " + ilvGraphic + " should be in a subcell! (bounds: " + ilvRect + " _count: " + this.g + " _divided: " + this.h + " pos: " + string2 + ")");
            }
        }
        if (this.h && this.c == null && this.b == null && this.e == null && this.d == null) {
            System.out.println("cell " + this + ": no subcell, but flag _divided is true!!");
            System.out.println("parent = " + this.p);
            throw new RuntimeException("No subcell, but flag _divided is true!!");
        }
        if (!(this.h || this.c == null && this.b == null && this.e == null && this.d == null)) {
            if (this.c != null) {
                System.out.println("_divided is false but _topR is " + this.c + " (elem., count = " + this.c.g + ")");
            }
            if (this.b != null) {
                System.out.println("_divided is false but _topL is " + this.b + " (elem., count = " + this.b.g + ")");
            }
            if (this.e != null) {
                System.out.println("_divided is false but _bottomR is " + this.e + " (elem., count = " + this.e.g + ")");
            }
            if (this.d != null) {
                System.out.println("_divided is false but _bottomL is " + this.d + " (elem., count = " + this.d.g + ")");
            }
            throw new RuntimeException("Subcells exist, but flag _divided is false!!");
        }
        if (this.h) {
            if (this.c != null) {
                if (this.c.d() != this) {
                    System.out.println("this: " + this);
                    System.out.println("_topL = " + this.c + " with count: " + this.c.g);
                    System.out.println("_topL.getParent() = " + this.c.d() + " with count: " + this.c.d().g);
                    throw new RuntimeException("_topR.getParent != this !!" + (this.c.d() == null ? " (is null)" : ""));
                }
                if (bl) {
                    System.out.println("  topR:");
                }
                n2 += this.c.a(bl);
            }
            if (this.b != null) {
                if (this.b.d() != this) {
                    System.out.println("this: " + this);
                    System.out.println("_topL = " + this.b + " with count: " + this.b.g);
                    System.out.println("_topL.getParent() = " + this.b.d() + " with count: " + this.b.d().g);
                    throw new RuntimeException("_topL.getParent != this !!" + (this.b.d() == null ? " (is null)" : ""));
                }
                if (bl) {
                    System.out.println("  topL:");
                }
                n2 += this.b.a(bl);
            }
            if (this.e != null) {
                if (this.e.d() != this) {
                    System.out.println("this: " + this);
                    System.out.println("_bottomR = " + this.e + " with count: " + this.e.g);
                    System.out.println("_bottomR.getParent() = " + this.e.d() + " with count: " + this.e.d().g);
                    throw new RuntimeException("_bottomR.getParent != this !!" + (this.e.d() == null ? " (is null)" : ""));
                }
                if (bl) {
                    System.out.println("  bottomR:");
                }
                n2 += this.e.a(bl);
            }
            if (this.d != null) {
                if (this.d.d() != this) {
                    System.out.println("this: " + this);
                    System.out.println("_bottomL = " + this.d + " with count: " + this.d.g);
                    System.out.println("_bottomL.getParent() = " + this.d.d() + " with count: " + this.d.d().g);
                    throw new RuntimeException("_bottomL.getParent != this !!" + (this.d.d() == null ? " (is null)" : ""));
                }
                if (bl) {
                    System.out.println("  bottomL:");
                }
                n2 += this.d.a(bl);
            }
        }
        return n2;
    }
}

