/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.file.FileTable;
import oracle.ide.net.URLFactory;
import oracle.ide.util.ArraySortedSet;
import oracle.ideimpl.index.ResultCollector;
import oracle.ideimpl.index.file.AbstractFileTable;
import oracle.ideimpl.index.file.DirEntry;
import oracle.ideimpl.index.file.DirNameComparator;
import oracle.ideimpl.index.file.FileEntry;

public class FileTableSnapshot
implements FileTable {
    protected static final Comparator<FileEntry> DIR_NAME_COMPARATOR = new DirNameComparator();
    private static final String[] FILE_QUERIES = new String[]{"file.all", "file.extension", "file.modified.after", "file.modified.at.or.after", "file.modified.at.or.before", "file.modified.before", "file.name", "file.name.contains", "file.name.starts.with", "file.name.ends.with", "file.size.equals", "file.size.greater", "file.size.greater.or.equal", "file.size.less", "file.size.less.or.equal"};
    private static final int[] EMPTY_ARRAY = new int[0];
    private final AbstractFileTable table;
    private final long version;
    private final ArraySortedSet<FileEntry> files;
    private final ArraySortedSet<DirEntry> directories;

    public FileTableSnapshot(AbstractFileTable table) {
        this.table = table;
        this.version = table.version;
        this.files = (ArraySortedSet)table.files.clone();
        this.directories = (ArraySortedSet)table.directories.clone();
    }

    public AbstractFileTable getFileTable() {
        return this.table;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public boolean isValid(int id) {
        return this.lookupFileEntry(id) != null;
    }

    @Override
    public URL getFileURL(int id) {
        FileEntry entry = this.lookupFileEntry(id);
        return this.getFileURL(entry);
    }

    @Override
    public long getTimestamp(int id) {
        FileEntry entry = this.lookupFileEntry(id);
        return entry.lastModified;
    }

    @Override
    public int[] getFilesChangedSince(long version) {
        if (version >= this.version) {
            return EMPTY_ARRAY;
        }
        ArraySortedSet changedFiles = new ArraySortedSet(DIR_NAME_COMPARATOR);
        for (DirEntry dir : this.directories) {
            if (dir.version <= version) continue;
            for (FileEntry file : dir.files) {
                if (file.version <= version) continue;
                changedFiles.add((Object)file);
            }
        }
        int[] ids = new int[changedFiles.size()];
        int i = 0;
        for (FileEntry entry : changedFiles) {
            ids[i++] = entry.id;
        }
        return ids;
    }

    @Override
    public void release() {
        this.table.release();
    }

    public void query(QueryCriteria criteria, ResultCollector results, boolean endResults) throws InterruptedException {
        Set entries = criteria.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            if (!FileTableSnapshot.isFileQuery(key)) continue;
            results.startResultSet(endResults && !iterator.hasNext());
            this.handleQuery((String)key, (String)entry.getValue(), results);
            results.endResultSet();
        }
    }

    private FileEntry lookupFileEntry(int id) {
        FileEntry lookupFile = new FileEntry();
        lookupFile.id = id;
        return (FileEntry)this.files.lookup((Object)lookupFile);
    }

    private URL getFileURL(FileEntry entry) {
        if (entry != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(entry.directory);
            buffer.append(entry.name);
            return URLFactory.newURL((URL)this.table.root.getURL(), (String)buffer.toString());
        }
        return null;
    }

    public static QueryCriteria getFileCriteria(QueryCriteria criteria) {
        Set entries = criteria.entrySet();
        QueryCriteria fileCriteria = new QueryCriteria();
        for (Map.Entry entry : entries) {
            Object key = entry.getKey();
            if (!FileTableSnapshot.isFileQuery(key)) continue;
            fileCriteria.put(key, entry.getValue());
        }
        return fileCriteria;
    }

    private static boolean isFileQuery(Object key) {
        if (key instanceof String) {
            String keyStr = (String)key;
            for (String str : FILE_QUERIES) {
                if (!str.equals(keyStr)) continue;
                return true;
            }
        }
        return false;
    }

    private void handleQuery(String key, String value, ResultCollector results) throws InterruptedException {
        block34: {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block33: {
                                    if (!"file.all".equals(key)) break block33;
                                    for (FileEntry file : this.files) {
                                        results.add(key, file.id, this.getFileURL(file));
                                    }
                                    break block34;
                                }
                                if (!"file.extension".equals(key)) break block35;
                                if (value == null) break block34;
                                String[] extensions = value.split("\\|");
                                block1: for (FileEntry file : this.files) {
                                    String extension = new String(file.extension);
                                    for (String current : extensions) {
                                        if (!extension.equalsIgnoreCase(current)) continue;
                                        results.add(key, file.id);
                                        continue block1;
                                    }
                                }
                                break block34;
                            }
                            if (!"file.name".equals(key)) break block36;
                            for (FileEntry file : this.files) {
                                String name = new String(file.name);
                                if (!(name = name.substring(0, file.name.length - file.extension.length)).equalsIgnoreCase(value)) continue;
                                results.add(key, file.id);
                            }
                            break block34;
                        }
                        if (!"file.name.starts.with".equals(key)) break block37;
                        if (value == null) break block34;
                        for (FileEntry file : this.files) {
                            String name = new String(file.name);
                            if (!(name = name.substring(0, file.name.length - file.extension.length)).toLowerCase().startsWith(value.toLowerCase())) continue;
                            results.add(key, file.id);
                        }
                        break block34;
                    }
                    if (!"file.name.ends.with".equals(key)) break block38;
                    if (value == null) break block34;
                    for (FileEntry file : this.files) {
                        String name = new String(file.name);
                        if (!(name = name.substring(0, file.name.length - file.extension.length)).toLowerCase().endsWith(value.toLowerCase())) continue;
                        results.add(key, file.id);
                    }
                    break block34;
                }
                if (!"file.name.contains".equals(key)) break block39;
                if (value == null) break block34;
                for (FileEntry file : this.files) {
                    String name = new String(file.name);
                    if (!(name = name.substring(0, file.name.length - file.extension.length)).toLowerCase().contains(value.toLowerCase())) continue;
                    results.add(key, file.id);
                }
                break block34;
            }
            if ("file.size.equals".equals(key)) {
                long size = this.getFileSize(value);
                for (FileEntry file : this.files) {
                    if (file.length != size) continue;
                    results.add(key, file.id);
                }
            } else if ("file.size.greater".equals(key)) {
                long size = this.getFileSize(value);
                for (FileEntry file : this.files) {
                    if (file.length <= size) continue;
                    results.add(key, file.id);
                }
            } else if ("file.size.greater.or.equal".equals(key)) {
                long size = this.getFileSize(value);
                for (FileEntry file : this.files) {
                    if (file.length < size) continue;
                    results.add(key, file.id);
                }
            } else if ("file.size.less".equals(key)) {
                long size = this.getFileSize(value);
                for (FileEntry file : this.files) {
                    if (file.length >= size) continue;
                    results.add(key, file.id);
                }
            } else if ("file.size.less.or.equal".equals(key)) {
                long size = this.getFileSize(value);
                for (FileEntry file : this.files) {
                    if (file.length > size) continue;
                    results.add(key, file.id);
                }
            } else if ("file.modified.after".equals(key)) {
                long lastModified = Long.parseLong(value);
                for (FileEntry file : this.files) {
                    if (file.lastModified <= lastModified) continue;
                    results.add(key, file.id);
                }
            } else if ("file.modified.at.or.after".equals(key)) {
                long lastModified = Long.parseLong(value);
                for (FileEntry file : this.files) {
                    if (file.lastModified < lastModified) continue;
                    results.add(key, file.id);
                }
            } else if ("file.modified.before".equals(key)) {
                long lastModified = Long.parseLong(value);
                for (FileEntry file : this.files) {
                    if (file.lastModified >= lastModified) continue;
                    results.add(key, file.id);
                }
            } else if ("file.modified.at.or.before".equals(key)) {
                long lastModified = Long.parseLong(value);
                for (FileEntry file : this.files) {
                    if (file.lastModified > lastModified) continue;
                    results.add(key, file.id);
                }
            }
        }
    }

    private long getFileSize(String size) {
        int multiplier = 1;
        int len = size.length();
        if (len > 0) {
            char c = size.charAt(size.length() - 1);
            if (c == 'k') {
                multiplier = 1024;
                size = size.substring(0, len);
            } else if (c == 'm') {
                multiplier = 0x100000;
                size = size.substring(0, len);
            } else if (c == 'g') {
                multiplier = 0x40000000;
                size = size.substring(0, len);
            }
        }
        return Long.parseLong(size) * (long)multiplier;
    }
}

