/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index.file;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArraySortedSet;
import oracle.ide.util.PatternFilters;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.file.AbstractFileTable;
import oracle.ideimpl.index.file.ActiveRootManager;
import oracle.ideimpl.index.file.DirEntry;
import oracle.ideimpl.index.file.FileEntry;

public class DirFileTable
extends AbstractFileTable {
    private boolean unverified = true;
    private int added;
    private int modified;
    private int removed;
    private final Object invalidLock = new Object();
    @GuardedBy(value="invalidLock")
    private boolean invalid;
    @GuardedBy(value="invalidLock")
    private HashSet<URL> invalidDirectories = new HashSet(5);
    @GuardedBy(value="invalidLock")
    private HashSet<URL> invalidRoots = new HashSet(3);
    private static boolean verify = Boolean.getBoolean("ide.file.table.verify");

    static DirFileTable newInstance(Project project, URL root, PatternFilters filters) {
        DirFileTable instance = new DirFileTable(project, root, filters);
        ActiveRootManager.getInstance().addRootListener(instance.root, instance.rootListener);
        return instance;
    }

    protected DirFileTable(Project project, URL root, PatternFilters filters) {
        super(project, root, filters);
    }

    @Override
    public void invalidateFile(URL file) {
        URL directory = URLFileSystem.getParent((URL)file);
        if (directory != null) {
            this.invalidateDir(directory, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateDir(URL directory, boolean subdirs) {
        if (subdirs && URLFileSystem.equals((URL)directory, (URL)this.root.getURL())) {
            Object object = this.invalidLock;
            synchronized (object) {
                if (!this.invalid) {
                    this.invalid = true;
                }
            }
        }
        Object object = this.invalidLock;
        synchronized (object) {
            if (subdirs) {
                this.invalidRoots.add(directory);
            } else {
                this.invalidDirectories.add(directory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateFileTable() {
        this.bailIfCancelled();
        boolean hasChanges = false;
        this.removed = 0;
        this.modified = 0;
        this.added = 0;
        hasChanges = this.version == 0L || this.invalid || verify && this.unverified ? this.fullUpdate() : this.incrementalUpdate();
        if (hasChanges) {
            ++this.version;
        }
        this.unverified = false;
        Object object = this.invalidLock;
        synchronized (object) {
            this.invalid = false;
        }
        if (IndexLogger.getLogger().isLoggable(Level.FINEST)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Updated " + URLFileSystem.getPlatformPathName((URL)this.root.getURL()) + "\n");
            buffer.append("    " + this.added + " file(s) added\n");
            buffer.append("    " + this.modified + " file(s) modified\n");
            buffer.append("    " + this.removed + " file(s) removed");
            IndexLogger.getLogger().finest(buffer.toString());
        }
        return hasChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clear() {
        super.clear();
        this.unverified = true;
        Object object = this.invalidLock;
        synchronized (object) {
            this.invalid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fullUpdate() {
        Object object = this.invalidLock;
        synchronized (object) {
            this.invalidRoots = new HashSet(3);
            this.invalidDirectories = new HashSet(5);
        }
        LinkedList<DirEntry> queue = new LinkedList<DirEntry>();
        if (this.directories.isEmpty()) {
            DirEntry rootDir = new DirEntry(new char[0]);
            this.directories.add((Object)rootDir);
            queue.add(rootDir);
        } else {
            queue.addAll((Collection<DirEntry>)this.directories);
        }
        return this.processQueue(queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean incrementalUpdate() {
        HashSet<URL> localDirectories;
        HashSet<URL> localRoots;
        Object object = this.invalidLock;
        synchronized (object) {
            localRoots = this.invalidRoots;
            localDirectories = this.invalidDirectories;
            this.invalidRoots = new HashSet(3);
            this.invalidDirectories = new HashSet(5);
        }
        HashSet<URL> queued = new HashSet<URL>();
        LinkedList<DirEntry> queue = new LinkedList<DirEntry>();
        if (!localRoots.isEmpty()) {
            for (URL dir : localRoots) {
                String path = URLFileSystem.toRelativeSpec((URL)dir, (URL)this.root.getURL(), (boolean)true);
                if (path == null) continue;
                for (DirEntry entry : this.directories) {
                    URL url;
                    if (!this.startsWith(entry.path, path) || queued.contains(url = this.getDirURL(entry))) continue;
                    queue.add(entry);
                    queued.add(url);
                }
            }
        }
        if (!localDirectories.isEmpty()) {
            Iterator<URL> i$ = localDirectories.iterator();
            block5: while (i$.hasNext()) {
                String path;
                URL dir;
                URL current = dir = i$.next();
                while (current != null && !queued.contains(current) && (path = URLFileSystem.toRelativeSpec((URL)current, (URL)this.root.getURL(), (boolean)true)) != null) {
                    DirEntry entry;
                    this.lookupDir.path = path.toCharArray();
                    entry = (DirEntry)this.directories.lookup((Object)this.lookupDir);
                    if (entry != null) {
                        queue.add(entry);
                        queued.add(current);
                        continue block5;
                    }
                    current = URLFileSystem.getParent((URL)current);
                }
            }
        }
        queued.clear();
        return this.processQueue(queue);
    }

    private boolean processQueue(LinkedList<DirEntry> queue) {
        boolean hasChanges = false;
        while (!queue.isEmpty()) {
            DirEntry entry = queue.removeFirst();
            if (entry.version > this.version || !this.updateDir(entry, queue)) continue;
            hasChanges = true;
        }
        return hasChanges;
    }

    private boolean updateDir(DirEntry entry, LinkedList<DirEntry> queue) {
        URL url = this.getDirURL(entry.path);
        URLFileSystem.FileInfo[] infos = URLFileSystem.ls((URL)url);
        if (infos == null) {
            if (entry.path.length == 0) {
                boolean hadFiles = !this.files.isEmpty();
                this.files.clear();
                this.directories.clear();
                queue.clear();
                this.directories.add((Object)new DirEntry(new char[0]));
                return hadFiles;
            }
            this.removeDirEntry(entry);
            return true;
        }
        boolean hasChanges = false;
        ArraySortedSet oldFiles = (ArraySortedSet)entry.files.clone();
        ArraySortedSet newFiles = new ArraySortedSet(FILE_NAME_COMPARATOR);
        for (URLFileSystem.FileInfo info : infos) {
            long timestamp;
            StringBuffer buffer;
            String filename;
            if (info.isHidden() || (filename = URLFileSystem.getFileName((URL)info.getURL())).startsWith(".")) continue;
            if (info.isDirectory()) {
                buffer = new StringBuffer();
                buffer.append(entry.path);
                buffer.append(filename);
                buffer.append("/");
                String subpath = buffer.toString();
                if (!this.dirPassesFilters(subpath)) continue;
                this.lookupDir.path = subpath.toCharArray();
                DirEntry subdir = (DirEntry)this.directories.lookup((Object)this.lookupDir);
                if (subdir != null) continue;
                subdir = new DirEntry(this.charPool.add(this.lookupDir.path));
                this.directories.add((Object)subdir);
                queue.add(subdir);
                continue;
            }
            buffer = new StringBuffer();
            buffer.append(entry.path);
            buffer.append(filename);
            if (!this.filePassesFilters(buffer.toString())) continue;
            Node node = NodeFactory.find((URL)info.getURL());
            long lastModified = node != null ? ((timestamp = node.getTimestampLoadedUnsafe()) > 0L ? timestamp : info.lastModified()) : info.lastModified();
            String suffix = URLFileSystem.getSuffix((URL)info.getURL());
            this.lookupFile.name = filename.toCharArray();
            FileEntry oldFile = (FileEntry)oldFiles.lookup((Object)this.lookupFile);
            if (oldFile == null) {
                char[] nameChars = this.charPool.add(filename);
                char[] suffixChars = this.charPool.add(suffix);
                FileEntry newFile = new FileEntry(nameChars, entry.path, suffixChars, lastModified, info.length(), this.getNextFileId(), this.version + 1L);
                newFiles.add((Object)newFile);
                this.files.add((Object)newFile);
                hasChanges = true;
                ++this.added;
                continue;
            }
            if (oldFile.lastModified != lastModified) {
                oldFiles.remove((Object)oldFile);
                this.files.remove((Object)oldFile);
                FileEntry newFile = new FileEntry(oldFile.name, entry.path, oldFile.extension, lastModified, info.length(), this.getNextFileId(), this.version + 1L);
                newFiles.add((Object)newFile);
                this.files.add((Object)newFile);
                hasChanges = true;
                ++this.modified;
                continue;
            }
            oldFiles.remove((Object)oldFile);
            newFiles.add((Object)oldFile);
        }
        hasChanges = hasChanges || !oldFiles.isEmpty();
        this.removed += oldFiles.size();
        this.files.removeAll((Collection)oldFiles);
        if (hasChanges) {
            this.directories.remove((Object)entry);
            this.directories.add((Object)new DirEntry(entry.path, this.version + 1L, (ArraySortedSet<FileEntry>)newFiles));
        }
        return hasChanges;
    }

    private boolean startsWith(char[] c, String prefix) {
        String str = new String(c);
        return str.startsWith(prefix);
    }

    static {
        if (!verify) {
            EnvironOptions options = Ide.getEnvironOptions();
            verify = options == null || options.getVerifyCachedFileData();
        }
    }
}

