/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.index.Indexer;

public class IndexerStatistics {
    private static final Logger LOGGER = Logger.getLogger(IndexerStatistics.class.getName());
    private static final boolean ENABLED = LOGGER.isLoggable(Level.FINE);
    private static final HashMap<String, Integer> ENTRIES = new HashMap();
    private static final HashMap<String, Long> TIMING = new HashMap();
    private static final HashMap<String, Integer> CALLS = new HashMap();
    private static long bufferTime = 0L;
    private static long openTime = 0L;
    private static long saveTime = 0L;
    private static long nodeTime = 0L;
    private static long fileTableTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addIndexEntry(String key) {
        if (ENABLED) {
            HashMap<String, Integer> hashMap = ENTRIES;
            synchronized (hashMap) {
                Integer count = ENTRIES.get(key);
                ENTRIES.put(key, count == null ? 1 : count + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addIndexerTiming(Indexer indexer, long time) {
        if (ENABLED) {
            HashMap<String, Long> hashMap = TIMING;
            synchronized (hashMap) {
                String key = indexer.getClass().getName();
                Long total = TIMING.get(key);
                TIMING.put(key, total == null ? time : total + time);
                Integer calls = CALLS.get(key);
                CALLS.put(key, calls == null ? 1 : calls + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addBufferTime(long time) {
        if (ENABLED) {
            HashMap<String, Long> hashMap = TIMING;
            synchronized (hashMap) {
                bufferTime += time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addOpenTime(long time) {
        if (ENABLED) {
            HashMap<String, Long> hashMap = TIMING;
            synchronized (hashMap) {
                openTime += time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addSaveTime(long time) {
        if (ENABLED) {
            HashMap<String, Long> hashMap = TIMING;
            synchronized (hashMap) {
                saveTime += time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addNodeTime(long time) {
        if (ENABLED) {
            HashMap<String, Long> hashMap = TIMING;
            synchronized (hashMap) {
                nodeTime += time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addFileTableTime(long time) {
        if (ENABLED) {
            HashMap<String, Long> hashMap = TIMING;
            synchronized (hashMap) {
                fileTableTime += time;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void logStatistics() {
        if (ENABLED) {
            Comparator<String> c;
            ArrayList<String> keys;
            boolean hasData = false;
            StringBuilder msg = new StringBuilder();
            Formatter formatter = new Formatter(msg);
            HashMap<String, Number> hashMap = TIMING;
            synchronized (hashMap) {
                formatter.format("\n\n  Time to scan files:    %6dms", fileTableTime / 1000000L);
                formatter.format("\n  Time to create nodes:  %6dms", nodeTime / 1000000L);
                formatter.format("\n  Time to open files:    %6dms", openTime / 1000000L);
                formatter.format("\n  Time to load buffers:  %6dms", bufferTime / 1000000L);
                formatter.format("\n  Time to write indexes: %6dms", saveTime / 1000000L);
                if (!TIMING.isEmpty()) {
                    msg.append("\n\n  Total time per Indexer:\n");
                    hasData = true;
                    keys = new ArrayList<String>(TIMING.keySet());
                    c = new Comparator<String>(){

                        @Override
                        public int compare(String s1, String s2) {
                            long time1 = (Long)TIMING.get(s1);
                            long time2 = (Long)TIMING.get(s2);
                            return time2 > time1 ? 1 : (time2 == time1 ? 0 : -1);
                        }

                        @Override
                        public boolean equals(Object obj) {
                            return this.equals(obj);
                        }
                    };
                    Collections.sort(keys, c);
                    for (String key : keys) {
                        formatter.format("  %6dms %s (%d files)\n", TIMING.get(key) / 1000000L, key, CALLS.get(key));
                    }
                }
            }
            hashMap = ENTRIES;
            synchronized (hashMap) {
                if (!ENTRIES.isEmpty()) {
                    if (hasData) {
                        msg.append("\n");
                    }
                    hasData = true;
                    keys = new ArrayList<String>(ENTRIES.keySet());
                    c = new Comparator<String>(){

                        @Override
                        public int compare(String s1, String s2) {
                            int count1 = (Integer)ENTRIES.get(s1);
                            int count2 = (Integer)ENTRIES.get(s2);
                            return count2 - count1;
                        }

                        @Override
                        public boolean equals(Object obj) {
                            return this.equals(obj);
                        }
                    };
                    Collections.sort(keys, c);
                    msg.append("  Number of entries per key:\n");
                    for (String key : keys) {
                        formatter.format("  %10d %s\n", ENTRIES.get(key), key);
                    }
                }
            }
            if (hasData) {
                LOGGER.fine(msg.toString());
            }
        }
    }
}

