/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.index.file.FileTable;
import oracle.ide.index.file.FileTableManager;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.persistence.NameSpace;
import oracle.ide.persistence.Storage;
import oracle.ide.persistence.Storages;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ideimpl.index.DataCollectorImpl;
import oracle.ideimpl.index.DataLocation;
import oracle.ideimpl.index.FileData;
import oracle.ideimpl.index.IndexInfo;
import oracle.ideimpl.index.IndexLogger;
import oracle.ideimpl.index.IndexProgressMonitor;
import oracle.ideimpl.index.IndexThreadFactory;
import oracle.ideimpl.index.IndexerStatistics;
import oracle.ideimpl.index.IndexingContextImpl;
import oracle.ideimpl.index.ResultCollector;
import oracle.ideimpl.index.util.ContentSetRoot;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.VariableLengthIntArrayFactory;
import oracle.javatools.util.ArraySortedSet;
import oracle.javatools.util.Maps;

@ThreadSafe
public class IndexRoot
implements Runnable {
    private static final String STORAGE_PREFIX = "$index.Data$";
    private static final String INFO_RECORD_NAME = "$index.info$";
    private static final char[] ENCODING_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v'};
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final ObjectFactory INT_ARRAY_FACTORY = VariableLengthIntArrayFactory.VARIABLE_LENGTH_INT_ARRAY_FACTORY;
    private static final Comparator<Integer> REVERSE_COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer obj1, Integer obj2) {
            return obj2.compareTo(obj1);
        }
    };
    private static final Map<ContentSetRoot, IndexRoot> INSTANCES = new Maps.ManagedCacheMap(Maps.CacheMap.SOFT, IndexRoot.class.getSimpleName());
    private static final int MEMORY_THRESHOLD = 0x200000;
    protected static final ExecutorService UPDATE_SCHEDULER = Executors.newSingleThreadExecutor(new IndexThreadFactory("index-update"));
    private final Project project;
    private final URL root;
    private final PatternFilters filters;
    private final String storageKey;
    private ReentrantLock lock = new ReentrantLock();
    private Condition updateFinished = this.lock.newCondition();
    @GuardedBy(value="lock")
    private long version = 0L;
    @GuardedBy(value="lock")
    private long lastCleanup = 0L;
    @GuardedBy(value="lock")
    private Storage storage;
    @GuardedBy(value="lock")
    private FileTable fileTable;
    @GuardedBy(value="lock")
    private Future runningUpdate;
    @GuardedBy(value="lock")
    private List<IndexRootProgressMonitor> monitors = new ArrayList<IndexRootProgressMonitor>();
    @GuardedBy(value="lock")
    private int updateCount;
    @GuardedBy(value="lock")
    private int lockCount;
    @GuardedBy(value="INSTANCES")
    private int refCount;
    @GuardedBy(value="lock")
    private int[] changedFiles;
    @GuardedBy(value="lock")
    private boolean disposed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexRoot getIndexRoot(Project project, URL root, PatternFilters filters) {
        Map<ContentSetRoot, IndexRoot> map = INSTANCES;
        synchronized (map) {
            ContentSetRoot key = new ContentSetRoot(project, root, filters);
            IndexRoot instance = INSTANCES.get(key);
            if (instance == null) {
                instance = new IndexRoot(project, root, filters);
                INSTANCES.put(key, instance);
            }
            instance.acquire();
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        Map<ContentSetRoot, IndexRoot> map = INSTANCES;
        synchronized (map) {
            Iterator<IndexRoot> iterator = INSTANCES.values().iterator();
            while (iterator.hasNext()) {
                IndexRoot root = iterator.next();
                if (root == null || root.refCount != 0) continue;
                iterator.remove();
                root.dispose();
            }
        }
    }

    private IndexRoot(Project project, URL root, PatternFilters filters) {
        this.project = project;
        this.root = root;
        this.filters = filters;
        this.storageKey = IndexRoot.getStorageKey(project, root, filters);
    }

    public URL getRootURL() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws InterruptedException, LockFailedException {
        this.lock.lockInterruptibly();
        try {
            this.storage = Storages.getProjectStorage((Project)this.project);
            this.storage.open();
            boolean success = false;
            try {
                if (this.lockCount == 0) {
                    FileTable oldFileTable = this.fileTable;
                    FileTableManager ftm = FileTableManager.getFileTableManager();
                    long start = System.nanoTime();
                    this.fileTable = ftm.getFileTable(this.project, this.root, this.filters);
                    IndexerStatistics.addFileTableTime(System.nanoTime() - start);
                    if (oldFileTable != null) {
                        oldFileTable.release();
                    }
                    this.changedFiles = null;
                }
                ++this.lockCount;
                success = true;
            }
            finally {
                if (!success) {
                    this.storage.close();
                }
            }
        }
        catch (ExecutionException ee) {
            throw new LockFailedException(ee.getCause());
        }
        catch (RejectedExecutionException ree) {
            throw ree;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            throw new LockFailedException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        this.lock.lock();
        try {
            this.storage.close();
            --this.lockCount;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileTable getFileTable() {
        this.lock.lock();
        try {
            FileTable fileTable = this.fileTable;
            return fileTable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void query(QueryCriteria criteria, ResultCollector results) throws InterruptedException, QueryFailedException {
        QueryCriteria copy = new QueryCriteria();
        copy.putAll(criteria);
        Set entries = copy.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Map.Entry entry = iterator.next();
            iterator.remove();
            Object value = entry.getValue();
            results.startResultSet(copy.isEmpty());
            if (value instanceof String) {
                String[] values;
                String str = (String)value;
                for (String current : values = str.split("\\|")) {
                    this.lookup(entry.getKey(), current, results);
                }
            } else {
                this.lookup(entry.getKey(), entry.getValue(), results);
            }
            results.endResultSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangedFileCount() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            if (this.changedFiles == null) {
                IndexInfo info = this.loadIndexInfo();
                if (info != null) {
                    this.version = info.version;
                    this.lastCleanup = info.lastCleanup;
                } else {
                    this.version = 0L;
                    this.lastCleanup = 0L;
                }
                this.changedFiles = this.fileTable.getFilesChangedSince(this.version);
            }
            int n = this.changedFiles.length;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() {
        Map<ContentSetRoot, IndexRoot> map = INSTANCES;
        synchronized (map) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Map<ContentSetRoot, IndexRoot> map = INSTANCES;
        synchronized (map) {
            --this.refCount;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        this.lock.lock();
        try {
            if (!this.disposed) {
                if (this.fileTable != null) {
                    this.fileTable.release();
                }
                this.disposed = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(IndexProgressMonitor progress) throws InterruptedException {
        block14: {
            this.lock.lockInterruptibly();
            try {
                long fileTableVersion = this.fileTable.getVersion();
                if (fileTableVersion == this.version) break block14;
                IndexRootProgressMonitor rootProgress = null;
                if (progress != null) {
                    rootProgress = new IndexRootProgressMonitor(progress);
                    this.monitors.add(rootProgress);
                }
                ++this.updateCount;
                if (this.runningUpdate == null) {
                    this.runningUpdate = UPDATE_SCHEDULER.submit(this);
                }
                boolean cancelled = false;
                Future task = this.runningUpdate;
                try {
                    while (task == this.runningUpdate) {
                        this.updateFinished.await();
                    }
                }
                catch (InterruptedException e) {
                    cancelled = true;
                    if (rootProgress != null) {
                        this.monitors.remove(rootProgress);
                    }
                    if (--this.updateCount == 0 && this.runningUpdate != null) {
                        this.runningUpdate.cancel(true);
                        this.runningUpdate = null;
                    }
                }
                finally {
                    if (!cancelled) {
                        --this.updateCount;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        PerformanceLogger.get().startTiming("IndexRoot.run");
        int[] ids = null;
        try {
            this.lock();
            try {
                FileTable localFileTable;
                this.lock.lockInterruptibly();
                try {
                    if (this.getChangedFileCount() == 0) {
                        return;
                    }
                    ids = new int[this.changedFiles.length];
                    System.arraycopy(this.changedFiles, 0, ids, 0, this.changedFiles.length);
                    localFileTable = this.fileTable;
                }
                finally {
                    this.lock.unlock();
                }
                int current = 0;
                IntHashMap data = new IntHashMap();
                while (current < ids.length) {
                    if ((current = this.updateImpl(localFileTable, ids, current, (IntHashMap<ArraySortedSet<FileData>>)data)) == ids.length) {
                        this.lock.lockInterruptibly();
                        try {
                            long newVersion = this.fileTable.getVersion();
                            this.saveIndex(newVersion, this.lastCleanup, (IntHashMap<ArraySortedSet<FileData>>)data);
                            this.version = newVersion;
                            continue;
                        }
                        finally {
                            this.lock.unlock();
                            continue;
                        }
                    }
                    this.saveIndex(-1L, -1L, (IntHashMap<ArraySortedSet<FileData>>)data);
                }
            }
            finally {
                this.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            IndexLogger.getLogger().log(Level.SEVERE, "Exception while building index for " + URLFileSystem.getPlatformPathName((URL)this.root), t);
        }
        finally {
            this.lock.lock();
            try {
                this.runningUpdate = null;
                this.monitors.clear();
                this.changedFiles = new int[0];
                this.updateFinished.signalAll();
            }
            finally {
                this.lock.unlock();
            }
            if (ids != null) {
                PerformanceLogger.get().stopTiming("IndexRoot.run", "Indexed " + ids.length + " files");
            } else {
                PerformanceLogger.get().stopTiming("IndexRoot.run", null);
            }
        }
    }

    private IndexInfo loadIndexInfo() {
        byte[] data;
        IndexInfo info = null;
        NameSpace namespace = this.getNameSpace();
        if (namespace != null && (data = namespace.getRecord(INFO_RECORD_NAME)) != null) {
            try {
                info = (IndexInfo)IndexInfo.INDEX_INFO_FACTORY.assemble(data);
            }
            catch (AssemblyException e) {
                namespace.close();
                this.storage.deleteNameSpace(this.storageKey);
                IndexLogger.getLogger().log(Level.FINE, "Invalid index for " + URLFileSystem.getPlatformPathName((URL)this.root), e);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveIndex(long version, long lastCleanup, IntHashMap<ArraySortedSet<FileData>> dataMap) {
        NameSpace namespace = this.getNameSpace();
        if (namespace != null) {
            long start = System.nanoTime();
            try {
                if (version != -1L) {
                    IndexInfo info = new IndexInfo(version, lastCleanup);
                    byte[] data = IndexInfo.INDEX_INFO_FACTORY.disassemble((Object)info);
                    namespace.putRecord(INFO_RECORD_NAME, data);
                }
                Set hashSet = dataMap.keySet();
                int numHashes = hashSet.size();
                Integer[] hashesToProcess = hashSet.toArray(new Integer[numHashes]);
                Arrays.sort(hashesToProcess, REVERSE_COMPARATOR);
                for (int i = 0; i < numHashes; ++i) {
                    int hash = hashesToProcess[i];
                    String hashStr = IndexRoot.encode(hash);
                    byte[] data = namespace.getRecord(hashStr);
                    int[] oldData = EMPTY_INT_ARRAY;
                    if (data != null) {
                        oldData = (int[])INT_ARRAY_FACTORY.assemble(data);
                    }
                    int[] newData = this.mergeData(oldData, (ArraySortedSet<FileData>)((ArraySortedSet)dataMap.remove(hash)));
                    data = INT_ARRAY_FACTORY.disassemble((Object)newData);
                    namespace.putRecord(hashStr, data);
                }
                namespace.flush();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                namespace.close();
                this.storage.deleteNameSpace(this.storageKey);
                IndexLogger.getLogger().log(Level.INFO, "Corrupted index deleted for " + URLFileSystem.getPlatformPathName((URL)this.root));
            }
            catch (AssemblyException e) {
                namespace.close();
                this.storage.deleteNameSpace(this.storageKey);
                IndexLogger.getLogger().log(Level.INFO, "Unable to save index for " + URLFileSystem.getPlatformPathName((URL)this.root), e);
            }
            finally {
                IndexerStatistics.addSaveTime(System.nanoTime() - start);
            }
        }
    }

    private static final String encode(int hash) {
        char[] c = new char[7];
        for (int i = 6; i >= 0; --i) {
            c[i] = ENCODING_CHARS[hash & 0x1F];
            hash >>>= 5;
        }
        return new String(c);
    }

    private int[] mergeData(int[] oldData, ArraySortedSet<FileData> newData) {
        int i = 0;
        int lastId = -1;
        int lastValidId = -1;
        int j = 0;
        while (j < oldData.length) {
            int delta = oldData[j++];
            int n = lastId = lastId == -1 ? delta : lastId + delta;
            if (this.fileTable.isValid(lastId)) {
                if (i == j - 1) {
                    lastValidId = lastId;
                    j += oldData[j] * 2 + 1;
                    i = j;
                    continue;
                }
                oldData[i++] = lastValidId == -1 ? lastId : lastId - lastValidId;
                lastValidId = lastId;
                int numLocations = oldData[j++];
                oldData[i++] = numLocations;
                for (int k = 0; k < numLocations; ++k) {
                    oldData[i++] = oldData[j++];
                    oldData[i++] = oldData[j++];
                }
                continue;
            }
            j += oldData[j] * 2 + 1;
        }
        int size = i + newData.size() * 2;
        for (FileData fileData : newData) {
            size += fileData.locations.size() * 2;
        }
        int[] merged = null;
        if (size == oldData.length) {
            merged = oldData;
        } else {
            merged = new int[size];
            if (i != 0) {
                System.arraycopy(oldData, 0, merged, 0, i);
            }
        }
        for (FileData fileData : newData) {
            ArraySortedSet<DataLocation> locations = fileData.locations;
            merged[i++] = lastValidId != -1 ? fileData.id - lastValidId : fileData.id;
            int sizeIndex = i++;
            int numLocations = locations.size();
            int lastOffset = -1;
            int lastLength = -1;
            for (DataLocation location : locations) {
                if (location.length == 0) {
                    --numLocations;
                    continue;
                }
                int offset = lastOffset != -1 ? location.offset - lastOffset : location.offset;
                merged[i++] = offset;
                int length = lastLength != -1 ? location.length - lastLength : location.length;
                merged[i++] = length;
                lastOffset = location.offset;
                lastLength = location.length;
            }
            merged[sizeIndex] = numLocations;
            lastValidId = fileData.id;
        }
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateImpl(FileTable localFileTable, int[] ids, int start, IntHashMap<ArraySortedSet<FileData>> data) throws InterruptedException {
        IndexingContextImpl context = new IndexingContextImpl(this.project);
        context.startIndexing();
        try {
            int i;
            DataCollectorImpl collector = new DataCollectorImpl(data);
            for (i = start; i < ids.length && collector.getCount() < 0x200000; ++i) {
                int id = ids[i];
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                URL url = localFileTable.getFileURL(id);
                if (url == null) {
                    IndexLogger.getLogger().warning("Invalid file id " + id + " in " + URLFileSystem.getPlatformPathName((URL)this.root));
                    continue;
                }
                collector.setId(id);
                long timestamp = localFileTable.getTimestamp(id);
                context.index(url, timestamp, collector);
                this.lock.lock();
                try {
                    for (IndexRootProgressMonitor progress : this.monitors) {
                        progress.setCurrentValue(i);
                    }
                    continue;
                }
                finally {
                    this.lock.unlock();
                }
            }
            int n = i;
            return n;
        }
        finally {
            context.endIndexing();
        }
    }

    private static String getStorageKey(Project project, URL root, PatternFilters filters) {
        PatternFilter[] filterArray;
        StringBuffer buffer = new StringBuffer();
        buffer.append(STORAGE_PREFIX);
        URL projectDir = URLFileSystem.getParent((URL)project.getURL());
        String relativePath = URLFileSystem.toRelativeSpec((URL)root, (URL)projectDir, (boolean)false);
        if (relativePath != null) {
            buffer.append(relativePath);
        } else {
            buffer.append(root.toString());
        }
        if (!(filters == null || (filterArray = filters.getFilters()) == null || filterArray.length == 1 && "**".equals(filterArray[0].getPattern()))) {
            for (PatternFilter filter : filterArray) {
                buffer.append(filter.toStr());
            }
        }
        return buffer.toString();
    }

    private void lookup(Object key, Object value, ResultCollector results) throws InterruptedException, QueryFailedException {
        int hash;
        byte[] data;
        NameSpace namespace = this.getNameSpace();
        if (namespace != null && (data = namespace.getRecord(IndexRoot.encode(hash = "xml.all".equals(key) ? key.hashCode() : key.hashCode() ^ value.hashCode()))) != null) {
            try {
                int count;
                int lastId = -1;
                int[] ints = (int[])INT_ARRAY_FACTORY.assemble(data);
                for (int i = 0; i < ints.length; i += count * 2 + 2) {
                    int id = ints[i];
                    if (lastId != -1) {
                        id += lastId;
                    }
                    count = ints[i + 1];
                    int lastOffset = -1;
                    int lastLength = -1;
                    for (int j = 0; j < count; ++j) {
                        int offset = ints[j * 2 + i + 2];
                        if (lastOffset != -1) {
                            offset += lastOffset;
                        }
                        int length = ints[j * 2 + i + 3];
                        if (lastLength != -1) {
                            length += lastLength;
                        }
                        results.add((String)key, id, null, offset, length);
                        lastOffset = offset;
                        lastLength = length;
                    }
                    if (count == 0) {
                        results.add((String)key, id, null, 0, 0);
                    }
                    lastId = id;
                }
            }
            catch (AssemblyException ae) {
                namespace.close();
                this.storage.deleteNameSpace(this.storageKey);
                throw new QueryFailedException(ae);
            }
        }
    }

    private NameSpace getNameSpace() {
        return this.storage.getNameSpace(this.storageKey, 1);
    }

    private final class IndexRootProgressMonitor {
        private IndexProgressMonitor owner;
        private int start;

        public IndexRootProgressMonitor(IndexProgressMonitor owner) {
            this.owner = owner;
            this.start = owner.getCurrentValue();
        }

        public void setCurrentValue(int current) {
            this.owner.setCurrentValue(this.start + current);
        }
    }
}

