/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import net.jcip.annotations.NotThreadSafe;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.index.IndexerStatistics;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.WriteLockRequestListener;

@NotThreadSafe
final class FileTextBuffer
implements TextBuffer {
    private static final int INITIAL_SIZE = 16384;
    private static final int SIZE_INCREMENT = 16834;
    private URL url;
    private int length;
    private char[] buffer = new char[16384];

    FileTextBuffer() {
    }

    public void load(URL url) throws IOException {
        this.url = url;
        try {
            this.load(new File(url.toURI()));
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to open " + URLFileSystem.getPlatformPathName((URL)url), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File file) throws IOException {
        FileReader fileReader = null;
        try {
            long start = System.nanoTime();
            fileReader = new FileReader(file);
            IndexerStatistics.addOpenTime(System.nanoTime() - start);
            start = System.nanoTime();
            this.length = 0;
            while (true) {
                int available = this.buffer.length - this.length;
                int read = fileReader.read(this.buffer, this.length, available);
                this.length += read;
                if (read < available) break;
                this.buffer = FileTextBuffer.resizeBuffer(this.buffer, this.length + 16834);
            }
            IndexerStatistics.addBufferTime(System.nanoTime() - start);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static char[] resizeBuffer(char[] buffer, int size) {
        char[] resized = new char[size];
        System.arraycopy(buffer, 0, resized, 0, buffer.length);
        return resized;
    }

    public void beginEdit() throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public UndoableEdit endEdit() {
        return null;
    }

    public UndoableEdit insert(int offset, char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
        return null;
    }

    public UndoableEdit insert(int offset, Reader reader) throws IndexOutOfBoundsException, IOException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public UndoableEdit append(char[] data) throws IndexOutOfBoundsException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public UndoableEdit remove(int offset, int count) throws IndexOutOfBoundsException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public UndoableEdit removeToEnd(int offset) throws IndexOutOfBoundsException, ReadOnlyException {
        throw new ReadOnlyException();
    }

    public LineMap getLineMap() {
        throw new UnsupportedOperationException();
    }

    public void addTextBufferListener(TextBufferListener listener) {
    }

    public void removeTextBufferListener(TextBufferListener listener) {
    }

    public void setReadOnly(boolean readOnly) {
    }

    public boolean isReadOnly() {
        return true;
    }

    public void writeLock() throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void writeLock(boolean checkIfReadOnly) throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public boolean tryWriteLock() throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public void writeUnlock() {
    }

    public boolean addWriteLockRequestListener(WriteLockRequestListener listener) {
        return false;
    }

    public void removeWriteLockRequestListener(WriteLockRequestListener listener) {
    }

    public OffsetMark addOffsetMark(int offset) {
        return null;
    }

    public OffsetMark addOffsetMark(int offset, boolean bias) {
        return null;
    }

    public void removeOffsetMark(OffsetMark offsetMark) {
    }

    public boolean isModified() {
        return false;
    }

    public void clearModified() {
    }

    public int getChangeId() {
        return 0;
    }

    public void read(Reader reader) throws IOException {
    }

    public void write(Writer writer) throws IOException {
    }

    public void write(Writer writer, boolean clearModified) throws IOException {
    }

    public String getPlatformEOLType() {
        return "\r\n";
    }

    public String getEOLType() {
        return "\r\n";
    }

    public void setEOLType(String eolType) throws ReadOnlyException {
        throw new ReadOnlyException();
    }

    public int getLength() {
        return this.length;
    }

    public char getChar(int offset) throws IndexOutOfBoundsException {
        if (offset < 0 || offset >= this.length) {
            throw new IndexOutOfBoundsException("Invalid offset " + offset + " in " + URLFileSystem.getPlatformPathName((URL)this.url));
        }
        return this.buffer[offset];
    }

    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        if (offset < 0 || offset + length >= this.length) {
            throw new IndexOutOfBoundsException("Invalid offset " + offset + " and length " + length + " in " + URLFileSystem.getPlatformPathName((URL)this.url));
        }
        char[] chars = new char[length];
        System.arraycopy(this.buffer, offset, chars, 0, length);
        return chars;
    }

    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        if (offset < 0 || offset + length >= this.length) {
            throw new IndexOutOfBoundsException("Invalid offset " + offset + " and length " + length + " in " + URLFileSystem.getPlatformPathName((URL)this.url));
        }
        return new String(this.buffer, offset, length);
    }

    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        if (offset < 0 || offset + length >= this.length) {
            throw new IndexOutOfBoundsException("Invalid offset " + offset + " and length " + length + " in " + URLFileSystem.getPlatformPathName((URL)this.url));
        }
        segment.array = this.buffer;
        segment.offset = offset;
        segment.count = length;
    }

    public void readLock() {
    }

    public boolean tryReadLock() {
        return true;
    }

    public void readUnlock() {
    }

    public int getLockStatus() {
        return -1;
    }
}

