/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.connection;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.raptor.connections.ConnectionPropertiesUpdater;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolderCache;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.adapter.OracleConnectionCreator;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdevimpl.db.adapter.CMHelper;

public final class ConnectionUtils {
    public static final String NEW_PWD = "OCINewPassword";
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.OracleDriver";
    private static List<Class<? extends ConnectionPropertiesUpdater>> s_updaters = new CopyOnWriteArrayList<Class<? extends ConnectionPropertiesUpdater>>();

    public static String scrubOraDriverType(String string) {
        String string2 = "";
        if (string != null && string.startsWith("jdbc:oracle")) {
            String[] stringArray;
            int n = string.indexOf("@");
            String string3 = string.substring(0, n);
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((stringArray = string3.split(":")).length == 3) {
                string2 = stringArray[2];
            }
        }
        return string2;
    }

    public static String getThinUrl(Properties properties) throws SQLException {
        String string = properties.getProperty("customUrl");
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        if (ModelUtil.hasLength((String)string)) {
            if (ConnectionUtils.scrubOraDriverType(string).equals("oci8")) {
                properties2.setProperty("oraDriverType", "thin");
                properties2.remove("customUrl");
                return ConnectionUtils.getConnectionURL(properties2);
            }
        } else {
            properties2.setProperty("oraDriverType", "thin");
            return ConnectionUtils.getConnectionURL(properties2);
        }
        return string;
    }

    public static String getOCIUrl(Properties properties) throws SQLException {
        String string = properties.getProperty("customUrl");
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        if (ModelUtil.hasLength((String)string)) {
            if (ConnectionUtils.scrubOraDriverType(string).equals("thin")) {
                properties2.setProperty("oraDriverType", "oci8");
                properties2.remove("customUrl");
                return ConnectionUtils.getConnectionURL(properties2);
            }
        } else {
            properties2.setProperty("oraDriverType", "oci8");
            return ConnectionUtils.getConnectionURL(properties2);
        }
        return string;
    }

    private static String getConnectionURL(Properties properties) throws SQLException {
        OracleConnectionCreator oracleConnectionCreator = new OracleConnectionCreator();
        return oracleConnectionCreator.getConnectionURL(properties);
    }

    public static void addNewConnectionBasedOn(String string, String string2, String string3, String string4) {
        try {
            Properties properties = DatabaseConnectionStores.getInstance().getStore("IdeConnections").getProperties(string2);
            properties.setProperty("user", string3);
            properties.setProperty("NoPasswordConnection", "TRUE");
            properties.remove("role");
            if (string4 != null) {
                properties.setProperty("SavePassword", Boolean.TRUE.toString());
                properties.setProperty("password", string4);
            } else if (properties.getProperty("password") != null) {
                properties.remove("password");
                properties.setProperty("SavePassword", Boolean.FALSE.toString());
            } else {
                properties.setProperty("SavePassword", Boolean.FALSE.toString());
            }
            String string5 = string3;
            if (string == null) {
                ConnectionUtils.addConnToStore(string5, properties, "Connections based on " + string2);
            } else {
                ConnectionUtils.addConnToStore(string5, properties, string);
            }
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    public static void addConnection(Properties properties, String string, String string2) {
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        String string3 = properties.getProperty("name") + "-" + string;
        ConnectionUtils.addConnToStore(string3, properties, null);
    }

    public static void addConnection(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7, String string8, String string9) {
        String string10 = null;
        Properties properties = new Properties();
        if (string2.equals("/")) {
            properties.setProperty("oraDriverType", "oci8");
            string10 = "jdbc:oracle:oci8:@";
        } else {
            string10 = "jdbc:oracle:thin:@";
            properties.setProperty("user", string2);
            if (string3 != null) {
                properties.setProperty("password", string3);
                properties.setProperty("SavePassword", Boolean.TRUE.toString());
            } else {
                properties.setProperty("SavePassword", Boolean.FALSE.toString());
            }
            properties.setProperty("oraDriverType", "thin");
        }
        if (string5 != null) {
            string10 = string10 + string5;
        }
        if (string6 != null) {
            string10 = string10 + ":" + string6;
        }
        if (string4 != null) {
            string10 = string10 + ":" + string4;
        } else if (string7 != null) {
            string10 = string10 + "/" + string7;
        }
        properties.setProperty("subtype", "oraJDBC");
        properties.setProperty("driver", DRIVER_CLASS_NAME);
        properties.setProperty("oraDriverType", "oci8");
        properties.setProperty("RaptorConnectionType", "Oracle");
        if (string8 != null) {
            properties.setProperty("role", string8);
        }
        if (string5 != null) {
            properties.setProperty("hostname", string5);
        }
        if (string6 != null) {
            properties.setProperty("port", string6);
        }
        if (string4 != null) {
            properties.setProperty("sid", string4);
        } else if (string7 != null) {
            properties.setProperty("serviceName", string7);
        }
        properties.setProperty("customUrl", string10);
        properties.setProperty("OracleConnectionType", OracleConnectionType.BASIC.name());
        if (bl || string2.equals("/")) {
            properties.setProperty("OS_AUTHENTICATION", "TRUE");
            properties.setProperty("NoPasswordConnection", "FALSE");
        } else {
            properties.setProperty("NoPasswordConnection", "TRUE");
        }
        ConnectionUtils.addConnToStore(string, properties, string9);
    }

    public static void addConnToStore(String string, Properties properties, String string2) {
        try {
            Properties properties2 = DatabaseConnectionStores.getInstance().getStore("IdeConnections").getProperties(string);
            if (properties2 != null) {
                return;
            }
            if (string2 != null) {
                DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
                databasesFolderCache.addConnection("IdeConnections", string2, string);
            }
            DatabaseConnectionStores.getInstance().getStore("IdeConnections").addConnection(string, properties);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    public static void importFile(File file) {
        if (file.exists()) {
            String string2;
            HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
            DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
            CMConnectionsReader cMConnectionsReader = new CMConnectionsReader(file.getAbsolutePath(), true);
            List list = cMConnectionsReader.read();
            if (list != null && list.size() > 0) {
                for (Properties object : list) {
                    string2 = object.getProperty("ConnectionName");
                    hashMap.put(string2, ConnectionUtils.convertProps(object));
                }
            } else {
                try {
                    DatabaseConnections databaseConnections2 = DatabaseConnections.getPrivateInstance((URL)file.toURI().toURL());
                    for (String string2 : databaseConnections2.listConnections()) {
                        hashMap.put(string2, databaseConnections2.getProperties(string2));
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
            try {
                for (Map.Entry entry : hashMap.entrySet()) {
                    string2 = (String)entry.getKey();
                    Properties properties = (Properties)entry.getValue();
                    if (properties == null) continue;
                    boolean bl = true;
                    boolean bl2 = databaseConnections.getProperties(string2) != null;
                    for (ConnectionPropertiesUpdater connectionPropertiesUpdater : ConnectionUtils.getUpdaters("IdeConnections")) {
                        connectionPropertiesUpdater.processForImport(string2, properties, bl2);
                    }
                    if (bl2) {
                        databaseConnections.updateConnection(string2, string2, properties);
                        continue;
                    }
                    databaseConnections.addConnection(string2, properties);
                }
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
        }
    }

    private static Properties convertProps(Properties properties) {
        Properties properties2 = ((DatabaseProvider)CMHelper.createReferenceFromDescriptor((Properties)properties)).getProperties();
        if ("oraJDBC".equals(properties2.getProperty("subtype"))) {
            String string = properties2.getProperty("password");
            String string2 = properties2.getProperty("SavePassword");
            if (!ModelUtil.hasLength((String)string) && string2 == null) {
                properties2.setProperty("SavePassword", Boolean.FALSE.toString());
            }
        }
        return properties2;
    }

    private static List<ConnectionPropertiesUpdater> getUpdaters(String string) {
        ArrayList<ConnectionPropertiesUpdater> arrayList = new ArrayList<ConnectionPropertiesUpdater>();
        for (Class<? extends ConnectionPropertiesUpdater> clazz : s_updaters) {
            try {
                ConnectionPropertiesUpdater connectionPropertiesUpdater = clazz.newInstance();
                connectionPropertiesUpdater.setConnectionStore(string);
                arrayList.add(connectionPropertiesUpdater);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }
}

