/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.standalone.actions.ResetPasswordPanel;
import oracle.dbtools.raptor.standalone.connection.ConnectionUtils;
import oracle.dbtools.raptor.standalone.connection.RaptorConnectionCreator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class ResetPasswordAction
extends AbstractMenuAction {
    private static final Logger LOGGER = Logger.getLogger(ResetPasswordAction.class.getName());
    private static Boolean s_ociAvailable;

    private static boolean isOCIAvailable() {
        if (s_ociAvailable == null) {
            s_ociAvailable = Connections.isOCIDriverAvailable();
        }
        return s_ociAvailable;
    }

    public boolean isEnabled(Context context) {
        Element[] elementArray;
        boolean bl = false;
        if (ResetPasswordAction.isOCIAvailable() && (elementArray = context.getSelection()) != null && elementArray.length == 1) {
            bl = elementArray[0] instanceof DatabaseConnection && !((DatabaseConnection)elementArray[0]).isConnectionOpen();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() {
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getConnectionName();
        Element element = dBObject.getElement();
        if (((DatabaseConnection)element).isConnectionOpen()) {
            return;
        }
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        String string2 = properties.getProperty("user");
        Connection connection = null;
        try {
            if (ResetPasswordPanel.promptForNewPassword(properties)) {
                Properties properties2 = new Properties();
                properties2.putAll((Map<?, ?>)properties);
                properties2.setProperty("customUrl", ConnectionUtils.getOCIUrl(properties2));
                RaptorConnectionCreator raptorConnectionCreator = new RaptorConnectionCreator();
                connection = raptorConnectionCreator.getConnection(properties2);
                if (connection != null && ModelUtil.areEqual((Object)string2, (Object)properties.getProperty("user")) && Boolean.valueOf(properties.getProperty("SavePassword", Boolean.TRUE.toString())).booleanValue()) {
                    properties.setProperty("password", properties.getProperty("OCINewPassword"));
                    properties.remove("OCINewPassword");
                    String string3 = Connections.getStoreName((String)string);
                    String string4 = Connections.getConnectionName((String)string);
                    DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(string3);
                    try {
                        databaseConnections.updateConnection(string4, string4, properties);
                    }
                    catch (ConnectionException connectionException) {
                        LOGGER.log(Level.SEVERE, connectionException.getLocalizedMessage());
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException((Exception)sQLException, (String)string);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setArgs(String string) {
    }
}

