/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.standalone;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.dialogs.actions.RemoteDebug;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.NavWindow;
import oracle.dbtools.raptor.navigator.net.project.TransientNodeFactory;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;

public class RaptorContextSupport
implements NavWindow.ContextSupport,
TreeSelectionListener {
    private TreePath[] m_sel = new TreePath[0];
    private static Workspace s_wksp;
    private static Map<String, Project> s_projMap;
    private Project m_currentProj;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workspace getWorkspace() {
        Class<RaptorContextSupport> clazz = RaptorContextSupport.class;
        synchronized (RaptorContextSupport.class) {
            if (s_wksp == null) {
                try {
                    s_wksp = (Workspace)TransientNodeFactory.findOrCreate(Workspace.class, (String)(DatabaseNavigatorResources.getString((String)"PACKAGED_TAB_NAME") + ".jws"));
                    Workspaces workspaces = Ide.getWorkspaces();
                    workspaces.add((Element)s_wksp);
                }
                catch (IllegalAccessException illegalAccessException) {
                    DatabaseNavigatorManager.LOGGER.severe(illegalAccessException.getLocalizedMessage());
                }
                catch (InstantiationException instantiationException) {
                    DatabaseNavigatorManager.LOGGER.severe(instantiationException.getLocalizedMessage());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s_wksp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject(String string) {
        Class<RaptorContextSupport> clazz = RaptorContextSupport.class;
        synchronized (RaptorContextSupport.class) {
            Project project = s_projMap.get(string);
            if (project == null) {
                try {
                    project = (Project)TransientNodeFactory.findOrCreate(Project.class, (String)(string + ".jpr"));
                    String string2 = RunConfigurations.getActiveName((Project)project);
                    RunConfiguration runConfiguration = RunConfigurations.getRunConfigurationByName((Project)project, (String)string2);
                    if (runConfiguration == null) {
                        runConfiguration = new RunConfiguration();
                        runConfiguration.setName(string2);
                        RunConfigurations.addRunConfiguration((Project)project, (RunConfiguration)runConfiguration);
                        RunConfigurations.setActiveRunConfiguration((Project)project, (RunConfiguration)runConfiguration);
                    }
                    runConfiguration.setCompileBeforeRun(false);
                    runConfiguration.setConnectionName(string);
                    runConfiguration = RemoteDebug.getRemoteDebugConfiguration((Project)project);
                    runConfiguration.setConnectionName(string);
                    Workspace workspace = this.getWorkspace();
                    workspace.add((Element)project);
                    try {
                        project.save();
                        workspace.save();
                    }
                    catch (IOException iOException) {
                        DatabaseNavigatorManager.LOGGER.severe(iOException.getLocalizedMessage());
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    DatabaseNavigatorManager.LOGGER.severe(illegalAccessException.getLocalizedMessage());
                }
                catch (InstantiationException instantiationException) {
                    DatabaseNavigatorManager.LOGGER.severe(instantiationException.getLocalizedMessage());
                }
                s_projMap.put(string, project);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return project;
        }
    }

    public void attach(NavWindow navWindow) {
        navWindow.getTreeExplorer().getJTree().addTreeSelectionListener(this);
    }

    public void updateContext(Context context) {
        context.setProject(this.m_currentProj);
        context.setWorkspace(this.getWorkspace());
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        AbstractConnectionNode abstractConnectionNode;
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        TreePath[] treePathArray2 = new TreePath[this.m_sel.length + treePathArray.length];
        int n = 0;
        block4: for (TreePath treePath : this.m_sel) {
            for (TreePath treePath2 : treePathArray) {
                if (!treePath.equals(treePath2)) continue;
                if (treeSelectionEvent.isAddedPath(treePath2)) break;
                continue block4;
            }
            treePathArray2[n++] = treePath;
        }
        for (TreePath treePath : treePathArray) {
            if (!treeSelectionEvent.isAddedPath(treePath)) continue;
            treePathArray2[n++] = treePath;
        }
        if (n < treePathArray2.length) {
            abstractConnectionNode = treePathArray2;
            treePathArray2 = new TreePath[n];
            System.arraycopy(abstractConnectionNode, 0, treePathArray2, 0, n);
        }
        this.m_sel = treePathArray2;
        abstractConnectionNode = null;
        switch (this.m_sel.length) {
            case 0: {
                break;
            }
            case 1: {
                TNode tNode = (TNode)this.m_sel[0].getLastPathComponent();
                if (tNode == null) break;
                abstractConnectionNode = (AbstractConnectionNode)tNode.getAncestor(AbstractConnectionNode.class, true);
                break;
            }
            default: {
                for (TreePath treePath : this.m_sel) {
                    TNode tNode = (TNode)treePath.getLastPathComponent();
                    if (tNode == null) continue;
                    AbstractConnectionNode abstractConnectionNode2 = (AbstractConnectionNode)tNode.getAncestor(AbstractConnectionNode.class, true);
                    if (abstractConnectionNode == null) {
                        abstractConnectionNode = abstractConnectionNode2;
                        continue;
                    }
                    if (abstractConnectionNode2 == abstractConnectionNode) continue;
                    abstractConnectionNode = null;
                }
            }
        }
        this.m_currentProj = abstractConnectionNode != null ? this.getProject(abstractConnectionNode.getQualifiedConnectionName()) : null;
        this.getWorkspace().setActiveProject(this.m_currentProj);
    }

    static {
        s_projMap = new HashMap<String, Project>();
    }
}

