/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.folders;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import oracle.dbtools.raptor.BaseRaptorFilter;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolder;
import oracle.dbtools.raptor.navigator.folders.DatabasesFolderCache;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.data.PropertyStorage;

public final class DatabasesFilter
extends BaseRaptorFilter {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Comparator<TNode> s_comp = new C();
    private Map<String, DatabasesFolder> m_folders;
    private List<Element> m_children;
    private String m_storeID;
    private ConnectionListener m_renameListener;

    public Comparator<?> getComparator() {
        return s_comp;
    }

    public void setOwner(TNode tNode) {
        super.setOwner(tNode);
        Databases databases = tNode != null ? (Databases)tNode.getData() : null;
        this.m_storeID = databases != null ? databases.getStoreId() : null;
    }

    protected Object getKey(Object object) {
        if (object instanceof DatabaseConnection) {
            return "Store:" + ((DatabaseConnection)object).getQualifiedConnectionName();
        }
        if (object instanceof DatabasesFolder) {
            return "Folder:" + ((DatabasesFolder)((Object)object)).getName();
        }
        return null;
    }

    public TNode childrenAdded(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        block0: for (Object e : updateMessage.getAddObjects()) {
            DatabaseConnection databaseConnection = (DatabaseConnection)e;
            for (String string : databasesFolderCache.getFolders(this.m_storeID)) {
                if (!databasesFolderCache.getConnectionNames(this.m_storeID, string).contains(databaseConnection.getConnectionName())) continue;
                DatabasesFolder databasesFolder = this.m_folders.get(string);
                if (databasesFolder == null) {
                    databasesFolder = this.createFolder(string);
                    this.m_folders.put(string, databasesFolder);
                    this.m_children.add((Element)databasesFolder);
                    TNode tNode2 = treeExplorer.addChild((Element)databasesFolder, tNode, treeExplorer.getTreeModel());
                    this.cache(tNode2);
                }
                databasesFolder.add((Element)databaseConnection);
                UpdateMessage.fireChildAdded((Subject)databasesFolder, (Element)databaseConnection);
                continue block0;
            }
            this.m_children.add((Element)databaseConnection);
            TNode tNode3 = treeExplorer.addChild((Element)databaseConnection, tNode, treeExplorer.getTreeModel());
            this.cache(tNode3);
        }
        this.savePrefs();
        return tNode;
    }

    private void savePrefs() {
        if (!Ide.isStarting()) {
            try {
                Preferences preferences = Preferences.getPreferences();
                preferences.save();
            }
            catch (IOException iOException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, iOException.getLocalizedMessage());
            }
        }
    }

    private DatabasesFolder createFolder(String string) {
        DatabasesFolder databasesFolder = new DatabasesFolder(string);
        return databasesFolder;
    }

    public TNode childrenRemoved(UpdateMessage updateMessage, TNode tNode, TreeExplorer treeExplorer) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        for (Object e : updateMessage.getRemoveObjects()) {
            DatabaseConnection databaseConnection = (DatabaseConnection)e;
            TNode tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)databaseConnection, tNode);
            TNode tNode3 = (TNode)tNode2.getParent();
            if (tNode3 == tNode) {
                treeExplorer.removeChild(tNode2, treeExplorer.getTreeModel());
                continue;
            }
            DatabasesFolder databasesFolder = (DatabasesFolder)tNode3.getData();
            databasesFolder.remove((Element)databaseConnection);
            databasesFolderCache.removeConnection(this.m_storeID, databasesFolder.getName(), databaseConnection.getConnectionName());
            UpdateMessage.fireChildRemoved((Subject)databasesFolder, (Element)databaseConnection);
        }
        this.savePrefs();
        return tNode;
    }

    public TNode update(TNode tNode, UpdateMessage updateMessage) {
        return super.update(tNode, updateMessage);
    }

    public void closeChildren() {
        if (this.m_children != null) {
            this.m_children.clear();
            this.m_children = null;
            this.m_folders.clear();
            this.m_folders = null;
            this.clearRenameListener();
        }
    }

    public Iterator<Element> getChildren() {
        if (this.m_children == null) {
            boolean bl = false;
            this.m_children = new ArrayList<Element>();
            this.m_folders = new HashMap<String, DatabasesFolder>();
            this.initRenameListener();
            HashMap<String, DatabaseConnection> hashMap = new HashMap<String, DatabaseConnection>();
            DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
            Databases databases = (Databases)this.getOwner().getData();
            Iterator<String> iterator = databases.getChildren();
            while (iterator.hasNext()) {
                DatabaseConnection object = (DatabaseConnection)iterator.next();
                hashMap.put(object.getConnectionName(), object);
            }
            for (String string : databasesFolderCache.getFolders(this.m_storeID)) {
                DatabasesFolder databasesFolder = this.createFolder(string);
                for (String string2 : databasesFolderCache.getConnectionNames(this.m_storeID, string)) {
                    DatabaseConnection databaseConnection = (DatabaseConnection)hashMap.remove(string2);
                    if (databaseConnection != null) {
                        databasesFolder.add((Element)databaseConnection);
                        continue;
                    }
                    databasesFolderCache.removeConnection(this.m_storeID, string, string2);
                    bl = true;
                }
                if (databasesFolder.size() > 0) {
                    this.m_children.add((Element)databasesFolder);
                    this.m_folders.put(string, databasesFolder);
                    continue;
                }
                databasesFolderCache.removeFolder(this.m_storeID, string);
                bl = true;
            }
            if (bl) {
                this.savePrefs();
            }
            this.m_children.addAll(hashMap.values());
        }
        return this.m_children.iterator();
    }

    public String[] getFolderNames() {
        if (this.m_folders != null) {
            return this.m_folders.keySet().toArray(EMPTY_ARRAY);
        }
        return EMPTY_ARRAY;
    }

    public boolean renameFolder(String string, String string2) {
        DatabasesFolder databasesFolder = this.m_folders.remove(string);
        if (databasesFolder != null) {
            TNode tNode = this.lookup((Element)databasesFolder);
            if (tNode != null) {
                this.uncache(tNode);
            }
            databasesFolder.setName(string2);
            this.m_folders.put(string2, databasesFolder);
            if (tNode != null) {
                this.cache(tNode);
            }
            DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
            databasesFolderCache.renameFolder(this.m_storeID, string, string2);
            this.savePrefs();
            UpdateMessage.fireObjectRenamed((Subject)databasesFolder);
            return true;
        }
        return false;
    }

    public void updateFolder(String string, Element[] elementArray) {
        if (elementArray == null || elementArray.length == 0) {
            return;
        }
        TNode tNode = this.getOwner();
        TreeExplorer treeExplorer = tNode.getOwner();
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        DefaultTreeModel defaultTreeModel = treeExplorer.getTreeModel();
        if (string != null) {
            TNode tNode2;
            DatabasesFolder databasesFolder = this.m_folders.get(string);
            if (databasesFolder == null) {
                databasesFolder = this.createFolder(string);
                this.m_folders.put(string, databasesFolder);
                this.m_children.add((Element)databasesFolder);
                tNode2 = treeExplorer.addChild((Element)databasesFolder, tNode, defaultTreeModel);
                this.cache(tNode2);
            } else {
                tNode2 = this.lookup((Element)databasesFolder);
            }
            treeExplorer.addChildren(tNode2);
            DatabasesFolder databasesFolder2 = this.getParent(elementArray[0]);
            if (databasesFolder2 == null) {
                for (Element element : elementArray) {
                    databasesFolder.add(element);
                    databasesFolderCache.addConnection(this.m_storeID, string, ((DatabaseConnection)element).getConnectionName());
                    this.reparentNode(tNode, tNode2, element);
                    this.m_children.remove(element);
                }
            } else if (databasesFolder2 != databasesFolder) {
                TNode tNode3 = this.lookup((Element)databasesFolder2);
                ArrayList<Element> arrayList = new ArrayList<Element>();
                for (Element element : elementArray) {
                    if (databasesFolder2.remove(element)) {
                        arrayList.add(element);
                        databasesFolderCache.removeConnection(this.m_storeID, databasesFolder2.getName(), ((DatabaseConnection)element).getConnectionName());
                    }
                    databasesFolder.add(element);
                    databasesFolderCache.addConnection(this.m_storeID, string, ((DatabaseConnection)element).getConnectionName());
                    this.reparentNode(tNode, tNode2, element);
                }
            }
        } else {
            DatabasesFolder databasesFolder = this.getParent(elementArray[0]);
            if (databasesFolder != null) {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                for (Element element : elementArray) {
                    TNode tNode4;
                    if (databasesFolder.remove(element)) {
                        arrayList.add(element);
                        databasesFolderCache.removeConnection(this.m_storeID, databasesFolder.getName(), ((DatabaseConnection)element).getConnectionName());
                    }
                    if ((tNode4 = this.reparentNode(tNode, tNode, element)) == null) {
                        tNode4 = treeExplorer.addChild(element, tNode, defaultTreeModel);
                        this.cache(tNode4);
                    }
                    this.m_children.add(element);
                }
            }
        }
        this.savePrefs();
    }

    private TNode reparentNode(TNode tNode, TNode tNode2, Element element) {
        TreeExplorer treeExplorer = tNode.getOwner();
        DefaultTreeModel defaultTreeModel = treeExplorer.getTreeModel();
        TNode tNode3 = this.lookup(element);
        if (tNode3 == null) {
            tNode3 = treeExplorer.searchTNodeBreadthFirst(element, tNode);
        }
        if (tNode3 != null) {
            defaultTreeModel.removeNodeFromParent((MutableTreeNode)tNode3);
            if (tNode2 != null) {
                defaultTreeModel.insertNodeInto((MutableTreeNode)tNode3, (MutableTreeNode)tNode2, tNode2.getChildCount());
            }
        }
        return tNode3;
    }

    private DatabasesFolder getParent(Element element) {
        Iterator<Element> iterator = this.getChildren();
        while (iterator.hasNext()) {
            Element element2 = iterator.next();
            if (!(element2 instanceof DatabasesFolder) || !((DatabasesFolder)element2).containsChild(element)) continue;
            return (DatabasesFolder)element2;
        }
        return null;
    }

    public void removeFolder(String string) {
        DatabasesFolder databasesFolder = this.m_folders.remove(string);
        if (databasesFolder != null) {
            DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
            databasesFolderCache.removeFolder(this.m_storeID, string);
            TNode tNode = this.getOwner();
            TreeExplorer treeExplorer = tNode.getOwner();
            DefaultTreeModel defaultTreeModel = treeExplorer.getTreeModel();
            TNode tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)databasesFolder, tNode);
            if (tNode2 != null) {
                Enumeration enumeration = tNode2.getChildTNodes();
                while (enumeration.hasMoreElements()) {
                    TNode tNode3 = (TNode)enumeration.nextElement();
                    this.cache(tNode3);
                    defaultTreeModel.insertNodeInto((MutableTreeNode)tNode3, (MutableTreeNode)tNode, tNode.getChildCount());
                }
                if (this.m_children != null) {
                    this.m_children.remove(tNode2.getData());
                }
            }
            this.savePrefs();
            treeExplorer.removeChild(tNode2, defaultTreeModel);
        }
    }

    private void handleConnectionRename(String string, String string2) {
        DatabasesFolderCache databasesFolderCache = DatabasesFolderCache.getInstance((PropertyStorage)Preferences.getPreferences());
        String string3 = Connections.getConnectionName((String)string);
        String string4 = Connections.getConnectionName((String)string2);
        for (String string5 : databasesFolderCache.getFolders(this.m_storeID)) {
            if (!databasesFolderCache.getConnectionNames(this.m_storeID, string5).contains(string3)) continue;
            databasesFolderCache.removeConnection(this.m_storeID, string5, string3);
            databasesFolderCache.addConnection(this.m_storeID, string5, string4);
            break;
        }
    }

    private void initRenameListener() {
        this.m_renameListener = new ConnectionListener(){

            public void connectionAdded(ConnectionEvent connectionEvent) {
            }

            public void connectionClosed(ConnectionEvent connectionEvent) {
            }

            public void connectionModified(ConnectionEvent connectionEvent) {
                DatabasesFilter.this.handleConnectionRename(connectionEvent.getOldName(), connectionEvent.getConnectionName());
            }

            public void connectionOpened(ConnectionEvent connectionEvent) {
            }

            public void connectionRemoved(ConnectionEvent connectionEvent) {
            }

            public void connectionRenamed(ConnectionEvent connectionEvent) {
                DatabasesFilter.this.handleConnectionRename(connectionEvent.getOldName(), connectionEvent.getConnectionName());
            }
        };
        Connections.getInstance().addConnectionListener(this.m_renameListener);
    }

    private void clearRenameListener() {
        Connections.getInstance().removeConnectionListener(this.m_renameListener);
        this.m_renameListener = null;
    }

    private static class C
    implements Comparator<TNode> {
        private Comparator<Object> m_default = Collator.getInstance();

        private C() {
        }

        @Override
        public int compare(TNode tNode, TNode tNode2) {
            Element element = tNode.getData();
            Element element2 = tNode2.getData();
            return element.getClass() == element2.getClass() ? this.compareSameTypes(element, element2) : this.compareDifferentTypes(element, element2);
        }

        private int compareSameTypes(Element element, Element element2) {
            return this.m_default.compare(element.getShortLabel(), element2.getShortLabel());
        }

        private int compareDifferentTypes(Element element, Element element2) {
            return element instanceof DatabasesFolder ? -1 : 1;
        }

        @Override
        public boolean equals(Object object) {
            return object != null && object.getClass() == this.getClass();
        }
    }
}

