/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.layout.ResetLayoutController;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.ideimpl.window.WindowFlatWindows;
import oracle.ideri.util.Product;

public final class WindowManagerImpl
implements MenuListener,
Controller,
Addin {
    public static final float WEIGHT_WINDOW_MENU = MenuConstants.increment((float)MenuConstants.WEIGHT_TOOLS_MENU);
    public static final float SECTION_WINDOW_LAYOUTS = 1.0f;
    public static final float SECTION_WINDOW_CLOSE = MenuConstants.increment((float)1.0f);
    public static final float SECTION_WINDOW_SYSTEM = MenuConstants.increment((float)SECTION_WINDOW_CLOSE);
    public static final float SECTION_WINDOW_SPLITS = MenuConstants.increment((float)SECTION_WINDOW_SYSTEM);
    public static final float SECTION_WINDOW_NEW_FREEZE = MenuConstants.increment((float)SECTION_WINDOW_SPLITS);
    public static final float SECTION_WINDOW_ADDINS = MenuConstants.increment((float)SECTION_WINDOW_NEW_FREEZE);
    public static final float SECTION_WINDOW_WINDOW_LIST = MenuConstants.increment((float)SECTION_WINDOW_ADDINS);
    @Deprecated
    public static final float SECTION_WINDOW_WINDOWS = MenuConstants.increment((float)SECTION_WINDOW_WINDOW_LIST);
    @Deprecated
    public static final float SECTION_WINDOW_GOTO = SECTION_WINDOW_ADDINS;
    private static final String NAVIGATE_WINDOWS_MENU_ID = "Navigate.WindowsMenu";
    private static final String ASSIGN_ACCELERATOR_MENU_ID = "Window.AssignFileAcceleratorMenu";

    public void initialize() {
        this.createActions();
        if (!Product.isRaptor()) {
            Menubar menuMgr = Ide.getMenubar();
            JMenu windowMenu = menuMgr.createMenu(IdeArb.getString((int)192), WEIGHT_WINDOW_MENU, SECTION_WINDOW_ADDINS);
            windowMenu.addMenuListener(this);
            MenuManager.putJMenu((String)"Window", (JMenu)windowMenu);
            menuMgr.add((Component)windowMenu);
        }
    }

    private void createActions() {
        AddinManager addMgr = AddinManager.getAddinManager();
        IdeAction actionNextWindow = IdeAction.get((int)42, (String)addMgr.getCommand(42, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)331), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)IdeArb.getInteger((int)332), (ArrayResourceBundle)IdeArb.getInstance(), (int)333, null, (boolean)false);
        actionNextWindow.addController((Controller)this);
        IdeAction actionPrevWindow = IdeAction.get((int)43, (String)addMgr.getCommand(43, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)334), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)IdeArb.getInteger((int)335), (ArrayResourceBundle)IdeArb.getInstance(), (int)336, null, (boolean)false);
        actionPrevWindow.addController((Controller)this);
        IdeAction actionWindowsDotDotDot = IdeAction.get((int)61, (String)addMgr.getCommand(61, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)194), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)IdeArb.getInteger((int)195), null, null, (boolean)false);
        actionWindowsDotDotDot.addController((Controller)this);
        Menubar menuMgr = Ide.getMenubar();
        JMenu menuNavigateWindows = this.fillNavigateWIndowsMenu(menuMgr);
        MenuManager.putJMenu((String)NAVIGATE_WINDOWS_MENU_ID, (JMenu)menuNavigateWindows);
        menuMgr.add((Component)menuNavigateWindows, IdeMenus.findOrCreateJMenu("Navigate"), MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
    }

    private Controller getController(Context context) {
        View view = context.getView();
        Component c = view.getGUI();
        if (SwingUtilities.getAncestorOfClass(TitledPanel.class, c) != null) {
            return DockStation.getDockStation();
        }
        return EditorManager.getEditorManager();
    }

    private void whenWindowsDotDotDot() {
        WindowFlatWindows.runDialog((Frame)Ide.getMainWindow());
        EditorManager.getEditorManager().activateCurrentEditorFrame();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int nCmdID = action.getCommandId();
        switch (nCmdID) {
            case 42: 
            case 43: {
                this.getController(context).handleEvent(action, context);
                break;
            }
            case 61: {
                this.whenWindowsDotDotDot();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        int nCmdID = action.getCommandId();
        switch (nCmdID) {
            case 42: 
            case 43: {
                this.getController(context).update(action, context);
                break;
            }
            case 61: {
                Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
                boolean hasEditorOpen = currentEditor != null;
                action.setEnabled(hasEditorOpen);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void fillWindowMenu(JMenu windowMenu) {
        Menubar menuMgr = Ide.getMenubar();
        windowMenu.removeAll();
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.SPLIT_DOCUMENT_CMD_ID)), windowMenu, SECTION_WINDOW_SPLITS);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.UNSPLIT_DOCUMENT_CMD_ID)), windowMenu, SECTION_WINDOW_SPLITS);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.DETACH_DOCUMENT_CMD_ID)), windowMenu, SECTION_WINDOW_SPLITS);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.REGROUP_DOCUMENTS_CMD_ID)), windowMenu, SECTION_WINDOW_SPLITS);
        if (Product.isJDeveloper()) {
            JMenuItem menuResetWindows = menuMgr.createMenuItem((ToggleAction)ResetLayoutController.resetWindowsAction());
            menuResetWindows.setName("resetWindowsToFactorySettings");
            menuMgr.add((Component)menuResetWindows, windowMenu, 1.0f);
        }
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeActions.getViewNewViewAction()), windowMenu, SECTION_WINDOW_NEW_FREEZE);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeActions.getViewFreezeAction()), windowMenu, SECTION_WINDOW_NEW_FREEZE);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.SYSTEM_MENU_CMD_ID)), windowMenu, SECTION_WINDOW_SYSTEM);
        JMenu menuAssign = this.fillAssignMenu(menuMgr);
        menuAssign.putClientProperty("menu-weight", Float.valueOf(1.0f));
        MenuManager.putJMenu((String)ASSIGN_ACCELERATOR_MENU_ID, (JMenu)menuAssign);
        menuMgr.add((Component)menuAssign, windowMenu, SECTION_WINDOW_WINDOW_LIST);
        EditorManagerImpl em = (EditorManagerImpl)EditorManager.getEditorManager();
        List windowList = em.getWindowList();
        int n = windowList.size();
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                JMenuItem item = (JMenuItem)windowList.get(i);
                item.putClientProperty("menu-weight", Float.valueOf(2.0f));
                menuMgr.add((Component)item, windowMenu, SECTION_WINDOW_WINDOW_LIST);
            }
        }
        IdeAction windowDotDotDotAction = IdeAction.find((int)61);
        JMenuItem menuWindowsDotDotDot = menuMgr.createMenuItem((ToggleAction)windowDotDotDotAction, 3.0f);
        menuMgr.add((Component)menuWindowsDotDotDot, windowMenu, SECTION_WINDOW_WINDOW_LIST);
        windowDotDotDotAction.updateAction();
    }

    private JMenu fillNavigateWIndowsMenu(Menubar menuMgr) {
        float section = 1.0f;
        String navWindowsString = IdeImplArb.getString(0);
        String navWindowsLabel = StringUtils.stripMnemonic((String)navWindowsString);
        Integer gotoMnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)navWindowsString));
        JMenu menuGoTo = menuMgr.createSubMenu(navWindowsLabel, gotoMnemonic, MenuConstants.WEIGHT_NAVIGATE_GO_TO_WINDOWS);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.SHOW_DROPDOWN_CMD_ID)), menuGoTo, section);
        JMenuItem nextEditorFrameMenuItem = menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)42));
        menuMgr.add((Component)nextEditorFrameMenuItem, menuGoTo, section += 1.0f);
        JMenuItem prevEditorFrameMenuItem = menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)43));
        menuMgr.add((Component)prevEditorFrameMenuItem, menuGoTo, section);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)70)), menuGoTo, section += 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)71)), menuGoTo, section);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.NEXT_PANE_CMD_ID)), menuGoTo, section += 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)EditorManagerImpl.PREV_PANE_CMD_ID)), menuGoTo, section);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)41)), menuGoTo, section += 1.0f);
        menuMgr.add((Component)menuMgr.createMenuItem((ToggleAction)IdeAction.find((int)40)), menuGoTo, section);
        return menuGoTo;
    }

    private JMenu fillAssignMenu(Menubar menuMgr) {
        float section = 1.0f;
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        String assignString = IdeImplArb.getString(2);
        String assignLabel = StringUtils.stripMnemonic((String)assignString);
        Integer mnemonic = StringUtils.getMnemonicKeyCode((String)assignString);
        JMenu menuAssign = menuMgr.createSubMenu(assignLabel, mnemonic);
        for (int i = 0; i < 9; ++i) {
            int assignCmdId = editorManager.getAssignCmdId(i);
            IdeAction action = IdeAction.find((int)assignCmdId);
            JMenuItem assignMenuItem = menuMgr.createMenuItem((ToggleAction)action);
            menuMgr.add((Component)assignMenuItem, menuAssign, section);
        }
        return menuAssign;
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.fillWindowMenu(MenuManager.getJMenu((String)"Window"));
    }
}

