/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.viewers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import oracle.ide.Context;
import oracle.ide.controls.ThinBevel;
import oracle.ide.editor.Editor;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.model.ImageNode;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ideimpl.resource.ViewersArb;
import oracle.javatools.editor.plugins.StatusBarPlugin;

public class ImageViewer
extends Editor {
    private static final Border THIN_BEVEL_BORDER = BorderFactory.createCompoundBorder((Border)new ThinBevel(1), StatusBarPlugin.EMPTY_BORDER);
    private JPanel mainPanel;
    private ImageNode imageNode;

    public void setContext(Context context) {
        if (context == null) {
            this.imageNode = null;
            return;
        }
        Node node = context.getNode();
        if (!(node instanceof ImageNode)) {
            return;
        }
        this.imageNode = (ImageNode)node;
        super.setContext(context);
    }

    public Object getEditorAttribute(String attribute) {
        if (attribute == "old_editor") {
            return Boolean.TRUE;
        }
        return super.getEditorAttribute(attribute);
    }

    public void open() {
        if (this.imageNode == null) {
            return;
        }
        try {
            this.imageNode.open();
        }
        catch (IOException e) {
            throw new OpenAbortedException("Unable to open image", (Throwable)e);
        }
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public void close() {
        super.close();
        this.mainPanel = null;
        this.imageNode = null;
    }

    public Component getGUI() {
        return this.createGUI();
    }

    private Component createGUI() {
        if (this.mainPanel != null) {
            return this.mainPanel;
        }
        Image image = this.imageNode != null ? this.imageNode.getImage() : null;
        ImageIcon icon = image != null ? new ImageIcon(image) : null;
        ScrollableImage view = new ScrollableImage(icon);
        AccessibleContext ac = view.getAccessibleContext();
        if (ac != null) {
            ac.setAccessibleName(ViewersArb.getString(4));
        }
        view.setBorder(BorderFactory.createLineBorder(Color.red));
        JScrollPane scrollPane = new JScrollPane(view);
        scrollPane.setBorder(CUSTOM_BORDER);
        scrollPane.setViewportBorder(null);
        scrollPane.getViewport().setBackground(Color.white);
        String msg = icon != null ? ViewersArb.format(3, icon.getIconWidth(), icon.getIconHeight()) : null;
        JLabel statusCell = new JLabel(msg);
        statusCell.setBorder(THIN_BEVEL_BORDER);
        JPanel statusBar = new JPanel(new BorderLayout());
        statusBar.add((Component)statusCell, "Center");
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)scrollPane, "Center");
        this.mainPanel.add((Component)statusBar, "South");
        return this.mainPanel;
    }

    private static final class ScrollableImage
    extends JLabel
    implements Scrollable {
        private final int unitIncrement = 16;

        ScrollableImage(Icon icon) {
            super(icon);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            int currentPos = orientation == 0 ? visibleRect.x : visibleRect.y;
            if (direction < 0) {
                int newPos = currentPos - currentPos / 16 * 16;
                return newPos == 0 ? 16 : newPos;
            }
            return (currentPos / 16 + 1) * 16 - currentPos;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return visibleRect.width - 16;
            }
            return visibleRect.height - 16;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

