/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.print;

import java.awt.Component;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.net.URL;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PageableFactory;
import oracle.ide.print.PrintManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.View;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.print.FactoryRegistry;
import oracle.ideimpl.print.PrintThread;

public class PrintManagerImpl
extends PrintManager
implements Controller,
Addin {
    private PageFormat mPageFormat = new PageFormat();
    private int mPrintThreadCount = 0;
    private FactoryRegistry mFactoryRegistry = new FactoryRegistry();
    private PrinterJob mPrinterJob;
    private Printable mPrintable;
    private Pageable mPageable;
    private Pageable[] mPageables;
    private PrintRequestAttributeSet mPrintRequestAttributeSet;

    public PrintManagerImpl() {
        this.mFactoryRegistry.registerPageableFactory("oracle.ide.model.TextNode", "oracle.ide.ceditor.EditorPageableFactory");
    }

    public void initialize() {
        PrintManager.setPrintManager((PrintManager)this);
        Menubar menuMgr = Ide.getMenubar();
        JMenu fileMenu = MenuManager.getJMenu((String)"File");
        menuMgr.add((Component)this.createPrinterSetupMenuItem(), fileMenu, MenuConstants.SECTION_FILE_PRINT);
        menuMgr.add((Component)this.createPrinterMenuItem(), fileMenu, MenuConstants.SECTION_FILE_PRINT);
    }

    private JMenuItem createPrinterSetupMenuItem() {
        return IdeMenus.createMenuItem(this, 15, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString((int)70), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger((int)71), IdeArb.getInstance(), 72, null, true, MenuConstants.WEIGHT_FILE_PAGE_SETUP);
    }

    private JMenuItem createPrinterMenuItem() {
        return IdeMenus.createMenuItem(this, 16, "oracle.ide.cmd.NotImplementedCommand", IdeArb.getString((int)73), IdeMainWindow.ACTION_CATEGORY_FILE, IdeArb.getInteger((int)74), IdeArb.getInstance(), 75, null, false, MenuConstants.WEIGHT_FILE_PRINT);
    }

    public void setPrintable(Printable printable, PageFormat pageFormat) {
        this.mPrintable = printable;
        this.mPageFormat = pageFormat;
    }

    public void setPageable(Pageable pageable) {
        this.mPageable = pageable;
    }

    public void setPageables(Pageable[] pageables) {
        this.mPageables = pageables;
    }

    public boolean registerDocumentPrintFactory(Class viewClass, Class documentPrintFactoryClass) {
        return this.mFactoryRegistry.registerDocumentPrintFactory(viewClass, documentPrintFactoryClass);
    }

    public void unregisterDocumentPrintFactory(Class viewClass) {
        this.mFactoryRegistry.unregisterDocumentPrintFactory(viewClass);
    }

    public Pageable createPageableForObject(Object object) {
        return this.createPageableForObject(null, object);
    }

    public Pageable createPageableForObject(Context context, Object object) {
        PageableFactory pageableFactory = this.mFactoryRegistry.getPageableFactory(object);
        if (pageableFactory != null) {
            Pageable pageable = pageableFactory.create(context, object, this.mPageFormat);
            pageableFactory = null;
            return pageable;
        }
        return null;
    }

    public PageFormat getPageFormat() {
        return this.mPageFormat;
    }

    public void setPageFormat(PageFormat parPageFormat) {
        this.mPageFormat = parPageFormat;
    }

    void incrementPrintThread() {
        ++this.mPrintThreadCount;
    }

    void decrementPrintThread() {
        --this.mPrintThreadCount;
    }

    private void showPageDialog() {
        if (!this.hasPrintServices()) {
            return;
        }
        if (this.mPrinterJob == null) {
            this.mPrinterJob = PrinterJob.getPrinterJob();
        }
        if (this.mPrintRequestAttributeSet == null) {
            this.mPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        this.mPageFormat = this.mPrinterJob.pageDialog(this.mPrintRequestAttributeSet);
    }

    private boolean hasPrintServices() {
        PrintService[] printServices = PrinterJob.lookupPrintServices();
        if (printServices == null || printServices.length == 0) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), IdeArb.getString((int)486), IdeArb.getString((int)485), 0);
            return false;
        }
        return true;
    }

    private void print(final Context context) {
        if (!this.hasPrintServices()) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                DocumentPrintFactory documentPrintFactory;
                if (PrintManagerImpl.this.mPrinterJob == null) {
                    PrintManagerImpl.this.mPrinterJob = PrinterJob.getPrinterJob();
                }
                PrintManagerImpl.this.mPrintable = null;
                PrintManagerImpl.this.mPageable = null;
                PrintManagerImpl.access$302(PrintManagerImpl.this, null);
                Node locatable = context.getNode();
                if (locatable != null) {
                    PrintManagerImpl.this.mPrinterJob.setJobName(URLFileSystem.getPlatformPathName((URL)locatable.getURL()));
                }
                if ((documentPrintFactory = PrintManagerImpl.this.mFactoryRegistry.getDocumentPrintFactory(context.getView().getClass())) == null) {
                    return null;
                }
                documentPrintFactory.create(context);
                if (PrintManagerImpl.this.mPrintable != null || PrintManagerImpl.this.mPageable != null || PrintManagerImpl.this.mPageables != null) {
                    if (PrintManagerImpl.this.mPrintable != null) {
                        PrintManagerImpl.this.mPrinterJob.setPrintable(PrintManagerImpl.this.mPrintable, PrintManagerImpl.this.mPageFormat);
                    } else if (PrintManagerImpl.this.mPageable != null) {
                        PrintManagerImpl.this.mPrinterJob.setPageable(PrintManagerImpl.this.mPageable);
                    } else if (PrintManagerImpl.this.mPageables != null) {
                        PrintManagerImpl.this.mPrinterJob.setPageable(PrintManagerImpl.this.mPageables[0]);
                    }
                }
                if (PrintManagerImpl.this.mPrintRequestAttributeSet == null) {
                    PrintManagerImpl.this.mPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                }
                if (PrintManagerImpl.this.mPrinterJob.printDialog(PrintManagerImpl.this.mPrintRequestAttributeSet)) {
                    if (PrintManagerImpl.this.mPageFormat == null) {
                        PrintManagerImpl.this.mPageFormat = new PageFormat();
                    }
                    int beginOrientation = PrintManagerImpl.this.mPageFormat.getOrientation();
                    OrientationRequested req = (OrientationRequested)PrintManagerImpl.this.mPrintRequestAttributeSet.get(OrientationRequested.class);
                    if (req != null) {
                        if (req == OrientationRequested.LANDSCAPE && beginOrientation != 0) {
                            PrintManagerImpl.this.mPageFormat.setOrientation(0);
                            documentPrintFactory.create(context);
                        } else if ((req == OrientationRequested.PORTRAIT || req == OrientationRequested.REVERSE_PORTRAIT) && beginOrientation != 1) {
                            PrintManagerImpl.this.mPageFormat.setOrientation(1);
                            documentPrintFactory.create(context);
                        } else if (req == OrientationRequested.REVERSE_LANDSCAPE && beginOrientation != 2) {
                            PrintManagerImpl.this.mPageFormat.setOrientation(2);
                            documentPrintFactory.create(context);
                        }
                    }
                    if (PrintManagerImpl.this.mPrintable != null || PrintManagerImpl.this.mPageable != null || PrintManagerImpl.this.mPageables != null) {
                        Thread printThread = null;
                        if (PrintManagerImpl.this.mPrintable != null) {
                            printThread = new PrintThread(PrintManagerImpl.this.mPrintable, PrintManagerImpl.this.mPrinterJob, PrintManagerImpl.this.mPrintRequestAttributeSet);
                        } else if (PrintManagerImpl.this.mPageable != null) {
                            printThread = new PrintThread(PrintManagerImpl.this.mPageable, PrintManagerImpl.this.mPrinterJob, PrintManagerImpl.this.mPrintRequestAttributeSet);
                        } else if (PrintManagerImpl.this.mPageables != null) {
                            printThread = new PrintThread(PrintManagerImpl.this.mPageables, PrintManagerImpl.this.mPrinterJob, PrintManagerImpl.this.mPrintRequestAttributeSet);
                        }
                        printThread.setPriority(printThread.getPriority() - 1);
                        printThread.start();
                    }
                } else {
                    PrintManagerImpl.this.mPrintable = null;
                    PrintManagerImpl.this.mPageable = null;
                    PrintManagerImpl.access$302(PrintManagerImpl.this, null);
                }
                return null;
            }

            public void finished() {
                View aView = context.getView();
                if (aView != null) {
                    aView.getGUI().requestFocusInWindow();
                }
            }
        };
        worker.start();
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 16) {
            boolean enabled = false;
            if (context == null) {
                enabled = false;
            } else {
                DocumentPrintFactory documentPrintFactory = this.mFactoryRegistry.getDocumentPrintFactory(context.getView().getClass());
                if (documentPrintFactory == null) {
                    enabled = false;
                } else if (documentPrintFactory.isPrintingEnabled(context)) {
                    enabled = true;
                    documentPrintFactory = null;
                } else {
                    enabled = false;
                }
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 15) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, final Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 16) {
            this.print(context);
            return true;
        }
        if (cmdId == 15) {
            SwingWorker worker = new SwingWorker(){

                public Object construct() {
                    PrintManagerImpl.this.showPageDialog();
                    return this;
                }

                public void finished() {
                    View aView;
                    if (context != null && (aView = context.getView()) != null) {
                        aView.getGUI().requestFocusInWindow();
                    }
                }
            };
            worker.start();
            return true;
        }
        return false;
    }

    static /* synthetic */ Pageable[] access$302(PrintManagerImpl x0, Pageable[] x1) {
        x0.mPageables = x1;
        return x1;
    }
}

