/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyUtil;

final class TreeUIHelper {
    private static final String CANCEL_ACTION = "cancel";
    private JTree tree;

    TreeUIHelper(JTree tree) {
        this.tree = tree;
    }

    void installKeyboardActionsHook() {
        ActionMap actionMap = this.tree.getActionMap();
        actionMap.put(CANCEL_ACTION, new TreeCancelEditingAction());
        KeyStroke[] keyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(10, 0)};
        KeyUtil.removeKeyStrokesFromInputMaps((JComponent)this.tree, (KeyStroke[])keyStrokes);
    }

    private class TreeCancelEditingAction
    extends AbstractAction {
        private TreeCancelEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TreeUIHelper.this.tree != null) {
                TreeUIHelper.this.tree.cancelEditing();
            }
        }

        @Override
        public boolean isEnabled() {
            return TreeUIHelper.this.tree != null && TreeUIHelper.this.tree.isEnabled() && TreeUIHelper.this.tree.isEditing();
        }
    }
}

