/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;

public class ImageIconUIResource
extends ImageIcon
implements UIResource {
    private Icon icon;
    private boolean nullConversionFailed;

    public ImageIconUIResource(Icon icon) {
        this.icon = icon;
    }

    @Override
    public Image getImage() {
        if (this.icon != null && !this.nullConversionFailed) {
            this.nullConversion();
        }
        return super.getImage();
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        this.icon = null;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.icon != null) {
            this.componentConversion(c);
        }
        if (!this.nullConversionFailed && super.getImage() != null) {
            super.paintIcon(c, g, x, y);
        } else if (this.icon != null) {
            this.icon.paintIcon(c, g, x, y);
        }
    }

    @Override
    public int getIconHeight() {
        return this.icon != null ? this.icon.getIconHeight() : super.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon != null ? this.icon.getIconWidth() : super.getIconWidth();
    }

    private void nullConversion() {
        if (this.convertToImage(null)) {
            this.icon = null;
        } else {
            this.nullConversionFailed = true;
        }
    }

    private void componentConversion(Component c) {
        if (!this.nullConversionFailed) {
            this.nullConversion();
        }
        if (this.nullConversionFailed && c != null) {
            this.convertToImage(c);
        }
    }

    private boolean convertToImage(Component c) {
        boolean success;
        Image image = this.createImage();
        if (image == null) {
            return false;
        }
        Graphics gImage = image.getGraphics();
        try {
            this.icon.paintIcon(c, gImage, 0, 0);
            success = true;
        }
        catch (Exception ex) {
            success = false;
        }
        return success;
    }

    private Image createImage() {
        Image image = super.getImage();
        if (this.icon != null) {
            int w = this.icon.getIconWidth();
            int h = this.icon.getIconHeight();
            if (w != 0 && h != 0 && (image == null || w != image.getWidth(null) || h != image.getHeight(null))) {
                image = new BufferedImage(w, h, 2);
                super.setImage(image);
            }
        }
        return image;
    }
}

