/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.net;

import java.net.URLStreamHandlerFactory;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public final class URLFileSystemHook
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem";
    private static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "urlfilesystem-hook");
    private static final ElementName STREAMFACTORY = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "streamfactory");
    private static final ElementName FSHELPER = new ElementName("http://xmlns.oracle.com/jdeveloper/hooks/urlfilesystem", "fshelper");
    private final ElementVisitor _streamFactoryHandler = new StreamFactoryHandler();
    private final ElementVisitor _helperHandler = new HelperHandler();

    public void start(ElementStartContext context) {
        context.registerChildVisitor(STREAMFACTORY, this._streamFactoryHandler);
        context.registerChildVisitor(FSHELPER, this._helperHandler);
    }

    private class HelperHandler
    extends ElementVisitor {
        private HelperHandler() {
        }

        public void start(ElementStartContext context) {
            String protocol = context.getAttributeValue("protocol");
            String className = context.getAttributeValue("class");
            if (protocol == null) {
                context.getLogger().severe("Required attribute protocol missing from helper");
                return;
            }
            if (className == null) {
                context.getLogger().severe("Required attribute class missing from helper");
                return;
            }
            try {
                Class<?> cls = Class.forName(className);
                URLFileSystemHelper helper = (URLFileSystemHelper)cls.newInstance();
                URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)helper);
            }
            catch (Exception e) {
                context.getLogger().severe("Failed to create helper class " + className);
            }
        }
    }

    private class StreamFactoryHandler
    extends ElementVisitor {
        private StreamFactoryHandler() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null) {
                context.getLogger().severe("Missing required attribute 'class'");
                return;
            }
            try {
                Class<?> cls = Class.forName(className);
                URLStreamHandlerFactory factory = (URLStreamHandlerFactory)cls.newInstance();
                URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)factory);
            }
            catch (Exception e) {
                context.getLogger().severe("Failed to create stream factory class " + className);
            }
        }
    }
}

