/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.ui;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Reference;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLPath;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.ideimpl.navigator.delete.model.OptionalFolder;
import oracle.ideimpl.navigator.delete.model.ProjectModel;
import oracle.ideimpl.navigator.delete.model.TopLevelContentsFile;
import oracle.ideimpl.navigator.delete.ui.IdeModelTree;

public class IdeModelTreeBuilder {
    private final DefaultMutableTreeNode m_treeRoot = new DefaultMutableTreeNode("root");
    private final List<DefaultMutableTreeNode> m_workspaces = new ArrayList<DefaultMutableTreeNode>();
    private final List<DefaultMutableTreeNode> m_projects = new ArrayList<DefaultMutableTreeNode>();
    private final List<DefaultMutableTreeNode> m_outsideProjectSourcePaths = new ArrayList<DefaultMutableTreeNode>();
    private final List<DefaultMutableTreeNode> m_folders = new ArrayList<DefaultMutableTreeNode>();
    private static final FileFilter FILE_ONLY_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile();
        }
    };
    private static Comparator FILE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            int dir = this.compareForDirectory(f1, f2);
            if (dir == 0) {
                int hidden = this.compareForHidden(f1, f2);
                return hidden != 0 ? hidden : String.CASE_INSENSITIVE_ORDER.compare(f1.getPath(), f2.getPath());
            }
            return dir;
        }

        private int compareForDirectory(File f1, File f2) {
            if (f1.isDirectory()) {
                if (f2.isDirectory()) {
                    return String.CASE_INSENSITIVE_ORDER.compare(f1.getPath(), f2.getPath());
                }
                return 1;
            }
            if (f2.isDirectory()) {
                return -1;
            }
            return 0;
        }

        private int compareForHidden(File f1, File f2) {
            if (!f1.isHidden()) {
                if (!f2.isHidden()) {
                    return String.CASE_INSENSITIVE_ORDER.compare(f1.getPath(), f2.getPath());
                }
                return 1;
            }
            if (!f2.isHidden()) {
                return -1;
            }
            return 0;
        }
    };

    public IdeModelTree build() {
        for (DefaultMutableTreeNode wspnode : this.m_workspaces) {
            this.m_treeRoot.add(wspnode);
        }
        for (DefaultMutableTreeNode projectNode : this.m_projects) {
            this.m_treeRoot.add(projectNode);
        }
        for (DefaultMutableTreeNode outsideNode : this.m_outsideProjectSourcePaths) {
            this.m_treeRoot.add(outsideNode);
        }
        for (DefaultMutableTreeNode folderNode : this.m_folders) {
            this.m_treeRoot.add(folderNode);
        }
        return new IdeModelTree(this.m_treeRoot);
    }

    public IdeModelTreeBuilder folder(File folder) {
        DefaultMutableTreeNode folderNode = new DefaultMutableTreeNode(folder);
        this.m_folders.add(folderNode);
        IdeModelTreeBuilder.addAllChildrenRecursively(folderNode, folder);
        return this;
    }

    public IdeModelTreeBuilder project(Project project) {
        return this.project(project, new AddToListNodeAdder(this.m_projects, new TreeNodeVisitor[0]));
    }

    private IdeModelTreeBuilder project(Project project, TreeNodeVisitor addStrategy) {
        DefaultMutableTreeNode projectNode = new DefaultMutableTreeNode(project);
        addStrategy.visit(projectNode);
        ProjectModel projectModel = new ProjectModel(project);
        this.addOutputDirectory(projectNode, projectModel.getOutputDirectory());
        this.addSourceDirectories(projectNode, projectModel);
        return this;
    }

    public IdeModelTreeBuilder workspace(Workspace workSpace) {
        DefaultMutableTreeNode workspaceNode = new DefaultMutableTreeNode(workSpace);
        this.m_workspaces.add(workspaceNode);
        AddToTreeNodeAdder addToWsp = new AddToTreeNodeAdder(workspaceNode, new TreeNodeVisitor[0]);
        ArrayList<String> projectFolders = new ArrayList<String>();
        List projectReferences = workSpace.getListOfChildren();
        for (Reference e : projectReferences) {
            if (!(e.getData() instanceof Project)) continue;
            Project p = (Project)e.getData();
            this.project(p, addToWsp);
            projectFolders.add(FileSystemModelUtils.urlToFile(p.getURL()).getParent());
        }
        workspaceNode.add(new DefaultMutableTreeNode(FileSystemModelUtils.urlToFile(workSpace.getURL())));
        return this;
    }

    private static void addChildren(DefaultMutableTreeNode projectTreeNode, File file, FileFilter filter) {
        File[] files = file.listFiles(filter);
        if (files != null) {
            Arrays.sort(files, FILE_COMPARATOR);
            for (File childFile : files) {
                DefaultMutableTreeNode nextChild = new DefaultMutableTreeNode(childFile);
                projectTreeNode.add(nextChild);
                IdeModelTreeBuilder.addChildren(nextChild, childFile, filter);
            }
        }
    }

    private static void addFileAndAllItsChildrenRecursively(DefaultMutableTreeNode rootNode, File file, boolean topLevel) {
        DefaultMutableTreeNode directTreeNodeChild = new DefaultMutableTreeNode(topLevel ? new TopLevelContentsFile(file, FileSystemModelUtils.urlToFile(((Node)rootNode.getUserObject()).getURL()).getParentFile()) : file);
        rootNode.add(directTreeNodeChild);
        File[] childFiles = file.listFiles();
        if (childFiles != null) {
            Arrays.sort(childFiles, FILE_COMPARATOR);
            for (File childFile : childFiles) {
                IdeModelTreeBuilder.addFileAndAllItsChildrenRecursively(directTreeNodeChild, childFile, false);
            }
        }
    }

    private static void addAllChildrenRecursively(DefaultMutableTreeNode rootNode, File file) {
        File[] childFiles = file.listFiles();
        if (childFiles != null) {
            Arrays.sort(childFiles, FILE_COMPARATOR);
            for (File childFile : childFiles) {
                DefaultMutableTreeNode directTreeNodeChild = new DefaultMutableTreeNode(childFile);
                rootNode.add(directTreeNodeChild);
                IdeModelTreeBuilder.addAllChildrenRecursively(directTreeNodeChild, childFile);
            }
        }
    }

    private void addSourceDirectories(DefaultMutableTreeNode projectNode, ProjectModel model) {
        this.addSourceDirectories(projectNode, model.getProject(), model.getProjectBaseDirectory(), model.getContentRootDirectories(), model.getContentRootsOutsideProjectRoot());
    }

    private void addSourceDirectories(DefaultMutableTreeNode projectNode, Project project, File projectBaseDirectory, URLPath contentRootDirectories, List<File> externalRootDirectories) {
        for (URL sourceRootDirectory : contentRootDirectories) {
            File sourceRootFile = FileSystemModelUtils.urlToFile(sourceRootDirectory);
            if (!sourceRootFile.exists()) continue;
            if (sourceRootFile.equals(projectBaseDirectory)) {
                IdeModelTreeBuilder.addChildren(projectNode, projectBaseDirectory, FILE_ONLY_FILE_FILTER);
                continue;
            }
            if (!externalRootDirectories.contains(sourceRootFile)) {
                IdeModelTreeBuilder.addFileAndAllItsChildrenRecursively(projectNode, sourceRootFile, true);
                continue;
            }
            DefaultMutableTreeNode externalSourceRoot = new DefaultMutableTreeNode(new OptionalFolder(project, sourceRootFile, false));
            this.m_outsideProjectSourcePaths.add(externalSourceRoot);
            File[] sorted = sourceRootFile.listFiles();
            if (sorted == null) continue;
            Arrays.sort(sorted, FILE_COMPARATOR);
            for (File externalSourceRootFile : sorted) {
                IdeModelTreeBuilder.addFileAndAllItsChildrenRecursively(externalSourceRoot, externalSourceRootFile, false);
            }
        }
    }

    private void addOutputDirectory(DefaultMutableTreeNode projectTreeNode, File outputDirectory) {
        if (outputDirectory != null) {
            IdeModelTreeBuilder.addFileAndAllItsChildrenRecursively(projectTreeNode, outputDirectory, true);
        }
    }

    private static class AddToListNodeAdder
    extends TreeNodeVisitor {
        final List<DefaultMutableTreeNode> m_listOfNodes;

        AddToListNodeAdder(List<DefaultMutableTreeNode> listOfNodes, TreeNodeVisitor ... peerStrategies) {
            super(peerStrategies);
            this.m_listOfNodes = listOfNodes;
        }

        @Override
        public void visit(DefaultMutableTreeNode node) {
            super.visit(node);
            this.m_listOfNodes.add(node);
        }
    }

    private static class AddToTreeNodeAdder
    extends TreeNodeVisitor {
        final DefaultMutableTreeNode m_parent;

        AddToTreeNodeAdder(DefaultMutableTreeNode parent, TreeNodeVisitor ... peerStrategies) {
            super(peerStrategies);
            this.m_parent = parent;
        }

        @Override
        public void visit(DefaultMutableTreeNode node) {
            super.visit(node);
            this.m_parent.add(node);
        }
    }

    private static class TreeNodeVisitor {
        final TreeNodeVisitor[] m_peers;

        TreeNodeVisitor(TreeNodeVisitor ... peerVisitors) {
            this.m_peers = peerVisitors;
        }

        void visit(DefaultMutableTreeNode node) {
            if (this.m_peers == null || this.m_peers.length == 0) {
                return;
            }
            for (TreeNodeVisitor peer : this.m_peers) {
                peer.visit(node);
            }
        }
    }
}

