/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ideimpl.navigator.delete.model.OptionalFolder;
import oracle.ideimpl.navigator.delete.model.TopLevelContentsFile;
import oracle.ideimpl.navigator.delete.ui.BaseDirectoryNameRenderer;
import oracle.ideimpl.navigator.delete.ui.ExternalSourceNameRenderer;
import oracle.ideimpl.navigator.delete.ui.IdeModelTreeNameRenderer;
import oracle.ideimpl.navigator.delete.ui.ShortNameRenderer;
import oracle.javatools.icons.OracleIcons;

public class IdeModelTree {
    private final DefaultMutableTreeNode m_root;
    private final JTree m_tree;
    private static IdeModelTreeNameRenderer m_topLevelNameRenderer = new BaseDirectoryNameRenderer();
    private static IdeModelTreeNameRenderer m_fileSystemNameRenderer = new ShortNameRenderer();
    private static ExternalSourceNameRenderer m_outsideSourceNameRenderer = new ExternalSourceNameRenderer(DeleteDialogArb.getString((int)12));

    IdeModelTree(DefaultMutableTreeNode root) {
        this.m_root = root;
        this.m_tree = new JTree(root);
        this.m_tree.setRootVisible(false);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setCellRenderer(new DeleteDetailsTreeCellRenderer());
        this.m_tree.setCellEditor(new CheckBoxOptionalNodesEditor(this.m_tree));
        this.m_tree.setEditable(true);
        this.m_tree.setVisibleRowCount(Math.max(root.getChildCount() + 2, 10));
    }

    public JTree getTree() {
        return this.m_tree;
    }

    public boolean hasOptionalItems() {
        for (int i = 0; i < this.m_root.getChildCount(); ++i) {
            if (!(((DefaultMutableTreeNode)this.m_root.getChildAt(i)).getUserObject() instanceof OptionalFolder)) continue;
            return true;
        }
        return false;
    }

    public List<URL> getExcludedURLs() {
        ArrayList<URL> nonselected = new ArrayList<URL>();
        for (int i = 0; i < this.m_root.getChildCount(); ++i) {
            OptionalFolder folder;
            if (!(((DefaultMutableTreeNode)this.m_root.getChildAt(i)).getUserObject() instanceof OptionalFolder) || (folder = (OptionalFolder)((DefaultMutableTreeNode)this.m_root.getChildAt(i)).getUserObject()).isSelected()) continue;
            try {
                URL url = folder.getFile().toURI().toURL();
                nonselected.add(url);
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return nonselected;
    }

    public static String trimExtension(String s) {
        int indexOfExt = s.lastIndexOf(".");
        return indexOfExt != -1 ? s.substring(0, indexOfExt) : s;
    }

    private static class SelectableLabel
    extends JLabel {
        protected boolean isSelected = false;

        private SelectableLabel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.isSelected) {
                this.setOpaque(false);
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                g.setColor(UIManager.getColor("Tree.selectionBackground"));
                Insets i = this.getInsets();
                int x = i.left + this.getIcon().getIconWidth() + this.getIconTextGap() - 1;
                g.fillRect(x, i.top, this.getWidth() - x - i.right + 2, this.getHeight() - i.top - i.bottom);
            } else {
                this.setForeground(UIManager.getColor("Tree.foreground"));
            }
            super.paintComponent(g);
        }
    }

    private class CheckboxIconLabel
    extends JPanel {
        protected JCheckBox checkbox;
        protected SelectableLabel label = new SelectableLabel();

        CheckboxIconLabel() {
            this.checkbox = this.createCheckBox();
            this.setLayout(new BorderLayout(6, 0));
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.label, "Center");
        }

        protected JCheckBox createCheckBox() {
            JCheckBox cb = new JCheckBox();
            return cb;
        }

        JCheckBox checkbox() {
            return this.checkbox;
        }

        SelectableLabel label() {
            return this.label;
        }
    }

    private class CheckBoxOptionalNodesEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private final DeleteDetailsTreeCellRenderer m_editorInternalRenderer;
        ChangeEvent changeEvent = null;
        JTree tree;

        private CheckBoxOptionalNodesEditor(JTree tree) {
            this.m_editorInternalRenderer = new DeleteDetailsTreeCellRenderer();
            this.tree = tree;
        }

        @Override
        public Object getCellEditorValue() {
            JCheckBox checkbox = this.m_editorInternalRenderer.getOptionalRenderer();
            OptionalFolder checkBoxNode = new OptionalFolder(((OptionalFolder)checkbox.getClientProperty("value")).getProject(), ((OptionalFolder)checkbox.getClientProperty("value")).getFile(), checkbox.isSelected());
            return checkBoxNode;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            Object node;
            MouseEvent mouseEvent;
            TreePath path;
            boolean returnValue = false;
            if (event instanceof MouseEvent && (path = this.tree.getPathForLocation((mouseEvent = (MouseEvent)event).getX(), mouseEvent.getY())) != null && (node = path.getLastPathComponent()) != null && node instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                Object userObject = treeNode.getUserObject();
                returnValue = userObject instanceof OptionalFolder;
            }
            return returnValue;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            Component editor = this.m_editorInternalRenderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (CheckBoxOptionalNodesEditor.this.stopCellEditing()) {
                        CheckBoxOptionalNodesEditor.this.fireEditingStopped();
                    }
                }
            };
            if (editor instanceof CheckboxIconLabel) {
                CheckboxIconLabel theeditor = (CheckboxIconLabel)editor;
                theeditor.label().isSelected = true;
                theeditor.checkbox().addItemListener(itemListener);
            }
            return editor;
        }
    }

    private class DeleteDetailsTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private CheckboxIconLabel m_checkboxIconLabel = null;

        private DeleteDetailsTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            if (treeNode.getUserObject() instanceof Project) {
                if (treeNode.getParent().equals(IdeModelTree.this.m_root)) {
                    this.setTextAndToolTip(m_topLevelNameRenderer.nodeToString((Node)((Project)treeNode.getUserObject())));
                } else {
                    this.setTextAndToolTip(m_fileSystemNameRenderer.nodeToString((Node)((Project)treeNode.getUserObject())));
                }
                this.setIcon(OracleIcons.getIcon((String)"project.png"));
            } else if (treeNode.getUserObject() instanceof Workspace) {
                if (treeNode.getParent().equals(IdeModelTree.this.m_root)) {
                    this.setTextAndToolTip(m_topLevelNameRenderer.nodeToString((Node)((Workspace)treeNode.getUserObject())));
                } else {
                    this.setTextAndToolTip(m_fileSystemNameRenderer.nodeToString((Node)((Workspace)treeNode.getUserObject())));
                }
                this.setIcon(OracleIcons.getIcon((String)"application.png"));
            } else {
                if (treeNode.getUserObject() instanceof OptionalFolder) {
                    OptionalFolder checkBoxNode = (OptionalFolder)treeNode.getUserObject();
                    this.m_checkboxIconLabel = new CheckboxIconLabel();
                    this.m_checkboxIconLabel.setOpaque(false);
                    this.m_checkboxIconLabel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
                    this.m_checkboxIconLabel.setFont(UIManager.getFont("Tree.font"));
                    this.m_checkboxIconLabel.label().setText(m_outsideSourceNameRenderer.deriveNewExternalSourceNameRenderer(IdeModelTree.trimExtension(checkBoxNode.getProject().getShortLabel())).fileToString(checkBoxNode.getFile()));
                    this.m_checkboxIconLabel.label().setIcon(OracleIcons.getIcon((String)"folder.png"));
                    this.m_checkboxIconLabel.label().isSelected = sel;
                    this.m_checkboxIconLabel.checkbox().setSelected(checkBoxNode.isSelected());
                    this.m_checkboxIconLabel.checkbox().putClientProperty("value", checkBoxNode);
                    this.m_checkboxIconLabel.checkbox().setBackground(tree.getBackground());
                    this.m_checkboxIconLabel.checkbox().setEnabled(true);
                    return this.m_checkboxIconLabel;
                }
                if (treeNode.getUserObject() instanceof File) {
                    this.setTextAndToolTip(m_fileSystemNameRenderer.fileToString((File)treeNode.getUserObject()));
                    if (leaf) {
                        String leafNodePath = ((File)treeNode.getUserObject()).getPath();
                        if (leafNodePath.endsWith(".java")) {
                            this.setIcon(OracleIcons.getIcon((String)"javafile.png"));
                        } else if (leafNodePath.endsWith(".jsp")) {
                            this.setIcon(OracleIcons.getIcon((String)"jsp.png"));
                        } else if (leafNodePath.endsWith(".html")) {
                            this.setIcon(OracleIcons.getIcon((String)"html.png"));
                        } else if (leafNodePath.endsWith(".jar")) {
                            this.setIcon(OracleIcons.getIcon((String)"archivefile.png"));
                        } else if (leafNodePath.endsWith(".library")) {
                            this.setIcon(OracleIcons.getIcon((String)"library.png"));
                        } else if (leafNodePath.endsWith(".xml")) {
                            this.setIcon(OracleIcons.getIcon((String)"xmlfile.png"));
                        } else if (((File)treeNode.getUserObject()).isDirectory()) {
                            String[] files = ((File)treeNode.getUserObject()).list();
                            if (files != null && files.length == 0) {
                                this.setIcon(OracleIcons.getIcon((String)"folder.png"));
                            }
                        } else {
                            this.setIcon(OracleIcons.getIcon((String)"file.png"));
                        }
                    } else {
                        this.setIcon(OracleIcons.getIcon((String)"folder.png"));
                    }
                } else if (treeNode.getUserObject() instanceof TopLevelContentsFile) {
                    this.setTextAndToolTip(((TopLevelContentsFile)treeNode.getUserObject()).toString());
                    this.setIcon(OracleIcons.getIcon((String)"folder.png"));
                }
            }
            return this;
        }

        private JCheckBox getOptionalRenderer() {
            return this.m_checkboxIconLabel.checkbox();
        }

        private void setTextAndToolTip(String text) {
            this.setText(text);
            this.setToolTipText(text);
        }
    }
}

