/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.model;

import java.io.File;
import java.io.FileFilter;
import java.net.URISyntaxException;
import java.net.URL;
import oracle.ideimpl.navigator.delete.model.DeleteFileVisitor;

public class FileSystemModelUtils {
    private static FileFilter ALL_NONHIDDEN_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.isHidden();
        }
    };
    private static FileFilter ALL_HIDDEN_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isHidden();
        }
    };

    private FileSystemModelUtils() {
    }

    public static void deleteFolderRecursively(URL url, DeleteFileVisitor deletor) {
        FileSystemModelUtils.deleteFolderRecursively(FileSystemModelUtils.urlToFile(url), deletor);
    }

    public static void deleteFolderRecursively(File root, DeleteFileVisitor deletor) {
        if (root == null) {
            return;
        }
        if (root.isDirectory()) {
            for (File f : root.listFiles(ALL_NONHIDDEN_FILE_FILTER)) {
                FileSystemModelUtils.deleteFolderRecursively(f, deletor);
            }
            for (File f : root.listFiles(ALL_HIDDEN_FILE_FILTER)) {
                FileSystemModelUtils.deleteFolderRecursively(f, deletor);
            }
        }
        deletor.visitFile(root);
    }

    public static boolean isFolderEmpty(File file) {
        String[] files = file.list();
        return files != null && files.length == 0;
    }

    public static File urlToFile(URL fileUrl) {
        File file;
        try {
            file = new File(fileUrl.toURI());
        }
        catch (URISyntaxException e) {
            file = new File(fileUrl.getPath());
        }
        return file;
    }
}

