/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.navigator.delete.model;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.navigator.delete.model.IdeModelVisitor;

public class DeleteFileVisitor
extends IdeModelVisitor {
    private List<URL> m_undeleted = new ArrayList<URL>();

    @Override
    public void visitFile(File f) {
        URL url;
        if (f.exists() && !URLFileSystem.delete((URL)(url = URLFactory.newFileURL((File)f)))) {
            this.m_undeleted.add(url);
        }
    }

    @Override
    public void visitProject(Project p) {
        if (URLFileSystem.delete((URL)URLFileSystem.getParent((URL)p.getURL()))) {
            // empty if block
        }
    }

    @Override
    public void visitWorkspace(Workspace w) {
        if (URLFileSystem.delete((URL)URLFileSystem.getParent((URL)w.getURL()))) {
            // empty if block
        }
    }

    public List<URL> getUndeleted() {
        return this.m_undeleted;
    }
}

