/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.migration;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;

public final class UserDataHandler
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "user-data");
    private static final ElementName PATH = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "path");
    private final ElementVisitor _pathVisitor = new PathVisitor();
    private final Map _userDataURISByExtensionId = new HashMap();

    public Collection getUserDataURIs(String extensionId) {
        return (Collection)this._userDataURISByExtensionId.get(extensionId);
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(PATH, this._pathVisitor);
    }

    private final class PathVisitor
    extends ElementVisitor {
        private PathVisitor() {
        }

        public void end(ElementEndContext context) {
            String path = context.getText().trim();
            if (path.length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing path for user data.");
                return;
            }
            URI absPath = UserDataHandler.this.findPath((ElementContext)context, path);
            if (absPath == null) {
                this.log((ElementContext)context, Level.SEVERE, "User data URL does not exist: " + path + ". It should be in the extension jar file, or the jar file of an dependency extension.");
                return;
            }
            Extension extension = UserDataHandler.this.getExtension((ElementContext)context);
            ArrayList<URI> paths = (ArrayList<URI>)UserDataHandler.this._userDataURISByExtensionId.get(extension.getID());
            if (paths == null) {
                paths = new ArrayList<URI>();
                UserDataHandler.this._userDataURISByExtensionId.put(extension.getID(), paths);
            }
            paths.add(absPath);
        }
    }
}

