/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.migration;

import java.util.Collection;
import java.util.Map;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import oracle.ide.IdeHook;
import oracle.ideimpl.migration.MigrationClassInfo;
import oracle.javatools.util.MultiMap;

public final class MigratorsHook
extends IdeHook {
    static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "settings-migrators");
    private static final ElementName MIGRATOR_CLASS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "migrator-class");
    private final ElementVisitor _migratorVisitor = new MigratorVisitor();
    private final MultiMap<Extension, MigrationClassInfo> _migratorClassesByExtension = new MultiMap();

    Map<Extension, Collection<MigrationClassInfo>> getMigratorClassesByExtension() {
        return this._migratorClassesByExtension;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(MIGRATOR_CLASS, this._migratorVisitor);
    }

    private final class MigratorVisitor
    extends ElementVisitor {
        private MigratorVisitor() {
        }

        public void end(ElementEndContext context) {
            Extension ext = MigratorsHook.this.getExtension((ElementContext)context);
            String className = context.getText().trim();
            ClassLoader loader = (ClassLoader)context.getScopeData().get("classLoader");
            MigratorsHook.this._migratorClassesByExtension.add((Object)ext, (Object)new MigrationClassInfo(className, new MetaClass(loader, className)));
        }
    }
}

