/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.layout;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.VisibilityLayout;
import org.xml.sax.SAXException;

public class LayoutsImpl
extends Layouts {
    static final String LAYOUT_FILE_NAME = "windowinglayout.xml";
    private static final String LAYOUT_ROOT_TAG = "LayoutInfo";
    private static LayoutsImpl INSTANCE;
    private DefaultStructuredPropertyAccess _layoutInfo;
    private HashMap _visibilityLayouts = new HashMap();
    private static final String KEY_KNOWN_DOCKABLE_FACTORIES = "knownDockableFactories";
    private static final String KEY_DOCKABLE_POSITIONS = "dockingPositions";
    private static final String KEY_VISIBILITY_LAYOUT = "visibilityLayouts";
    private static final String KEY_CLIENT_LAYOUT_DATA = "clientLayoutData";

    private LayoutsImpl() {
    }

    public static LayoutsImpl createInstance() {
        INSTANCE = new LayoutsImpl();
        return LayoutsImpl.getInstance();
    }

    public static LayoutsImpl getInstance() {
        return INSTANCE;
    }

    private DefaultStructuredPropertyAccess getLayoutInfo() {
        if (this._layoutInfo == null) {
            this.loadLayoutInfo();
        }
        return this._layoutInfo;
    }

    public boolean hasLayoutInfo(String root) {
        boolean hasLayoutInfo = false;
        DefaultStructuredPropertyAccess layoutInfo = this.getLayoutInfo();
        if (layoutInfo.hasChildNodes()) {
            Iterator childNodes = layoutInfo.getChildNodes(root);
            hasLayoutInfo = childNodes.hasNext();
        }
        return hasLayoutInfo;
    }

    public StructuredPropertyAccess getLayoutInfo(String root) {
        StructuredPropertyAccess ret = this.getLayoutInfo().getChildNode(root);
        return ret;
    }

    public void setLayoutInfo(StructuredPropertyAccess root) {
        String rootName = root.getName();
        StructuredPropertyAccess oldInfo = this.getLayoutInfo(rootName);
        DefaultStructuredPropertyAccess layoutInfo = this.getLayoutInfo();
        if (oldInfo != null) {
            layoutInfo.removeChild(oldInfo);
        }
        layoutInfo.appendChild(root);
    }

    private void loadLayoutInfo() {
        File fileConfig = this.getLayoutFile();
        if (fileConfig.exists()) {
            try {
                this._layoutInfo = DefaultStructuredPropertyAccess.loadFromXML((File)fileConfig);
                this.loadVisibility();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._layoutInfo == null) {
            this._layoutInfo = new DefaultStructuredPropertyAccess(LAYOUT_ROOT_TAG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreLayoutsToFactorySettings() {
        WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
        waitCursor.show();
        try {
            LayoutResetEvent event = new LayoutResetEvent((Layout)this.getActiveLayout());
            List listeners = super.layoutResetListeners();
            View lastActiveView = Ide.getMainWindow().getLastActiveView();
            Context context = Ide.getMainWindow().getIdeMainWindowView().getContext();
            if (context == null && lastActiveView != null) {
                context = lastActiveView.getContext();
            }
            Editor currentEditor = EditorManager.getEditorManager().getCurrentEditor();
            for (LayoutResetListener l : listeners) {
                l.beforeLayoutReset(event);
            }
            this.doResetLayouts(listeners, event, lastActiveView, currentEditor, context);
            for (LayoutResetListener l : listeners) {
                l.afterLayoutReset(event);
            }
        }
        finally {
            waitCursor.hide();
        }
    }

    private void doResetLayouts(List<LayoutResetListener> listeners, LayoutResetEvent event, View lastActiveView, Editor currentEditor, Context context) {
        this._layoutInfo = new DefaultStructuredPropertyAccess(LAYOUT_ROOT_TAG);
        this.saveLayoutInfo(this._layoutInfo);
        DockStationImpl dockStation = DockStationImpl.getInstance();
        dockStation.restoreViewsToFactorySettings();
        for (LayoutResetListener l : listeners) {
            l.beforeLayoutActivation(event);
        }
        dockStation.loadCurrentLayout(lastActiveView, currentEditor, context);
        for (LayoutResetListener l : listeners) {
            l.afterLayoutActivation(event);
        }
    }

    public void saveLayoutInfo() {
        this.saveLayoutInfo(this.getLayoutInfo());
    }

    private void saveLayoutInfo(DefaultStructuredPropertyAccess layoutInfo) {
        File fileConfig = this.getLayoutFile();
        try {
            DefaultStructuredPropertyAccess.saveToXML((StructuredPropertyAccess)layoutInfo, (File)fileConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getLayoutFile() {
        URL url = ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.ide");
        File fileConfig = new File(url.getPath(), LAYOUT_FILE_NAME);
        return fileConfig;
    }

    public void saveAll() {
        super.saveAll();
        this.saveVisibility();
        this.saveLayoutInfo();
    }

    private void saveVisibility() {
        DefaultStructuredPropertyAccess visibilityNode = new DefaultStructuredPropertyAccess(KEY_VISIBILITY_LAYOUT);
        Set knownLayouts = this._visibilityLayouts.keySet();
        for (String layoutName : knownLayouts) {
            VisibilityLayout visibilityLayout = (VisibilityLayout)this._visibilityLayouts.get(layoutName);
            StructuredPropertyAccess layout = visibilityLayout.save();
            visibilityNode.appendChild(layout);
        }
        DefaultStructuredPropertyAccess layoutInfo = this.getLayoutInfo();
        StructuredPropertyAccess oldVisibilityNode = layoutInfo.getChildNode(KEY_VISIBILITY_LAYOUT);
        if (oldVisibilityNode != null) {
            layoutInfo.removeChild(oldVisibilityNode);
        }
        this.getLayoutInfo().appendChild((StructuredPropertyAccess)visibilityNode);
    }

    private void loadVisibility() {
        StructuredPropertyAccess root = this.getLayoutInfo(KEY_VISIBILITY_LAYOUT);
        if (root != null) {
            Iterator childNodes = root.getChildNodes();
            while (childNodes.hasNext()) {
                StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
                VisibilityLayout visibilityLayout = VisibilityLayout.load(child);
                String layoutName = child.getName();
                this._visibilityLayouts.put(layoutName, visibilityLayout);
            }
        }
    }

    public boolean hasDockableFactoryNode() {
        return this.hasLayoutInfo(KEY_KNOWN_DOCKABLE_FACTORIES);
    }

    public String[] getKnownDockableFactories() {
        ArrayList<String> ret = new ArrayList<String>();
        StructuredPropertyAccess knownFactories = this.getLayoutInfo(KEY_KNOWN_DOCKABLE_FACTORIES);
        if (knownFactories != null) {
            Iterator childNodes = knownFactories.getChildNodes();
            while (childNodes.hasNext()) {
                StructuredPropertyAccess knownFactory = (StructuredPropertyAccess)childNodes.next();
                String factoryName = knownFactory.getName();
                ret.add(factoryName);
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public void setKnownDockableFactories(String[] factoryNames) {
        DefaultStructuredPropertyAccess newNode = new DefaultStructuredPropertyAccess(KEY_KNOWN_DOCKABLE_FACTORIES);
        for (int i = 0; i < factoryNames.length; ++i) {
            String factoryName = factoryNames[i];
            DefaultStructuredPropertyAccess factoryNode = new DefaultStructuredPropertyAccess(factoryName);
            newNode.appendChild((StructuredPropertyAccess)factoryNode);
        }
        StructuredPropertyAccess oldNode = this.getLayoutInfo(KEY_KNOWN_DOCKABLE_FACTORIES);
        if (oldNode != null) {
            this.getLayoutInfo().removeChild(oldNode);
        }
        this.getLayoutInfo().appendChild((StructuredPropertyAccess)newNode);
    }

    public StructuredPropertyAccess getDockablePositions() {
        StructuredPropertyAccess dockablePositions = null;
        dockablePositions = this.getLayoutInfo(KEY_DOCKABLE_POSITIONS);
        return dockablePositions;
    }

    public void setDockablePositions(StructuredPropertyAccess positions) {
        StructuredPropertyAccess oldNode = this.getDockablePositions();
        if (oldNode != null) {
            this.getLayoutInfo().removeChild(oldNode);
        }
        positions.setName(KEY_DOCKABLE_POSITIONS);
        this.getLayoutInfo().appendChild(positions);
    }

    public VisibilityLayout getVisibilityLayout(String displayName) {
        String internalName = displayName.replace(' ', '_');
        VisibilityLayout visibilityLayout = (VisibilityLayout)this._visibilityLayouts.get(internalName);
        if (visibilityLayout == null) {
            visibilityLayout = new VisibilityLayout(internalName, displayName);
            this._visibilityLayouts.put(internalName, visibilityLayout);
        }
        return visibilityLayout;
    }

    public StructuredPropertyAccess getClientLayoutData() {
        StructuredPropertyAccess pa = this.getLayoutInfo(KEY_CLIENT_LAYOUT_DATA);
        if (pa == null) {
            pa = new DefaultStructuredPropertyAccess(KEY_CLIENT_LAYOUT_DATA);
            this.getLayoutInfo().appendChild(pa);
        }
        return pa;
    }

    public StructuredPropertyAccess findClientLayoutData() {
        return this.getLayoutInfo(KEY_CLIENT_LAYOUT_DATA);
    }

    public void setClientLayoutData(StructuredPropertyAccess clientData) {
        StructuredPropertyAccess oldNode = this.findClientLayoutData();
        if (oldNode != null) {
            this.getLayoutInfo().removeChild(oldNode);
        }
        clientData.setName(KEY_CLIENT_LAYOUT_DATA);
        this.getLayoutInfo().appendChild(clientData);
    }
}

