/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.model;

import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ide.model.spi.TextDocumentImpl;
import javax.ide.model.text.TextModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.ide.model.TextNode;
import oracle.ideimpl.jsr198.model.NodeBridge;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

public class TextNodeBridge
extends NodeBridge
implements TextDocumentImpl {
    private static final Map _textBufferListeners = new HashMap();

    public TextNodeBridge(URI uri) {
        super(uri);
    }

    private final TextNode getIdeTextNode() {
        return (TextNode)this.getIdeElement();
    }

    public TextModel getTextModel() {
        return new OracleTextModel();
    }

    @Override
    public Reader getReader() throws IOException {
        return this.getIdeTextNode().getReader();
    }

    private static final class DocumentListenerAdapter
    implements TextBufferListener {
        private final DocumentListener _delegate;
        private final Document _document;

        DocumentListenerAdapter(Document document, DocumentListener dl) {
            this._document = document;
            this._delegate = dl;
        }

        public void insertUpdate(TextBuffer buffer, final int offset, final int count, char[] insertedData) {
            DocumentEvent de = new DocumentEvent(){

                @Override
                public int getOffset() {
                    return offset;
                }

                @Override
                public int getLength() {
                    return count;
                }

                @Override
                public Document getDocument() {
                    return DocumentListenerAdapter.this._document;
                }

                @Override
                public DocumentEvent.EventType getType() {
                    return DocumentEvent.EventType.INSERT;
                }

                @Override
                public DocumentEvent.ElementChange getChange(Element elem) {
                    throw new UnsupportedOperationException();
                }
            };
            this._delegate.insertUpdate(de);
        }

        public void removeUpdate(TextBuffer buffer, final int offset, final int count, char[] removed) {
            DocumentEvent de = new DocumentEvent(){

                @Override
                public int getOffset() {
                    return offset;
                }

                @Override
                public int getLength() {
                    return count;
                }

                @Override
                public Document getDocument() {
                    return DocumentListenerAdapter.this._document;
                }

                @Override
                public DocumentEvent.EventType getType() {
                    return DocumentEvent.EventType.REMOVE;
                }

                @Override
                public DocumentEvent.ElementChange getChange(Element elem) {
                    throw new UnsupportedOperationException();
                }
            };
            this._delegate.removeUpdate(de);
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }
    }

    private class OracleTextModel
    implements TextModel,
    Document {
        private TextBuffer _currentBuffer;

        private OracleTextModel() {
        }

        public synchronized Document getDocument() {
            return this;
        }

        public synchronized void beginEdit() {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing.");
            }
            this._currentBuffer.beginEdit();
        }

        public synchronized UndoableEdit commitEdit() {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing.");
            }
            return this._currentBuffer.endEdit();
        }

        public synchronized void rollbackEdit() {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing");
            }
            this._currentBuffer.endEdit().undo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void read(Runnable runnable) {
            if (this._currentBuffer != null) {
                throw new IllegalStateException("Cannot read while writing.");
            }
            this._currentBuffer = TextNodeBridge.this.getIdeTextNode().acquireTextBuffer();
            try {
                this._currentBuffer.readLock();
                try {
                    runnable.run();
                }
                finally {
                    this._currentBuffer.readUnlock();
                }
            }
            finally {
                TextNodeBridge.this.getIdeTextNode().releaseTextBuffer();
                this._currentBuffer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void write(Runnable runnable) {
            if (this._currentBuffer != null) {
                throw new IllegalStateException("Cannot write while writing");
            }
            this._currentBuffer = TextNodeBridge.this.getIdeTextNode().acquireTextBuffer();
            try {
                this._currentBuffer.writeLock();
                try {
                    runnable.run();
                }
                finally {
                    this._currentBuffer.writeUnlock();
                }
            }
            finally {
                TextNodeBridge.this.getIdeTextNode().releaseTextBuffer();
                this._currentBuffer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getLength() {
            TextBuffer buffer = null;
            try {
                buffer = TextNodeBridge.this.getIdeTextNode().acquireTextBuffer();
                buffer.readLock();
                int n = buffer.getLength();
                return n;
            }
            finally {
                if (buffer != null) {
                    buffer.readUnlock();
                }
                TextNodeBridge.this.getIdeTextNode().releaseTextBuffer();
            }
        }

        @Override
        public void remove(int offs, int len) {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing.");
            }
            this._currentBuffer.remove(offs, len);
        }

        @Override
        public void render(Runnable r) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getText(int offset, int length) {
            TextBuffer buffer = null;
            try {
                buffer = TextNodeBridge.this.getIdeTextNode().acquireTextBuffer();
                buffer.readLock();
                String string = buffer.getString(offset, length);
                return string;
            }
            finally {
                buffer.readUnlock();
                TextNodeBridge.this.getIdeTextNode().releaseTextBuffer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addDocumentListener(DocumentListener listener) {
            try {
                TextBuffer buffer = TextNodeBridge.this.getIdeTextNode().acquireTextBuffer();
                DocumentListenerAdapter tbl = new DocumentListenerAdapter(this, listener);
                _textBufferListeners.put(listener, tbl);
                buffer.addTextBufferListener((TextBufferListener)tbl);
            }
            finally {
                TextNodeBridge.this.getIdeTextNode().releaseTextBuffer();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeDocumentListener(DocumentListener listener) {
            TextBufferListener tbl = (TextBufferListener)_textBufferListeners.get(listener);
            if (tbl == null) {
                throw new IllegalArgumentException("Unknown listener");
            }
            try {
                TextBuffer buffer = TextNodeBridge.this.getIdeTextNode().acquireTextBuffer();
                _textBufferListeners.remove(listener);
                buffer.removeTextBufferListener(tbl);
            }
            finally {
                TextNodeBridge.this.getIdeTextNode().releaseTextBuffer();
            }
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element getDefaultRootElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element[] getRootElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Position getEndPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Position getStartPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Position createPosition(int offs) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getText(int offset, int length, Segment txt) {
            TextBuffer buffer = null;
            try {
                buffer = TextNodeBridge.this.getIdeTextNode().acquireTextBuffer();
                buffer.readLock();
                buffer.getText(offset, length, txt);
            }
            finally {
                buffer.readUnlock();
                TextNodeBridge.this.getIdeTextNode().releaseTextBuffer();
            }
        }

        @Override
        public Object getProperty(Object key) {
            return null;
        }

        @Override
        public void putProperty(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) {
            if (this._currentBuffer == null) {
                throw new IllegalStateException("Must be writing.");
            }
            this._currentBuffer.insert(offset, str.toCharArray());
        }
    }
}

