/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.ide.model.Document;
import javax.ide.model.DocumentFactory;
import javax.ide.model.Element;
import javax.ide.model.spi.ElementFactory;
import javax.ide.model.spi.ElementImpl;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.Context;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ideimpl.jsr198.model.Custom;
import oracle.ideimpl.jsr198.model.ElementBridge;

public final class ContextFactory {
    public static final String JDEVELOPER_CONTEXT = "jdeveloperContext";

    private ContextFactory() {
    }

    public static final Context createOracleContext(javax.ide.command.Context javaxContext) {
        try {
            Context context = new Context();
            javax.ide.model.Project javaxProject = javaxContext.getProject();
            if (javaxProject == null) {
                context.setProject(null);
            } else {
                URL projectURL = VirtualFileSystem.getVirtualFileSystem().toURL(javaxProject.getURI());
                context.setProject((Project)NodeFactory.find((URL)projectURL));
            }
            Document javaxDocument = javaxContext.getDocument();
            if (javaxDocument == null) {
                context.setNode(null);
            } else {
                URL docURL = VirtualFileSystem.getVirtualFileSystem().toURL(javaxDocument.getURI());
                context.setNode(NodeFactory.find((URL)docURL));
            }
            Element[] javaxSelection = javaxContext.getSelection();
            if (javaxSelection != null) {
                ArrayList<Node> ideSelection = new ArrayList<Node>();
                for (int i = 0; i < javaxSelection.length; ++i) {
                    Element javaxElement = javaxSelection[i];
                    if (!(javaxElement instanceof Document)) continue;
                    URL docURL = VirtualFileSystem.getVirtualFileSystem().toURL(((Document)javaxElement).getURI());
                    ideSelection.add(NodeFactory.find((URL)docURL));
                }
                context.setSelection(ideSelection.toArray(new oracle.ide.model.Element[ideSelection.size()]));
            }
            return context;
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
            return new Context();
        }
    }

    public static final javax.ide.command.Context createJsrContext(Context ideContext) {
        Element[] jsrSelection;
        oracle.ide.model.Element[] ideSelection = ideContext.getSelection();
        Project ideProject = ideContext.getProject();
        Node ideNode = ideContext.getNode();
        Element[] elementArray = jsrSelection = ideSelection == null ? new Element[]{} : new Element[ideSelection.length];
        if (ideSelection != null) {
            for (int i = 0; i < ideSelection.length; ++i) {
                final oracle.ide.model.Element sel = ideSelection[i];
                if (sel instanceof Custom) {
                    jsrSelection[i] = ((Custom)sel).getJSRDocument();
                    continue;
                }
                if (sel instanceof Locatable) {
                    try {
                        jsrSelection[i] = DocumentFactory.getDocumentFactory().findOrCreate(URIFactory.newURI((URL)((Locatable)sel).getURL()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                jsrSelection[i] = ElementFactory.createElement((ElementImpl)new ElementBridge(){

                    @Override
                    protected oracle.ide.model.Element getIdeElement() {
                        return sel;
                    }
                });
            }
        }
        Document jsrDocument = null;
        javax.ide.model.Project jsrProject = null;
        try {
            jsrDocument = ideNode instanceof Custom ? ((Custom)ideNode).getJSRDocument() : (ideNode == null ? null : DocumentFactory.getDocumentFactory().findOrCreate(URIFactory.newURI((URL)ideNode.getURL())));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            jsrProject = ideProject == null ? null : (javax.ide.model.Project)DocumentFactory.getDocumentFactory().findOrCreate(URIFactory.newURI((URL)ideProject.getURL()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        javax.ide.command.Context c = new javax.ide.command.Context(jsrDocument, jsrProject, jsrSelection);
        c.setProperty("oracle.ide.context", (Object)ideContext);
        return c;
    }
}

