/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.history.HistoryManager;
import oracle.ide.history.LocalState;
import oracle.ide.net.URLFactory;
import oracle.ide.persistence.NameSpace;
import oracle.ideimpl.history.HistoryManagerImpl2;
import oracle.ideimpl.history.LocalStateImpl;
import oracle.ideimpl.history.LocalStateImpl2;
import oracle.ideimpl.history.NodeInfo;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.IntArrayFactory;

public final class HistoryManagerImpl
extends HistoryManager
implements Addin {
    private static final String NS_STATES = "LocalHistory:States";
    private static final String NS_URLS = "LocalHistory:Urls";
    private static final String NS_NODES = "LocalHistory:Documents";
    private static final String NS_COMMENTS = "LocalHistory:Comments";
    private static final String NS_IDS = "LocalHistory:IdData";
    private static final NameSpace STATES = NameSpace.getNameSpace((String)"LocalHistory:States");
    private static final NameSpace URLS = NameSpace.getNameSpace((String)"LocalHistory:Urls");
    private static final NameSpace NODES = NameSpace.getNameSpace((String)"LocalHistory:Documents");
    private static final NameSpace COMMENTS = NameSpace.getNameSpace((String)"LocalHistory:Comments");
    private static final NameSpace IDS = NameSpace.getNameSpace((String)"LocalHistory:IdData");

    public void initialize() {
        if (NODES.getKeyIterator().hasNext()) {
            HistoryMigratorImpl migrator = new HistoryMigratorImpl(NODES, STATES, URLS, COMMENTS, IDS);
            ((HistoryManagerImpl2)HistoryManagerImpl2.getInstance()).setHistoryMigrator(migrator);
        }
    }

    public synchronized boolean hasLocalHistory(URL url) {
        return false;
    }

    public synchronized LocalState[] getLocalHistory(URL url) {
        return null;
    }

    public synchronized LocalState[] getLocalHistory(Object nodeId) {
        return null;
    }

    public synchronized LocalState getLastState(Object nodeId) {
        return null;
    }

    public Object[] getDeletions(URL url) {
        return null;
    }

    public synchronized void persistInitialState(URL[] sources) throws Exception {
    }

    public synchronized void persist(URL[] sources, String description) throws Exception {
    }

    public void restore(LocalState[] states, Context context) throws Exception {
    }

    public void registerHistorian(Class historianCls, Class nodeCls) {
    }

    public Class getRegisteredHistorian(Class nodeCls) throws IllegalArgumentException {
        return null;
    }

    public void clear(URL[] sources) {
    }

    static {
        if (STATES != null && URLS != null && NODES != null && COMMENTS != null) {
            STATES.setAutoFlush(1500L);
            URLS.setAutoFlush(1500L);
            NODES.setAutoFlush(1500L);
            COMMENTS.setAutoFlush(1500L);
            IDS.setAutoFlush(1500L);
        }
    }

    public static class HistoryMigratorImpl
    implements HistoryManagerImpl2.HistoryMigrator {
        private NameSpace _oldStates;
        private NameSpace _oldUrls;
        private NameSpace _oldNodes;
        private NameSpace _oldComments;
        private NameSpace _oldIds;
        private static final String FIELD_SEPARATOR = "|";
        private static final int DELETION_URL_ID = -1;
        private boolean _migrated;
        private static Logger logger = Logger.getLogger(HistoryMigratorImpl.class.getName());

        public HistoryMigratorImpl(NameSpace nodes, NameSpace states, NameSpace urls, NameSpace comments, NameSpace ids) {
            this._oldNodes = nodes;
            this._oldStates = states;
            this._oldUrls = urls;
            this._oldComments = comments;
            this._oldIds = ids;
        }

        @Override
        public synchronized boolean hasRun() {
            return this._migrated;
        }

        @Override
        public synchronized void migrateHistory(NameSpace nodeNameSpace, NameSpace stateNameSpace, NameSpace idNameSpace) {
            if (this._migrated) {
                return;
            }
            this._migrateStates(nodeNameSpace, stateNameSpace);
            this._migrateIds(idNameSpace);
            this._cleanup();
            this._migrated = true;
        }

        private void _migrateStates(NameSpace nodeNameSpace, NameSpace stateNameSpace) {
            Map<String, Integer> urls = this._loadUrls();
            Object[] ns = this._loadNodes();
            Map nodes = (Map)ns[0];
            List deletedNodes = (List)ns[1];
            Iterator states = this._oldStates.getKeyIterator();
            while (states.hasNext()) {
                String key = (String)states.next();
                this._oldStates.delRecord(key);
                LocalStateImpl stateImpl = LocalStateImpl.decode(key);
                Integer nodeId = (Integer)stateImpl.getNodeId();
                Integer stateUrlId = (Integer)stateImpl.getStateUrlId();
                Date timestamp = stateImpl.getDate();
                URL stateUrl = this.fetchURL(urls, stateUrlId);
                String comment = this.fetchComment(timestamp);
                URL nodeUrl = this.fetchNodeUrl(urls, nodes, nodeId);
                LocalStateImpl2 stateImpl2 = new LocalStateImpl2(nodeId, timestamp, nodeUrl, stateUrl, comment);
                NodeInfo nodeInfo = new NodeInfo(nodeId, stateUrl, this.urlsAreNotEqual(nodeUrl, stateUrl));
                nodeNameSpace.putRecord(nodeInfo.getKey(), NodeInfo.disassemble(nodeInfo));
                stateNameSpace.putRecord(stateImpl2.getKey(), LocalStateImpl2.disassemble(stateImpl2));
            }
        }

        private void _migrateIds(NameSpace idNameSpace) {
            byte[] maxId = this._oldIds.getRecord("node.max");
            int maxNodeId = maxId == null || maxId.length == 0 ? 0 : HistoryManagerImpl2.IdManager.bytesToInt(maxId, 0);
            idNameSpace.putRecord("LocalHistory2:IdManager:MAX_ID", HistoryManagerImpl2.IdManager.intToBytes(maxNodeId, null, 0));
            byte[] freeIds = this._oldIds.getRecord("node.free");
            if (freeIds != null) {
                int length = freeIds.length / 4;
                int[] freeNodeIds = new int[length];
                for (int i = 0; i < length; ++i) {
                    freeNodeIds[i] = HistoryManagerImpl2.IdManager.bytesToInt(freeIds, i * 4);
                }
                try {
                    idNameSpace.putRecord("LocalHistory2:IdManager:FREE_IDS", IntArrayFactory.INT_ARRAY_FACTORY.disassemble((Object)freeNodeIds));
                }
                catch (AssemblyException e) {
                    logger.log(Level.SEVERE, "An error occurred while reading from the local history database.", e);
                }
            }
            this._oldIds.delRecord("node.max");
            this._oldIds.delRecord("node.free");
        }

        private void _cleanup() {
            Iterator i = this._oldComments.getKeyIterator();
            if (i != null && i.hasNext()) {
                this._oldComments.delRecord((String)i.next());
            }
        }

        private Map<String, Integer> _loadUrls() {
            HashMap<String, Integer> urls = new HashMap<String, Integer>();
            int count = 0;
            Iterator i = this._oldUrls.getKeyIterator();
            if (i != null) {
                while (i.hasNext()) {
                    String key = (String)i.next();
                    int index = key.lastIndexOf(FIELD_SEPARATOR);
                    try {
                        ++count;
                        URL url = URLFactory.newURL((String)key.substring(0, index));
                        Integer urlId = Integer.decode(key.substring(++index));
                        urls.put(url.toString(), urlId);
                        this._oldUrls.delRecord(key);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "An error occurred while reading from the local history database.", e);
                    }
                }
            }
            return urls;
        }

        private Object[] _loadNodes() {
            HashMap<Integer, Integer> nodes = new HashMap<Integer, Integer>();
            ArrayList<Integer> deletedNodes = new ArrayList<Integer>();
            int count = 0;
            Iterator i = this._oldNodes.getKeyIterator();
            if (i != null) {
                while (i.hasNext()) {
                    String key = (String)i.next();
                    int index = key.indexOf(FIELD_SEPARATOR);
                    try {
                        ++count;
                        Integer urlId = Integer.decode(key.substring(0, index));
                        Integer nodeId = Integer.decode(key.substring(++index));
                        if (urlId != -1) {
                            nodes.put(urlId, nodeId);
                        } else {
                            deletedNodes.add(nodeId);
                        }
                        this._oldNodes.delRecord(key);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "An error occurred while reading from the local history database.", e);
                    }
                }
            }
            return new Object[]{nodes, deletedNodes};
        }

        private URL fetchURL(Map<String, Integer> urls, Integer urlId) {
            for (Map.Entry<String, Integer> entry : urls.entrySet()) {
                if (!urlId.equals(entry.getValue())) continue;
                return URLFactory.newURL((String)entry.getKey());
            }
            return null;
        }

        private URL fetchNodeUrl(Map<String, Integer> urls, Map<Integer, Integer> nodes, Integer nodeUrlId) {
            for (Map.Entry<Integer, Integer> entry : nodes.entrySet()) {
                if (!nodeUrlId.equals(entry.getValue())) continue;
                return this.fetchURL(urls, entry.getKey());
            }
            return null;
        }

        private String fetchComment(Date timestamp) {
            Iterator i = this._oldComments.getKeyIterator("" + timestamp.getTime());
            if (i != null && i.hasNext()) {
                String key = (String)i.next();
                int index = key.indexOf(FIELD_SEPARATOR);
                return key.substring(++index);
            }
            return null;
        }

        private boolean urlsAreNotEqual(URL a, URL b) {
            return !a.toString().equals(b.toString());
        }
    }
}

