/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.ExtensionRegistry;
import oracle.ide.config.IdeSettings;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.extension.ExtensionPreferencesHook;
import oracle.ideimpl.extension.preference.CachedExtensionInfo;
import oracle.ideimpl.extension.preference.ExtensionListPanel;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideimpl.resource.ExtensionManagerOptionsArb;
import oracle.javatools.ui.layout.VerticalFlowLayout;

public final class ExtensionOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private static final String NORMAL = "normal";
    private static final String DISABLED = "disabled";
    private final ExtensionListPanel _normalPanel = new ExtensionListPanel();
    private final JPanel _disabledPanel = new JPanel();
    private final JLabel _disabledLabel = new JLabel();
    private final JPanel _clPanel = new JPanel();
    private final CardLayout _cl = new CardLayout();
    private boolean _populated = false;
    private boolean _disabled = false;
    private boolean _layoutDone = false;
    private Set<String> _disabledIds = null;
    private Set _composedTraversables;

    private void layoutControls() {
        this.setLayout(new BorderLayout());
        this.add(this._clPanel, "Center");
        this._disabledPanel.setLayout(new GridBagLayout());
        this._disabledPanel.add((Component)this._disabledLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._clPanel.setLayout(this._cl);
        this._clPanel.add((Component)this._normalPanel, NORMAL);
        this._clPanel.add((Component)this._disabledPanel, DISABLED);
        JPanel south = new JPanel();
        this.add(south, "South");
        south.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        for (Traversable t : this._composedTraversables) {
            south.add(t.getComponent());
        }
    }

    private void resControls() {
        this._disabledLabel.setText("<html><p>" + ExtensionManagerOptionsArb.getString(2) + "</p></html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEntry(TraversableContext tc) {
        if (!this._layoutDone) {
            ExtensionPreferencesHook hook = (ExtensionPreferencesHook)ExtensionRegistry.getExtensionRegistry().getHook(ExtensionPreferencesHook.ELEMENT);
            this._composedTraversables = hook == null ? Collections.EMPTY_SET : hook.getTraversables();
            this.layoutControls();
            this.resControls();
            this.setHelpID("f1_idedidesetextensionmanager_html");
            this._layoutDone = true;
        }
        for (Traversable t : this._composedTraversables) {
            t.onEntry(tc);
        }
        if (this._populated) {
            return;
        }
        try {
            Set<Object> keySet = System.getProperties().keySet();
            if (keySet.contains("ide.extensions") || keySet.contains("ide.noextensions")) {
                this._cl.show(this._clPanel, DISABLED);
                this._disabled = true;
            } else {
                this._cl.show(this._clPanel, NORMAL);
                ExtensionPreferences options = ExtensionPreferences.getInstance();
                this._disabledIds = options != null ? new HashSet<String>(options.getDisabledIds()) : new HashSet<String>();
                this._normalPanel.setDisabledIds(this._disabledIds);
                this._normalPanel.populate();
                this._normalPanel.setCachedExtensionInfo(new CachedExtensionInfo());
            }
        }
        finally {
            this._populated = true;
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        for (Traversable t : this._composedTraversables) {
            t.onExit(tc);
        }
        if (this.disabledIdsHaveChanged()) {
            IdeSettings settings = (IdeSettings)tc.find("ide-options");
            settings.setAskExit(true);
        }
    }

    private boolean disabledIdsHaveChanged() {
        return !((Object)this._disabledIds).equals(ExtensionPreferences.getInstance().getDisabledIds());
    }

    private void applyExtensionPreferences() {
        if (this._disabled) {
            return;
        }
        if (!this.disabledIdsHaveChanged()) {
            return;
        }
        ExtensionPreferences p = ExtensionPreferences.getInstance();
        p.setDisabledIds(this._disabledIds);
        try {
            p.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void apply(ApplyEvent e) {
        this.applyExtensionPreferences();
        for (Traversable t : this._composedTraversables) {
            if (!(t instanceof ApplyListener)) continue;
            ((ApplyListener)t).apply(e);
        }
    }

    public void cancel(ApplyEvent e) {
        for (Traversable t : this._composedTraversables) {
            if (!(t instanceof ApplyListener)) continue;
            ((ApplyListener)t).cancel(e);
        }
    }
}

