/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.TextEditor;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.SwingUtils;
import org.xml.sax.Locator;

final class MessagePresenter
extends Handler
implements IdeListener {
    private static final String UNKNOWN_SOURCE = "(Unknown Source)";
    private final MessageTreeModel model = new MessageTreeModel();

    public MessagePresenter() {
        if (Ide.isRunning()) {
            Ide.addIdeListener((IdeListener)this);
        }
        this.setLevel(Level.INFO);
    }

    private void createLogPage() {
        LogManager logManager = LogManager.getLogManager();
        if (logManager == null) {
            return;
        }
        logManager.addPage((LogPage)new ManifestExtensionLogPage());
        if (!logManager.isLogVisible()) {
            logManager.showLog();
        }
    }

    @Override
    public void publish(final LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        SwingUtils.dispatch((Runnable)new Runnable(){

            @Override
            public void run() {
                MessagePresenter.this.model.publish(record);
            }
        });
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        Layouts.getLayouts().addLayoutResetListener(new LayoutResetListener(){

            public void beforeLayoutActivation(LayoutResetEvent e) {
                LogManager logManager = LogManager.getLogManager();
                if (MessagePresenter.this.model.hasMessages() && !logManager.isLogVisible()) {
                    logManager.showLog();
                }
            }
        });
        if (this.model.hasMessages()) {
            this.createLogPage();
        } else {
            this.model.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    MessagePresenter.this.model.removeTreeModelListener(this);
                    MessagePresenter.this.createLogPage();
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
        }
    }

    private Comparator<LogRecord> recordComparator() {
        final Collator collator = Collator.getInstance();
        return new Comparator<LogRecord>(){

            @Override
            public int compare(LogRecord o1, LogRecord o2) {
                int levelComp = this.compareLevels(o1, o2);
                if (levelComp != 0) {
                    return levelComp;
                }
                int lineNumberComp = this.compareLineNumbers(o1, o2);
                if (lineNumberComp != 0) {
                    return lineNumberComp;
                }
                return collator.compare(o1.getMessage(), o2.getMessage());
            }

            private int compareLineNumbers(LogRecord o1, LogRecord o2) {
                if (o1 instanceof ExtensionLogRecord && o2 instanceof ExtensionLogRecord) {
                    int o1Line = ((ExtensionLogRecord)o1).getLocator().getLineNumber();
                    int o2Line = ((ExtensionLogRecord)o2).getLocator().getLineNumber();
                    return o1Line - o2Line;
                }
                return 0;
            }

            private int compareLevels(LogRecord o1, LogRecord o2) {
                return o1.getLevel().intValue() - o2.getLevel().intValue();
            }
        };
    }

    private final class MessageTreeModel
    implements TreeModel {
        private final Object ROOT = new Object();
        private final List<TreeModelListener> listeners = new CopyOnWriteArrayList<TreeModelListener>();
        private final Map<String, Collection<LogRecord>> recordsByLocation = new TreeMap<String, Collection<LogRecord>>();

        private MessageTreeModel() {
        }

        public boolean hasMessages() {
            return this.getChildCount(this.ROOT) != 0;
        }

        public void publish(LogRecord record) {
            int index;
            String location = this.location(record);
            Collection<LogRecord> records = this.recordsByLocation.get(location);
            if (records == null) {
                records = new TreeSet<LogRecord>(MessagePresenter.this.recordComparator());
                this.recordsByLocation.put(location, records);
                index = this.getIndexOfChild(this.ROOT, location);
                this.fireNodesInserted(new Object[]{this.ROOT}, new int[]{index}, new Object[]{location});
            }
            if (records.add(record)) {
                index = this.getIndexOfChild(location, record);
                this.fireNodesInserted(new Object[]{this.ROOT, location}, new int[]{index}, new Object[]{record});
            }
        }

        private void fireNodesInserted(Object[] path, int[] childIndices, Object[] children) {
            TreeModelEvent event = new TreeModelEvent((Object)this, path, childIndices, children);
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesInserted(event);
            }
        }

        private String location(LogRecord record) {
            if (record instanceof ExtensionLogRecord) {
                Locator locator = ((ExtensionLogRecord)record).getLocator();
                String displayString = locator.getSystemId();
                if (displayString == null) {
                    return MessagePresenter.UNKNOWN_SOURCE;
                }
                try {
                    URI uri = URIFactory.newURI((String)displayString);
                    if (uri != null && uri.getScheme() != null) {
                        URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                        if (url == null) {
                            return MessagePresenter.UNKNOWN_SOURCE;
                        }
                        if ("jar".equals(url.getProtocol())) {
                            url = JarUtil.getJarFileURL((URL)url);
                        }
                        return ExtensionManagerImpl.getExtensionIdFromFilename(URLFileSystem.getFileName((URL)url));
                    }
                }
                catch (MalformedURLException mfe) {
                    // empty catch block
                }
            }
            return MessagePresenter.UNKNOWN_SOURCE;
        }

        private Object get(Collection collection, int index) {
            int c = 0;
            for (Object t : collection) {
                if (c == index) {
                    return t;
                }
                ++c;
            }
            return null;
        }

        @Override
        public Object getRoot() {
            return this.ROOT;
        }

        private Collection collectionForParent(Object parent) {
            Collection<LogRecord> result;
            if (parent == this.ROOT) {
                return this.recordsByLocation.keySet();
            }
            if (parent instanceof String && (result = this.recordsByLocation.get((String)parent)) != null) {
                return result;
            }
            return Collections.emptySet();
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.get(this.collectionForParent(parent), index);
        }

        @Override
        public int getChildCount(Object parent) {
            return this.collectionForParent(parent).size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof LogRecord;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            int index = 0;
            for (Object o : this.collectionForParent(parent)) {
                if (o == child) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }
    }

    private final class ManifestExtensionLogPage
    extends DefaultLogPage {
        public ManifestExtensionLogPage() {
            super(new ViewId("ManifestExtensionLogPage", ExtensionManagerArb.getString(18)), null, false, HIDE_FIX_SOURCE_MENU);
            this.getTree().setModel(MessagePresenter.this.model);
            this.getTree().setCellRenderer(new ManifestLogCellRender());
            this.getTree().setShowsRootHandles(true);
            IdeUtil.expandAllTreeRows((JTree)this.getTree());
            MessagePresenter.this.model.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    if (e.getTreePath().getPathCount() == 1) {
                        IdeUtil.expandAllTreeRows((JTree)ManifestExtensionLogPage.this.getTree());
                    }
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
        }

        public HelpInfo getHelpInfo() {
            return new HelpInfo("f1_idelogwindowgen_html");
        }

        protected String treeNodeToString(Object treeNode) {
            if (treeNode instanceof LogRecord) {
                return this.getRecordText((LogRecord)treeNode);
            }
            return super.treeNodeToString(treeNode);
        }

        private String getRecordText(LogRecord rec) {
            return this.getFormattedMessage(rec);
        }

        private String initCap(String str) {
            StringBuffer b = new StringBuffer(str);
            boolean upper = true;
            for (int i = 0; i < b.length(); ++i) {
                char c = b.charAt(i);
                if (Character.isWhitespace(c)) {
                    upper = true;
                    continue;
                }
                b.setCharAt(i, upper ? Character.toUpperCase(c) : Character.toLowerCase(c));
                upper = false;
            }
            return b.toString();
        }

        private String getFormattedMessage(LogRecord record) {
            StringBuilder message = new StringBuilder();
            if (record.getLevel() == Level.SEVERE) {
                message.append("Error");
            } else {
                message.append(this.initCap(record.getLevel().toString()));
            }
            message.append(": ");
            String msg = record.getMessage();
            Object[] parameters = record.getParameters();
            if (parameters == null || parameters.length == 0) {
                message.append(msg);
            } else {
                try {
                    message.append(MessageFormat.format(msg, parameters));
                }
                catch (Exception e) {
                    message.append("[Malformed message] ");
                    if (msg != null) {
                        message.append("'").append(msg).append("'");
                    } else {
                        message.append(msg);
                    }
                    message.append(" with parameters: ").append(Arrays.toString(parameters));
                }
            }
            return message.toString();
        }

        protected void activateObject(Object obj) {
            if (!(obj instanceof ExtensionLogRecord)) {
                return;
            }
            ExtensionLogRecord record = (ExtensionLogRecord)obj;
            Locator locator = record.getLocator();
            String fileURI = locator.getSystemId();
            URL url = null;
            try {
                url = VirtualFileSystem.getVirtualFileSystem().toURL(URIFactory.newURI((String)fileURI));
            }
            catch (MalformedURLException mfe) {
                url = null;
            }
            if (url == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Unable to open manifest for " + fileURI), (String)"Unable to Open Manifest", null);
            } else {
                try {
                    Node manifestNode = NodeFactory.findOrCreate((URL)url);
                    Context context = Context.newIdeContext((Node)manifestNode);
                    Editor editor = EditorUtil.openExplicitEditorInFrame(Class.forName("oracle.ide.ceditor.CodeEditor"), (Context)context);
                    if (editor instanceof TextEditor) {
                        int row = locator.getLineNumber();
                        int col = locator.getColumnNumber();
                        ((TextEditor)editor).gotoLine(row, col, true);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        private boolean isWarning(Object obj) {
            return obj instanceof LogRecord && ((LogRecord)obj).getLevel() == Level.WARNING;
        }

        private boolean isError(Object obj) {
            return obj instanceof LogRecord && ((LogRecord)obj).getLevel() == Level.SEVERE;
        }

        private boolean isInformation(Object obj) {
            return obj instanceof LogRecord && ((LogRecord)obj).getLevel() == Level.INFO;
        }

        private class ManifestLogCellRender
        extends DefaultTreeCellRenderer {
            private Font _defaultFont = null;
            private Font _boldFont = null;

            private ManifestLogCellRender() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (this._defaultFont == null) {
                    this._defaultFont = this.getFont();
                    this._boldFont = new Font(this._defaultFont.getName(), 1, this._defaultFont.getSize());
                }
                if (value instanceof LogRecord) {
                    LogRecord rec = (LogRecord)value;
                    this.setText(ManifestExtensionLogPage.this.getRecordText(rec));
                }
                if (leaf) {
                    if (ManifestExtensionLogPage.this.isError(value)) {
                        this.setIcon(OracleIcons.getIcon((String)"error.png"));
                    } else if (ManifestExtensionLogPage.this.isWarning(value)) {
                        this.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    } else if (ManifestExtensionLogPage.this.isInformation(value)) {
                        this.setIcon(OracleIcons.getIcon((String)"info.png"));
                    }
                } else {
                    this.setIcon(OracleIcons.getIcon((String)"extras/extension.png"));
                }
                this.setFont(leaf ? this._defaultFont : this._boldFont);
                return this;
            }
        }
    }
}

