/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ideimpl.extension.ExtensionManagerImpl;

public final class IDEHookHandlerHook
extends ExtensionHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "jdeveloper-hook");
    private static final ElementName HOOK_HANDLER = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "hook-handler");
    private final IDEHookVisitorFactory _hookVisitorFactory = new IDEHookVisitorFactory();
    private final ElementVisitor _hookHandlerVisitor = new HookHandlerVisitor();

    public void start(ElementStartContext context) {
        context.registerVisitorFactory((ElementVisitorFactory)this._hookVisitorFactory);
    }

    private class HookHandlerVisitor
    extends ElementVisitor {
        private HookHandlerVisitor() {
        }

        public void start(ElementStartContext context) {
            String tagName = context.getAttributeValue("tag-name");
            if (tagName == null || (tagName = tagName.trim()).length() == 0) {
                context.getLogger().severe("Missing required attribute 'tag-name'");
                return;
            }
            String handlerClassName = context.getAttributeValue("handler-class");
            if (handlerClassName == null || (handlerClassName = handlerClassName.trim()).length() == 0) {
                context.getLogger().severe("Missing required attribute 'handler-class'");
                return;
            }
            String namespace = context.getAttributeValue("namespace");
            if (namespace == null || (namespace = namespace.trim()).length() == 0) {
                context.getLogger().severe("Missing required attribute 'namespace'");
                return;
            }
            MetaClass mc = new MetaClass(Thread.currentThread().getContextClassLoader(), handlerClassName);
            Object hookInstance = null;
            try {
                hookInstance = mc.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                this.log((ElementContext)context, Level.SEVERE, "Custom hook class " + handlerClassName + " not found.");
                return;
            }
            catch (InstantiationException ie) {
                this.log((ElementContext)context, Level.SEVERE, "Custom hook class " + handlerClassName + " cannot be instantiated.");
                ie.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                this.log((ElementContext)context, Level.SEVERE, "Custom hook class " + handlerClassName + " is not public or does not have a public no argument constructor.");
                iae.printStackTrace();
            }
            if (hookInstance != null) {
                try {
                    ExtensionManagerImpl extReg = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry();
                    ElementName name = new ElementName(namespace, tagName);
                    if (extReg.getHook(name) == null) {
                        extReg.registerHook(name, (ExtensionHook)hookInstance);
                    } else {
                        this.log((ElementContext)context, Level.SEVERE, "Duplicate definition of hook for " + name);
                    }
                }
                catch (ClassCastException cce) {
                    this.log((ElementContext)context, Level.SEVERE, "Custom hook class " + handlerClassName + " is not derived from " + ExtensionHook.class.getName());
                }
            }
        }
    }

    private class IDEHookVisitorFactory
    implements ElementVisitorFactory {
        private IDEHookVisitorFactory() {
        }

        public ElementVisitor getVisitor(ElementName name) {
            if (HOOK_HANDLER.equals((Object)name)) {
                return IDEHookHandlerHook.this._hookHandlerVisitor;
            }
            ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
            return extReg.getHook(name);
        }
    }
}

