/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DependenciesVisitor;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.net.VirtualFileSystem;
import oracle.classloader.ConfigurationOrigin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.boot.IdeConfigurationTypes;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ideimpl.extension.ExtensionManagerLoader;

final class IDEExtensionVisitor
extends ExtensionVisitor {
    private final ExtensionRegistry extensionManager;
    private final ExtensionManagerLoader loader;

    IDEExtensionVisitor(ElementVisitorFactory factory, ExtensionRegistry extensionManager, ExtensionManagerLoader loader) {
        super(factory);
        this.extensionManager = extensionManager;
        this.loader = loader;
    }

    public void extension(ElementContext context, Extension extension) {
        super.extension(context, extension);
        ResourceBundle bundle = IDEExtensionVisitor.getResourceBundle((ElementContext)context);
        if (bundle instanceof ArrayResourceBundle) {
            context.getLogger().log((LogRecord)new ExtensionLogRecord(context, Level.SEVERE, "rsbundle-class '" + bundle.getClass().getName() + "' is an ArrayResourceBundle. ArrayResourceBundles must not be used in extension manifests."));
        }
    }

    private String stripSuffix(String s) {
        int lastDot = s.lastIndexOf(46);
        if (lastDot == -1) {
            return s;
        }
        return s.substring(0, lastDot);
    }

    private ConfigurationOrigin originFor(ElementContext context, Extension extension, URI entry) {
        VirtualFileSystem fs = VirtualFileSystem.getVirtualFileSystem();
        String fileName = fs.getFileName(entry);
        fileName = this.stripSuffix(fileName);
        if (extension.getID().equals(fileName)) {
            URI parent = fs.getParent(entry);
            String parentLocalName = fs.getPlatformPathName(parent);
            return new ConfigurationOrigin(IdeConfigurationTypes.EXTENSION_JAR, parentLocalName);
        }
        ExtensionSource source = (ExtensionSource)context.getScopeData().get("extSource");
        if (source == null) {
            return new ConfigurationOrigin(IdeConfigurationTypes.EXTENSION_CLASSPATH, extension.getID());
        }
        URI sourceUri = source.getManifestURI();
        String sourcePath = extension.getID();
        if (sourceUri != null) {
            sourcePath = sourceUri.getPath();
        }
        return new ConfigurationOrigin(IdeConfigurationTypes.EXTENSION_CLASSPATH, sourcePath);
    }

    public void addToClasspath(ElementContext context, Extension ext, URI entry) {
        if (entry == null) {
            return;
        }
        URL url = this.toURL(entry);
        if (URLFileSystem.exists((URL)url)) {
            this.loader.addToClassLoader(Collections.singletonList(this.ensureDirectoryUrlEndsWithSlash(url)), this.loader.findOrCreateLoader(ext), this.originFor(context, ext, entry));
        } else {
            this.warnMissingClasspathEntry(context, url);
        }
    }

    private URL toURL(URI uri) {
        try {
            return VirtualFileSystem.getVirtualFileSystem().toURL(uri);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private URL ensureDirectoryUrlEndsWithSlash(URL url) {
        String urlString = url.toString();
        if (IDEExtensionVisitor.last(urlString) == '/') {
            return url;
        }
        if (urlString.endsWith("jar") || urlString.endsWith("zip")) {
            return url;
        }
        if (!URLFileSystem.isDirectory((URL)url)) {
            return url;
        }
        return URLFactory.newURL((String)(urlString + '/'));
    }

    private static char last(String s) {
        return s.charAt(s.length() - 1);
    }

    private void warnMissingClasspathEntry(ElementContext context, URL url) {
        if (!Boolean.getBoolean("ide.extension.cpmissing.nowarn")) {
            this.log(context, Level.WARNING, "Classpath entry " + URLFileSystem.getPlatformPathName((URL)url) + " not found.");
        }
    }

    protected ElementVisitor createClasspathVisitor() {
        return new BaseExtensionVisitor.ClasspathVisitor(){

            protected boolean acceptClasspathEntry(ElementContext context, URI uri) {
                if (!uri.toString().toLowerCase().endsWith("jar")) {
                    return true;
                }
                VirtualFileSystem vfs = VirtualFileSystem.getVirtualFileSystem();
                URI parent = vfs.getParent(uri);
                File parentAsFile = new File(vfs.getPlatformPathName(parent));
                for (File dir : IDEExtensionVisitor.this.extensionManager.getExtensionSearchPath()) {
                    if (!parentAsFile.equals(dir)) continue;
                    String jarName = vfs.getFileName(uri);
                    this.log(context, Level.SEVERE, "Extension jar '" + jarName + "' must not be imported using <classpath>. Use <import> instead.");
                }
                return true;
            }
        };
    }

    protected ClassLoader getClassLoader(Extension extension) {
        return this.loader.findOrCreateLoader(extension);
    }

    protected ElementVisitor createDependenciesVisitor() {
        return new DependenciesVisitor(){

            protected void endDependencies(Extension extension) {
                IDEExtensionVisitor.this.loader.resolveImports(extension);
            }
        };
    }
}

