/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.Extension2;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import oracle.classloader.ClassLoaderQuery;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.PolicyClassLoader;
import oracle.classloader.util.VersionNumber;
import oracle.ide.boot.IdeConfigurationPolicies;
import oracle.ide.boot.IdeConfigurationTypes;
import oracle.ide.boot.IsolatedExtensionsModuleOutputProcessor;

final class ExtensionManagerLoader {
    private static final Logger LOG = Logger.getLogger(ExtensionManagerLoader.class.getName());
    private final Logger manifestLogger;
    private boolean loadersCommitted = false;

    ExtensionManagerLoader(Logger logger) {
        this.manifestLogger = logger;
    }

    synchronized ClassLoader findOrCreateLoader(Extension extension) {
        if (!(extension instanceof Extension2)) {
            return this.globalLoader();
        }
        Extension2 extension2 = (Extension2)extension;
        switch (extension2.getPreferredLoader()) {
            case GLOBAL: {
                return this.globalLoader();
            }
            case ISOLATED: {
                return this.findOrCreateIsolatedLoader(extension);
            }
        }
        throw new AssertionError((Object)("Unknown preferred loader: " + extension2.getPreferredLoader()));
    }

    ClassLoader findLoader(String name) {
        return ClassLoaderQuery.findLoader((String)name);
    }

    private boolean isGlobalLoader(ClassLoader loader) {
        if (!(loader instanceof PolicyClassLoader)) {
            return false;
        }
        return "ide-global".equals(((PolicyClassLoader)loader).getName());
    }

    ClassLoader globalLoader() {
        return this.findLoader("ide-global");
    }

    private ClassLoader findOrCreateIsolatedLoader(Extension extension) {
        ClassLoader loader = this.findLoader(extension.getID());
        if (loader != null) {
            return loader;
        }
        LOG.log(Level.CONFIG, "Creating isolated class loader for {0}", extension.getID());
        ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.ISOLATED_LOADER, this.sourceUri(extension));
        PolicyClassLoader pcl = new PolicyClassLoader(extension.getID(), new VersionNumber(extension.getVersion().toString()), this.globalLoader(), origin, IdeConfigurationPolicies.EXTENSION_LOADER_POLICY);
        if (IsolatedExtensionsModuleOutputProcessor.hasModularBuildDirectory((String)extension.getID())) {
            File modularBuildDirectory = IsolatedExtensionsModuleOutputProcessor.getModularBuildDirectory((String)extension.getID());
            ConfigurationOrigin modularBuildOrigin = new ConfigurationOrigin(IdeConfigurationTypes.MODULAR_BUILD_OUTPUT, modularBuildDirectory.getAbsolutePath());
            try {
                pcl.addCodeSource(modularBuildDirectory.getAbsolutePath(), modularBuildOrigin);
            }
            catch (IOException e) {
                LOG.log(Level.CONFIG, "Failed to add modular outpur directory for {0}", extension.getID());
            }
        }
        return pcl;
    }

    void resolveImports(Extension extension) {
        ClassLoader loader = this.findOrCreateLoader(extension);
        if (this.isGlobalLoader(loader)) {
            return;
        }
        this.importLoaders((PolicyClassLoader)loader, extension);
    }

    private void importLoaders(PolicyClassLoader loader, Extension extension) {
        for (ExtensionDependency dep : extension.getDependencies()) {
            ClassLoader depLoader;
            String depId = dep.getID();
            Extension depExtension = this.findExtension(depId);
            if (depExtension == null || this.isGlobalLoader(depLoader = this.findOrCreateLoader(depExtension))) continue;
            loader.importLoader((PolicyClassLoader)depLoader, new ConfigurationOrigin(IdeConfigurationTypes.EXTENSION_IMPORT, this.sourceUri(extension)));
        }
    }

    private String sourceUri(Extension extension) {
        if (!(extension instanceof DefaultExtension)) {
            return extension.getID();
        }
        ExtensionSource source = ((DefaultExtension)extension).getSource();
        if (source == null) {
            return extension.getID();
        }
        URI uri = source.getManifestURI();
        if (uri == null) {
            return extension.getID();
        }
        return uri.getPath();
    }

    private Extension findExtension(String id) {
        return ExtensionRegistry.getExtensionRegistry().findExtension(id);
    }

    void addToClassLoader(Collection<URL> entries, ClassLoader loader, ConfigurationOrigin origin) {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        assert (loader instanceof PolicyClassLoader) : "Don't know how to add classes to loader " + loader;
        PolicyClassLoader pcl = (PolicyClassLoader)loader;
        for (URL entry : entries) {
            try {
                LOG.log(Level.CONFIG, "Adding {0} to loader {1}. Origin: {2}", new String[]{entry.toString(), loader.toString(), origin.toString()});
                pcl.addCodeSource(entry, origin);
            }
            catch (IOException e) {
                this.manifestLogger.log(Level.SEVERE, "Failed to add classpath entry " + entry, e);
            }
        }
    }

    synchronized void commitLoaders() {
        if (this.loadersCommitted) {
            throw new IllegalStateException("Already committed all loaders");
        }
        this.loadersCommitted = true;
        for (Object loader : ClassLoaderQuery.getAllLoaders()) {
            LOG.log(Level.CONFIG, "Committing loader {0}", loader.toString());
            ((PolicyClassLoader)loader).commit();
        }
    }
}

