/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.ide.IDE;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.UnrecognizedElementException;
import javax.ide.extension.spi.BaseExtensionVisitor;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.DefaultHookVisitorFactory;
import javax.ide.extension.spi.DependenciesVisitor;
import javax.ide.extension.spi.DependencyTree;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.ExtensionVisitor;
import javax.ide.extension.spi.Feature;
import javax.ide.extension.spi.FeatureHook;
import javax.ide.extension.spi.FeatureRegistry;
import javax.ide.extension.spi.JARExtensionSource;
import javax.ide.extension.spi.SAXManifestParser;
import javax.ide.model.DocumentFactory;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.Graph;
import javax.swing.Icon;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.classloader.ConfigurationOrigin;
import oracle.classloader.PolicyClassLoader;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.Version;
import oracle.ide.boot.IdeConfigurationTypes;
import oracle.ide.config.ClientSetting;
import oracle.ide.extension.ExtensionProcessorPlugin;
import oracle.ide.extension.PropertiesExtensionProcessorPlugin;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.extension.AddinsAboutPage;
import oracle.ideimpl.extension.DefaultIdeExtensionSearchStrategy;
import oracle.ideimpl.extension.DisabledReason;
import oracle.ideimpl.extension.ExtensionInfo;
import oracle.ideimpl.extension.ExtensionManagerLoader;
import oracle.ideimpl.extension.ExtensionSearchStrategy;
import oracle.ideimpl.extension.IDEElementContext;
import oracle.ideimpl.extension.IDEExtensionVisitor;
import oracle.ideimpl.extension.LocatorImpl;
import oracle.ideimpl.extension.MessagePresenter;
import oracle.ideimpl.extension.MutableURLClassLoader;
import oracle.ideimpl.extension.RoleExtensionSource;
import oracle.ideimpl.extension.RoleManagerImpl;
import oracle.ideimpl.extension.RolePreferencePage;
import oracle.ideimpl.extension.RolePreferences;
import oracle.ideimpl.extension.RoleSelectionPanel;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.controls.SplashScreen;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.Pair;
import oracle.javatools.util.SwingClosure;
import oracle.javatools.util.SwingUtils;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;

public class ExtensionManagerImpl
extends ExtensionRegistry {
    private ExtensionSearchStrategy searchStrategy;
    private MessagePresenter _msgPresenter;
    private ExtensionSet _extensionSet;
    private Set _newlyInstalledIds = new HashSet();
    private final Set<String> m_disabledExtensionIdsOnly = new HashSet<String>();
    private final Set _disabledExtensionIds = new HashSet();
    private final Map _disabledExtensions = new HashMap();
    private final Map _disabledFeaturesByExtension = new HashMap();
    private final Map<String, Pair<DisabledReason, String>> _disabledReasons = new HashMap<String, Pair<DisabledReason, String>>();
    private RoleManagerImpl _roleManager;
    private Collection<File> _extensionSearchPath;
    private DefaultHookVisitorFactory _hookVisitor;
    private Collection<ExtensionProcessorPlugin> _processorPlugins = new ArrayList<ExtensionProcessorPlugin>();
    private Collection<ExtensionSource> _allExtensionSources;
    private final ExtensionManagerLoader _loader = new ExtensionManagerLoader(this.getManifestLogger());

    private ExtensionSearchStrategy getSearchStrategy() {
        if (this.searchStrategy != null) {
            return this.searchStrategy;
        }
        String strategyType = System.getProperty("ide.extension.search.strategy");
        if (strategyType != null) {
            try {
                this.searchStrategy = (ExtensionSearchStrategy)Class.forName(strategyType).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.searchStrategy == null) {
            this.searchStrategy = new DefaultIdeExtensionSearchStrategy();
        }
        this.searchStrategy.setExtensionRegistry(this);
        return this.searchStrategy;
    }

    protected ElementVisitorFactory createHookVisitorFactory() {
        this._hookVisitor = new DefaultHookVisitorFactory(){

            protected ElementVisitor validateHookForExtension(ElementContext context, ElementName name, ExtensionHook hook, Extension extension) throws UnrecognizedElementException {
                if (extension instanceof DefaultExtension && ((DefaultExtension)extension).getSource() instanceof RoleExtensionSource) {
                    return hook;
                }
                return super.validateHookForExtension(context, name, hook, extension);
            }
        };
        return this._hookVisitor;
    }

    public final Collection<ExtensionHook> getAllHooks() {
        if (this._hookVisitor == null) {
            throw new IllegalStateException("Hook visitor factory not yet initialized");
        }
        return this._hookVisitor.getHooks();
    }

    private Collection<File> getRoleSearchPath() {
        LinkedHashSet<File> searchPath = new LinkedHashSet<File>();
        File ideRoles = new File(this.oracleHome() + "/ide/roles");
        if (ideRoles.isDirectory()) {
            searchPath.add(ideRoles);
        }
        String baseDir = this.oracleHome();
        String systemPropPaths = System.getProperty("ide.extension.role.search.path");
        if (systemPropPaths != null) {
            for (String token : ExtensionManagerImpl.pathElements(systemPropPaths)) {
                File f = new File((baseDir != null ? baseDir + "/" : "") + token);
                if (f.isDirectory()) {
                    searchPath.add(f);
                    continue;
                }
                File file = new File(token);
                if (!file.isDirectory()) continue;
                searchPath.add(file);
            }
        }
        return searchPath;
    }

    private void addRoleResourcesToClasspath(Collection<File> roleSearchPath) {
        ArrayList<URL> pathEntries = new ArrayList<URL>();
        for (File f : roleSearchPath) {
            pathEntries.add(URLFactory.newDirURL((String)new File(f, "res").getAbsolutePath()));
        }
        if (!pathEntries.isEmpty()) {
            this.addURLToClassPath(pathEntries);
        }
    }

    protected final void cycleEncountered(Collection extensions) {
        StringBuffer cycle = new StringBuffer();
        for (Extension e : extensions) {
            cycle.append(e.getID());
            cycle.append("->");
        }
        if (cycle.length() > 2) {
            cycle.setLength(cycle.length() - 2);
        }
        Extension lastExtension = (Extension)extensions.toArray()[extensions.size() - 1];
        this.createExtensionLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "Cyclic extension dependencies: " + cycle.toString(), lastExtension, 0));
    }

    protected String oracleHome() {
        return Ide.getOracleHomeDirectory();
    }

    protected String productHome() {
        return Ide.getProductHomeDirectory();
    }

    public Collection<File> getExtensionSearchPath() {
        if (this._extensionSearchPath == null) {
            this._extensionSearchPath = new LinkedHashSet<File>();
            File ideExtensions = new File(this.oracleHome() + "/ide", "extensions");
            if (ideExtensions.isDirectory()) {
                this._extensionSearchPath.add(ideExtensions);
            }
            this.addPathEntries("ide.extension.search.path", this._extensionSearchPath);
            this.addPathEntries("ide.extension.extra.search.path", this._extensionSearchPath, null);
        }
        return this._extensionSearchPath;
    }

    private void addPathEntries(String systemProperty, Collection<File> paths) {
        this.addPathEntries(systemProperty, paths, this.oracleHome());
    }

    static Collection<String> pathElements(String path) {
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder currentElement = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ':' && currentElement.length() == 1) {
                currentElement.append(c);
                continue;
            }
            if (c == ':' || c == ';' || c == ',') {
                elements.add(currentElement.toString());
                currentElement.setLength(0);
                continue;
            }
            currentElement.append(c);
        }
        if (currentElement.length() > 0) {
            elements.add(currentElement.toString());
        }
        return Collections.unmodifiableCollection(elements);
    }

    private void addPathEntries(String systemProperty, Collection<File> paths, String baseDir) {
        String systemPropPaths = System.getProperty(systemProperty);
        if (systemPropPaths != null) {
            for (String token : ExtensionManagerImpl.pathElements(systemPropPaths)) {
                File f = new File((baseDir != null ? baseDir + "/" : "") + token);
                if (!f.isDirectory()) continue;
                paths.add(f);
            }
        }
    }

    public URL getSystemDirectory(String extensionId) {
        if (extensionId == null) {
            throw new NullPointerException("extensionId is null");
        }
        Extension ext = this.findExtension(extensionId);
        if (ext == null) {
            Collection<String> disabledExtensions = this.getDisabledExtensions();
            if (disabledExtensions.contains(extensionId)) {
                ext = this.findDisabledExtension(extensionId);
            } else {
                throw new IllegalArgumentException("Unrecognized extension id " + extensionId);
            }
        }
        return this.getSystemDirectory(extensionId, ext.getVersion());
    }

    public URL getSystemDirectory(String extensionId, javax.ide.util.Version version) {
        if (extensionId == null) {
            throw new NullPointerException("extensionId is null");
        }
        if (version == null) {
            throw new NullPointerException("version is null");
        }
        String dirName = this.compactExtensionId(extensionId);
        if (!new javax.ide.util.Version(Version.VER_FULL).equals((Object)version)) {
            dirName = dirName + "." + version.toCanonicalString();
        }
        return URLFactory.newDirURL((URL)URLFactory.newDirURL((String)Ide.getSystemDirectory()), (String)dirName);
    }

    private String compactExtensionId(String extensionId) {
        if (extensionId.startsWith("oracle.") && extensionId.length() > "oracle.".length()) {
            return "o." + extensionId.substring("oracle.".length());
        }
        return extensionId;
    }

    public boolean isLoaded(String extensionId) {
        return !this.getDisabledExtensions().contains(extensionId);
    }

    public boolean isUserExtension(String extensionId) {
        if (extensionId == null) {
            throw new NullPointerException("extensionId is null");
        }
        try {
            ExtensionSource src = ((DefaultExtension)this.findExtension(extensionId)).getSource();
            if (src instanceof JARExtensionSource) {
                JARExtensionSource jarSource = (JARExtensionSource)src;
                String path = URLFileSystem.getPlatformPathName((URL)VirtualFileSystem.getVirtualFileSystem().toURL(jarSource.getURI()));
                return !Ide.getProductHomeDirectory().equals(Ide.getUserSettingsDirectory()) && path.startsWith(Ide.getUserSettingsDirectory());
            }
            return false;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String ideExtensionsValue() {
        return System.getProperty("ide.extensions");
    }

    private String prohibitedExtensionsValue() {
        return System.getProperty("ide.prohibited.extensions");
    }

    protected Collection loadExtensions() {
        try {
            this.expandExtensionClosure();
            this.checkForProhibitedExtensions();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return super.loadExtensions();
    }

    private void checkForProhibitedExtensions() throws IOException {
        Set<String> enabled = ExtensionManagerImpl.stringToSet(this.ideExtensionsValue());
        Set<String> prohibited = ExtensionManagerImpl.stringToSet(this.prohibitedExtensionsValue());
        enabled.retainAll(prohibited);
        if (!enabled.isEmpty()) {
            throw new IllegalArgumentException("The ide cannot start because extensions on the ide.prohibited.extensions list are enabled via the closure of ide.extensions. Prohibited: " + enabled);
        }
    }

    private void expandExtensionClosure() throws IOException {
        Set<String> enabledIds = ExtensionManagerImpl.stringToSet(this.ideExtensionsValue());
        if (enabledIds.isEmpty()) {
            return;
        }
        ArrayList failed = new ArrayList();
        Map extensions = DependencyTree.loadMinimal((DefaultElementContext)new IDEElementContext(), this.findAllExtensionSources(), failed, (Logger)this.createExtensionLogger());
        DependencyTree.removeDuplicates((Map)extensions);
        HashMap<String, Extension> extensionsById = new HashMap<String, Extension>();
        for (Extension e : extensions.keySet()) {
            extensionsById.put(e.getID(), e);
        }
        Graph graph = new Graph();
        for (Extension e : extensions.keySet()) {
            if (!graph.contains((Object)e)) {
                graph.add((Object)e);
            }
            Collection deps = e.getDependencies();
            for (ExtensionDependency d : deps) {
                String id = d.getID();
                Extension depExtension = (Extension)extensionsById.get(id);
                if (depExtension == null) continue;
                if (!graph.contains((Object)depExtension)) {
                    graph.add((Object)depExtension);
                }
                graph.connect((Object)depExtension, (Object)e);
            }
        }
        HashSet<String> closure = new HashSet<String>(enabledIds);
        for (String enabledId : enabledIds) {
            Extension enabledExtension = (Extension)extensionsById.get(enabledId);
            try {
                if (enabledExtension == null) {
                    System.err.println("Extension id " + enabledId + " specified in ide.extensions does not exist!");
                    continue;
                }
                List closureForThis = graph.getVerticesConnectedTo((Object)enabledExtension);
                for (Extension e : closureForThis) {
                    closure.add(e.getID());
                }
            }
            catch (Graph.CycleException ce) {
                ce.printStackTrace();
            }
        }
        StringBuilder closureString = new StringBuilder();
        for (String id : closure) {
            closureString.append(id);
            closureString.append(",");
        }
        if (!closure.isEmpty()) {
            closureString.setLength(closureString.length() - 1);
        }
        System.setProperty("ide.extensions", closureString.toString());
    }

    protected Collection loadExtensions(Collection orderedSources) {
        ArrayList<RoleExtensionSource> updatedSources = new ArrayList<RoleExtensionSource>(orderedSources.size() + 1);
        updatedSources.addAll(orderedSources);
        Role activeRole = this.getRoleManager().getActiveRole();
        if (RoleManager.NO_ROLE != activeRole) {
            File roleFile = ((RoleManagerImpl)this.getRoleManager()).getRoleFile(activeRole);
            RoleExtensionSource roleSource = new RoleExtensionSource(roleFile);
            updatedSources.add(roleSource);
        }
        return super.loadExtensions(updatedSources);
    }

    public Collection getAllExtensions() {
        ArrayList<Extension> allExtensions = new ArrayList<Extension>(this.getExtensions());
        Collection<String> disabledExtensionIds = this.getDisabledExtensions();
        for (String id : disabledExtensionIds) {
            allExtensions.add(this.findDisabledExtension(id));
        }
        return allExtensions;
    }

    public Collection<String> getDisabledExtensions() {
        return this.m_disabledExtensionIdsOnly;
    }

    public Extension findExtensionEvenIfNotLoaded(String id) {
        Extension ext = this.findExtension(id);
        if (ext == null && this.getDisabledExtensions().contains(id)) {
            ext = this.findDisabledExtension(id);
        }
        return ext;
    }

    public Extension findDisabledExtension(String id) {
        Extension ext = (Extension)this._disabledExtensions.get(id);
        if (ext == null) {
            javax.ide.util.Version version = null;
            for (Pair p : this._disabledExtensionIds) {
                if (!p.getFirst().equals(id)) continue;
                javax.ide.util.Version thisVersion = (javax.ide.util.Version)p.getSecond();
                if (version != null && thisVersion.compareTo(version) <= 0) continue;
                version = thisVersion;
            }
            if (version == null) {
                throw new IllegalArgumentException("Unknown extension " + id);
            }
            ext = this.loadDisabledExtension(id, version);
            this._disabledExtensions.put(id, ext);
        }
        return ext;
    }

    protected void loadExtension(SAXManifestParser parser, Logger logger, ExtensionSource source) {
        String name = source.getName();
        int lastSlash = name.lastIndexOf(47);
        if (lastSlash > 0) {
            name = name.substring(lastSlash + 1);
        }
        long start = System.nanoTime();
        super.loadExtension(parser, logger, source);
        PerformanceLogger.get().log("loadExtension", name, System.nanoTime() - start);
    }

    List<File> findExtensionJars(String id) {
        ArrayList<File> results = new ArrayList<File>();
        for (File dir : this.getExtensionSearchPath()) {
            File f = new File(dir, id + ".jar");
            if (!f.isFile()) continue;
            results.add(f);
        }
        return results;
    }

    private Extension loadDisabledExtension(String id, javax.ide.util.Version version) {
        Extension extension = null;
        for (File jarFile : this.findExtensionJars(id)) {
            Extension potential = this.loadDisabledExtension(id, version, jarFile.getPath());
            if (!version.equals((Object)potential.getVersion())) continue;
            extension = potential;
            break;
        }
        if (extension == null) {
            DefaultExtension de = new DefaultExtension(id);
            de.setVersion(version);
            return de;
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Extension loadDisabledExtension(String id, javax.ide.util.Version version, String extensionJAR) {
        JARExtensionSource source = new JARExtensionSource(URIFactory.newURI((String)extensionJAR));
        SAXManifestParser disabledParser = new SAXManifestParser((DefaultElementContext)this.createInitialContext());
        DisabledExtensionVisitor visitor = new DisabledExtensionVisitor();
        disabledParser.getContext().registerChildVisitor(ExtensionVisitor.ELEMENT, (ElementVisitor)visitor);
        disabledParser.getContext().getScopeData().put("extSource", source);
        MutableURLClassLoader cl = new MutableURLClassLoader(new URL[]{URLFactory.newURL((String)extensionJAR)}, Thread.currentThread().getContextClassLoader());
        disabledParser.getContext().getScopeData().put("classLoader", cl);
        InputStream inputStream = null;
        try {
            inputStream = VirtualFileSystem.getVirtualFileSystem().openInputStream(source.getManifestURI());
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(source.getManifestURI().toString());
            disabledParser.parse(inputSource);
            Extension extension = visitor.getExtension();
            Feature feature = visitor.getFeature();
            if (feature != null) {
                this._disabledFeaturesByExtension.put(extension, feature);
            }
            Extension extension2 = extension;
            return extension2;
        }
        catch (Exception e) {
            DefaultExtension de = new DefaultExtension(id);
            de.setVersion(version);
            DefaultExtension defaultExtension = de;
            return defaultExtension;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public Feature getFeature(Extension extension) {
        Feature feature = FeatureRegistry.getFeatureRegistry().getFeature(extension);
        if (feature == null) {
            return this.getDisabledFeature(extension);
        }
        return feature;
    }

    private Feature getDisabledFeature(Extension extension) {
        Collection<String> disabledExtensions = this.getDisabledExtensions();
        if (disabledExtensions.contains(extension.getID())) {
            Extension disabledExt = this.findDisabledExtension(extension.getID());
            return (Feature)this._disabledFeaturesByExtension.get(disabledExt);
        }
        return null;
    }

    protected ElementContext createInitialContext() {
        return new IDEElementContext();
    }

    protected Logger createExtensionLogger() {
        if (this._manifestLogger != null) {
            return this._manifestLogger;
        }
        this._manifestLogger = super.createExtensionLogger();
        this._manifestLogger.setUseParentHandlers(false);
        this._manifestLogger.addHandler(this.createConsoleLogHandler());
        if (Ide.isRunning() && Ide.getIdeArgs().getCreateUI() && !GraphicsEnvironment.isHeadless()) {
            this._manifestLogger.addHandler(this.createLogWindowLogHandler());
        }
        return this._manifestLogger;
    }

    private Handler createConsoleLogHandler() {
        ConsoleHandler handler = new ConsoleHandler(){

            @Override
            public void publish(LogRecord record) {
                if (super.isLoggable(record) && record.getLevel() == Level.SEVERE) {
                    super.publish(record);
                }
            }
        };
        handler.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                return record instanceof ExtensionLogRecord && ((ExtensionLogRecord)record).getLocator() != null;
            }
        });
        handler.setFormatter(new SimpleFormatter(){

            @Override
            public synchronized String formatMessage(LogRecord record) {
                Locator locator = ((ExtensionLogRecord)record).getLocator();
                return locator.getSystemId() + ":" + locator.getLineNumber() + ": " + super.formatMessage(record);
            }
        });
        return handler;
    }

    private Handler createLogWindowLogHandler() {
        if (this._msgPresenter != null) {
            return this._msgPresenter;
        }
        this._msgPresenter = new MessagePresenter();
        return this._msgPresenter;
    }

    protected ExtensionVisitor createExtensionVisitor(ElementVisitorFactory hookVisitorFactory) {
        return new IDEExtensionVisitor(hookVisitorFactory, this, this._loader);
    }

    protected Collection<ExtensionSource> findAllExtensionSources() {
        return this.getSearchStrategy().findExtensionSources();
    }

    public ClassLoader getClassLoader(String extensionId) {
        return this._loader.findOrCreateLoader(this.findExtension(extensionId));
    }

    public RoleManager getRoleManager() {
        if (this._roleManager == null) {
            this._roleManager = new RoleManagerImpl();
        }
        return this._roleManager;
    }

    protected void initialize() {
        this.runRoleSelectionDialog();
        this.loadProcessorPlugins();
        super.initialize();
        this.addUserJarsToClasspath();
        this._loader.commitLoaders();
        this.postLoadedExtensions();
    }

    private void addUserJarsToClasspath() {
        File userDir = new File(Ide.getUserSettingsDirectory());
        File lib = new File(userDir, "idelib");
        File[] files = lib.listFiles();
        if (files == null) {
            return;
        }
        ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.IDELIB_JAR, lib.getPath());
        for (File f : files) {
            String name = f.getName();
            if (!name.toLowerCase().endsWith(".jar")) continue;
            this._loader.addToClassLoader(Collections.singleton(URLFactory.newFileURL((File)f)), this._loader.globalLoader(), origin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProcessorPlugins() {
        PerformanceLogger.get().startTiming("loadProcessorPlugins");
        try {
            this.loadProcessorPlugins(new File(this.productHome(), "macros"), this._processorPlugins);
            this.loadProcessorPlugins(new File(this.oracleHome(), "ide/macros"), this._processorPlugins);
        }
        finally {
            PerformanceLogger.get().stopTiming("loadProcessorPlugins", "Loaded ExtensionProcessorPlugins", 250);
        }
    }

    private void loadProcessorPlugins(File directory, Collection<ExtensionProcessorPlugin> plugins) {
        File[] files = directory.listFiles();
        if (files != null) {
            ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.PROCESSOR_PLUGIN, directory.getPath());
            for (File file : files) {
                try {
                    URL url;
                    if (!file.getName().toLowerCase().endsWith(".jar") || !URLFileSystem.exists((URL)(url = URLFactory.newJarURL((File)file, (String)"META-INF/services/oracle.ide.extension.ExtensionProcessorPlugin")))) continue;
                    this.getLogger().config("Adding manifest processor plugin jar " + file);
                    if (Thread.currentThread().getContextClassLoader() instanceof PolicyClassLoader) {
                        this._loader.addToClassLoader(Collections.singleton(URLFactory.newFileURL((File)file)), this._loader.globalLoader(), origin);
                    } else {
                        this.addURLToClassPath(Collections.singleton(URLFactory.newFileURL((File)file)));
                    }
                    String className = this.readTextFromFile(url);
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> c = Class.forName(className, true, loader);
                    plugins.add((ExtensionProcessorPlugin)c.newInstance());
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.SEVERE, "Exception loading macro definitions from " + file, t);
                }
            }
            for (File file : files) {
                try {
                    String name = file.getName().toLowerCase();
                    if (!name.endsWith(".properties") && !name.endsWith(".xml")) continue;
                    plugins.add((ExtensionProcessorPlugin)new PropertiesExtensionProcessorPlugin(file));
                }
                catch (Throwable t) {
                    this.getLogger().log(Level.SEVERE, "Exception loading macro definitions from " + file, t);
                }
            }
        }
    }

    public Collection<ExtensionProcessorPlugin> getProcessorPlugins() {
        return this._processorPlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTextFromFile(URL url) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(URLFileSystem.openInputStream((URL)url)));
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return sb.toString().trim();
    }

    private void runRoleSelectionDialog() {
        boolean headless = !Ide.getIdeArgs().getCreateUI();
        String roleId = Ide.getIdeArgs().getRole();
        if (roleId == null && (Boolean.getBoolean("ide.extension.noroles") || headless)) {
            return;
        }
        Collection<File> roleSearchPath = this.getRoleSearchPath();
        this.addRoleResourcesToClasspath(roleSearchPath);
        this.getRoleManager();
        this._roleManager.loadRoles(roleSearchPath);
        List<Role> roles = this._roleManager.getRoles();
        if (headless) {
            for (Role r : roles) {
                if (!roleId.equals(r.getId())) continue;
                this._roleManager.setActiveRole(r);
                return;
            }
            System.out.println("Role " + roleId + " not found.");
            return;
        }
        final RolePreferences prefs = this._roleManager.getRolePreferences();
        if (roles.size() == 0) {
            if (prefs.getSelectedRoleId() != null && !RoleManager.NO_ROLE.getId().equals(prefs.getSelectedRoleId())) {
                System.out.println("Role " + prefs.getSelectedRoleId() + " is no longer available.");
            }
            return;
        }
        boolean showDialog = prefs.isStartupRoleUIEnabled() && !Ide.getIdeArgs().hasArg("-nonag") && roleId == null;
        Role selectedRole = null;
        if (roleId == null && prefs.getSelectedRoleId() != null && !RoleManager.NO_ROLE.getId().equals(prefs.getSelectedRoleId())) {
            roleId = prefs.getSelectedRoleId();
        }
        if (roleId != null) {
            for (Role r : roles) {
                if (!roleId.equals(r.getId())) continue;
                selectedRole = r;
            }
            if (selectedRole == null) {
                System.out.println("Role " + roleId + " is no longer available.");
                showDialog = true;
            }
        }
        if (showDialog) {
            final ArrayList<Role> allRoles = new ArrayList<Role>();
            allRoles.add(RoleManager.NO_ROLE);
            allRoles.addAll(roles);
            try {
                new SwingClosure(false){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runImpl() {
                        RoleSelectionPanel rsp = new RoleSelectionPanel();
                        rsp.setSelectOnStartupChecked(prefs.isFresh() ? true : prefs.isStartupRoleUIEnabled());
                        rsp.setRoles(allRoles);
                        if (prefs.getSelectedRoleId() != null) {
                            rsp.setSelectedRole(prefs.getSelectedRoleId());
                        }
                        final JEWTDialog dlg = JEWTDialog.createDialog((Component)SwingUtils.getToplevelWindow(), (String)ExtensionManagerArb.getString(38), (int)3);
                        DialogHeader header = new DialogHeader();
                        header.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/person.png")));
                        header.setHeaderDescription(ExtensionManagerArb.getString(39));
                        dlg.setDialogHeader((Component)header);
                        dlg.setContent((Component)rsp);
                        dlg.setResizable(true);
                        dlg.pack();
                        rsp.addDoubleClickActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                dlg.closeDialog(false);
                            }
                        });
                        Dimension size = dlg.getPreferredSize();
                        dlg.setPreferredSize(new Dimension(Math.max(size.width, 450), size.height));
                        try {
                            if (dlg.runDialog()) {
                                prefs.setStartupRoleUIEnabled(rsp.isSelectOnStartupChecked());
                                ExtensionManagerImpl.this._roleManager.setActiveRole(rsp.getSelectedRole());
                                ExtensionManagerImpl.this._roleManager.saveRolePreferences();
                            } else {
                                System.exit(0);
                            }
                        }
                        finally {
                            SplashScreen.setVisible((boolean)true);
                        }
                    }
                }.run();
            }
            catch (ClosureException e) {
                e.printStackTrace();
            }
        } else if (selectedRole != null) {
            this._roleManager.setActiveRole(selectedRole);
        }
    }

    private void commitLoaders() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl instanceof PolicyClassLoader) {
            PolicyClassLoader pcl = (PolicyClassLoader)cl;
            pcl.commit();
        }
    }

    private static javax.ide.util.Version getVersionFromFilename(String filename) {
        String parts = ExtensionManagerImpl.getParts(filename, true);
        if (parts.length() == 0) {
            return null;
        }
        return new javax.ide.util.Version(parts);
    }

    static String getExtensionIdFromFilename(String filename) {
        return ExtensionManagerImpl.getParts(filename, false);
    }

    private static String getParts(String filename, boolean numeric) {
        StringTokenizer tok = new StringTokenizer(filename, ".");
        StringBuffer sb = new StringBuffer();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            try {
                Integer.parseInt(token);
                if (!numeric) continue;
                sb.append(token);
                sb.append('.');
            }
            catch (NumberFormatException nfe) {
                if (numeric || "jar".equalsIgnoreCase(token)) continue;
                sb.append(token);
                sb.append('.');
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private void postLoadedExtensions() {
        for (Extension ext : this.getExtensions()) {
            ExtensionSource src;
            boolean squashWarning;
            URL systemDir = this.getSystemDirectory(ext.getID());
            if (!URLFileSystem.exists((URL)systemDir)) {
                this._newlyInstalledIds.add(ext.getID());
            }
            if ((squashWarning = Boolean.getBoolean("ide.extension.badname.nowarn")) || !(ext instanceof DefaultExtension) || !((src = ((DefaultExtension)ext).getSource()) instanceof JARExtensionSource)) continue;
            URI jarURI = ((JARExtensionSource)src).getURI();
            String filename = VirtualFileSystem.getVirtualFileSystem().getFileName(jarURI);
            int lastDot = filename.lastIndexOf(46);
            if (lastDot > 1) {
                filename = filename.substring(0, lastDot);
            }
            if (filename.equals(ext.getID())) continue;
            javax.ide.util.Version v = ExtensionManagerImpl.getVersionFromFilename(filename);
            if (v != null) {
                if (ext.getVersion().toString().startsWith(v.toString())) {
                    this.getManifestLogger().log(Level.INFO, ExtensionManagerArb.getString(31), new LocatorImpl(src.getManifestURI().toString()));
                    continue;
                }
                this.getManifestLogger().log(Level.SEVERE, ExtensionManagerArb.format(32, ext.getID(), filename, ext.getVersion().toString()), new LocatorImpl(src.getManifestURI().toString()));
                continue;
            }
            this.getManifestLogger().log(Level.SEVERE, ExtensionManagerArb.format(33, ext.getID(), filename), new LocatorImpl(src.getManifestURI().toString()));
        }
        if (Ide.getIdeArgs().getCreateUI()) {
            if (!Boolean.getBoolean("ide.extension.noroles") && !this._roleManager.getRoles().isEmpty()) {
                Navigable n = new Navigable(ExtensionManagerArb.getString(40), RolePreferencePage.class);
                ClientSetting.registerUI((Navigable)n);
            }
            Ide.addIdeListener((IdeListener)new IdeListener(){

                public void addinsLoaded(IdeEvent e) {
                    Ide.removeIdeListener((IdeListener)this);
                    AboutBoxFactory.getAboutBoxFactory().addPage(ExtensionInfo.class);
                    if (Version.DEBUG_BUILD == 1 || Boolean.getBoolean("ide.extension.about.addins")) {
                        AboutBoxFactory.getAboutBoxFactory().addPage(AddinsAboutPage.class);
                    }
                }

                public void mainWindowOpened(IdeEvent e) {
                }

                public void mainWindowClosing(IdeEvent e) {
                }
            });
        }
        IDE.getIDE();
        DocumentFactory.getDocumentFactory();
    }

    final void registerHook(ElementName elementName, ExtensionHook hook) {
        super.registerIdeHook(elementName, hook);
    }

    public String getNotLoadedReason(String id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        if (this.isLoaded(id)) {
            return "";
        }
        Pair<DisabledReason, String> reason = this._disabledReasons.get(id);
        if (reason == null) {
            return ExtensionManagerArb.getString(34);
        }
        return String.format(((DisabledReason)((Object)reason.getFirst())).getMessageTemplate(), reason.getSecond());
    }

    public DisabledReason getDisabledReason(String id) {
        Pair<DisabledReason, String> reason = this._disabledReasons.get(id);
        if (reason == null) {
            return DisabledReason.ERROR;
        }
        return (DisabledReason)((Object)reason.getFirst());
    }

    protected void unsatisfiedExtensionDependencies(Extension ext, Collection deps) {
        Pair thisExtension = new Pair((Object)ext.getID(), (Object)ext.getVersion());
        this._disabledExtensionIds.add(thisExtension);
        this.m_disabledExtensionIdsOnly.add(ext.getID());
        StringBuffer missingDeps = new StringBuffer();
        Iterator i = deps.iterator();
        while (i.hasNext()) {
            ExtensionDependency dep = (ExtensionDependency)i.next();
            missingDeps.append(dep.getID());
            if (!i.hasNext()) continue;
            missingDeps.append(", ");
        }
        this._disabledReasons.put(ext.getID(), (Pair<DisabledReason, String>)new Pair((Object)DisabledReason.MISSING_DEPENDENCIES, (Object)missingDeps.toString()));
    }

    protected boolean isExtensionEnabled(String id, javax.ide.util.Version version) {
        boolean enabled;
        if (this._extensionSet == null) {
            try {
                this._extensionSet = new ExtensionSet();
                this._extensionSet.load();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                this._extensionSet = new NullExtensionSet();
            }
        }
        if (!(enabled = this._extensionSet.isExtensionEnabled(id, version))) {
            this._disabledReasons.put(id, (Pair<DisabledReason, String>)new Pair((Object)DisabledReason.USER_DISABLED, (Object)""));
        }
        if (this._roleManager != null && this._roleManager.getActiveRole() != RoleManager.NO_ROLE && this._roleManager.getDisabledExtensions(this._roleManager.getActiveRole()).contains(id)) {
            enabled = false;
            this._disabledReasons.put(id, (Pair<DisabledReason, String>)new Pair((Object)DisabledReason.ROLE_DISABLED, (Object)this._roleManager.getActiveRole().getName()));
        }
        if (!enabled) {
            this._disabledExtensionIds.add(new Pair((Object)id, (Object)version));
            this.m_disabledExtensionIdsOnly.add(id);
        }
        return enabled;
    }

    private void addURLToClassPath(Collection jarFiles) {
        if (jarFiles == null || jarFiles.isEmpty()) {
            return;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader instanceof URLClassLoader) {
                this.addToURLClassLoader(jarFiles, (URLClassLoader)loader);
            } else {
                this.addToPolicyClassLoader(jarFiles, loader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addToURLClassLoader(Collection jarFiles, URLClassLoader loader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> c = Class.forName("java.net.URLClassLoader");
        Class[] parameterTypes = new Class[]{Class.forName("java.net.URL")};
        Method m = c.getDeclaredMethod("addURL", parameterTypes);
        m.setAccessible(true);
        HashSet<URL> existingEntries = new HashSet<URL>();
        existingEntries.addAll(Arrays.asList(loader.getURLs()));
        for (URL url : jarFiles) {
            if (existingEntries.contains(url)) continue;
            Object[] args = new Object[]{url};
            try {
                m.invoke((Object)loader, args);
                URL userDir = URLFactory.newDirURL((String)System.getProperty("user.dir"));
                String relativePath = URLFileSystem.toRelativeSpec((URL)url, (URL)userDir);
                if (File.separatorChar != '/') {
                    relativePath = relativePath.replace('/', File.separatorChar);
                }
                String cp = System.getProperty("java.class.path") + File.pathSeparator + relativePath;
                System.setProperty("java.class.path", cp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void addToPolicyClassLoader(Collection<URL> entries, ClassLoader loader) {
        PolicyClassLoader pcl = (PolicyClassLoader)loader;
        for (URL entry : entries) {
            ConfigurationOrigin origin = new ConfigurationOrigin(IdeConfigurationTypes.EXTENSION_CLASSPATH, URLFileSystem.getPlatformPathName((URL)entry));
            try {
                pcl.addCodeSource(entry, origin);
            }
            catch (IOException e) {
                this.createExtensionLogger().log(Level.SEVERE, "Unable to add classpath entry " + entry, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> stringToSet(String propValue) throws IOException {
        HashSet<String> list = new HashSet<String>();
        if (propValue == null) {
            return list;
        }
        if (propValue.charAt(0) == '@') {
            String filename = propValue.substring(1);
            File f = new File(filename);
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(f));
                String line = br.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                        list.add(line);
                    }
                    line = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }
        StringTokenizer tok = new StringTokenizer(propValue, ", ");
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list;
    }

    private void addToDisabledClasspath(ElementContext context, URI cpEntry) {
        ClassLoader cl = (ClassLoader)context.getScopeData().get("classLoader");
        if (cl instanceof MutableURLClassLoader) {
            try {
                URL url = VirtualFileSystem.getVirtualFileSystem().toURL(cpEntry);
                ((MutableURLClassLoader)cl).addURL(url);
            }
            catch (MalformedURLException mue) {
                this.getLogger().log(Level.WARNING, "Malformed URL", mue);
            }
        }
    }

    public boolean isNewlyInstalled(String extensionId) {
        return this._newlyInstalledIds.contains(extensionId);
    }

    private final class DisabledExtensionVisitor
    extends BaseExtensionVisitor {
        private final ElementName HOOKS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hooks");
        private Extension _extension;
        private Feature _feature;
        private FeatureHook _featureHook = new FeatureHook();
        private DependenciesVisitor _depVisitor = new CustomDependenciesVisitor();
        private BaseExtensionVisitor.ClasspathsVisitor _cpVisitor = new BaseExtensionVisitor.ClasspathsVisitor((BaseExtensionVisitor)this);

        private DisabledExtensionVisitor() {
        }

        public Extension getExtension() {
            return this._extension;
        }

        public Feature getFeature() {
            return this._feature;
        }

        public void addToClasspath(ElementContext context, Extension extension, URI cpEntry) {
            ExtensionManagerImpl.this.addToDisabledClasspath(context, cpEntry);
        }

        public void start(ElementStartContext context) {
            this._extension = this.processExtension(context);
            String rsbundle = context.getAttributeValue("rsbundle-class");
            if (rsbundle != null && (rsbundle = rsbundle.trim()).length() != 0) {
                context.getScopeData().put("rsbundleclass", rsbundle);
            }
            context.registerChildVisitor(this.HOOKS, new ElementVisitor(){

                public void start(ElementStartContext context) {
                    context.registerChildVisitor(FeatureHook.ELEMENT, (ElementVisitor)DisabledExtensionVisitor.this._featureHook);
                }
            });
            context.registerChildVisitor(new ElementName("http://jcp.org/jsr/198/extension-manifest", "name"), (ElementVisitor)new I18NStringVisitor(){

                protected void string(ElementContext context, String value) {
                    ((DefaultExtension)DisabledExtensionVisitor.this._extension).setName(value);
                }
            });
            context.registerChildVisitor(DependenciesVisitor.ELEMENT, (ElementVisitor)this._depVisitor);
            context.registerChildVisitor(CLASSPATH_ELEMENT, (ElementVisitor)this._cpVisitor);
        }

        public void extension(ElementContext context, Extension extension) {
            this._feature = (Feature)this._featureHook.getFeatures().get(this._extension.getID());
        }
    }

    private final class CustomDependenciesVisitor
    extends DependenciesVisitor {
        private CustomDependenciesVisitor() {
        }

        private URI findExtensionJar(String id) {
            File systemDir;
            File userDir = new File(Ide.getUserSettingsDirectory(), "extensions");
            if (userDir.exists() && userDir.isDirectory()) {
                File[] extJarFiles = userDir.listFiles();
                for (int i = 0; i < extJarFiles.length; ++i) {
                    File extJarFile = extJarFiles[i];
                    if (!extJarFile.getName().startsWith(id) || !extJarFile.getName().toUpperCase().endsWith(".JAR")) continue;
                    return URIFactory.newFileURI((String)extJarFile.getPath());
                }
            }
            if (!(systemDir = new File(Ide.getProductHomeDirectory(), "extensions")).equals(userDir) && systemDir.exists() && systemDir.isDirectory()) {
                File[] extJarFiles = systemDir.listFiles();
                for (int i = 0; i < extJarFiles.length; ++i) {
                    File extJarFile = extJarFiles[i];
                    if (!extJarFile.getName().startsWith(id) || !extJarFile.getName().toUpperCase().endsWith(".JAR")) continue;
                    return URIFactory.newFileURI((String)extJarFile.getPath());
                }
            }
            return null;
        }

        protected void addDependency(ElementContext context, DefaultExtension extension, ExtensionDependency dep) {
            extension.addDependency(dep);
            URI jar = this.findExtensionJar(dep.getID());
            if (jar != null) {
                ExtensionManagerImpl.this.addToDisabledClasspath(context, jar);
            }
        }
    }

    private class ExtensionSet {
        private Set _disabledExtensions;
        private Set _enabledExtensions;

        private ExtensionSet() {
        }

        public boolean isExtensionEnabled(String id, javax.ide.util.Version version) {
            if (this._disabledExtensions != null) {
                return !this._disabledExtensions.contains(id);
            }
            if (this._enabledExtensions != null) {
                return this._enabledExtensions.contains(id);
            }
            return true;
        }

        public void load() throws Exception {
            String enabled = System.getProperty("ide.extensions");
            String disabled = System.getProperty("ide.noextensions");
            if (enabled != null && disabled != null) {
                throw new Exception("Must set only one of ide.noextensions or ide.extensions");
            }
            if (enabled != null) {
                this._enabledExtensions = ExtensionManagerImpl.stringToSet(enabled.trim());
            } else if (disabled != null) {
                this._disabledExtensions = ExtensionManagerImpl.stringToSet(disabled.trim());
            } else {
                ExtensionPreferences prefs = ExtensionPreferences.getInstance();
                this._disabledExtensions = new HashSet<String>(prefs.getDisabledIds());
            }
        }
    }

    private final class NullExtensionSet
    extends ExtensionSet {
        @Override
        public boolean isExtensionEnabled(String id, javax.ide.util.Version version) {
            return true;
        }
    }
}

