/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.ide.extension.Extension;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.ExtensionRegistry;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.SimpleTableModel;
import oracle.ideimpl.help.AboutTablePage;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;

public final class ExtensionInfo
extends AboutTablePage {
    public ExtensionInfo() {
        this.setName(ExtensionManagerArb.getString(19));
    }

    @Override
    protected void configureTable(NiceTable table) {
        table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new ExtensionTableCellRenderer()));
    }

    @Override
    protected TableModel buildTableModel() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        ExtensionRegistry extReg = ExtensionRegistry.getExtensionRegistry();
        Collection extensions = extReg.getAllExtensions();
        for (Extension ext : extensions) {
            Object[] row = new Object[4];
            String name = ext.getName();
            if (name == null) {
                name = "(Name Unavailable)";
            }
            row[0] = name;
            row[1] = ext.getID();
            row[2] = ext.getVersion();
            row[3] = extReg.isLoaded(ext.getID()) ? ExtensionManagerArb.getString(26) : ((ExtensionManagerImpl)extReg).getNotLoadedReason(ext.getID());
            data.add(row);
        }
        String[] colNames = new String[]{ExtensionManagerArb.getString(20), ExtensionManagerArb.getString(23), ExtensionManagerArb.getString(21), ExtensionManagerArb.getString(22)};
        return new SimpleTableModel(data, colNames);
    }

    private final class ExtensionTableCellRenderer
    extends NiceTableCellRenderer {
        private ExtensionTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component label = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel model = table.getModel();
            String id = (String)model.getValueAt(row, 1);
            if (id != null && !ExtensionRegistry.getExtensionRegistry().isLoaded(id)) {
                label.setForeground(isSelected ? table.getSelectionForeground() : Color.GRAY);
            }
            return label;
        }
    }
}

