/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import javax.swing.JComponent;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroupState;

final class SplitPaneStructPersistence
extends XMLDockLayoutPersistence {
    private TabGroupState _tabGroupState;

    public SplitPaneStructPersistence(TabGroupState tabGroupState) {
        this._tabGroupState = tabGroupState;
    }

    @Override
    public boolean saveComponent(StructuredPropertyAccess leafBox, JComponent component) {
        SplitPane splitPane = (SplitPane)component;
        SplitPaneState splitPaneState = splitPane.getSplitPaneState();
        int splitPaneStatePos = this._tabGroupState.indexOf(splitPaneState);
        leafBox.setProperty("pane", Integer.toString(splitPaneStatePos));
        return true;
    }

    @Override
    public JComponent loadComponent(StructuredPropertyAccess leafBox) {
        SplitPane splitPane = null;
        String paneProperty = leafBox.getProperty("pane", null);
        if (paneProperty != null) {
            int splitPaneStatePos = Integer.parseInt(paneProperty);
            SplitPaneState splitPaneState = this._tabGroupState.getSplitPaneState(splitPaneStatePos);
            EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
            splitPane = editorManager.createSplitPane();
            splitPaneState.setSplitPane(splitPane);
            splitPane.setSplitPaneState(splitPaneState);
        }
        return splitPane;
    }
}

