/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.RecentFilesBundle;
import oracle.javatools.dialogs.MessageDialog;

final class RecentFilesDockableWindow
extends DockableWindow
implements ApplicationChangeListener {
    static final String VIEW_TYPE = "oracle_ideimpl_editor_RecentFiles_VIEW_TYPE";
    static final String VIEW_NAME = "oracle_ideimpl_editor_RecentFiles_VIEW_NAME";
    private Workspace _currentApplication;
    private Component _gui;
    private JList _recentFilesList;
    private DefaultListModel _recentFilesListModel;
    private RecentFile[] _lastRecentFiles;

    RecentFilesDockableWindow(ViewId viewId) {
        super(viewId.getType() + "." + viewId.getName());
        EditorManagerImpl.getInstance()._recentFilesLRU.addWindow(this);
    }

    public String getTabName() {
        return RecentFilesBundle.get("RECENT_OPEN_FILES_TAB_NAME");
    }

    public String getTitleName() {
        return RecentFilesBundle.get("RECENT_OPEN_FILES_TITLE_NAME");
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = this.createGUI();
        }
        return this._gui;
    }

    private Component createGUI() {
        JScrollPane sp = new JScrollPane();
        sp.setBorder(BorderFactory.createEmptyBorder());
        class RecentFilesJList
        extends JList {
            private final KeyNavigationManager _knm;

            public RecentFilesJList() {
                this._knm = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.ListKeyAdapter(this){

                    public String toString(Object row) {
                        int nRow = this.getRowPosition(row);
                        ListModel listModel = this.getModel();
                        Object obj = listModel.getElementAt(nRow);
                        RecentFile recentFile = (RecentFile)obj;
                        return URLFileSystem.getFileName((URL)recentFile.getNodeURL());
                    }
                });
            }

            @Override
            protected void processKeyEvent(KeyEvent e) {
                this._knm.preProcessKeyEvent(e);
                super.processKeyEvent(e);
                this._knm.postProcessKeyEvent(e);
            }
        }
        RecentFilesJList list = new RecentFilesJList();
        list.setName("RecentlyOpenedFiles");
        this._recentFilesList = list;
        this._recentFilesListModel = new DefaultListModel();
        list.setModel(this._recentFilesListModel);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                RecentFile recentFile = (RecentFile)value;
                URL nodeURL = recentFile.getNodeURL();
                try {
                    Node node = NodeFactory.findOrCreate((URL)nodeURL);
                    this.setText(node.getShortLabel());
                    this.setToolTipText(node.getToolTipText());
                    this.setIcon(node.getIcon());
                }
                catch (Exception e) {
                    this.setText(URLFileSystem.getFileName((URL)nodeURL));
                    this.setToolTipText(URLFileSystem.toDisplayString((URL)nodeURL));
                    this.setIcon(null);
                }
                return this;
            }
        });
        list.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RecentFilesDockableWindow.this.openCurrentRecentFile();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        list.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!e.isConsumed() && e.getKeyCode() == 10) {
                    RecentFilesDockableWindow.this.openCurrentRecentFile();
                }
            }
        });
        sp.getViewport().add(list);
        return sp;
    }

    private void openCurrentRecentFile() {
        RecentFile recentFile = (RecentFile)this._recentFilesList.getSelectedValue();
        if (recentFile != null) {
            if (URLFileSystem.exists((URL)recentFile.getNodeURL())) {
                Context context = recentFile.getContext();
                EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                openEditorOptions.setFlags(8, true);
                editorManager.openEditor(openEditorOptions);
            } else {
                URL url = recentFile.getNodeURL();
                Node node = this.getErasedFileNode(url);
                if (node != null) {
                    EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
                    editorManager.removeFromLRUList(new Context(node));
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)(URLFileSystem.getPlatformPathName((URL)url) + " does not exist."), (String)"File not Found", null);
                }
                this.updateGUI();
            }
        }
    }

    private Node getErasedFileNode(URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            NodeFactory.uncache((URL)url, (boolean)false);
            return node;
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    final void updateGUI() {
        Object[] recentFiles = EditorManagerImpl.getInstance()._recentFilesLRU.getRecentFiles();
        if (!Arrays.equals(recentFiles, this._lastRecentFiles)) {
            this.updateGUIImpl((RecentFile[])recentFiles);
        } else {
            for (int i = 0; i < recentFiles.length; ++i) {
                if (recentFiles[i].isExplicit() == this._lastRecentFiles[i].isExplicit()) continue;
                this.updateGUIImpl((RecentFile[])recentFiles);
                break;
            }
        }
    }

    private void updateGUIImpl(RecentFile[] recentFiles) {
        if (this._recentFilesListModel != null) {
            this._recentFilesListModel.clear();
            if (this._currentApplication != null) {
                URL currentApplicationURL = this._currentApplication.getURL();
                int n = recentFiles.length;
                for (int i = 0; i < n; ++i) {
                    RecentFile recentFile = recentFiles[i];
                    URL nodeURL = recentFile.getNodeURL();
                    if (nodeURL == null || !URLFileSystem.equals((URL)currentApplicationURL, (URL)recentFile.getWorkspaceURL())) continue;
                    this._recentFilesListModel.addElement(recentFile);
                }
                this._lastRecentFiles = recentFiles;
            }
        }
    }

    public int getDefaultVisibility(Layout layout) {
        return 1;
    }

    public void applicationChanged(ApplicationChangeEvent e) {
        Workspace application;
        if (e.getStateChange() == 2 && (application = e.getApplication()) != null) {
            this._currentApplication = application;
            if (this._gui != null) {
                RecentFile[] recentFiles = EditorManagerImpl.getInstance()._recentFilesLRU.getRecentFiles();
                this.updateGUIImpl(recentFiles);
            }
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_iderecentlyopenedfiles_html");
    }
}

