/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.editor.Editor;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.javatools.data.HashStructure;

final class EditorHookRegistration {
    private final HashStructure _hash;

    EditorHookRegistration(HashStructure hs) {
        this._hash = hs;
    }

    public String getId() {
        return this._hash.getString("id");
    }

    public MetaClass<Editor> getEditorClass() {
        LazyClassAdapter lca = LazyClassAdapter.getInstance((HashStructure)this._hash);
        return lca.getMetaClass("editor-class");
    }

    public String getLabel() {
        return this._hash.getString("label");
    }

    public boolean isRestoreAtStartup() {
        return this._hash.getBoolean("restore-at-startup", true);
    }

    public boolean isDuplicable() {
        return this._hash.getBoolean("duplicable", true);
    }

    public boolean isDefault() {
        return this._hash.getBoolean("default", false);
    }

    public Collection<MetaClass> getNodeClasses() {
        List nodeTypes = this._hash.getAsList("node-type");
        if (nodeTypes == null) {
            return Collections.emptySet();
        }
        ArrayList<MetaClass> nodeClasses = new ArrayList<MetaClass>();
        for (HashStructure hs : nodeTypes) {
            ClassLoader loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(HashStructureHook.getExtensionId((HashStructure)hs));
            nodeClasses.add(new MetaClass(loader, hs.getString("class")));
        }
        return nodeClasses;
    }

    public String toString() {
        return String.format("%s [id=%s, label=%s, editor-class=%s, default=%s, duplicable=%s, restore-at-startup=%s]", this.getClass().getName(), this.getLabel(), this._hash.getString("editor-class"), this.isDefault(), this.isDuplicable(), this.isRestoreAtStartup());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditorHookRegistration)) {
            return false;
        }
        EditorHookRegistration that = (EditorHookRegistration)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return 377 + this.getId().hashCode();
    }
}

